/*
 * Decompiled with CFR 0.152.
 */
package leica;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.io.TiffDecoder;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public class Leica_SP_Reader
extends ImagePlus
implements PlugIn {
    private ImagePlus[] images;
    private int nr_frames = 1;
    private int nr_channels = 1;
    private String imageInfo;

    public void run(String string) {
        Object object;
        if (IJ.versionLessThan((String)"1.18h")) {
            return;
        }
        boolean bl = (string == null || string.trim().equals("")) && !Interpreter.isBatchMode();
        String string2 = "";
        String string3 = "";
        if (string == null || string.equals("")) {
            object = new OpenDialog("Leica Tiff", null);
            string2 = object.getDirectory();
            string3 = object.getFileName();
        } else {
            object = new File(string.trim());
            string2 = ((File)object).getParent() + File.separator;
            string3 = ((File)object).getName();
        }
        if (string == null) {
            return;
        }
        try {
            object = this.getFileInfo(string2, string3);
            this.nr_channels = ((Object)object).length / this.nr_frames;
            this.images = new ImagePlus[this.nr_channels];
            for (int i = 0; i < this.nr_channels; ++i) {
                ImageStack imageStack = this.openStack((FileInfo[])object, i);
                if (imageStack == null) continue;
                int n = i + 1;
                ((FileInfo)object[0]).fileName = string;
                ((FileInfo)object[0]).directory = string2;
                Calibration calibration = new Calibration();
                calibration.pixelWidth = ((FileInfo)object[0]).pixelWidth;
                calibration.pixelHeight = ((FileInfo)object[0]).pixelHeight;
                calibration.pixelDepth = ((FileInfo)object[0]).pixelDepth;
                if (i == 0) {
                    this.setStack(string3 + "(channel1)", imageStack);
                    this.setCalibration(calibration);
                    this.setFileInfo((FileInfo)object[0]);
                }
                this.images[i] = new ImagePlus(string3 + " (channel" + n + ")", imageStack);
                this.images[i].setCalibration(calibration);
                this.images[i].setFileInfo((FileInfo)object[0]);
                this.images[i].setProperty("Info", (Object)this.imageInfo);
                if (!bl) continue;
                this.images[i].show();
            }
        }
        catch (IOException iOException) {
            String string4 = iOException.getMessage();
            if (string4 == null || string4.equals("")) {
                string4 = "" + iOException;
            }
            IJ.showMessage((String)"Leica SP Reader", (String)string4);
        }
    }

    public int getNumberOfChannels() {
        return this.nr_channels;
    }

    public ImagePlus getImage(int n) {
        return this.images[n];
    }

    public FileInfo[] getFileInfo(String string, String string2) throws IOException {
        FileInfo[] fileInfoArray;
        LeicaTiffDecoder leicaTiffDecoder = new LeicaTiffDecoder(string, string2);
        if (IJ.debugMode) {
            leicaTiffDecoder.enableDebugging();
        }
        if ((fileInfoArray = leicaTiffDecoder.getTiffInfo()) == null) {
            throw new IOException("This file does not appear to be in TIFF format.");
        }
        if (IJ.debugMode) {
            IJ.write((String)fileInfoArray[0].info);
        }
        return fileInfoArray;
    }

    ImageStack openStack(FileInfo[] fileInfoArray, int n) throws IOException {
        if (fileInfoArray[0].fileType != 5) {
            throw new IOException("This does not appear to be  a stack of 8-bit color images.");
        }
        if (n < 0 || n >= this.nr_channels) {
            throw new IOException("Image does not contain channel " + n);
        }
        int n2 = this.nr_channels;
        int n3 = fileInfoArray[0].width;
        int n4 = fileInfoArray[0].height;
        String string = fileInfoArray[0].fileName;
        int n5 = fileInfoArray.length / this.nr_channels;
        ImageStack imageStack = new ImageStack(n3, n4);
        for (int i = 0; i < n5; ++i) {
            int n6 = i + n * n5;
            if (fileInfoArray[n6].width != n3 || fileInfoArray[n6].height != n4) break;
            FileOpener fileOpener = new FileOpener(fileInfoArray[n6]);
            ImagePlus imagePlus = fileOpener.open(false);
            if (imagePlus != null) {
                imageStack.addSlice("", imagePlus.getProcessor());
            }
            IJ.showProgress((int)(i + 1), (int)n5);
        }
        return imageStack;
    }

    class LeicaTiffDecoder
    extends TiffDecoder {
        public LeicaTiffDecoder(String string, String string2) {
            super(string, string2);
        }

        public void saveImageDescription(byte[] byArray, FileInfo fileInfo) {
            this.decodeImageDescription(byArray, fileInfo);
        }

        public void decodeImageDescription(byte[] byArray, FileInfo fileInfo) {
            Leica_SP_Reader.this.imageInfo = new String(byArray);
            if (new String(byArray, 0, 8).equals("[GLOBAL]")) {
                String string;
                if (this.debugMode) {
                    IJ.write((String)"Leica file detected...\n");
                }
                fileInfo.info = string = new String(byArray);
                if (this.debugMode) {
                    IJ.write((String)string);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n= ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.equals("NumOfFrames")) {
                        Leica_SP_Reader.this.nr_frames = this.getInt(stringTokenizer);
                        if (!this.debugMode) continue;
                        IJ.write((String)(Leica_SP_Reader.this.nr_channels + " channels detected\n"));
                        continue;
                    }
                    if (string2.equals("VoxelSizeX")) {
                        fileInfo.pixelWidth = this.getDouble(stringTokenizer);
                        continue;
                    }
                    if (string2.equals("VoxelSizeY")) {
                        fileInfo.pixelHeight = this.getDouble(stringTokenizer);
                        continue;
                    }
                    if (!string2.equals("VoxelSizeZ")) continue;
                    fileInfo.pixelDepth = this.getDouble(stringTokenizer);
                }
            }
        }

        public int getInt(StringTokenizer stringTokenizer) {
            String string = stringTokenizer.nextToken().trim();
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("invalid number: " + string);
            }
        }

        public double getDouble(StringTokenizer stringTokenizer) {
            String string = stringTokenizer.nextToken().trim();
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("invalid number: " + string);
            }
        }
    }
}

