/*
 * Decompiled with CFR 0.152.
 */
package math3d;

import math3d.FastMatrixN;
import math3d.Point3d;

public class Bookstein {
    protected Point3d[] points;
    protected Bookstein1d bx;
    protected Bookstein1d by;
    protected Bookstein1d bz;
    public double x;
    public double y;
    public double z;

    public Bookstein(Point3d[] point3dArray, Point3d[] point3dArray2) {
        int n;
        int n2;
        if (point3dArray.length != point3dArray2.length) {
            throw new RuntimeException("orig has " + point3dArray.length + " points, but trans has " + point3dArray2.length + "???");
        }
        this.points = point3dArray;
        int n3 = point3dArray.length + 4;
        double[][] dArray = new double[n3][n3];
        for (n2 = 0; n2 < point3dArray.length; ++n2) {
            for (n = n2 + 1; n < point3dArray.length; ++n) {
                dArray[n2][n] = Bookstein.U(point3dArray[n2].distanceTo(point3dArray[n]));
            }
            dArray[n2][point3dArray.length] = 1.0;
            dArray[n2][point3dArray.length + 1] = point3dArray[n2].x;
            dArray[n2][point3dArray.length + 2] = point3dArray[n2].y;
            dArray[n2][point3dArray.length + 3] = point3dArray[n2].z;
            for (n = n2 + 1; n < n3; ++n) {
                dArray[n][n2] = dArray[n2][n];
            }
        }
        FastMatrixN.invert(dArray);
        this.bx = new Bookstein1d();
        this.by = new Bookstein1d();
        this.bz = new Bookstein1d();
        this.bx.w = new double[point3dArray.length];
        this.by.w = new double[point3dArray.length];
        this.bz.w = new double[point3dArray.length];
        for (n2 = 0; n2 < point3dArray.length; ++n2) {
            for (n = 0; n < point3dArray.length; ++n) {
                int n4 = n2;
                this.bx.w[n4] = this.bx.w[n4] + point3dArray2[n].x * dArray[n2][n];
                int n5 = n2;
                this.by.w[n5] = this.by.w[n5] + point3dArray2[n].y * dArray[n2][n];
                int n6 = n2;
                this.bz.w[n6] = this.bz.w[n6] + point3dArray2[n].z * dArray[n2][n];
            }
        }
        for (n2 = 0; n2 < point3dArray.length; ++n2) {
            this.bx.a1 += point3dArray2[n2].x * dArray[point3dArray.length][n2];
            this.bx.ax += point3dArray2[n2].x * dArray[point3dArray.length + 1][n2];
            this.bx.ay += point3dArray2[n2].x * dArray[point3dArray.length + 2][n2];
            this.bx.az += point3dArray2[n2].x * dArray[point3dArray.length + 3][n2];
            this.by.a1 += point3dArray2[n2].y * dArray[point3dArray.length][n2];
            this.by.ax += point3dArray2[n2].y * dArray[point3dArray.length + 1][n2];
            this.by.ay += point3dArray2[n2].y * dArray[point3dArray.length + 2][n2];
            this.by.az += point3dArray2[n2].y * dArray[point3dArray.length + 3][n2];
            this.bz.a1 += point3dArray2[n2].z * dArray[point3dArray.length][n2];
            this.bz.ax += point3dArray2[n2].z * dArray[point3dArray.length + 1][n2];
            this.bz.ay += point3dArray2[n2].z * dArray[point3dArray.length + 2][n2];
            this.bz.az += point3dArray2[n2].z * dArray[point3dArray.length + 3][n2];
        }
    }

    public void apply(Point3d point3d) {
        this.x = this.bx.evalInit(point3d);
        this.y = this.by.evalInit(point3d);
        this.z = this.bz.evalInit(point3d);
        for (int i = 0; i < this.points.length; ++i) {
            double d = Bookstein.U(point3d.distanceTo(this.points[i]));
            this.x += this.bx.w[i] * d;
            this.y += this.by.w[i] * d;
            this.z += this.bz.w[i] * d;
        }
    }

    public static double U(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        return d * d * Math.log(d);
    }

    public class Bookstein1d {
        double a1;
        double ax;
        double ay;
        double az;
        public double[] w;

        public double evalInit(Point3d point3d) {
            return this.a1 + this.ax * point3d.x + this.ay * point3d.y + this.az * point3d.z;
        }

        public double eval(Point3d point3d) {
            double d = this.evalInit(point3d);
            for (int i = 0; i < Bookstein.this.points.length; ++i) {
                d += this.w[i] * Bookstein.U(point3d.distanceTo(Bookstein.this.points[i]));
            }
            return d;
        }
    }
}

