/*
 * Decompiled with CFR 0.152.
 */
package math3d;

public class Eigensystem2x2Double {
    double[][] m;
    double[] eigenVectors;
    double[] eigenValues;

    public Eigensystem2x2Double(double[][] dArray) {
        this.m = dArray;
        if (this.m[0][1] != this.m[1][0]) {
            throw new RuntimeException("Eigensystem2x2Double only works with symmetric matrices");
        }
    }

    public void getEvalues(double[] dArray) {
        dArray[0] = this.eigenValues[0];
        dArray[1] = this.eigenValues[1];
    }

    public double[] getEvaluesCopy() {
        return (double[])this.eigenValues.clone();
    }

    public double[] getEvalues() {
        return this.eigenValues;
    }

    public boolean findEvalues() {
        this.eigenValues = new double[2];
        double d = this.m[0][0];
        double d2 = this.m[1][1];
        double d3 = -(d + d2);
        double d4 = 1.0;
        double d5 = this.m[0][1];
        double d6 = d * d2 - d5 * d5;
        double d7 = d3 * d3 - 4.0 * d4 * d6;
        if (d7 < 0.0) {
            return false;
        }
        this.eigenValues[0] = (-d3 + Math.sqrt(d7)) / (2.0 * d4);
        this.eigenValues[1] = (-d3 - Math.sqrt(d7)) / (2.0 * d4);
        return true;
    }
}

