/*
 * Decompiled with CFR 0.152.
 */
package math3d;

public class Eigensystem2x2Float {
    float[][] m;
    float[] eigenVectors;
    float[] eigenValues;

    public Eigensystem2x2Float(float[][] fArray) {
        this.m = fArray;
        if (this.m[0][1] != this.m[1][0]) {
            throw new RuntimeException("Eigensystem2x2Float only works with symmetric matrices");
        }
    }

    public void getEvalues(float[] fArray) {
        fArray[0] = this.eigenValues[0];
        fArray[1] = this.eigenValues[1];
    }

    public float[] getEvaluesCopy() {
        return (float[])this.eigenValues.clone();
    }

    public float[] getEvalues() {
        return this.eigenValues;
    }

    public boolean findEvalues() {
        this.eigenValues = new float[2];
        double d = this.m[0][0];
        double d2 = this.m[1][1];
        double d3 = -(d + d2);
        double d4 = 1.0;
        double d5 = this.m[0][1];
        double d6 = d * d2 - d5 * d5;
        double d7 = d3 * d3 - 4.0 * d4 * d6;
        if (d7 < 0.0) {
            return false;
        }
        this.eigenValues[0] = (float)((-d3 + Math.sqrt(d7)) / (2.0 * d4));
        this.eigenValues[1] = (float)((-d3 - Math.sqrt(d7)) / (2.0 * d4));
        return true;
    }
}

