/*
 * Decompiled with CFR 0.152.
 */
package math3d;

import ij.IJ;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class FastMatrixN {
    public static void invert(double[][] dArray) {
        FastMatrixN.invert(dArray, false);
    }

    public static void invert(double[][] dArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = dArray.length;
        if (n4 != dArray[0].length) {
            throw new RuntimeException("invert: no square matrix");
        }
        double[][] dArray2 = new double[n4][n4];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray2[n3][n3] = 1.0;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            int n5;
            if (bl) {
                IJ.showStatus((String)("invert matrix: " + n3 + "/" + 2 * n4));
            }
            n2 = n3;
            for (n5 = n3 + 1; n5 < n4; ++n5) {
                if (!(Math.abs(dArray[n5][n3]) > Math.abs(dArray[n2][n3]))) continue;
                n2 = n5;
            }
            if (n2 != n3) {
                double[] dArray3 = dArray[n2];
                dArray[n2] = dArray[n3];
                dArray[n3] = dArray3;
                dArray3 = dArray2[n2];
                dArray2[n2] = dArray2[n3];
                dArray2[n3] = dArray3;
            }
            if (dArray[n3][n3] != 1.0) {
                double d = dArray[n3][n3];
                n = n3;
                while (n < n4) {
                    double[] dArray4 = dArray[n3];
                    int n6 = n++;
                    dArray4[n6] = dArray4[n6] / d;
                }
                n = 0;
                while (n < n4) {
                    double[] dArray5 = dArray2[n3];
                    int n7 = n++;
                    dArray5[n7] = dArray5[n7] / d;
                }
            }
            for (n5 = n3 + 1; n5 < n4; ++n5) {
                int n8;
                double d = dArray[n5][n3];
                for (n8 = n3; n8 < n4; ++n8) {
                    double[] dArray6 = dArray[n5];
                    int n9 = n8;
                    dArray6[n9] = dArray6[n9] - d * dArray[n3][n8];
                }
                for (n8 = 0; n8 < n4; ++n8) {
                    double[] dArray7 = dArray2[n5];
                    int n10 = n8;
                    dArray7[n10] = dArray7[n10] - d * dArray2[n3][n8];
                }
            }
        }
        for (n3 = n4 - 1; n3 > 0; --n3) {
            if (bl) {
                IJ.showStatus((String)("invert matrix: " + (2 * n4 - n3) + "/" + 2 * n4));
            }
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                double d = dArray[n2][n3] / dArray[n3][n3];
                for (n = n3; n < n4; ++n) {
                    double[] dArray8 = dArray[n2];
                    int n11 = n;
                    dArray8[n11] = dArray8[n11] - d * dArray[n3][n];
                }
                for (n = 0; n < n4; ++n) {
                    double[] dArray9 = dArray2[n2];
                    int n12 = n;
                    dArray9[n12] = dArray9[n12] - d * dArray2[n3][n];
                }
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = dArray2[n3];
        }
    }

    public static double[][] clone(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(dArray[i], 0, dArray2[i], 0, n2);
        }
        return dArray2;
    }

    public static double[][] times(double[][] dArray, double[][] dArray2) {
        int n = dArray2.length;
        if (dArray[0].length != dArray2.length) {
            throw new RuntimeException("rank mismatch");
        }
        int n2 = dArray.length;
        int n3 = dArray2[0].length;
        double[][] dArray3 = new double[n2][n3];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n; ++k) {
                    double[] dArray4 = dArray3[i];
                    int n4 = j;
                    dArray4[n4] = dArray4[n4] + dArray[i][k] * dArray2[k][j];
                }
            }
        }
        return dArray3;
    }

    public static double[] times(double[][] dArray, double[] dArray2) {
        int n = dArray2.length;
        if (dArray[0].length != dArray2.length) {
            throw new RuntimeException("rank mismatch");
        }
        int n2 = dArray.length;
        double[] dArray3 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = i;
                dArray3[n3] = dArray3[n3] + dArray[i][j] * dArray2[j];
            }
        }
        return dArray3;
    }

    static double[][] LU_decomposition(double[][] dArray) {
        int n;
        int n2;
        int n3 = dArray.length;
        double[][] dArray2 = new double[n3][n3];
        double[][] dArray3 = new double[n3][n3];
        for (int i = 0; i < n3; ++i) {
            for (n2 = i; n2 < n3; ++n2) {
                dArray2[i][n2] = dArray[i][n2];
                for (n = 0; n < i; ++n) {
                    double[] dArray4 = dArray2[i];
                    int n4 = n2;
                    dArray4[n4] = dArray4[n4] - dArray3[i][n] * dArray2[n][n2];
                }
            }
            for (n2 = i + 1; n2 < n3; ++n2) {
                dArray3[n2][i] = dArray[n2][i];
                for (n = 0; n < i; ++n) {
                    double[] dArray5 = dArray3[n2];
                    int n5 = i;
                    dArray5[n5] = dArray5[n5] - dArray3[n2][n] * dArray2[n][i];
                }
                double[] dArray6 = dArray3[n2];
                int n6 = i;
                dArray6[n6] = dArray6[n6] / dArray2[i][i];
            }
        }
        double[][] dArray7 = new double[n3][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                dArray7[n2][n] = dArray3[n2][n] + dArray2[n2][n];
            }
        }
        return dArray7;
    }

    static double[][] choleskyDecomposition(double[][] dArray) {
        if (dArray.length != dArray[0].length) {
            throw new RuntimeException("Row and column rank must be equal");
        }
        int n = dArray.length;
        double[][] dArray2 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[i][j] = 0.0;
            }
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            int n2;
            d = 0.0;
            for (n2 = 0; n2 < i; ++n2) {
                d += dArray2[n2][i] * dArray2[n2][i];
            }
            if (dArray[i][i] - d < 0.0) {
                throw new RuntimeException("Matrix must be positive definite (trace is " + d + ", but diagonal element " + i + " is " + dArray[i][i] + ")");
            }
            dArray2[i][i] = Math.sqrt(dArray[i][i] - d);
            for (n2 = i + 1; n2 < n; ++n2) {
                d = 0.0;
                for (int j = 0; j < i; ++j) {
                    d += dArray2[j][n2] * dArray2[j][i];
                }
                dArray2[i][n2] = (dArray[i][n2] - d) / dArray2[i][i];
            }
        }
        return dArray2;
    }

    public static double[][] transpose(double[][] dArray) {
        double[][] dArray2 = new double[dArray[0].length][dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray2[i].length; ++j) {
                dArray2[i][j] = dArray[j][i];
            }
        }
        return dArray2;
    }

    public static double[] solve_UL(double[][] dArray, double[] dArray2) {
        double[][] dArray3 = FastMatrixN.LU_decomposition(dArray);
        double[] dArray4 = new double[dArray2.length];
        for (int i = 0; i < dArray4.length; ++i) {
            double d = 0.0;
            for (int j = 0; j < i; ++j) {
                d += dArray3[i][j] * dArray4[j];
            }
            dArray4[i] = dArray2[i] - d;
        }
        double[] dArray5 = new double[dArray2.length];
        for (int i = dArray5.length - 1; i >= 0; --i) {
            double d = 0.0;
            for (int j = i + 1; j < dArray5.length; ++j) {
                d += dArray3[i][j] * dArray5[j];
            }
            dArray5[i] = (dArray4[i] - d) / dArray3[i][i];
        }
        return dArray5;
    }

    public static double[] solve_cholesky(double[][] dArray, double[] dArray2) {
        double[][] dArray3 = FastMatrixN.choleskyDecomposition(dArray);
        dArray3 = FastMatrixN.choleskyDecomposition(dArray);
        double[][] dArray4 = FastMatrixN.transpose(dArray3);
        double[] dArray5 = FastMatrixN.forward_substitution(dArray4, dArray2);
        double[] dArray6 = FastMatrixN.backward_substitution(dArray3, dArray5);
        return dArray6;
    }

    private static double[] backward_substitution(double[][] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray2.length];
        for (int i = dArray3.length - 1; i >= 0; --i) {
            double d = 0.0;
            for (int j = i + 1; j < dArray3.length; ++j) {
                d += dArray[i][j] * dArray3[j];
            }
            dArray3[i] = (dArray2[i] - d) / dArray[i][i];
        }
        return dArray3;
    }

    private static double[] forward_substitution(double[][] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray3.length; ++i) {
            double d = 0.0;
            for (int j = 0; j < i; ++j) {
                d += dArray[i][j] * dArray3[j];
            }
            dArray3[i] = (dArray2[i] - d) / dArray[i][i];
        }
        return dArray3;
    }

    public static double[] apply(double[][] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = 0.0;
            for (int j = 0; j < n2; ++j) {
                int n3 = i;
                dArray3[n3] = dArray3[n3] + dArray[i][j] * dArray2[j];
            }
        }
        return dArray3;
    }

    public static void print(double[] dArray) {
        System.out.print("[");
        for (int i = 0; i < dArray.length; ++i) {
            System.out.print(dArray[i] + ", ");
        }
        System.out.print("]");
        System.out.println();
    }

    public static void print(double[][] dArray) {
        FastMatrixN.print(dArray, System.out);
    }

    public static void print(double[][] dArray, PrintStream printStream, char c) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                printStream.print(decimalFormat.format(dArray[i][j]) + c);
            }
            printStream.println("");
        }
        printStream.println();
    }

    public static float round(double d, int n, RoundingMode roundingMode) {
        BigDecimal bigDecimal = BigDecimal.valueOf(d);
        return bigDecimal.setScale(n, roundingMode).floatValue();
    }

    public static void print(double[][] dArray, PrintStream printStream) {
        FastMatrixN.print(dArray, printStream, '\t');
    }

    public static void main(String[] stringArray) {
        double d = 1234.1234;
        BigDecimal bigDecimal = BigDecimal.valueOf(d);
        System.out.println(bigDecimal.unscaledValue() + " " + bigDecimal.scale());
        int n = BigDecimal.valueOf(d).movePointLeft(2).unscaledValue().intValue() * 100;
        bigDecimal = bigDecimal.movePointLeft(2);
        System.out.println(bigDecimal.unscaledValue());
        System.out.println("Test rounding");
        double d2 = 1.234567889;
        System.out.println("Math.round(" + d2 + ") = " + Math.round(d2));
        System.out.println("round(" + d2 + ",2) = " + FastMatrixN.round(d2, 2, RoundingMode.HALF_EVEN));
        double[][] dArrayArray = new double[][]{{1.0, 2.0, 3.0, 2.0}, {-1.0, 0.0, 2.0, -3.0}, {-2.0, 1.0, 1.0, 1.0}, {0.0, -2.0, 3.0, 0.0}};
        double[][] dArray = FastMatrixN.clone(dArrayArray);
        FastMatrixN.invert(dArray);
        double[][] dArray2 = FastMatrixN.times((double[][])dArrayArray, dArray);
        FastMatrixN.print(dArray2);
        double[][] dArray3 = new double[5][5];
        for (int i = 0; i < dArray3.length; ++i) {
            for (int j = i; j < dArray3.length; ++j) {
                double d3 = 1.0 / (double)(i + j + 1);
                dArray3[j][i] = d3;
                dArray3[i][j] = d3;
            }
        }
        System.out.println("Original matrix ");
        FastMatrixN.print(dArray3);
        double[][] dArray4 = FastMatrixN.choleskyDecomposition(dArray3);
        System.out.println("Upper triangular form u of cholesky decomposition ");
        FastMatrixN.print(dArray4);
        double[][] dArray5 = FastMatrixN.transpose(dArray4);
        System.out.println("Transposed form u^T of u ");
        FastMatrixN.print(dArray5);
        double[][] dArray6 = FastMatrixN.times(dArray5, dArray4);
        System.out.println("Finally the product of the u^T and u, which should give the original matrix ");
        FastMatrixN.print(dArray6);
        double[] dArray7 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        System.out.println("A vector x: x = [1.0 2.0 3.0]^T\n");
        double[] dArray8 = FastMatrixN.apply(dArray3, dArray7);
        System.out.println("Applying the original matrix to x gives b: ");
        FastMatrixN.print(dArray8);
        System.out.println("\n\nTest different solve methods");
        System.out.println("\nTest Cholesky decomposition");
        double[] dArray9 = FastMatrixN.solve_cholesky(dArray3, dArray8);
        System.out.println("Now solve Ax = b for x and see if it is the original x");
        FastMatrixN.print(dArray9);
        System.out.println("\nTest LU decomposition");
        System.out.println("Now solve Ax = b for x and see if it is the original x");
        dArray9 = FastMatrixN.solve_UL(dArray3, dArray8);
        FastMatrixN.print(dArray9);
        System.out.println("\nTest ordinary invert method");
        System.out.println("Now solve Ax = b for x and see if it is the original x");
        double[][] dArray10 = FastMatrixN.clone(dArray3);
        FastMatrixN.invert(dArray10);
        dArray9 = FastMatrixN.apply(dArray10, dArray8);
        FastMatrixN.print(dArray9);
    }
}

