/*
 * Decompiled with CFR 0.152.
 */
package math3d;

import math3d.FastMatrixN;

public class JacobiDouble {
    private double[][] matrix;
    private double[][] eigenmatrix;
    private double[] eigenvalues;
    private int numberOfRotationsNeeded;
    private int maxSweeps;

    public JacobiDouble(double[][] dArray) {
        this(dArray, 50);
    }

    public JacobiDouble(double[][] dArray, int n) {
        this.matrix = dArray;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = i + 1; j < dArray.length; ++j) {
                if (this.isSmallComparedTo(Math.abs(dArray[i][j] - dArray[j][i]), dArray[i][j])) continue;
                throw new RuntimeException("Matrix is not symmetric!");
            }
        }
        this.eigenmatrix = new double[dArray.length][dArray.length];
        this.eigenvalues = new double[dArray.length];
        this.maxSweeps = n;
        this.perform();
    }

    public double[][] getEigenVectors() {
        return FastMatrixN.transpose(this.eigenmatrix);
    }

    public double[][] getEigenMatrix() {
        return this.eigenmatrix;
    }

    public double[] getEigenValues() {
        return this.eigenvalues;
    }

    public int getNumberOfRotations() {
        return this.numberOfRotationsNeeded;
    }

    private double offDiagonalSum() {
        double d = 0.0;
        for (int i = 0; i < this.matrix.length - 1; ++i) {
            for (int j = i + 1; j < this.matrix.length; ++j) {
                d += Math.abs(this.matrix[i][j]);
            }
        }
        return d;
    }

    private void rotate(int n, int n2, int n3, int n4, double d, double d2) {
        double d3 = this.matrix[n][n2];
        double d4 = this.matrix[n3][n4];
        this.matrix[n][n2] = d3 - d * (d4 + d3 * d2);
        this.matrix[n3][n4] = d4 + d * (d3 - d4 * d2);
    }

    private void rotateEigenMatrix(int n, int n2, int n3, int n4, double d, double d2) {
        double d3 = this.eigenmatrix[n][n2];
        double d4 = this.eigenmatrix[n3][n4];
        this.eigenmatrix[n][n2] = d3 - d * (d4 + d3 * d2);
        this.eigenmatrix[n3][n4] = d4 + d * (d3 - d4 * d2);
    }

    private boolean isSmallComparedTo(double d, double d2) {
        return Math.abs(d2) + d == Math.abs(d2);
    }

    private void perform() {
        int n;
        double[] dArray = new double[this.matrix.length];
        double[] dArray2 = new double[this.matrix.length];
        for (n = 0; n < this.matrix.length; ++n) {
            for (int i = 0; i < this.matrix.length; ++i) {
                this.eigenmatrix[n][i] = 0.0;
            }
            this.eigenmatrix[n][n] = 1.0;
            dArray[n] = this.eigenvalues[n] = this.matrix[n][n];
            dArray2[n] = 0.0;
        }
        this.numberOfRotationsNeeded = 0;
        for (n = 0; n < this.maxSweeps; ++n) {
            int n2;
            double d = this.offDiagonalSum();
            if (d == 0.0) {
                return;
            }
            double d2 = 0.0;
            if (n < 3) {
                d2 = (double)0.2f * d / (double)(this.matrix.length * this.matrix.length);
            }
            for (n2 = 0; n2 < this.matrix.length - 1; ++n2) {
                for (int i = n2 + 1; i < this.matrix.length; ++i) {
                    int n3;
                    double d3;
                    double d4;
                    double d5 = 100.0 * Math.abs(this.matrix[n2][i]);
                    if (n > 3 && this.isSmallComparedTo(d5, this.eigenvalues[n2]) && this.isSmallComparedTo(d5, this.eigenvalues[i])) {
                        this.matrix[n2][i] = 0.0;
                        continue;
                    }
                    if (!(Math.abs(this.matrix[n2][i]) > d2)) continue;
                    double d6 = this.eigenvalues[i] - this.eigenvalues[n2];
                    if (this.isSmallComparedTo(d5, d6)) {
                        d4 = this.matrix[n2][i] / d6;
                    } else {
                        d3 = 0.5 * d6 / this.matrix[n2][i];
                        d4 = 1.0 / (Math.abs(d3) + Math.sqrt(1.0 + d3 * d3));
                        if (d3 < 0.0) {
                            d4 = -d4;
                        }
                    }
                    d3 = 1.0 / Math.sqrt(1.0 + d4 * d4);
                    double d7 = d4 * d3;
                    double d8 = d7 / (1.0 + d3);
                    double d9 = d4 * this.matrix[n2][i];
                    int n4 = n2;
                    dArray2[n4] = dArray2[n4] - d9;
                    int n5 = i;
                    dArray2[n5] = dArray2[n5] + d9;
                    int n6 = n2;
                    this.eigenvalues[n6] = this.eigenvalues[n6] - d9;
                    int n7 = i;
                    this.eigenvalues[n7] = this.eigenvalues[n7] + d9;
                    this.matrix[n2][i] = 0.0;
                    for (n3 = 0; n3 <= n2 - 1; ++n3) {
                        this.rotate(n3, n2, n3, i, d7, d8);
                    }
                    for (n3 = n2 + 1; n3 <= i - 1; ++n3) {
                        this.rotate(n2, n3, n3, i, d7, d8);
                    }
                    for (n3 = i + 1; n3 < this.matrix.length; ++n3) {
                        this.rotate(n2, n3, i, n3, d7, d8);
                    }
                    for (n3 = 0; n3 < this.matrix.length; ++n3) {
                        this.rotateEigenMatrix(n3, n2, n3, i, d7, d8);
                    }
                    ++this.numberOfRotationsNeeded;
                }
            }
            for (n2 = 0; n2 < this.matrix.length; ++n2) {
                int n8 = n2;
                dArray[n8] = dArray[n8] + dArray2[n2];
                this.eigenvalues[n2] = dArray[n2];
                dArray2[n2] = 0.0;
            }
        }
    }

    public static String toString(double[] dArray) {
        String string = "{";
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + dArray[i];
        }
        return string + "}";
    }

    public static String toString(double[][] dArray) {
        String string = "{";
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + JacobiDouble.toString(dArray[i]);
        }
        return string + "}";
    }

    public static double[] getColumn(double[][] dArray, int n) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i][n];
        }
        return dArray2;
    }

    public static double[][] matMult(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray2[0].length;
        double[][] dArray3 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray3[i][j] = 0.0;
                for (int k = 0; k < dArray2.length; ++k) {
                    double[] dArray4 = dArray3[i];
                    int n3 = j;
                    dArray4[n3] = dArray4[n3] + dArray[i][k] * dArray2[k][j];
                }
            }
        }
        return dArray3;
    }

    public static double[] vecMult(double[][] dArray, double[] dArray2) {
        int n = dArray.length;
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = 0.0;
            for (int j = 0; j < dArray2.length; ++j) {
                int n2 = i;
                dArray3[n2] = dArray3[n2] + dArray[i][j] * dArray2[j];
            }
        }
        return dArray3;
    }

    public static double[][] transpose(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n2][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[j][i] = dArray[i][j];
            }
        }
        return dArray2;
    }

    public static void main(String[] stringArray) {
        double[][] dArrayArray = new double[][]{{1.0, 2.0}, {2.0, 1.0}};
        JacobiDouble jacobiDouble = new JacobiDouble(dArrayArray);
        double[] dArray = jacobiDouble.getEigenValues();
        double[][] dArray2 = new double[dArray.length][dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i][i] = dArray[i];
        }
        double[][] dArray3 = jacobiDouble.getEigenVectors();
        double[][] dArray4 = JacobiDouble.matMult(dArray3, JacobiDouble.matMult(dArray2, JacobiDouble.transpose(dArray3)));
        System.out.println("out: " + JacobiDouble.toString(dArray4));
    }
}

