/*
 * Decompiled with CFR 0.152.
 */
package math3d;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import math3d.Eigensystem2x2Double;
import math3d.Eigensystem2x2Float;
import math3d.Eigensystem3x3Double;
import math3d.Eigensystem3x3Float;
import math3d.JacobiDouble;
import math3d.JacobiFloat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestEigenvalueDecompositions {
    boolean printTimings = false;
    ArrayList<TestMatrixAndResultDouble> realSymmetricTestCases2x2Double;
    ArrayList<TestMatrixAndResultFloat> realSymmetricTestCases2x2Float;
    ArrayList<TestMatrixAndResultDouble> realSymmetricTestCases3x3Double;
    ArrayList<TestMatrixAndResultFloat> realSymmetricTestCases3x3Float;

    @Before
    public void setUp() {
        Object object;
        double[] dArray;
        Object object2;
        Object object3;
        Object object4;
        this.realSymmetricTestCases3x3Double = new ArrayList();
        double[] dArray2 = new double[]{1.0038581, 0.11780524, -0.020147324, 0.11780524, 0.82471085, 0.040020466, -0.020147324, 0.040020466, 1.0540304};
        double[] dArray3 = new double[]{0.7594775408789509, 1.0607974405512743, 1.0623243685697759};
        this.realSymmetricTestCases3x3Double.add(new TestMatrixAndResultDouble(3, dArray2, dArray3));
        double[] dArray4 = new double[]{3.0, 0.0, 0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 5.0};
        double[] dArray5 = new double[]{3.0, 5.0, 5.0};
        this.realSymmetricTestCases3x3Double.add(new TestMatrixAndResultDouble(3, dArray4, dArray5));
        double[] dArray6 = new double[]{1.0, 2.0, 3.0, 2.0, 4.0, 5.0, 3.0, 5.0, 6.0};
        double[] dArray7 = new double[]{-0.5157294715892572, 11.344814282762078, 0.17091518882717946};
        this.realSymmetricTestCases3x3Double.add(new TestMatrixAndResultDouble(3, dArray6, dArray7));
        double[] dArray8 = new double[]{0.0, 1.0, -1.0, 1.0, 1.0, 0.0, -1.0, 0.0, 1.0};
        double[] dArray9 = new double[]{2.0, 1.0, -1.0};
        this.realSymmetricTestCases3x3Double.add(new TestMatrixAndResultDouble(3, dArray8, dArray9));
        Random random = new Random(123456789L);
        for (int i = 0; i < 2000; ++i) {
            double[] object52 = new double[9];
            object52[0] = random.nextDouble();
            object52[1] = object52[3] = random.nextDouble();
            object52[2] = object52[6] = random.nextDouble();
            object52[4] = random.nextDouble();
            object52[5] = object52[7] = random.nextDouble();
            object52[8] = random.nextDouble();
            object4 = new double[3][3];
            for (int j = 0; j < 9; ++j) {
                object4[j / 3][j % 3] = object52[j];
            }
            object3 = new Matrix((double[][])object4);
            object2 = new EigenvalueDecomposition(object3);
            dArray = object2.getRealEigenvalues();
            this.realSymmetricTestCases3x3Double.add(new TestMatrixAndResultDouble(3, object52, dArray));
        }
        this.realSymmetricTestCases3x3Float = new ArrayList();
        for (TestMatrixAndResultDouble testMatrixAndResultDouble : this.realSymmetricTestCases3x3Double) {
            object4 = new TestMatrixAndResultFloat(3, testMatrixAndResultDouble.getMatrixFloats(), testMatrixAndResultDouble.getEvaluesFloats());
            this.realSymmetricTestCases3x3Float.add((TestMatrixAndResultFloat)object4);
        }
        this.realSymmetricTestCases2x2Double = new ArrayList();
        Object object6 = new double[]{1.0038581, 0.11780524, 0.11780524, 0.82471085};
        double[] dArray10 = new double[]{0.7662928912288334, 1.0622760587711666};
        this.realSymmetricTestCases2x2Double.add(new TestMatrixAndResultDouble(2, (double[])object6, dArray10));
        object4 = new double[]{3.0, 0.0, 0.0, 5.0};
        object3 = new double[]{3.0, 5.0};
        this.realSymmetricTestCases2x2Double.add(new TestMatrixAndResultDouble(2, (double[])object4, (double[])object3));
        object2 = new double[]{1.0, 2.0, 2.0, 4.0};
        dArray = new double[]{0.0, 5.0};
        this.realSymmetricTestCases2x2Double.add(new TestMatrixAndResultDouble(2, (double[])object2, dArray));
        double[] dArray11 = new double[]{0.0, -1.0, -1.0, 1.0};
        double[] dArray12 = new double[]{-0.6180338859558105, 1.6180338859558105};
        this.realSymmetricTestCases2x2Double.add(new TestMatrixAndResultDouble(2, dArray11, dArray12));
        random = new Random(123456789L);
        for (int i = 0; i < 2000; ++i) {
            double[] dArray13 = new double[4];
            dArray13[0] = random.nextDouble();
            dArray13[1] = dArray13[2] = random.nextDouble();
            dArray13[3] = random.nextDouble();
            object = new double[2][2];
            for (int j = 0; j < 4; ++j) {
                object[j / 2][j % 2] = dArray13[j];
            }
            Matrix matrix = new Matrix((double[][])object);
            EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(matrix);
            double[] dArray14 = eigenvalueDecomposition.getRealEigenvalues();
            this.realSymmetricTestCases2x2Double.add(new TestMatrixAndResultDouble(2, dArray13, dArray14));
        }
        this.realSymmetricTestCases2x2Float = new ArrayList();
        for (TestMatrixAndResultDouble testMatrixAndResultDouble : this.realSymmetricTestCases2x2Double) {
            object = new TestMatrixAndResultFloat(2, testMatrixAndResultDouble.getMatrixFloats(), testMatrixAndResultDouble.getEvaluesFloats());
            this.realSymmetricTestCases2x2Float.add((TestMatrixAndResultFloat)object);
        }
    }

    @After
    public void tearDown() {
        this.realSymmetricTestCases3x3Float = null;
        this.realSymmetricTestCases3x3Double = null;
        this.realSymmetricTestCases2x2Float = null;
        this.realSymmetricTestCases2x2Double = null;
        System.gc();
    }

    @Test
    public void test3x3Jama() {
        long l = System.currentTimeMillis();
        for (TestMatrixAndResultDouble testMatrixAndResultDouble : this.realSymmetricTestCases3x3Double) {
            Matrix matrix = new Matrix(testMatrixAndResultDouble.m);
            EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(matrix);
            double[] dArray = eigenvalueDecomposition.getImagEigenvalues();
            boolean bl = false;
            for (int i = 0; i < dArray.length; ++i) {
                Assert.assertTrue((dArray[i] == 0.0 ? 1 : 0) != 0);
            }
            dArray = eigenvalueDecomposition.getRealEigenvalues();
            testMatrixAndResultDouble.checkEvalues(dArray);
        }
        if (this.printTimings) {
            System.out.println("testJama: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
    }

    @Test
    public void test3x3JacobiDouble() {
        long l = System.currentTimeMillis();
        for (TestMatrixAndResultDouble testMatrixAndResultDouble : this.realSymmetricTestCases3x3Double) {
            JacobiDouble jacobiDouble = new JacobiDouble(testMatrixAndResultDouble.m, 50);
            double[] dArray = jacobiDouble.getEigenValues();
            testMatrixAndResultDouble.checkEvalues(dArray);
        }
        if (this.printTimings) {
            System.out.println("testJacobiDouble: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
    }

    @Test
    public void test3x3JacobiFloat() {
        long l = System.currentTimeMillis();
        for (TestMatrixAndResultFloat testMatrixAndResultFloat : this.realSymmetricTestCases3x3Float) {
            JacobiFloat jacobiFloat = new JacobiFloat(testMatrixAndResultFloat.m, 50);
            float[] fArray = jacobiFloat.getEigenValues();
            testMatrixAndResultFloat.checkEvalues(fArray);
        }
        if (this.printTimings) {
            System.out.println("testJacobiFloat: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
    }

    @Test
    public void test3x3JacobiDoubleAgain() {
        long l = System.currentTimeMillis();
        for (TestMatrixAndResultDouble testMatrixAndResultDouble : this.realSymmetricTestCases3x3Double) {
            JacobiDouble jacobiDouble = new JacobiDouble(testMatrixAndResultDouble.m, 50);
            double[] dArray = jacobiDouble.getEigenValues();
            testMatrixAndResultDouble.checkEvalues(dArray);
        }
        if (this.printTimings) {
            System.out.println("testJacobiDoubleAgain: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
    }

    @Test
    public void test3x3RootFindingDouble() {
        long l = System.currentTimeMillis();
        for (TestMatrixAndResultDouble testMatrixAndResultDouble : this.realSymmetricTestCases3x3Double) {
            Eigensystem3x3Double eigensystem3x3Double = new Eigensystem3x3Double(testMatrixAndResultDouble.m);
            boolean bl = eigensystem3x3Double.findEvalues();
            assert (bl);
            if (!bl) continue;
            testMatrixAndResultDouble.checkEvalues(eigensystem3x3Double.eigenValues);
        }
        if (this.printTimings) {
            System.out.println("testRootFinding: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
    }

    @Test
    public void test3x3RootFindingFloat() {
        long l = System.currentTimeMillis();
        for (TestMatrixAndResultFloat testMatrixAndResultFloat : this.realSymmetricTestCases3x3Float) {
            Eigensystem3x3Float eigensystem3x3Float = new Eigensystem3x3Float(testMatrixAndResultFloat.m);
            boolean bl = eigensystem3x3Float.findEvalues();
            assert (bl);
            if (!bl) continue;
            testMatrixAndResultFloat.checkEvalues(eigensystem3x3Float.eigenValues);
        }
        if (this.printTimings) {
            System.out.println("testRootFinding: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
    }

    @Test
    public void test2x2Jama() {
        long l = System.currentTimeMillis();
        for (TestMatrixAndResultDouble testMatrixAndResultDouble : this.realSymmetricTestCases2x2Double) {
            Matrix matrix = new Matrix(testMatrixAndResultDouble.m);
            EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(matrix);
            double[] dArray = eigenvalueDecomposition.getImagEigenvalues();
            boolean bl = false;
            for (int i = 0; i < dArray.length; ++i) {
                Assert.assertTrue((dArray[i] == 0.0 ? 1 : 0) != 0);
            }
            dArray = eigenvalueDecomposition.getRealEigenvalues();
            testMatrixAndResultDouble.checkEvalues(dArray);
        }
        if (this.printTimings) {
            System.out.println("testJama: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
    }

    @Test
    public void test2x2JacobiDouble() {
        long l = System.currentTimeMillis();
        for (TestMatrixAndResultDouble testMatrixAndResultDouble : this.realSymmetricTestCases2x2Double) {
            JacobiDouble jacobiDouble = new JacobiDouble(testMatrixAndResultDouble.m, 50);
            double[] dArray = jacobiDouble.getEigenValues();
            testMatrixAndResultDouble.checkEvalues(dArray);
        }
        if (this.printTimings) {
            System.out.println("testJacobiDouble: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
    }

    @Test
    public void test2x2JacobiFloat() {
        long l = System.currentTimeMillis();
        for (TestMatrixAndResultFloat testMatrixAndResultFloat : this.realSymmetricTestCases2x2Float) {
            JacobiFloat jacobiFloat = new JacobiFloat(testMatrixAndResultFloat.m, 50);
            float[] fArray = jacobiFloat.getEigenValues();
            testMatrixAndResultFloat.checkEvalues(fArray);
        }
        if (this.printTimings) {
            System.out.println("testJacobiFloat: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
    }

    @Test
    public void test2x2JacobiDoubleAgain() {
        long l = System.currentTimeMillis();
        for (TestMatrixAndResultDouble testMatrixAndResultDouble : this.realSymmetricTestCases2x2Double) {
            JacobiDouble jacobiDouble = new JacobiDouble(testMatrixAndResultDouble.m, 50);
            double[] dArray = jacobiDouble.getEigenValues();
            testMatrixAndResultDouble.checkEvalues(dArray);
        }
        if (this.printTimings) {
            System.out.println("testJacobiDoubleAgain: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
    }

    @Test
    public void test2x2RootFindingDouble() {
        long l = System.currentTimeMillis();
        for (TestMatrixAndResultDouble testMatrixAndResultDouble : this.realSymmetricTestCases2x2Double) {
            Eigensystem2x2Double eigensystem2x2Double = new Eigensystem2x2Double(testMatrixAndResultDouble.m);
            boolean bl = eigensystem2x2Double.findEvalues();
            assert (bl);
            if (!bl) continue;
            testMatrixAndResultDouble.checkEvalues(eigensystem2x2Double.eigenValues);
        }
        if (this.printTimings) {
            System.out.println("testRootFinding: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
    }

    @Test
    public void test2x2RootFindingFloat() {
        long l = System.currentTimeMillis();
        for (TestMatrixAndResultFloat testMatrixAndResultFloat : this.realSymmetricTestCases2x2Float) {
            Eigensystem2x2Float eigensystem2x2Float = new Eigensystem2x2Float(testMatrixAndResultFloat.m);
            boolean bl = eigensystem2x2Float.findEvalues();
            assert (bl);
            if (!bl) continue;
            testMatrixAndResultFloat.checkEvalues(eigensystem2x2Float.eigenValues);
        }
        if (this.printTimings) {
            System.out.println("testRootFinding: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
    }

    static class TestMatrixAndResultFloat {
        int side;
        float[][] m;
        float[] evaluesResult;
        float[][] evectorsResult;

        TestMatrixAndResultFloat(int n, float[] fArray, float[] fArray2) {
            this.side = n;
            this.m = new float[n][n];
            this.evaluesResult = new float[n];
            this.evectorsResult = new float[n][n];
            for (int i = 0; i < n * n; ++i) {
                this.m[i / n][i % n] = fArray[i];
            }
            System.arraycopy(fArray2, 0, this.evaluesResult, 0, n);
        }

        TestMatrixAndResultFloat(int n, float[][] fArray, float[] fArray2) {
            this.side = n;
            this.m = new float[n][n];
            this.evaluesResult = new float[n];
            this.evectorsResult = new float[n][n];
            for (int i = 0; i < n * n; ++i) {
                this.m[i / n][i % n] = fArray[i / n][i % n];
            }
            System.arraycopy(fArray2, 0, this.evaluesResult, 0, n);
        }

        void checkEvalues(float[] fArray) {
            Assert.assertTrue((fArray.length == this.side ? 1 : 0) != 0);
            float[] fArray2 = new float[this.side];
            float[] fArray3 = new float[this.side];
            System.arraycopy(fArray, 0, fArray2, 0, this.side);
            System.arraycopy(this.evaluesResult, 0, fArray3, 0, this.side);
            Arrays.sort(fArray2);
            Arrays.sort(fArray3);
            for (int i = 0; i < this.side; ++i) {
                Assert.assertEquals((double)fArray3[i], (double)fArray2[i], (double)1.0E-6);
            }
        }
    }

    static class TestMatrixAndResultDouble {
        int side;
        double[][] m;
        double[] evaluesResult;
        double[][] evectorsResult;

        TestMatrixAndResultDouble(int n, double[] dArray, double[] dArray2) {
            this.side = n;
            this.m = new double[n][n];
            this.evaluesResult = new double[n];
            this.evectorsResult = new double[n][n];
            for (int i = 0; i < n * n; ++i) {
                this.m[i / n][i % n] = dArray[i];
            }
            System.arraycopy(dArray2, 0, this.evaluesResult, 0, n);
        }

        TestMatrixAndResultDouble(int n, double[][] dArray, double[] dArray2) {
            this.side = n;
            this.m = new double[n][n];
            this.evaluesResult = new double[n];
            this.evectorsResult = new double[n][n];
            for (int i = 0; i < n * n; ++i) {
                this.m[i / n][i % n] = dArray[i / n][i % n];
            }
            System.arraycopy(dArray2, 0, this.evaluesResult, 0, n);
        }

        void checkEvalues(double[] dArray) {
            Assert.assertTrue((dArray.length == this.side ? 1 : 0) != 0);
            double[] dArray2 = new double[this.side];
            double[] dArray3 = new double[this.side];
            System.arraycopy(dArray, 0, dArray2, 0, this.side);
            System.arraycopy(this.evaluesResult, 0, dArray3, 0, this.side);
            Arrays.sort(dArray2);
            Arrays.sort(dArray3);
            for (int i = 0; i < this.side; ++i) {
                Assert.assertEquals((double)dArray3[i], (double)dArray2[i], (double)1.0E-6);
            }
        }

        float[][] getMatrixFloats() {
            float[][] fArray = new float[this.side][this.side];
            for (int i = 0; i < this.side * this.side; ++i) {
                fArray[i / this.side][i % this.side] = (float)this.m[i / this.side][i % this.side];
            }
            return fArray;
        }

        float[] getEvaluesFloats() {
            float[] fArray = new float[this.side];
            for (int i = 0; i < this.side; ++i) {
                fArray[i] = (float)this.evaluesResult[i];
            }
            return fArray;
        }
    }
}

