/*
 * Decompiled with CFR 0.152.
 */
package nrrd;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Formatter;
import nrrd.NrrdAxisInfo;
import nrrd.NrrdHeader;

public class NrrdInfo {
    NrrdHeader nh;
    public static final int NRRD_DIM_MAX = 16;
    public static final int NRRD_SPACE_DIM_MAX = 8;
    public static final int NRRD_UNKNOWN = -1;
    public static final int NRRD_FALSE = 0;
    public static final int NRRD_TRUE = 1;
    public static final int NRRD_BIG_ENDIAN = 4321;
    public static final int NRRD_LITTLE_ENDIAN = 1234;
    String type;
    String encoding;
    int dim = -1;
    long[] sizes;
    long nsamples;
    long nbytes;
    int endian = -1;
    int lineSkip = 0;
    long byteSkip = 0L;
    boolean detachedHeader;
    public String primaryFileDirectory = null;
    public String primaryFileName = null;
    public File[] dataFiles = null;
    Object data;
    NrrdAxisInfo[] nai;
    String content;
    String sampleUnits;
    String contentType;
    String space;
    int spaceDim;
    String[] spaceUnits;
    double[] spaceOrigin;
    double[][] measurementFrame;
    double oldMin;
    double oldMax;
    private double[] spacings;
    private double[] thicknesses;
    private double[] axismins;
    private double[] axismaxs;
    private String[] centers;
    private String[] labels;
    private String[] kinds;
    private String[] units;
    private int dataFileSubDim = -1;
    private long dataFileByteSize;
    public static final String[] int8Types = new String[]{"char", "int8", "int8_t", "signed char"};
    public static final String[] uint8Types = new String[]{"uchar", "uint8", "uint8_t", "unsigned char"};
    public static final String[] int16Types = new String[]{"int16", "int16_t", "short", "short int", "signed short", "signed short int"};
    public static final String[] uint16Types = new String[]{"uint16", "uint16_t", "unsigned short", "unsigned short int", "ushort"};
    public static final String[] int32Types = new String[]{"int", "int32", "int32_t", "signed int"};
    public static final String[] uint32Types = new String[]{"uint", "uint32", "uint32_t", "unsigned int"};
    public static final String[] int64Types = new String[]{"int64", "int64_t", "long long", "long long int", "longlong", "signed long long", "signed long long int"};
    public static final String[] uint64Types = new String[]{"uint64", "uint64_t", "ulonglong", "unsigned long long", "unsigned long long int"};

    public NrrdInfo(NrrdHeader nrrdHeader) {
        this.nh = nrrdHeader;
    }

    public void parseHeader() throws Exception {
        try {
            String[] stringArray;
            long[] lArray;
            int[] nArray;
            this.encoding = this.getStandardEncoding(this.getStringFieldChecked("encoding", 1, true)[0]);
            if (this.encoding == null) {
                throw new Exception("Unknown encoding: " + this.getStringField("type"));
            }
            this.type = this.getStandardType(this.getStringFieldChecked("type", 1, true)[0]);
            if (this.type == null) {
                throw new Exception("Unknown data type: " + this.getStringField("type"));
            }
            this.dim = this.getIntegerFieldChecked("dimension", 1, true)[0];
            if (this.dim < 1 || this.dim > 16) {
                throw new Exception("dim out of range:" + this.dim);
            }
            this.sizes = this.getLongFieldChecked("sizes", this.dim, true);
            int n = this.type.equals("block") ? this.getIntegerFieldChecked("block size", 1, true)[0] : this.getByteSize(this.type);
            if (n < 1) {
                throw new Exception("Inferred byte size less than 1; check type or block size specification");
            }
            this.nsamples = this.sizes[0];
            for (int i = 1; i < this.dim; ++i) {
                this.nsamples *= this.sizes[i];
            }
            if (this.nsamples < 1L) {
                throw new Exception("Invalid number of samples: " + this.nsamples + "; check sizes field");
            }
            this.nbytes = this.nsamples * (long)n;
            if (!this.type.equals("block") && !this.encoding.equals("txt") && n > 1) {
                String string = this.getStringFieldChecked("endian", 1, true)[0];
                if (string.equals("little")) {
                    this.endian = 1234;
                } else if (string.equals("big")) {
                    this.endian = 4321;
                } else {
                    throw new Exception("Unknown endian specification: " + string);
                }
            }
            if ((nArray = this.getIntegerFieldChecked("line skip", 1, false)) != null) {
                this.lineSkip = nArray[0];
            }
            if ((lArray = this.getLongFieldChecked("byte skip", 1, false)) != null) {
                this.byteSkip = lArray[0];
            }
            this.primaryFileDirectory = this.nh.directory;
            this.primaryFileName = this.nh.filename;
            if (this.nh.detachedHeader) {
                int n2;
                int n3;
                String[] stringArray2 = this.getStringField("data file");
                if (stringArray2 == null) {
                    throw new Exception("Supposed to be a detached header file, but no data file field");
                }
                if (stringArray2.length == 1 || stringArray2.length == 2) {
                    if (stringArray2[0].equals("LIST")) {
                        if (this.nh.dataFiles == null || this.nh.dataFiles.size() == 0) {
                            throw new Exception("No data files listed after data file LIST line");
                        }
                        this.dataFileSubDim = stringArray2.length == 2 ? new Integer(stringArray2[1]) : this.dim - 1;
                        this.dataFiles = new File[this.nh.dataFiles.size()];
                        for (n3 = 0; n3 < this.dataFiles.length; ++n3) {
                            this.dataFiles[n3] = this.makeCheckedFile((String)this.nh.dataFiles.get(n3));
                        }
                    } else {
                        this.dataFiles = new File[1];
                        this.dataFiles[0] = this.makeCheckedFile(stringArray2[0]);
                    }
                } else {
                    int n4;
                    int n5;
                    String string = stringArray2[0];
                    try {
                        n2 = new Integer(stringArray2[1]);
                        n5 = new Integer(stringArray2[2]);
                        n4 = new Integer(stringArray2[3]);
                        this.dataFileSubDim = stringArray2.length == 5 ? new Integer(stringArray2[4]) : this.dim - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new Exception("Could not parse data file field; expected data file: <format> <min> <max> <step> [<subdim>]");
                    }
                    int n6 = 1 + (n5 - n2) / n4;
                    int n7 = n2;
                    this.dataFiles = new File[n6];
                    try {
                        for (int i = 0; i < n6; ++i) {
                            Formatter formatter = new Formatter().format(string, n7);
                            this.dataFiles[i] = this.makeCheckedFile(formatter.toString());
                            n7 += n4;
                        }
                    }
                    catch (IOException iOException) {
                        throw new IOException("Unable to find data files referred to by data file field");
                    }
                    catch (Exception exception) {
                        throw new Exception("Unable to process format specifier data file fields with Java<1.5");
                    }
                }
                if (this.dataFileSubDim != -1) {
                    if (this.dataFileSubDim < 1 || this.dataFileSubDim > this.dim) {
                        throw new Exception("Detached header subdim specification must be in range [1," + this.dim + "]");
                    }
                    if (this.dataFileSubDim == this.dim) {
                        if ((long)this.dataFiles.length % this.nsamples != 0L) {
                            throw new Exception("Number of slabs indicated by \"data file\" (" + this.dataFiles.length + ") does not divide evenly into number of samples (" + this.nsamples + ")");
                        }
                        this.dataFileByteSize = this.nbytes / (long)this.dataFiles.length;
                    } else if (this.dataFileSubDim < this.dim - 1) {
                        n3 = this.dim - 1;
                        n2 = (int)this.sizes[n3];
                        while (n3 >= this.dataFileSubDim) {
                            n2 = (int)((long)n2 * this.sizes[n3]);
                        }
                        if (n2 != this.dataFiles.length) {
                            throw new Exception("Number of data files indicated by \"data file\" (" + this.dataFiles.length + ") does not match product of dimension sizes >" + this.dataFileSubDim + " (ie " + n2 + ")");
                        }
                    } else if (this.dataFiles.length > 1 && (long)this.dataFiles.length != this.sizes[this.dim - 1]) {
                        throw new Exception("Number of data files indicated by \"data file\" (" + this.dataFiles.length + ") does not match final dimension size " + this.sizes[this.dim - 1]);
                    }
                }
            }
            if ((stringArray = this.getStringFieldChecked("space", 1, false)) != null) {
                this.processSpace(stringArray[0]);
            }
            if (this.spaceDim < 1 && (nArray = this.getIntegerFieldChecked("space dimension", 1, false)) != null) {
                this.spaceDim = nArray[0];
            }
            String[] stringArray3 = null;
            if (this.spaceDim > 0) {
                stringArray3 = this.getStringFieldChecked("space directions", this.dim, true);
                this.spaceUnits = this.getStringFieldChecked("space units", this.spaceDim, false);
                stringArray = this.getStringFieldChecked("space origin", 1, false);
                if (stringArray != null) {
                    this.spaceOrigin = this.getVector(stringArray[0], this.spaceDim);
                }
                String[] stringArray4 = this.getStringFieldChecked("measurement frame", this.dim, false);
                this.processMeasurementFrame(stringArray4);
            }
            this.spacings = this.getDoubleFieldChecked("spacings", this.dim, false);
            this.thicknesses = this.getDoubleFieldChecked("thicknesses", this.dim, false);
            this.axismins = this.getDoubleFieldChecked("axis mins", this.dim, false);
            this.axismaxs = this.getDoubleFieldChecked("axis maxs", this.dim, false);
            this.centers = this.getStringFieldChecked("centers", this.dim, false);
            this.labels = this.getStringFieldChecked("labels", this.dim, false);
            this.units = this.getStringFieldChecked("units", this.dim, false);
            this.kinds = this.getStringFieldChecked("kinds", this.dim, false);
            this.nai = new NrrdAxisInfo[this.dim];
            for (int i = 0; i < this.dim; ++i) {
                this.nai[i] = new NrrdAxisInfo();
                this.nai[i].size = this.sizes[i];
                if (stringArray3 != null) {
                    this.nai[i].setSpaceDirection(this.getVector(stringArray3[i], this.spaceDim));
                }
                if (this.axismins != null) {
                    this.nai[i].setMin(this.axismins[i]);
                }
                if (this.axismaxs != null) {
                    this.nai[i].setMax(this.axismaxs[i]);
                }
                if (this.units != null) {
                    this.nai[i].setUnits(this.units[i]);
                }
                if (this.centers != null) {
                    this.nai[i].center = this.centers[i];
                }
                if (this.labels != null) {
                    this.nai[i].label = this.labels[i];
                }
                if (this.kinds == null) continue;
                this.nai[i].kind = this.kinds[i];
            }
        }
        catch (Exception exception) {
            throw new Exception("nrrd: trouble parsing header for field: " + exception);
        }
    }

    File makeCheckedFile(String string) throws IOException {
        File file = new File(string);
        if (file.getParent() == null) {
            file = new File(this.primaryFileDirectory, string);
        }
        if (!file.exists()) {
            throw new IOException("Unable to find file: " + string);
        }
        return file;
    }

    boolean processMeasurementFrame(String[] stringArray) throws Exception {
        if (stringArray == null) {
            return false;
        }
        this.measurementFrame = new double[this.spaceDim][this.spaceDim];
        try {
            for (int i = 0; i < this.spaceDim; ++i) {
                this.measurementFrame[i] = this.getVector(stringArray[i], this.spaceDim);
            }
        }
        catch (Exception exception) {
            this.measurementFrame = null;
            throw new Exception("trouble parsing measurement frame:" + exception);
        }
        return true;
    }

    double[] getVector(String string, int n) throws Exception {
        double[] dArray;
        if (string.equals("none")) {
            return null;
        }
        if (string.startsWith("(") && string.endsWith(")")) {
            String[] stringArray = string.substring(1, string.length() - 1).split(",");
            if (n != stringArray.length) {
                throw new Exception("Vector " + string + " should have length: " + n);
            }
            dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                try {
                    if (stringArray[i].equals("nan")) {
                        dArray[i] = Double.NaN;
                        continue;
                    }
                    dArray[i] = new Double(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception("Can't parse component: " + stringArray[i] + " of vector: " + string);
                }
            }
        } else {
            throw new Exception("String " + string + " does not look like vector.");
        }
        return dArray;
    }

    int getByteSize(String string) {
        if (string.endsWith("int8")) {
            return 1;
        }
        if (string.endsWith("int16")) {
            return 2;
        }
        if (string.endsWith("int32") || string.equals("float")) {
            return 4;
        }
        if (string.endsWith("int64") || string.equals("double")) {
            return 8;
        }
        return -1;
    }

    public String getStandardType(String string) {
        if (string.equals("float") || string.equals("double") || string.equals("block")) {
            return string;
        }
        if (Arrays.binarySearch(int8Types, string) >= 0) {
            return "int8";
        }
        if (Arrays.binarySearch(uint8Types, string) >= 0) {
            return "uint8";
        }
        if (Arrays.binarySearch(int16Types, string) >= 0) {
            return "int16";
        }
        if (Arrays.binarySearch(uint16Types, string) >= 0) {
            return "uint16";
        }
        if (Arrays.binarySearch(int32Types, string) >= 0) {
            return "int32";
        }
        if (Arrays.binarySearch(uint32Types, string) >= 0) {
            return "uint32";
        }
        if (Arrays.binarySearch(int64Types, string) >= 0) {
            return "int64";
        }
        if (Arrays.binarySearch(uint64Types, string) >= 0) {
            return "uint64";
        }
        return null;
    }

    String getStandardEncoding(String string) {
        if (string.equals("raw") || string.equals("hex")) {
            return string;
        }
        if (string.equals("txt") || string.equals("text") || string.equals("ascii")) {
            return "txt";
        }
        if (string.equals("gz") || string.equals("gzip")) {
            return "gz";
        }
        if (string.equals("bz2") || string.equals("bzip2")) {
            return "bz2";
        }
        return null;
    }

    boolean processSpace(String string) throws Exception {
        if (string == null) {
            return false;
        }
        if (string.equals("ras") || string.equals("right-anterior-superior")) {
            this.space = "right-anterior-superior";
            this.spaceDim = 3;
        } else if (string.equals("rast") || string.equals("right-anterior-superior-time")) {
            this.space = "right-anterior-superior-time";
            this.spaceDim = 4;
        } else if (string.equals("las") || string.equals("left-anterior-superior")) {
            this.space = "left-anterior-superior";
            this.spaceDim = 3;
        } else if (string.equals("last") || string.equals("left-anterior-superior-time")) {
            this.space = "left-anterior-superior-time";
            this.spaceDim = 4;
        } else if (string.equals("lps") || string.equals("left-posterior-superior")) {
            this.space = "left-posterior-superior";
            this.spaceDim = 3;
        } else if (string.equals("lpst") || string.equals("left-posterior-superior-time")) {
            this.space = "left-posterior-superior-time";
            this.spaceDim = 4;
        } else if (string.startsWith("scanner-xyz") || string.startsWith("3d-right-handed") || string.startsWith("3d-left-handed")) {
            this.space = string;
            this.spaceDim = string.endsWith("-time") ? 4 : 3;
        } else {
            throw new Exception("Unknown space: " + string);
        }
        return true;
    }

    public String[] getStringField(String string) {
        if (this.nh.fields.containsKey(string)) {
            return (String[])this.nh.fields.get(string);
        }
        return null;
    }

    public double[] getDoubleField(String string) {
        if (this.nh.fields.containsKey(string)) {
            String[] stringArray = (String[])this.nh.fields.get(string);
            double[] dArray = new double[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                dArray[i] = stringArray[i].equals("nan") ? Double.NaN : new Double(stringArray[i]);
            }
            return dArray;
        }
        return null;
    }

    public long[] getLongField(String string) {
        if (this.nh.fields.containsKey(string)) {
            String[] stringArray = (String[])this.nh.fields.get(string);
            long[] lArray = new long[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                lArray[i] = new Long(stringArray[i]);
            }
            return lArray;
        }
        return null;
    }

    public int[] getIntegerField(String string) {
        if (this.nh.fields.containsKey(string)) {
            String[] stringArray = (String[])this.nh.fields.get(string);
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = new Integer(stringArray[i]);
            }
            return nArray;
        }
        return null;
    }

    public String[] getStringFieldChecked(String string, int n, boolean bl) throws Exception {
        String[] stringArray = this.getStringField(string);
        if (stringArray == null) {
            if (bl) {
                throw new Exception("Required field: " + string + " is missing");
            }
            return null;
        }
        if (stringArray.length != n) {
            throw new Exception("Field: " + string + " must have exactly " + n + " values");
        }
        return stringArray;
    }

    public int[] getIntegerFieldChecked(String string, int n, boolean bl) throws Exception {
        int[] nArray = this.getIntegerField(string);
        if (nArray == null) {
            if (bl) {
                throw new Exception("Required field: " + string + " is missing");
            }
            return null;
        }
        if (nArray.length != n) {
            throw new Exception("Field: " + string + " must have exactly " + n + " values");
        }
        return nArray;
    }

    public long[] getLongFieldChecked(String string, int n, boolean bl) throws Exception {
        long[] lArray = this.getLongField(string);
        if (lArray == null) {
            if (bl) {
                throw new Exception("Required field: " + string + " is missing");
            }
            return null;
        }
        if (lArray != null && lArray.length != n) {
            throw new Exception("Field: " + string + " must have exactly " + n + " values");
        }
        return lArray;
    }

    public double[] getDoubleFieldChecked(String string, int n, boolean bl) throws Exception {
        double[] dArray = this.getDoubleField(string);
        if (dArray == null) {
            if (bl) {
                throw new Exception("Required field: " + string + " is missing");
            }
            return null;
        }
        if (dArray != null && dArray.length != n) {
            throw new Exception("Field: " + string + " must have exactly " + n + " values");
        }
        return dArray;
    }

    public static void main(String[] stringArray) {
        System.out.println("Double nan " + new Double("NaN"));
    }
}

