/*
 * Decompiled with CFR 0.152.
 */
package octree;

import ij3d.AxisConstants;
import java.awt.image.BufferedImage;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import octree.CubeData;

public class AppearanceCreator
implements AxisConstants {
    private static final int TEX_MODE = 1;
    private static final int COMP_TYPE = 10;
    private static final boolean BY_REF = true;
    private static final boolean Y_UP = true;
    private static final int SIZE = 256;
    private TextureAttributes texAttr;
    private TransparencyAttributes transAttr;
    private PolygonAttributes polyAttr;
    private Material material;
    private ColoringAttributes colAttr;
    private RenderingAttributes rendAttr;
    private static AppearanceCreator instance;

    private AppearanceCreator() {
        this.initAttributes(null, 0.1f);
    }

    public static AppearanceCreator instance() {
        if (instance == null) {
            instance = new AppearanceCreator();
        }
        return instance;
    }

    public Appearance getAppearance(CubeData cubeData, int n) {
        Appearance appearance = new Appearance();
        appearance.setMaterial(this.material);
        appearance.setTransparencyAttributes(this.transAttr);
        appearance.setPolygonAttributes(this.polyAttr);
        appearance.setColoringAttributes(this.colAttr);
        appearance.setRenderingAttributes(this.rendAttr);
        appearance.setTexture((Texture)this.getTexture(cubeData, n));
        appearance.setTexCoordGeneration(cubeData.tg);
        appearance.setTextureAttributes(this.texAttr);
        return appearance;
    }

    public void setTransparency(float f) {
        this.transAttr.setTransparency(f);
    }

    public void setThreshold(float f) {
        this.rendAttr.setAlphaTestValue(f);
    }

    public void setColor(Color3f color3f) {
        this.colAttr.setColor(color3f);
    }

    private Texture2D getTexture(CubeData cubeData, int n) {
        BufferedImage bufferedImage = cubeData.images[n];
        Texture2D texture2D = new Texture2D(1, 1, 256, 256);
        ImageComponent2D imageComponent2D = new ImageComponent2D(10, 256, 256, true, true);
        imageComponent2D.set(bufferedImage);
        texture2D.setImage(0, (ImageComponent)imageComponent2D);
        texture2D.setEnable(true);
        texture2D.setMinFilter(3);
        texture2D.setMagFilter(3);
        texture2D.setBoundaryModeS(2);
        texture2D.setBoundaryModeT(2);
        return texture2D;
    }

    private void initAttributes(Color3f color3f, float f) {
        this.texAttr = new TextureAttributes();
        this.texAttr.setTextureMode(6);
        this.texAttr.setCombineRgbMode(1);
        this.texAttr.setPerspectiveCorrectionMode(1);
        this.transAttr = new TransparencyAttributes();
        this.transAttr.setTransparency(0.1f);
        this.transAttr.setCapability(3);
        this.transAttr.setTransparencyMode(2);
        this.transAttr.setTransparency(f);
        this.polyAttr = new PolygonAttributes();
        this.polyAttr.setCullFace(0);
        this.material = new Material();
        this.material.setLightingEnable(false);
        this.colAttr = new ColoringAttributes();
        this.colAttr.setCapability(1);
        this.colAttr.setShadeModel(1);
        if (color3f == null) {
            this.colAttr.setColor(1.0f, 1.0f, 1.0f);
        } else {
            this.colAttr.setColor(color3f);
        }
        this.rendAttr = new RenderingAttributes();
        this.rendAttr.setCapability(1);
        this.rendAttr.setAlphaTestValue(0.1f);
        this.rendAttr.setAlphaTestFunction(6);
    }
}

