/*
 * Decompiled with CFR 0.152.
 */
package octree;

import ij.IJ;
import java.util.List;
import octree.Cube;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubeUpdater {
    private List<Cube> queue;
    private static final int nThreads = Runtime.getRuntime().availableProcessors();
    private Thread[] threads = new WorkingThread[nThreads];
    private Thread currentThread;
    private boolean cancelled = false;
    private int orgSize;
    private int done;

    public void updateCubes(List<Cube> list) {
        this.queue = list;
        this.orgSize = list.size();
        this.done = 0;
        for (int i = 0; i < nThreads; ++i) {
            this.threads[i] = new WorkingThread();
            this.threads[i].start();
        }
        this.cancelled = false;
        this.currentThread = Thread.currentThread();
        for (Thread thread : this.threads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                System.out.println("interrupted");
            }
        }
        for (int i = 0; i < nThreads; ++i) {
            this.threads[i] = null;
        }
    }

    public void cancel() {
        this.cancelled = true;
        this.currentThread.interrupt();
    }

    public synchronized Cube poll() {
        return this.queue.remove(this.queue.size() - 1);
    }

    private final class WorkingThread
    extends Thread {
        private WorkingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Cube cube = null;
                CubeUpdater cubeUpdater = CubeUpdater.this;
                synchronized (cubeUpdater) {
                    if (CubeUpdater.this.queue.isEmpty() || CubeUpdater.this.cancelled) {
                        break;
                    }
                    cube = CubeUpdater.this.poll();
                    try {
                        if (!cube.cubeDataUpToDate()) {
                            cube.updateCubeData();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    CubeUpdater.this.done++;
                    if (CubeUpdater.this.done % 50 == 0) {
                        IJ.showProgress((int)CubeUpdater.this.done, (int)CubeUpdater.this.orgSize);
                    }
                }
            }
        }
    }
}

