/*
 * Decompiled with CFR 0.152.
 */
package octree;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Shape3D;
import octree.AppearanceCreator;
import octree.Cube;
import octree.CubeData;
import octree.GeometryCreator;

public class ShapeGroup
implements Comparable {
    float pos;
    Cube cube;
    Shape3D shape;

    public ShapeGroup(Cube cube) {
        this.cube = cube;
    }

    public ShapeGroup(ShapeGroup shapeGroup) {
        Shape3D shape3D = shapeGroup.shape;
        this.shape = new Shape3D(shape3D.getGeometry(), shape3D.getAppearance());
        this.cube = shapeGroup.cube;
        this.pos = shapeGroup.pos;
    }

    void setCubeData(Cube cube, CubeData cubeData, int n) {
        this.cube = cube;
        if (this.shape == null) {
            this.shape = new Shape3D((Geometry)this.createGeometry(cubeData, n), this.createAppearance(cubeData, n));
            return;
        }
        ((GeometryArray)this.shape.getGeometry()).setCoordinates(0, GeometryCreator.instance().getQuadCoordinates(cubeData, n));
        Appearance appearance = this.shape.getAppearance();
        appearance.setTexCoordGeneration(cubeData.tg);
        ((ImageComponent2D)appearance.getTexture().getImage(0)).set(cubeData.images[n]);
    }

    private GeometryArray createGeometry(CubeData cubeData, int n) {
        GeometryArray geometryArray = GeometryCreator.instance().getQuad(cubeData, n);
        return geometryArray;
    }

    private Appearance createAppearance(CubeData cubeData, int n) {
        return AppearanceCreator.instance().getAppearance(cubeData, n);
    }

    public int compareTo(Object object) {
        ShapeGroup shapeGroup = (ShapeGroup)object;
        if (this.pos < shapeGroup.pos) {
            return -1;
        }
        if (this.pos > shapeGroup.pos) {
            return 1;
        }
        return 0;
    }
}

