/*
 * Decompiled with CFR 0.152.
 */
package octree;

import ij3d.AxisConstants;
import ij3d.Content;
import ij3d.UniverseListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Properties;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.OrderedGroup;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import octree.Cube;
import octree.CubeData;
import octree.OctreeBehavior;
import octree.ShapeGroup;

public class VolumeOctree
implements UniverseListener,
AxisConstants {
    public static final int SIZE = 256;
    static final int DETAIL_AXIS = 6;
    private static final int[][] axisIndex = new int[3][2];
    private final Switch axisSwitch;
    private String imageDir;
    private final Cube rootCube;
    private final BranchGroup rootBranchGroup;
    int curAxis = 2;
    int curDir = 0;
    private final int xdim;
    private final int ydim;
    private final int zdim;
    final float pw;
    final float ph;
    final float pd;
    private final Point3d refPt;
    private final OctreeBehavior behavior;
    private BitSet bitset = new BitSet(6);
    private Vector3d eyeVec = new Vector3d();
    private static Transform3D parentInv = new Transform3D();
    private static Point3d viewPosition = new Point3d();
    private static Transform3D t = new Transform3D();

    public VolumeOctree(String string, Canvas3D canvas3D) throws RuntimeException {
        this.imageDir = string;
        VolumeOctree.axisIndex[0][0] = 0;
        VolumeOctree.axisIndex[0][1] = 1;
        VolumeOctree.axisIndex[1][0] = 2;
        VolumeOctree.axisIndex[1][1] = 3;
        VolumeOctree.axisIndex[2][0] = 4;
        VolumeOctree.axisIndex[2][1] = 5;
        this.axisSwitch = new Switch();
        this.axisSwitch.setCapability(18);
        this.axisSwitch.setCapability(13);
        this.axisSwitch.setCapability(14);
        for (int i = 0; i < 7; ++i) {
            this.axisSwitch.addChild((Node)VolumeOctree.getOrderedGroup());
        }
        this.rootBranchGroup = new BranchGroup();
        this.rootBranchGroup.addChild((Node)this.axisSwitch);
        this.rootBranchGroup.setCapability(17);
        this.rootBranchGroup.setCapability(11);
        this.behavior = new OctreeBehavior(canvas3D, this);
        BoundingSphere boundingSphere = new BoundingSphere();
        boundingSphere.setRadius(10000.0);
        this.behavior.setSchedulingBounds((Bounds)boundingSphere);
        this.behavior.setEnable(true);
        this.rootBranchGroup.addChild((Node)this.behavior);
        Properties properties = new Properties();
        int n = 1;
        try {
            properties.load(new FileInputStream(new File(string, "props.txt")));
            this.xdim = Integer.parseInt(properties.getProperty("width"));
            this.ydim = Integer.parseInt(properties.getProperty("height"));
            this.zdim = Integer.parseInt(properties.getProperty("depth"));
            n = Integer.parseInt(properties.getProperty("level"));
            this.pw = Float.parseFloat(properties.getProperty("pixelWidth"));
            this.ph = Float.parseFloat(properties.getProperty("pixelHeight"));
            this.pd = Float.parseFloat(properties.getProperty("pixelDepth"));
            this.rootCube = new Cube(this, string, 0, 0, 0, n);
            this.rootCube.createChildren();
            this.refPt = new Point3d((double)((float)this.xdim * this.pw / 2.0f), (double)((float)this.ydim * this.ph / 2.0f), (double)((float)this.zdim * this.pd / 2.0f));
        }
        catch (Exception exception) {
            throw new RuntimeException("Error in property file.", exception);
        }
    }

    public void update() {
        this.behavior.postId(1);
    }

    public void cancel() {
        this.behavior.cancel();
    }

    public BranchGroup getRootBranchGroup() {
        return this.rootBranchGroup;
    }

    public Cube getRootCube() {
        return this.rootCube;
    }

    public float realWorldXDim() {
        return (float)this.xdim * this.pw;
    }

    public float realWorldYDim() {
        return (float)this.ydim * this.ph;
    }

    public float realWorldZDim() {
        return (float)this.zdim * this.pd;
    }

    public void displayInitial() {
        int[] nArray = new int[]{0, 1, 2};
        for (int i = 0; i < 3; ++i) {
            CubeData cubeData = new CubeData(this.rootCube);
            cubeData.prepareForAxis(nArray[i]);
            try {
                cubeData.createData();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Arrays.sort(cubeData.shapes);
            OrderedGroup orderedGroup = this.getOrderedGroup(axisIndex[nArray[i]][0]);
            OrderedGroup orderedGroup2 = this.getOrderedGroup(axisIndex[nArray[i]][1]);
            for (int j = 0; j < 256; ++j) {
                BranchGroup branchGroup = VolumeOctree.getBranchGroup();
                branchGroup.addChild((Node)new ShapeGroup((ShapeGroup)cubeData.shapes[j]).shape);
                orderedGroup.addChild((Node)branchGroup);
                branchGroup = VolumeOctree.getBranchGroup();
                branchGroup.addChild((Node)new ShapeGroup((ShapeGroup)cubeData.shapes[j]).shape);
                orderedGroup2.insertChild((Node)branchGroup, 0);
            }
        }
        this.setWhichChild(axisIndex[this.curAxis][this.curDir]);
        System.out.println("# shapes: " + this.countInitialShapes());
    }

    final void removeAllCubes() {
        OrderedGroup orderedGroup = this.getOrderedGroup(6);
        for (int i = orderedGroup.numChildren() - 1; i >= 0; --i) {
            BranchGroup branchGroup = (BranchGroup)orderedGroup.getChild(i);
            branchGroup.detach();
            branchGroup.removeAllChildren();
        }
    }

    final void setWhichChild(int n) {
        this.axisSwitch.setWhichChild(n);
    }

    final void setCombinedWhichChild() {
        this.axisSwitch.setWhichChild(-3);
        this.bitset.clear();
        this.bitset.set(6, true);
        this.bitset.set(axisIndex[this.curAxis][this.curDir], true);
        this.axisSwitch.setChildMask(this.bitset);
    }

    final OrderedGroup getOrderedGroup(int n) {
        return (OrderedGroup)this.axisSwitch.getChild(n);
    }

    static final BranchGroup getBranchGroup() {
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        return branchGroup;
    }

    final int countDetailShapes() {
        return this.getOrderedGroup(6).numChildren();
    }

    private final int countInitialShapes() {
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            OrderedGroup orderedGroup = this.getOrderedGroup(i);
            n += orderedGroup.numChildren();
        }
        return n;
    }

    private static final OrderedGroup getOrderedGroup() {
        OrderedGroup orderedGroup = new OrderedGroup();
        orderedGroup.setCapability(14);
        orderedGroup.setCapability(13);
        return orderedGroup;
    }

    public void transformationUpdated(View view) {
        int n;
        Point3d point3d = VolumeOctree.getViewPosInLocal(view, (Node)this.rootBranchGroup);
        if (point3d == null) {
            return;
        }
        this.eyeVec.sub((Tuple3d)point3d, (Tuple3d)this.refPt);
        int n2 = 0;
        double d = this.eyeVec.x;
        double d2 = Math.abs(this.eyeVec.x);
        if (Math.abs(this.eyeVec.y) > d2) {
            n2 = 1;
            d = this.eyeVec.y;
            d2 = Math.abs(this.eyeVec.y);
        }
        if (Math.abs(this.eyeVec.z) > d2) {
            n2 = 2;
            d = this.eyeVec.z;
            d2 = Math.abs(this.eyeVec.z);
        }
        int n3 = n = d > 0.0 ? 0 : 1;
        if (n2 != this.curAxis || n != this.curDir) {
            this.curAxis = n2;
            this.curDir = n;
            this.setWhichChild(axisIndex[this.curAxis][this.curDir]);
        }
    }

    public void transformationStarted(View view) {
        this.cancel();
        this.axisSwitch.setWhichChild(axisIndex[this.curAxis][this.curDir]);
    }

    public void transformationFinished(View view) {
        this.update();
    }

    public void contentAdded(Content content) {
    }

    public void contentRemoved(Content content) {
    }

    public void contentChanged(Content content) {
    }

    public void contentSelected(Content content) {
    }

    public void canvasResized() {
    }

    public void universeClosed() {
    }

    private static Point3d getViewPosInLocal(View view, Node node) {
        if (node == null) {
            return null;
        }
        if (!node.isLive()) {
            return null;
        }
        Canvas3D canvas3D = view.getCanvas3D(0);
        canvas3D.getCenterEyeInImagePlate(viewPosition);
        canvas3D.getImagePlateToVworld(t);
        t.transform(viewPosition);
        node.getLocalToVworld(parentInv);
        parentInv.invert();
        parentInv.transform(viewPosition);
        return viewPosition;
    }
}

