/*
 * Decompiled with CFR 0.152.
 */
package oldsegmenters;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.util.ArrayList;
import oldsegmenters.SegmentatorModel;

public class LabelBinaryOps
implements PlugInFilter {
    public int setup(String string, ImagePlus imagePlus) {
        return 1;
    }

    public void run(ImageProcessor imageProcessor) {
        SegmentatorModel segmentatorModel = new SegmentatorModel(IJ.getImage());
        int n = segmentatorModel.data.getCurrentSlice();
        ImageProcessor imageProcessor2 = segmentatorModel.getLabelImagePlus().getStack().getProcessor(n);
        if (segmentatorModel.getCurrentMaterial() == null) {
            IJ.showMessage((String)"please select a label first");
            return;
        }
        LabelBinaryOps.close(imageProcessor2, IJ.getImage().getRoi(), (byte)segmentatorModel.getCurrentMaterial().id);
        segmentatorModel.updateSlice(n);
    }

    public static void dilate(ImageProcessor imageProcessor, Roi roi, byte by) {
        int n = imageProcessor.getWidth();
        byte[] byArray = (byte[])imageProcessor.getPixels();
        LabelBinaryOps.dilate(roi, byArray, n, by);
    }

    private static void dilate(Roi roi, byte[] byArray, int n, byte by) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Rectangle rectangle = roi != null ? roi.getBoundingRect() : new Rectangle(0, 0, n, byArray.length / n);
        for (int i = rectangle.x; i <= rectangle.x + rectangle.width; ++i) {
            block1: for (int j = rectangle.y; j <= rectangle.y + rectangle.height; ++j) {
                if (!roi.contains(i, j)) continue;
                for (int k = i - 1; k <= i + 1; ++k) {
                    for (int i2 = j - 1; i2 <= j + 1; ++i2) {
                        int n2 = k + i2 * n;
                        if (n2 < 0 || n2 >= byArray.length || byArray[n2] != by) continue;
                        arrayList.add(i + j * n);
                        continue block1;
                    }
                }
            }
        }
        for (Integer n3 : arrayList) {
            byArray[n3.intValue()] = by;
        }
    }

    public static void erode(ImageProcessor imageProcessor, Roi roi, byte by) {
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n = imageProcessor.getWidth();
        LabelBinaryOps.erode(roi, byArray, n, by);
    }

    private static void erode(Roi roi, byte[] byArray, int n, byte by) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Rectangle rectangle = roi != null ? roi.getBoundingRect() : new Rectangle(0, 0, n, byArray.length / n);
        for (int i = rectangle.x; i <= rectangle.x + rectangle.width; ++i) {
            block1: for (int j = rectangle.y; j <= rectangle.y + rectangle.height; ++j) {
                if (!roi.contains(i, j)) continue;
                for (int k = i - 1; k <= i + 1; ++k) {
                    for (int i2 = j - 1; i2 <= j + 1; ++i2) {
                        int n2 = k + i2 * n;
                        if (n2 < 0 || n2 >= byArray.length || byArray[n2] == by || byArray[i + j * n] != by) continue;
                        arrayList.add(i + j * n);
                        continue block1;
                    }
                }
            }
        }
        for (Integer n3 : arrayList) {
            byArray[n3.intValue()] = 0;
        }
    }

    public static void close(ImageProcessor imageProcessor, Roi roi, byte by) {
        LabelBinaryOps.dilate(imageProcessor, roi, by);
        LabelBinaryOps.erode(imageProcessor, roi, by);
    }

    public static void open(ImageProcessor imageProcessor, Roi roi, byte by) {
        LabelBinaryOps.erode(imageProcessor, roi, by);
        LabelBinaryOps.dilate(imageProcessor, roi, by);
    }

    public static void clean(Roi roi, byte[] byArray, int n, byte by) {
        LabelBinaryOps.dilate(roi, byArray, n, by);
        LabelBinaryOps.erode(roi, byArray, n, by);
        LabelBinaryOps.erode(roi, byArray, n, by);
        LabelBinaryOps.dilate(roi, byArray, n, by);
    }
}

