/*
 * Decompiled with CFR 0.152.
 */
package oldsegmenters;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import math3d.Line;
import math3d.Plane;
import math3d.Point3d;
import oldsegmenters.LabelBinaryOps;
import oldsegmenters.SegmentatorModel;
import oldsegmenters.Utils;

public class LabelInterpolator_
implements PlugIn {
    public void run(String string) {
        LabelInterpolator_.interpolate(new SegmentatorModel(IJ.getImage()));
    }

    public static void interpolate(SegmentatorModel segmentatorModel) {
        if (segmentatorModel.getCurrentMaterial() == null) {
            IJ.showMessage((String)"please select a label first");
            return;
        }
        StackData stackData = new StackData(segmentatorModel, segmentatorModel.getCurrentMaterial().id);
        System.out.println("stack data = " + stackData);
        IJ.showProgress((double)0.5);
        for (Interpolation interpolation : stackData.getInterpolations()) {
            interpolation.interpolate();
            for (int i = interpolation.firstIndex; i <= interpolation.secondIndex; ++i) {
                segmentatorModel.updateSliceNoRedraw(i);
            }
        }
        IJ.showProgress((double)1.0);
        segmentatorModel.data.updateAndDraw();
    }

    private static class Interpolation {
        byte[] labelledPixels1;
        byte[] labelledPixels2;
        int firstIndex;
        int secondIndex;
        int width;
        int color;
        Rectangle bounds;
        ArrayList<byte[]> interpolatedPixels = new ArrayList();

        private Interpolation() {
        }

        int getDistance() {
            return this.interpolatedPixels.size();
        }

        int getPixel(int n, int n2, byte[] byArray) {
            return byArray[n + n2 * this.width];
        }

        void setPixel(int n, int n2, int n3, byte[] byArray) {
            byArray[n + n2 * this.width] = (byte)n3;
        }

        void interpolate() {
            for (int i = this.bounds.x; i < this.bounds.x + this.bounds.width; ++i) {
                for (int j = this.bounds.y; j < this.bounds.y + this.bounds.height; ++j) {
                    Object object;
                    Point point;
                    if (this.getPixel(i, j, this.labelledPixels1) != this.color && this.getPixel(i, j, this.labelledPixels2) != this.color) continue;
                    if (this.getPixel(i, j, this.labelledPixels1) == this.color && this.getPixel(i, j, this.labelledPixels2) == this.color) {
                        for (byte[] byArray : this.interpolatedPixels) {
                            this.setPixel(i, j, this.color, byArray);
                        }
                        continue;
                    }
                    if (this.getPixel(i, j, this.labelledPixels1) == this.color) {
                        point = this.getNearest(new Point(i, j), this.labelledPixels2, this.width, this.color);
                        if (point == null) continue;
                        object = new Line(new Point3d(i, j, this.firstIndex), new Point3d(point.x, point.y, this.secondIndex));
                    } else {
                        point = this.getNearest(new Point(i, j), this.labelledPixels1, this.width, this.color);
                        if (point == null) continue;
                        object = new Line(new Point3d(i, j, this.secondIndex), new Point3d(point.x, point.y, this.firstIndex));
                    }
                    int n = this.firstIndex;
                    for (byte[] byArray : this.interpolatedPixels) {
                        int n2 = ++n;
                        Plane plane = new Plane(0.0, 0.0, 1.0, -n2);
                        Point3d point3d = plane.intersection((Line)object);
                        this.setPixel((int)Math.floor(point3d.x), (int)Math.ceil(point3d.y), this.color, byArray);
                        this.setPixel((int)Math.floor(point3d.x), (int)Math.floor(point3d.y), this.color, byArray);
                        this.setPixel((int)Math.ceil(point3d.x), (int)Math.floor(point3d.y), this.color, byArray);
                        this.setPixel((int)Math.ceil(point3d.x), (int)Math.ceil(point3d.y), this.color, byArray);
                    }
                }
            }
            for (byte[] byArray : this.interpolatedPixels) {
                LabelBinaryOps.clean(new Roi(this.bounds), byArray, this.width, (byte)this.color);
            }
            System.out.println("one interpolation done");
        }

        private Point getNearest(Point point, byte[] byArray, int n, int n2) {
            Point point2;
            Utils.Spiral spiral = new Utils.Spiral(point);
            boolean bl = false;
            do {
                point2 = spiral.next();
            } while (point2.x < 0 || point2.x >= n || point2.y < 0 || point2.y >= byArray.length / n || byArray[point2.x + point2.y * n] != n2);
            return point2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StackData {
        ImagePlus labelsData;
        ArrayList<Integer> labelledSlices = new ArrayList();
        SegmentatorModel model;
        int label;

        public StackData(SegmentatorModel segmentatorModel, int n) {
            this.model = segmentatorModel;
            this.labelsData = segmentatorModel.getLabelImagePlus();
            this.label = n;
            this.findLabelledSlices();
        }

        private void findLabelledSlices() {
            block0: for (int i = 1; i <= this.labelsData.getStackSize(); ++i) {
                byte[] byArray = (byte[])this.labelsData.getStack().getProcessor(i).getPixels();
                for (int j = 0; j < byArray.length; ++j) {
                    byte by = byArray[j];
                    if (by != this.label) continue;
                    this.labelledSlices.add(i);
                    continue block0;
                }
            }
        }

        public Iterable<Interpolation> getInterpolations() {
            LinkedList<Interpolation> linkedList = new LinkedList<Interpolation>();
            for (int i = 0; i < this.labelledSlices.size() - 1; ++i) {
                Interpolation interpolation = new Interpolation();
                int n = this.labelledSlices.get(i);
                int n2 = this.labelledSlices.get(i + 1);
                interpolation.width = this.model.getLabelImagePlus().getWidth();
                interpolation.color = this.label;
                interpolation.firstIndex = n;
                interpolation.secondIndex = n2;
                interpolation.labelledPixels1 = (byte[])this.labelsData.getStack().getProcessor(n).getPixels();
                interpolation.labelledPixels2 = (byte[])this.labelsData.getStack().getProcessor(n2).getPixels();
                interpolation.bounds = this.model.getLabelCanvas().getOutline(n, this.label).getBounds();
                interpolation.bounds.add(this.model.getLabelCanvas().getOutline(n2, this.label).getBounds());
                for (int j = n + 1; j < n2; ++j) {
                    interpolation.interpolatedPixels.add((byte[])this.labelsData.getStack().getProcessor(j).getPixels());
                }
                linkedList.add(interpolation);
            }
            return linkedList;
        }

        public String toString() {
            return "labelledSlices: " + this.labelledSlices;
        }
    }
}

