/*
 * Decompiled with CFR 0.152.
 */
package oldsegmenters;

import ij.gui.ShapeRoi;
import java.awt.Point;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Iterator;

public class Utils {
    public static final ShapeRoi toShapeRoi(PathIterator pathIterator) {
        int n;
        float[] fArray;
        ArrayList<Float> arrayList = new ArrayList<Float>();
        while (!pathIterator.isDone()) {
            fArray = new float[6];
            n = pathIterator.currentSegment(fArray);
            arrayList.add(Float.valueOf(n));
            if (n == 0 || n == 1) {
                arrayList.add(Float.valueOf(fArray[0]));
                arrayList.add(Float.valueOf(fArray[1]));
            } else if (n != 4) {
                throw new UnsupportedOperationException("upgrade ShapeBuilder " + n);
            }
            pathIterator.next();
        }
        fArray = new float[arrayList.size()];
        for (n = 0; n < fArray.length; ++n) {
            fArray[n] = ((Float)arrayList.get(n)).floatValue();
        }
        return new ShapeRoi(fArray);
    }

    public static void main(String[] stringArray) {
        Spiral spiral = new Spiral(new Point(5, 5));
        for (int i = 0; i < 20; ++i) {
            System.out.println(spiral.next());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Spiral
    implements Iterator<Point> {
        private Point currentCorner;
        private Point currentPoint;
        int depth = 0;
        boolean applyX = false;

        public Spiral(Point point) {
            this.currentPoint = new Point(point.x, point.y);
            this.currentCorner = new Point(point.x, point.y);
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        public Point nextCorner() {
            int n;
            int n2 = n = this.depth % 2 == 0 ? this.depth : -this.depth;
            if (this.applyX) {
                this.applyX = false;
                this.currentCorner.x += n;
            } else {
                this.applyX = true;
                this.currentCorner.y += n;
                ++this.depth;
            }
            return this.currentCorner;
        }

        @Override
        public Point next() {
            int n;
            int n2;
            if (this.currentPoint.equals(this.currentCorner)) {
                this.currentCorner = this.nextCorner();
            }
            if ((n2 = this.currentPoint.x - this.currentCorner.x) > 0) {
                --this.currentPoint.x;
            }
            if (n2 < 0) {
                ++this.currentPoint.x;
            }
            if ((n = this.currentPoint.y - this.currentCorner.y) > 0) {
                --this.currentPoint.y;
            }
            if (n < 0) {
                ++this.currentPoint.y;
            }
            return this.currentPoint;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

