/*
 * Decompiled with CFR 0.152.
 */
package orthoslice;

import ij.ImagePlus;
import java.util.BitSet;
import javax.media.j3d.Group;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.View;
import javax.vecmath.Color3f;
import voltex.VolumeRenderer;

public class Orthoslice
extends VolumeRenderer {
    private int[] slices = new int[3];
    private int[] dimensions = new int[3];
    private boolean[] visible = new boolean[3];
    private BitSet whichChild = new BitSet(6);

    public Orthoslice(ImagePlus imagePlus, Color3f color3f, float f, boolean[] blArray) {
        super(imagePlus, color3f, f, blArray);
        this.appCreator.setOpaqueTextures(true);
        this.dimensions[0] = imagePlus.getWidth();
        this.dimensions[1] = imagePlus.getHeight();
        this.dimensions[2] = imagePlus.getStackSize();
        for (int i = 0; i < 3; ++i) {
            this.slices[i] = this.dimensions[i] / 2;
            this.visible[i] = true;
            this.whichChild.set(i, true);
            this.whichChild.set(i + 3, true);
        }
    }

    protected void loadAxis(int n) {
        Group group = (Group)this.axisSwitch.getChild(this.axisIndex[n][0]);
        Group group2 = (Group)this.axisSwitch.getChild(this.axisIndex[n][1]);
        int n2 = this.slices[n];
        this.loadAxis(n, n2, group, group2);
    }

    public void eyePtChanged(View view) {
        this.axisSwitch.setWhichChild(-3);
        this.axisSwitch.setChildMask(this.whichChild);
    }

    public int getSlice(int n) {
        return this.slices[n];
    }

    public boolean isVisible(int n) {
        return this.visible[n];
    }

    public void setVisible(int n, boolean bl) {
        if (this.visible[n] != bl) {
            this.visible[n] = bl;
            this.whichChild.set(this.axisIndex[n][0], bl);
            this.whichChild.set(this.axisIndex[n][1], bl);
            this.axisSwitch.setChildMask(this.whichChild);
        }
    }

    public void decrease(int n) {
        this.setSlice(n, this.slices[n] - 1);
    }

    public void increase(int n) {
        this.setSlice(n, this.slices[n] + 1);
    }

    public void setSlice(int n, int n2) {
        if (n2 >= this.dimensions[n] || n2 < 0) {
            return;
        }
        this.slices[n] = n2;
        Group group = (Group)this.axisSwitch.getChild(this.axisIndex[n][0]);
        int n3 = group.numChildren();
        if (n3 > 1) {
            System.out.println(n3 + " children, expected only 1");
        }
        Shape3D shape3D = (Shape3D)((Group)group.getChild(n3 - 1)).getChild(0);
        double[] dArray = this.geomCreator.getQuadCoords(n, n2);
        ((QuadArray)shape3D.getGeometry()).setCoordinates(0, dArray);
        Texture2D texture2D = this.appCreator.getTexture(n, n2);
        shape3D.getAppearance().setTexture((Texture)texture2D);
        TexCoordGeneration texCoordGeneration = this.appCreator.getTg(n);
        shape3D.getAppearance().setTexCoordGeneration(texCoordGeneration);
    }
}

