/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.math.MachineAccuracy;
import pal.math.MersenneTwisterFast;
import pal.math.MultivariateFunction;
import pal.math.MultivariateMinimum;

public class ConjugateDirectionSearch
extends MultivariateMinimum {
    public int prin = 0;
    public double step = 1.0;
    public double scbd = 1.0;
    public boolean illc = false;
    public boolean interrupt = false;
    private int i;
    private int j;
    private int k;
    private int k2;
    private int nl;
    private int kl;
    private int kt;
    private double s;
    private double sl;
    private double dn;
    private double dmin;
    private double fx;
    private double f1;
    private double lds;
    private double ldt;
    private double sf;
    private double df;
    private double qf1;
    private double qd0;
    private double qd1;
    private double qa;
    private double qb;
    private double qc;
    private double small;
    private double vsmall;
    private double large;
    private double vlarge;
    private double ldfac;
    private double t2;
    private double[] d;
    private double[] y;
    private double[] z;
    private double[] q0;
    private double[] q1;
    private double[][] v;
    private double[] tflin;
    private int dim;
    private double[] x;
    private MultivariateFunction fun;
    private double h;
    private double t;
    private MersenneTwisterFast rng = new MersenneTwisterFast();
    private double min1;
    private double min2;

    public void optimize(MultivariateFunction multivariateFunction, double[] dArray, double d, double d2) {
        block65: {
            this.t = d2;
            this.fun = multivariateFunction;
            this.x = dArray;
            this.checkBounds(this.x);
            this.h = this.step;
            this.dim = this.fun.getNumArguments();
            this.d = new double[this.dim];
            this.y = new double[this.dim];
            this.z = new double[this.dim];
            this.q0 = new double[this.dim];
            this.q1 = new double[this.dim];
            this.v = new double[this.dim][this.dim];
            this.tflin = new double[this.dim];
            this.small = MachineAccuracy.EPSILON * MachineAccuracy.EPSILON;
            this.vsmall = this.small * this.small;
            this.large = 1.0 / this.small;
            this.vlarge = 1.0 / this.vsmall;
            this.ldfac = this.illc ? 0.1 : 0.01;
            this.kt = 0;
            this.nl = 0;
            this.numFun = 1;
            this.fx = this.fun.evaluate(this.x);
            this.stopCondition(this.fx, this.x, d, d2, true);
            this.qf1 = this.fx;
            this.t = this.t2 = this.small + Math.abs(this.t);
            this.dmin = this.small;
            if (this.h < 100.0 * this.t) {
                this.h = 100.0 * this.t;
            }
            this.ldt = this.h;
            this.i = 0;
            while (this.i < this.dim) {
                this.j = 0;
                while (this.j < this.dim) {
                    this.v[this.i][this.j] = this.i == this.j ? 1.0 : 0.0;
                    ++this.j;
                }
                ++this.i;
            }
            this.d[0] = 0.0;
            this.qd0 = 0.0;
            this.i = 0;
            while (this.i < this.dim) {
                this.q1[this.i] = this.x[this.i];
                ++this.i;
            }
            if (this.prin > 1) {
                System.out.println("\n------------- enter function praxis -----------\n");
                System.out.println("... current parameter settings ...");
                System.out.println("... scaling ... " + this.scbd);
                System.out.println("...   tolx  ... " + this.t);
                System.out.println("...  tolfx  ... " + d);
                System.out.println("... maxstep ... " + this.h);
                System.out.println("...   illc  ... " + this.illc);
                System.out.println("... maxFun  ... " + this.maxFun);
            }
            if (this.prin > 0) {
                System.out.println();
            }
            do {
                this.sf = this.d[0];
                this.d[0] = 0.0;
                this.s = 0.0;
                this.min1 = this.d[0];
                this.min2 = this.s;
                this.min(0, 2, this.fx, false);
                this.d[0] = this.min1;
                this.s = this.min2;
                if (this.s <= 0.0) {
                    this.i = 0;
                    while (this.i < this.dim) {
                        this.v[this.i][0] = -this.v[this.i][0];
                        ++this.i;
                    }
                }
                if (this.sf <= 0.9 * this.d[0] || 0.9 * this.sf >= this.d[0]) {
                    this.i = 1;
                    while (this.i < this.dim) {
                        this.d[this.i] = 0.0;
                        ++this.i;
                    }
                }
                boolean bl = false;
                this.k = 1;
                while (this.k < this.dim) {
                    boolean bl2;
                    this.i = 0;
                    while (this.i < this.dim) {
                        this.y[this.i] = this.x[this.i];
                        ++this.i;
                    }
                    this.sf = this.fx;
                    boolean bl3 = this.illc = this.illc || this.kt > 0;
                    do {
                        if (this.interrupt) {
                            return;
                        }
                        this.kl = this.k;
                        this.df = 0.0;
                        if (this.illc) {
                            this.i = 0;
                            while (this.i < this.dim) {
                                this.z[this.i] = (0.1 * this.ldt + this.t2 * Math.pow(10.0, this.kt)) * (this.rng.nextDouble() - 0.5);
                                this.s = this.z[this.i];
                                this.j = 0;
                                while (this.j < this.dim) {
                                    int n = this.j;
                                    this.x[n] = this.x[n] + this.s * this.v[this.j][this.i];
                                    ++this.j;
                                }
                                ++this.i;
                            }
                            this.checkBounds(this.x);
                            this.fx = this.fun.evaluate(this.x);
                            ++this.numFun;
                            if (this.interrupt) {
                                return;
                            }
                        }
                        this.k2 = this.k;
                        while (this.k2 < this.dim) {
                            this.sl = this.fx;
                            this.s = 0.0;
                            this.min1 = this.d[this.k2];
                            this.min2 = this.s;
                            this.min(this.k2, 2, this.fx, false);
                            if (this.interrupt) {
                                return;
                            }
                            this.d[this.k2] = this.min1;
                            this.s = this.min2;
                            if (this.illc) {
                                double d3 = this.s + this.z[this.k2];
                                this.s = this.d[this.k2] * d3 * d3;
                            } else {
                                this.s = this.sl - this.fx;
                            }
                            if (this.df < this.s) {
                                this.df = this.s;
                                this.kl = this.k2;
                            }
                            ++this.k2;
                        }
                        if (!this.illc && this.df < Math.abs(100.0 * MachineAccuracy.EPSILON * this.fx)) {
                            this.illc = true;
                            bl2 = true;
                            continue;
                        }
                        bl2 = false;
                    } while (bl2);
                    if (this.k == 1 && this.prin > 1) {
                        this.vecprint("\n... New Direction ...", this.d);
                    }
                    this.k2 = 0;
                    while (this.k2 <= this.k - 1) {
                        this.s = 0.0;
                        this.min1 = this.d[this.k2];
                        this.min2 = this.s;
                        this.min(this.k2, 2, this.fx, false);
                        if (this.interrupt) {
                            return;
                        }
                        this.d[this.k2] = this.min1;
                        this.s = this.min2;
                        ++this.k2;
                    }
                    this.f1 = this.fx;
                    this.fx = this.sf;
                    this.lds = 0.0;
                    this.i = 0;
                    while (this.i < this.dim) {
                        this.sl = this.x[this.i];
                        this.x[this.i] = this.y[this.i];
                        this.y[this.i] = this.sl - this.y[this.i];
                        this.sl = this.y[this.i];
                        this.lds += this.sl * this.sl;
                        ++this.i;
                    }
                    this.checkBounds(this.x);
                    this.lds = Math.sqrt(this.lds);
                    if (this.lds > this.small) {
                        this.i = this.kl - 1;
                        while (this.i >= this.k) {
                            this.j = 0;
                            while (this.j < this.dim) {
                                this.v[this.j][this.i + 1] = this.v[this.j][this.i];
                                ++this.j;
                            }
                            this.d[this.i + 1] = this.d[this.i];
                            --this.i;
                        }
                        this.d[this.k] = 0.0;
                        this.i = 0;
                        while (this.i < this.dim) {
                            this.v[this.i][this.k] = this.y[this.i] / this.lds;
                            ++this.i;
                        }
                        this.min1 = this.d[this.k];
                        this.min2 = this.lds;
                        this.min(this.k, 4, this.f1, true);
                        if (this.interrupt) {
                            return;
                        }
                        this.d[this.k] = this.min1;
                        this.lds = this.min2;
                        if (this.lds <= 0.0) {
                            this.lds = -this.lds;
                            this.i = 0;
                            while (this.i < this.dim) {
                                this.v[this.i][this.k] = -this.v[this.i][this.k];
                                ++this.i;
                            }
                        }
                    }
                    this.ldt = this.ldfac * this.ldt;
                    if (this.ldt < this.lds) {
                        this.ldt = this.lds;
                    }
                    if (this.prin > 1) {
                        this.print();
                    }
                    this.kt = this.stopCondition(this.fx, this.x, d, d2, false) ? ++this.kt : 0;
                    if (this.kt > 1) {
                        bl = true;
                        break;
                    }
                    ++this.k;
                }
                if (bl) break block65;
                this.quadr();
                this.dn = 0.0;
                this.i = 0;
                while (this.i < this.dim) {
                    this.d[this.i] = 1.0 / Math.sqrt(this.d[this.i]);
                    if (this.dn < this.d[this.i]) {
                        this.dn = this.d[this.i];
                    }
                    ++this.i;
                }
                if (this.prin > 2) {
                    this.matprint("\n... New Matrix of Directions ...", this.v);
                }
                this.j = 0;
                while (this.j < this.dim) {
                    this.s = this.d[this.j] / this.dn;
                    this.i = 0;
                    while (this.i < this.dim) {
                        double[] dArray2 = this.v[this.i];
                        int n = this.j;
                        dArray2[n] = dArray2[n] * this.s;
                        ++this.i;
                    }
                    ++this.j;
                }
                if (this.scbd > 1.0) {
                    this.s = this.vlarge;
                    this.i = 0;
                    while (this.i < this.dim) {
                        this.sl = 0.0;
                        this.j = 0;
                        while (this.j < this.dim) {
                            this.sl += this.v[this.i][this.j] * this.v[this.i][this.j];
                            ++this.j;
                        }
                        this.z[this.i] = Math.sqrt(this.sl);
                        if (this.z[this.i] < MachineAccuracy.SQRT_SQRT_EPSILON) {
                            this.z[this.i] = MachineAccuracy.SQRT_SQRT_EPSILON;
                        }
                        if (this.s > this.z[this.i]) {
                            this.s = this.z[this.i];
                        }
                        ++this.i;
                    }
                    this.i = 0;
                    while (this.i < this.dim) {
                        this.sl = this.s / this.z[this.i];
                        this.z[this.i] = 1.0 / this.sl;
                        if (this.z[this.i] > this.scbd) {
                            this.sl = 1.0 / this.scbd;
                            this.z[this.i] = this.scbd;
                        }
                        ++this.i;
                    }
                }
                this.i = 1;
                while (this.i < this.dim) {
                    this.j = 0;
                    while (this.j <= this.i - 1) {
                        this.s = this.v[this.i][this.j];
                        this.v[this.i][this.j] = this.v[this.j][this.i];
                        this.v[this.j][this.i] = this.s;
                        ++this.j;
                    }
                    ++this.i;
                }
                this.minfit(this.dim, MachineAccuracy.EPSILON, this.vsmall, this.v, this.d);
                if (this.scbd > 1.0) {
                    this.i = 0;
                    while (this.i < this.dim) {
                        this.s = this.z[this.i];
                        this.j = 0;
                        while (this.j < this.dim) {
                            double[] dArray3 = this.v[this.i];
                            int n = this.j++;
                            dArray3[n] = dArray3[n] * this.s;
                        }
                        ++this.i;
                    }
                    this.i = 0;
                    while (this.i < this.dim) {
                        this.s = 0.0;
                        this.j = 0;
                        while (this.j < this.dim) {
                            this.s += this.v[this.j][this.i] * this.v[this.j][this.i];
                            ++this.j;
                        }
                        this.s = Math.sqrt(this.s);
                        int n = this.i;
                        this.d[n] = this.d[n] * this.s;
                        this.s = 1.0 / this.s;
                        this.j = 0;
                        while (this.j < this.dim) {
                            double[] dArray4 = this.v[this.j];
                            int n2 = this.i;
                            dArray4[n2] = dArray4[n2] * this.s;
                            ++this.j;
                        }
                        ++this.i;
                    }
                }
                this.i = 0;
                while (this.i < this.dim) {
                    this.d[this.i] = this.dn * this.d[this.i] > this.large ? this.vsmall : (this.dn * this.d[this.i] < this.small ? this.vlarge : Math.pow(this.dn * this.d[this.i], -2.0));
                    ++this.i;
                }
                this.sort();
                this.dmin = this.d[this.dim - 1];
                if (this.dmin < this.small) {
                    this.dmin = this.small;
                }
                boolean bl4 = this.illc = MachineAccuracy.SQRT_EPSILON * this.d[0] > this.dmin;
                if (this.prin > 2 && this.scbd > 1.0) {
                    this.vecprint("\n... Scale Factors ...", this.z);
                }
                if (this.prin > 2) {
                    this.vecprint("\n... Eigenvalues of A ...", this.d);
                }
                if (this.prin <= 2) continue;
                this.matprint("\n... Eigenvectors of A ...", this.v);
            } while (this.maxFun <= 0 || this.nl <= this.maxFun);
            if (this.prin > 0) {
                System.out.println("\n... maximum number of function calls reached ...");
            }
        }
        if (this.prin > 0) {
            this.vecprint("\n... Final solution is ...", this.x);
            System.out.println("\n... Function value reduced to " + this.fx + " ...");
            System.out.println("... after " + this.numFun + " function calls.");
        }
    }

    private void sort() {
        for (int i = 0; i < this.dim - 1; ++i) {
            int n;
            int n2 = i;
            double d = this.d[i];
            for (n = i + 1; n < this.dim; ++n) {
                if (!(this.d[n] > d)) continue;
                n2 = n;
                d = this.d[n];
            }
            if (n2 <= i) continue;
            this.d[n2] = this.d[i];
            this.d[i] = d;
            for (n = 0; n < this.dim; ++n) {
                d = this.v[n][i];
                this.v[n][i] = this.v[n][n2];
                this.v[n][n2] = d;
            }
        }
    }

    private void vecprint(String string, double[] dArray) {
        System.out.println(string);
        for (int i = 0; i < dArray.length; ++i) {
            System.out.print(dArray[i] + "  ");
        }
        System.out.println();
    }

    private void print() {
        System.out.println();
        System.out.println("... function value reduced to ... " + this.fx);
        System.out.println("... after " + this.numFun + " function calls ...");
        System.out.println("... including " + this.nl + " linear searches ...");
        this.vecprint("... current values of x ...", this.x);
    }

    private void matprint(String string, double[][] dArray) {
        System.out.println(string);
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                System.out.print(dArray[i][j] + " ");
            }
            System.out.println();
        }
    }

    private double flin(double d, int n) {
        if (n != -1) {
            for (int i = 0; i < this.dim; ++i) {
                this.tflin[i] = this.x[i] + d * this.v[i][n];
            }
        } else {
            this.qa = d * (d - this.qd1) / (this.qd0 * (this.qd0 + this.qd1));
            this.qb = (d + this.qd0) * (this.qd1 - d) / (this.qd0 * this.qd1);
            this.qc = d * (d + this.qd0) / (this.qd1 * (this.qd0 + this.qd1));
            for (int i = 0; i < this.dim; ++i) {
                this.tflin[i] = this.qa * this.q0[i] + this.qb * this.x[i] + this.qc * this.q1[i];
            }
        }
        this.checkBounds(this.tflin);
        ++this.numFun;
        return this.fun.evaluate(this.tflin);
    }

    private void checkBounds(double[] dArray) {
        for (int i = 0; i < this.dim; ++i) {
            if (dArray[i] < this.fun.getLowerBound(i)) {
                dArray[i] = this.fun.getLowerBound(i);
            }
            if (!(dArray[i] > this.fun.getUpperBound(i))) continue;
            dArray[i] = this.fun.getUpperBound(i);
        }
    }

    private void min(int n, int n2, double d, boolean bl) {
        double d2;
        double d3;
        int n3;
        double d4;
        double d5 = d;
        double d6 = this.min2;
        int n4 = 0;
        double d7 = 0.0;
        double d8 = d4 = this.fx;
        boolean bl2 = this.min1 < MachineAccuracy.EPSILON;
        double d9 = 0.0;
        for (n3 = 0; n3 < this.dim; ++n3) {
            d9 += this.x[n3] * this.x[n3];
        }
        d9 = Math.sqrt(d9);
        double d10 = bl2 ? MachineAccuracy.SQRT_SQRT_EPSILON * Math.sqrt(Math.abs(this.fx) / this.dmin + d9 * this.ldt) + MachineAccuracy.SQRT_EPSILON * this.ldt : MachineAccuracy.SQRT_SQRT_EPSILON * Math.sqrt(Math.abs(this.fx) / this.min1 + d9 * this.ldt) + MachineAccuracy.SQRT_EPSILON * this.ldt;
        d9 = d9 * MachineAccuracy.SQRT_SQRT_EPSILON + this.t;
        if (bl2 && d10 > d9) {
            d10 = d9;
        }
        if (d10 < this.small) {
            d10 = this.small;
        }
        if (d10 > 0.01 * this.h) {
            d10 = 0.01 * this.h;
        }
        if (bl && d <= d8) {
            d7 = this.min2;
            d8 = d;
        }
        if (!bl || Math.abs(this.min2) < d10) {
            this.min2 = this.min2 > 0.0 ? d10 : -d10;
            d = this.flin(this.min2, n);
            if (this.interrupt) {
                return;
            }
        }
        if (d <= d8) {
            d7 = this.min2;
            d8 = d;
        }
        block1: do {
            if (bl2) {
                d3 = d4 < d ? -this.min2 : 2.0 * this.min2;
                d2 = this.flin(d3, n);
                if (this.interrupt) {
                    return;
                }
                if (d2 <= d8) {
                    d7 = d3;
                    d8 = d2;
                }
                this.min1 = (d3 * (d - d4) - this.min2 * (d2 - d4)) / (this.min2 * d3 * (this.min2 - d3));
            }
            double d11 = (d - d4) / this.min2 - this.min2 * this.min1;
            bl2 = true;
            d3 = this.min1 <= this.small ? (d11 < 0.0 ? this.h : -this.h) : -0.5 * d11 / this.min1;
            if (Math.abs(d3) > this.h) {
                d3 = d3 > 0.0 ? this.h : -this.h;
            }
            d2 = this.flin(d3, n);
            if (this.interrupt) {
                return;
            }
            n3 = 0;
            while (n4 < n2 && d2 > d4) {
                ++n4;
                if (d4 < d && this.min2 * d3 > 0.0) {
                    n3 = 1;
                    continue block1;
                }
                d2 = this.flin(d3 *= 0.5, n);
                if (!this.interrupt) continue;
                return;
            }
        } while (n3 != 0);
        ++this.nl;
        if (d2 > d8) {
            d3 = d7;
        } else {
            d8 = d2;
        }
        if (Math.abs(d3 * (d3 - this.min2)) > this.small) {
            this.min1 = (d3 * (d - d4) - this.min2 * (d8 - d4)) / (this.min2 * d3 * (this.min2 - d3));
        } else if (n4 > 0) {
            this.min1 = 0.0;
        }
        if (this.min1 <= this.small) {
            this.min1 = this.small;
        }
        this.min2 = d3;
        this.fx = d8;
        if (d5 < this.fx) {
            this.fx = d5;
            this.min2 = d6;
        }
        if (n != -1) {
            this.i = 0;
            while (this.i < this.dim) {
                int n5 = this.i;
                this.x[n5] = this.x[n5] + this.min2 * this.v[this.i][n];
                ++this.i;
            }
            this.checkBounds(this.x);
        }
    }

    private void quadr() {
        double d;
        int n;
        double d2 = this.fx;
        this.fx = this.qf1;
        this.qf1 = d2;
        this.qd1 = 0.0;
        for (n = 0; n < this.dim; ++n) {
            d2 = this.x[n];
            this.x[n] = d = this.q1[n];
            this.q1[n] = d2;
            this.qd1 += (d2 - d) * (d2 - d);
        }
        d2 = 0.0;
        d = this.qd1 = Math.sqrt(this.qd1);
        if (this.qd0 > 0.0 && this.qd1 > 0.0 && this.nl >= 3 * this.dim * this.dim) {
            this.min1 = d2;
            this.min2 = d;
            this.min(-1, 2, this.qf1, true);
            d2 = this.min1;
            d = this.min2;
            this.qa = d * (d - this.qd1) / (this.qd0 * (this.qd0 + this.qd1));
            this.qb = (d + this.qd0) * (this.qd1 - d) / (this.qd0 * this.qd1);
            this.qc = d * (d + this.qd0) / (this.qd1 * (this.qd0 + this.qd1));
        } else {
            this.fx = this.qf1;
            this.qb = 0.0;
            this.qa = 0.0;
            this.qc = 1.0;
        }
        this.qd0 = this.qd1;
        for (n = 0; n < this.dim; ++n) {
            d2 = this.q0[n];
            this.q0[n] = this.x[n];
            this.x[n] = this.qa * d2 + this.qb * this.x[n] + this.qc * this.q1[n];
        }
        this.checkBounds(this.x);
    }

    private void minfit(int n, double d, double d2, double[][] dArray, double[] dArray2) {
        double d3;
        int n2;
        double d4;
        double d5;
        int n3;
        double d6;
        int n4;
        int n5 = 0;
        double[] dArray3 = new double[this.dim];
        double d7 = 0.0;
        double d8 = 0.0;
        for (n4 = 0; n4 < n; ++n4) {
            dArray3[n4] = d7;
            d6 = 0.0;
            n5 = n4 + 1;
            for (n3 = n4; n3 < n; ++n3) {
                d6 += dArray[n3][n4] * dArray[n3][n4];
            }
            if (d6 < d2) {
                d7 = 0.0;
            } else {
                d5 = dArray[n4][n4];
                d7 = d5 < 0.0 ? Math.sqrt(d6) : -Math.sqrt(d6);
                d4 = d5 * d7 - d6;
                dArray[n4][n4] = d5 - d7;
                for (n3 = n5; n3 < n; ++n3) {
                    d5 = 0.0;
                    for (n2 = n4; n2 < n; ++n2) {
                        d5 += dArray[n2][n4] * dArray[n2][n3];
                    }
                    d5 /= d4;
                    for (n2 = n4; n2 < n; ++n2) {
                        double[] dArray4 = dArray[n2];
                        int n6 = n3;
                        dArray4[n6] = dArray4[n6] + d5 * dArray[n2][n4];
                    }
                }
            }
            dArray2[n4] = d7;
            d6 = 0.0;
            if (n4 < n) {
                for (n3 = n5; n3 < n; ++n3) {
                    d6 += dArray[n4][n3] * dArray[n4][n3];
                }
            }
            if (d6 < d2) {
                d7 = 0.0;
            } else {
                d5 = dArray[n4][n4 + 1];
                d7 = d5 < 0.0 ? Math.sqrt(d6) : -Math.sqrt(d6);
                d4 = d5 * d7 - d6;
                dArray[n4][n4 + 1] = d5 - d7;
                for (n3 = n5; n3 < n; ++n3) {
                    dArray3[n3] = dArray[n4][n3] / d4;
                }
                for (n3 = n5; n3 < n; ++n3) {
                    d6 = 0.0;
                    for (n2 = n5; n2 < n; ++n2) {
                        d6 += dArray[n3][n2] * dArray[n4][n2];
                    }
                    for (n2 = n5; n2 < n; ++n2) {
                        double[] dArray5 = dArray[n3];
                        int n7 = n2;
                        dArray5[n7] = dArray5[n7] + d6 * dArray3[n2];
                    }
                }
            }
            d3 = Math.abs(dArray2[n4]) + Math.abs(dArray3[n4]);
            if (!(d3 > d8)) continue;
            d8 = d3;
        }
        n4 = n - 1;
        while (n4 >= 0) {
            if (d7 != 0.0) {
                d4 = dArray[n4][n4 + 1] * d7;
                for (n3 = n5; n3 < n; ++n3) {
                    dArray[n3][n4] = dArray[n4][n3] / d4;
                }
                for (n3 = n5; n3 < n; ++n3) {
                    d6 = 0.0;
                    for (n2 = n5; n2 < n; ++n2) {
                        d6 += dArray[n4][n2] * dArray[n2][n3];
                    }
                    for (n2 = n5; n2 < n; ++n2) {
                        double[] dArray6 = dArray[n2];
                        int n8 = n3;
                        dArray6[n8] = dArray6[n8] + d6 * dArray[n2][n4];
                    }
                }
            }
            for (n3 = n5; n3 < n; ++n3) {
                dArray[n3][n4] = 0.0;
                dArray[n4][n3] = 0.0;
            }
            dArray[n4][n4] = 1.0;
            d7 = dArray3[n4];
            n5 = n4--;
        }
        d *= d8;
        boolean bl = false;
        for (n2 = n - 1; n2 >= 0; --n2) {
            double d9;
            int n9 = 0;
            do {
                double d10;
                double d11;
                ++n9;
                boolean bl2 = false;
                int n10 = n2;
                while (n10 >= 0) {
                    if (Math.abs(dArray3[n5 = n10--]) <= d) {
                        bl2 = true;
                        break;
                    }
                    if (Math.abs(dArray2[n5 - 1]) <= d) break;
                }
                if (!bl2) {
                    d11 = 0.0;
                    d6 = 1.0;
                    for (n4 = n5; n4 <= n2; ++n4) {
                        d5 = d6 * dArray3[n4];
                        int n11 = n4;
                        dArray3[n11] = dArray3[n11] * d11;
                        if (Math.abs(d5) <= d) break;
                        d7 = dArray2[n4];
                        if (Math.abs(d5) < Math.abs(d7)) {
                            d10 = d5 / d7;
                            d4 = Math.abs(d7) * Math.sqrt(1.0 + d10 * d10);
                        } else {
                            d10 = d7 / d5;
                            d4 = d5 != 0.0 ? Math.abs(d5) * Math.sqrt(1.0 + d10 * d10) : 0.0;
                        }
                        dArray2[n4] = d4;
                        if (d4 == 0.0) {
                            d4 = 1.0;
                            d7 = 1.0;
                        }
                        d11 = d7 / d4;
                        d6 = -d5 / d4;
                    }
                }
                d9 = dArray2[n2];
                if (n5 == n2) {
                    bl = true;
                    break;
                }
                d8 = dArray2[n5];
                d3 = dArray2[n2 - n5];
                d7 = dArray3[n2 - 1];
                d4 = dArray3[n2];
                d5 = ((d3 - d9) * (d3 + d9) + (d7 - d4) * (d7 + d4)) / (2.0 * d4 * d3);
                d7 = Math.sqrt(d5 * d5 + 1.0);
                d5 = d5 <= 0.0 ? ((d8 - d9) * (d8 + d9) + d4 * (d3 / (d5 - d7) - d4)) / d8 : ((d8 - d9) * (d8 + d9) + d4 * (d3 / (d5 + d7) - d4)) / d8;
                d11 = 1.0;
                d6 = 1.0;
                for (n4 = n5 + 1; n4 <= n2; ++n4) {
                    d7 = dArray3[n4];
                    d3 = dArray2[n4];
                    d4 = d6 * d7;
                    d7 *= d11;
                    if (Math.abs(d5) < Math.abs(d4)) {
                        d10 = d5 / d4;
                        d9 = Math.abs(d4) * Math.sqrt(1.0 + d10 * d10);
                    } else {
                        d10 = d4 / d5;
                        d9 = d5 != 0.0 ? Math.abs(d5) * Math.sqrt(1.0 + d10 * d10) : 0.0;
                    }
                    dArray3[n4 - 1] = d9;
                    if (d9 == 0.0) {
                        d9 = 1.0;
                        d5 = 1.0;
                    }
                    d11 = d5 / d9;
                    d6 = d4 / d9;
                    d5 = d8 * d11 + d7 * d6;
                    d7 = -d8 * d6 + d7 * d11;
                    d4 = d3 * d6;
                    d3 *= d11;
                    for (n3 = 0; n3 < n; ++n3) {
                        d8 = dArray[n3][n4 - 1];
                        d9 = dArray[n3][n4];
                        dArray[n3][n4 - 1] = d8 * d11 + d9 * d6;
                        dArray[n3][n4] = -d8 * d6 + d9 * d11;
                    }
                    if (Math.abs(d5) < Math.abs(d4)) {
                        d10 = d5 / d4;
                        d9 = Math.abs(d4) * Math.sqrt(1.0 + d10 * d10);
                    } else {
                        d10 = d4 / d5;
                        d9 = d5 != 0.0 ? Math.abs(d5) * Math.sqrt(1.0 + d10 * d10) : 0.0;
                    }
                    dArray2[n4 - 1] = d9;
                    if (d9 == 0.0) {
                        d5 = 1.0;
                        d9 = 1.0;
                    }
                    d11 = d5 / d9;
                    d6 = d4 / d9;
                    d5 = d11 * d7 + d6 * d3;
                    d8 = -d6 * d7 + d11 * d3;
                }
                dArray3[n5] = 0.0;
                dArray3[n2] = d5;
                dArray2[n2] = d8;
            } while (n9 <= 30);
            if (!bl) {
                dArray3[n2] = 0.0;
                System.out.println("\n+++ qr failed\n");
                System.exit(1);
            }
            if (!(d9 < 0.0)) continue;
            dArray2[n2] = -d9;
            for (n3 = 0; n3 < n; ++n3) {
                dArray[n3][n2] = -dArray[n3][n2];
            }
        }
    }
}

