/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.math.MachineAccuracy;
import pal.math.MultivariateFunction;

public abstract class MultivariateMinimum {
    public int numFun;
    public int maxFun = 0;
    public int numFuncStops = 4;
    private int countFuncStops;
    private double fxold;
    private double[] xold;

    public double findMinimum(MultivariateFunction multivariateFunction, double[] dArray) {
        this.optimize(multivariateFunction, dArray, MachineAccuracy.EPSILON, MachineAccuracy.EPSILON);
        return multivariateFunction.evaluate(dArray);
    }

    public double findMinimum(MultivariateFunction multivariateFunction, double[] dArray, int n, int n2) {
        double d = Math.pow(10.0, -1 - n);
        double d2 = Math.pow(10.0, -1 - n2);
        this.optimize(multivariateFunction, dArray, d, d2);
        double d3 = Math.pow(10.0, n2);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (double)Math.round(dArray[i] * d3) / d3;
        }
        return (double)Math.round(multivariateFunction.evaluate(dArray) * d3) / d3;
    }

    public abstract void optimize(MultivariateFunction var1, double[] var2, double var3, double var5);

    public boolean stopCondition(double d, double[] dArray, double d2, double d3, boolean bl) {
        boolean bl2 = false;
        if (bl) {
            this.countFuncStops = 0;
            this.fxold = d;
            this.xold = new double[dArray.length];
            this.copy(this.xold, dArray);
        } else if (this.xStop(dArray, this.xold, d3)) {
            bl2 = true;
        } else {
            this.countFuncStops = this.fxStop(d, this.fxold, d2) ? ++this.countFuncStops : 0;
            if (this.countFuncStops >= this.numFuncStops) {
                bl2 = true;
            }
        }
        if (!bl2) {
            this.fxold = d;
            this.copy(this.xold, dArray);
        }
        return bl2;
    }

    public void copy(double[] dArray, double[] dArray2) {
        for (int i = 0; i < dArray2.length; ++i) {
            dArray[i] = dArray2[i];
        }
    }

    private boolean xStop(double[] dArray, double[] dArray2, double d) {
        boolean bl = true;
        for (int i = 0; i < dArray.length && bl; ++i) {
            if (!(Math.abs(dArray[i] - dArray2[i]) > d)) continue;
            bl = false;
        }
        return bl;
    }

    private boolean fxStop(double d, double d2, double d3) {
        return !(Math.abs(d - d2) > d3);
    }
}

