/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.math.MersenneTwisterFast;
import pal.math.MultivariateFunction;
import pal.math.MultivariateMinimum;
import pal.math.OrthogonalLineFunction;
import pal.math.UnivariateMinimum;

public class StochasticOSearch
extends MultivariateMinimum {
    private static MersenneTwisterFast random = new MersenneTwisterFast();
    private UnivariateMinimum um = new UnivariateMinimum();
    private int numArgs;

    public void optimize(MultivariateFunction multivariateFunction, double[] dArray, double d, double d2) {
        int n;
        this.numArgs = multivariateFunction.getNumArguments();
        this.numFun = 1;
        double d3 = multivariateFunction.evaluate(dArray);
        this.stopCondition(d3, dArray, d, d2, true);
        OrthogonalLineFunction orthogonalLineFunction = new OrthogonalLineFunction(multivariateFunction);
        orthogonalLineFunction.setAllArguments(dArray);
        int[] nArray = new int[this.numArgs];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = n;
        }
        do {
            random.shuffle(nArray);
            for (n = 0; n < this.numArgs; ++n) {
                int n2 = nArray[n];
                orthogonalLineFunction.selectArgument(n2);
                dArray[n2] = this.um.optimize(orthogonalLineFunction, d2);
                if (this.um.fminx < d3) {
                    orthogonalLineFunction.setArgument(dArray[n2]);
                    d3 = this.um.fminx;
                }
                this.numFun += this.um.numFun;
            }
        } while (!this.stopCondition(d3, dArray, d, d2, false) && (this.maxFun <= 0 || this.numFun <= this.maxFun) && this.numArgs != 1);
    }
}

