/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class Distance_Transform_3D
implements PlugInFilter {
    private static final float SQ1 = 1.0f;
    private static final float SQ2 = (float)Math.sqrt(2.0);
    private static final float SQ3 = (float)Math.sqrt(3.0);
    private final float[] ML = new float[]{SQ3, SQ2, SQ3, SQ2, 1.0f, SQ2, SQ3, SQ2, SQ3, SQ2, 1.0f, SQ2, 1.0f};
    private final float[] MR = new float[]{1.0f, SQ2, 1.0f, SQ2, SQ3, SQ2, SQ3, SQ2, 1.0f, SQ2, SQ3, SQ2, SQ3};
    private ImagePlus image;
    private int w;
    private int h;
    private int d;
    private float[][] dist;
    private float maxVal;
    private int fg = 255;

    public void run(ImageProcessor imageProcessor) {
        this.getTransformed(this.image, 255).show();
    }

    public ImagePlus getTransformed(ImagePlus imagePlus, int n) {
        this.image = imagePlus;
        this.fg = n;
        this.init();
        this.forwardPass();
        this.backwardPass();
        return this.toFloat();
    }

    public float[][] getDistances() {
        return this.dist;
    }

    public void init(float[][] fArray, int n, int n2, int n3) {
        this.dist = fArray;
        this.w = n;
        this.h = n2;
        this.d = n3;
        this.maxVal = (float)Math.sqrt(n * n + n2 * n2 + n3 * n3);
    }

    public void init() {
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        this.d = this.image.getStackSize();
        this.maxVal = (float)Math.sqrt(this.w * this.w + this.h * this.h + this.d * this.d);
        this.dist = new float[this.d][this.w * this.h];
        for (int i = 0; i < this.d; ++i) {
            byte[] byArray = (byte[])this.image.getStack().getProcessor(i + 1).getPixels();
            for (int j = 0; j < this.w * this.h; ++j) {
                this.dist[i][j] = (byArray[j] & 0xFF) == this.fg ? 0.0f : this.maxVal;
            }
        }
    }

    private float dist(int n, int n2, int n3) {
        if (n < 0 || n >= this.w || n2 < 0 || n2 >= this.h || n3 < 0 || n3 >= this.d) {
            return -this.maxVal;
        }
        return this.dist[n3][n2 * this.w + n];
    }

    public void forwardPass() {
        float[] fArray = new float[13];
        for (int i = 0; i < this.d; ++i) {
            for (int j = 0; j < this.h; ++j) {
                for (int k = 0; k < this.w; ++k) {
                    if (this.dist[i][j * this.w + k] == 0.0f) continue;
                    fArray[0] = this.ML[0] + this.dist(k - 1, j - 1, i - 1);
                    fArray[1] = this.ML[1] + this.dist(k, j - 1, i - 1);
                    fArray[2] = this.ML[2] + this.dist(k + 1, j - 1, i - 1);
                    fArray[3] = this.ML[3] + this.dist(k - 1, j, i - 1);
                    fArray[4] = this.ML[4] + this.dist(k, j, i - 1);
                    fArray[5] = this.ML[5] + this.dist(k + 1, j, i - 1);
                    fArray[6] = this.ML[6] + this.dist(k - 1, j + 1, i - 1);
                    fArray[7] = this.ML[7] + this.dist(k, j + 1, i - 1);
                    fArray[8] = this.ML[8] + this.dist(k + 1, j + 1, i - 1);
                    fArray[9] = this.ML[9] + this.dist(k - 1, j - 1, i);
                    fArray[10] = this.ML[10] + this.dist(k, j - 1, i);
                    fArray[11] = this.ML[11] + this.dist(k + 1, j - 1, i);
                    fArray[12] = this.ML[12] + this.dist(k - 1, j, i);
                    this.dist[i][j * this.w + k] = this.min(fArray);
                }
            }
        }
    }

    public void backwardPass() {
        float[] fArray = new float[14];
        for (int i = this.d - 1; i >= 0; --i) {
            for (int j = this.h - 1; j >= 0; --j) {
                for (int k = this.w - 1; k >= 0; --k) {
                    if (this.dist[i][j * this.w + k] == 0.0f) continue;
                    fArray[0] = this.MR[0] + this.dist(k + 1, j, i);
                    fArray[1] = this.MR[1] + this.dist(k - 1, j + 1, i);
                    fArray[2] = this.MR[2] + this.dist(k, j + 1, i);
                    fArray[3] = this.MR[3] + this.dist(k + 1, j + 1, i);
                    fArray[4] = this.MR[4] + this.dist(k - 1, j - 1, i + 1);
                    fArray[5] = this.MR[5] + this.dist(k, j - 1, i + 1);
                    fArray[6] = this.MR[6] + this.dist(k + 1, j - 1, i + 1);
                    fArray[7] = this.MR[7] + this.dist(k - 1, j, i + 1);
                    fArray[8] = this.MR[8] + this.dist(k, j, i + 1);
                    fArray[9] = this.MR[9] + this.dist(k + 1, j, i + 1);
                    fArray[10] = this.MR[10] + this.dist(k - 1, j + 1, i + 1);
                    fArray[11] = this.MR[11] + this.dist(k, j + 1, i + 1);
                    fArray[12] = this.MR[12] + this.dist(k + 1, j + 1, i + 1);
                    fArray[13] = this.dist[i][j * this.w + k];
                    this.dist[i][j * this.w + k] = this.min(fArray);
                }
            }
        }
    }

    public float min(float[] fArray) {
        float f = this.maxVal;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(fArray[i] < f) || !(fArray[i] >= 0.0f)) continue;
            f = fArray[i];
        }
        return f;
    }

    public ImagePlus toFloat() {
        ImageStack imageStack = new ImageStack(this.w, this.h);
        for (int i = 0; i < this.d; ++i) {
            imageStack.addSlice("", (ImageProcessor)new FloatProcessor(this.w, this.h, this.dist[i], null));
        }
        return new ImagePlus("Distance", imageStack);
    }

    public ImagePlus rebin() {
        float f = Float.MAX_VALUE;
        float f2 = Float.MIN_VALUE;
        for (int i = 0; i < this.d; ++i) {
            for (int j = 0; j < this.w * this.h; ++j) {
                if (this.dist[i][j] < f) {
                    f = this.dist[i][j];
                }
                if (!(this.dist[i][j] > f2)) continue;
                f2 = this.dist[i][j];
            }
        }
        float f3 = (f2 - f) / 256.0f;
        ImageStack imageStack = new ImageStack(this.w, this.h);
        for (int i = 0; i < this.d; ++i) {
            byte[] byArray = new byte[this.w * this.h];
            for (int j = 0; j < this.w * this.h; ++j) {
                byArray[j] = (byte)((this.dist[i][j] - f) / f3);
            }
            imageStack.addSlice("", (ImageProcessor)new ByteProcessor(this.w, this.h, byArray, null));
        }
        return new ImagePlus("Distance", imageStack);
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 1;
    }
}

