/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.StackConverter;
import java.text.DecimalFormat;

public class FFT_
implements PlugInFilter {
    private ImagePlus image;

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 1;
    }

    public void run(ImageProcessor imageProcessor) {
        int n;
        int n2;
        System.out.println("input data");
        new StackConverter(this.image).convertToGray32();
        TestData testData = new TestData(this.image);
        System.out.println("output data");
        int n3 = this.image.getWidth();
        int n4 = this.image.getHeight();
        int n5 = this.image.getStackSize();
        for (n2 = 0; n2 < n5; ++n2) {
            for (n = 0; n < n4; ++n) {
                testData.setOffset(n2 * n3 * n4 + n * n3);
                testData.setIncrement(1);
                this.four1(testData, n3, false);
            }
            for (n = 0; n < n3; ++n) {
                testData.setOffset(n2 * n3 * n4 + n);
                testData.setIncrement(n3);
                this.four1(testData, n4, false);
            }
            IJ.showProgress((int)n2, (int)(n5 - 1));
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                testData.setOffset(n2 * n3 + n);
                testData.setIncrement(n3 * n4);
                this.four1(testData, n5, false);
            }
            IJ.showProgress((int)n2, (int)(n4 - 1));
        }
        testData.show();
        for (n2 = 0; n2 < n5; ++n2) {
            for (n = 0; n < n4; ++n) {
                testData.setOffset(n2 * n3 * n4 + n * n3);
                testData.setIncrement(1);
                this.four1(testData, n3, true);
            }
            for (n = 0; n < n3; ++n) {
                testData.setOffset(n2 * n3 * n4 + n);
                testData.setIncrement(n3);
                this.four1(testData, n4, true);
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                testData.setOffset(n2 * n3 + n);
                testData.setIncrement(n3 * n4);
                this.four1(testData, n5, true);
            }
        }
        testData.show();
    }

    public void four1(TestData testData, int n, boolean bl) {
        int n2;
        int n3;
        int n4 = bl ? -1 : 1;
        int n5 = 1;
        for (n3 = 1; n3 < n; ++n3) {
            if (n5 > n3) {
                testData.swap(n5, n3);
            }
            for (n2 = n >> 1; n2 >= 2 && n5 > n2; n5 -= n2, n2 >>= 1) {
            }
            n5 += n2;
        }
        for (n3 = 2; n >= n3; n3 <<= 1) {
            n2 = n3;
            double d = (double)n4 * (Math.PI * 2 / (double)n3);
            double d2 = Math.sin(0.5 * d);
            double d3 = -2.0 * d2 * d2;
            double d4 = Math.sin(d);
            double d5 = 1.0;
            double d6 = 0.0;
            for (int i = 1; i <= n3 >> 1; ++i) {
                for (int j = i; j <= n; j += n3) {
                    n5 = j + (n3 >> 1);
                    float f = (float)(d5 * (double)testData.getRe(n5) - d6 * (double)testData.getIm(n5));
                    float f2 = (float)(d5 * (double)testData.getIm(n5) + d6 * (double)testData.getRe(n5));
                    testData.setRe(n5, testData.getRe(j) - f);
                    testData.setIm(n5, testData.getIm(j) - f2);
                    testData.setRe(j, testData.getRe(j) + f);
                    testData.setIm(j, testData.getIm(j) + f2);
                }
                d2 = d5;
                d5 = d2 * d3 - d6 * d4 + d5;
                d6 = d6 * d3 + d2 * d4 + d6;
            }
        }
        if (bl) {
            for (n2 = 1; n2 <= n; ++n2) {
                testData.setRe(n2, testData.getRe(n2) / (float)n);
                testData.setIm(n2, testData.getIm(n2) / (float)n);
            }
        }
    }

    public class TestData {
        private float[][] re;
        private float[][] im;
        private int w;
        private int h;
        private int d;
        private int wh;
        private int offset = 0;
        private int incr = 1;
        DecimalFormat df = new DecimalFormat("###.##");

        public TestData(ImagePlus imagePlus) {
            this.w = imagePlus.getWidth();
            this.h = imagePlus.getHeight();
            this.d = imagePlus.getStackSize();
            this.wh = this.w * this.h;
            this.re = new float[this.d][];
            this.im = new float[this.d][];
            for (int i = 0; i < this.d; ++i) {
                this.re[i] = (float[])imagePlus.getStack().getPixels(i + 1);
                this.im[i] = new float[this.wh];
            }
        }

        public TestData(ImageProcessor imageProcessor) {
            this.w = imageProcessor.getWidth();
            this.h = imageProcessor.getHeight();
            this.d = 1;
            this.wh = this.w * this.h;
            this.re = new float[this.d][];
            this.im = new float[this.d][];
            this.re[0] = (float[])imageProcessor.getPixels();
            this.im[0] = new float[this.wh];
        }

        public void setIncrement(int n) {
            this.incr = n;
        }

        public void setOffset(int n) {
            this.offset = n;
        }

        public float getRe(int n) {
            int n2 = this.offset + (n - 1) * this.incr;
            try {
                return this.re[n2 / this.wh][n2 % this.wh];
            }
            catch (RuntimeException runtimeException) {
                System.out.println("offset = " + this.offset);
                System.out.println("incr = " + this.incr);
                System.out.println("j / wh = " + n2 / this.wh);
                System.out.println("j % wh = " + n2 % this.wh);
                System.out.println(n);
                System.out.println(n2);
                throw runtimeException;
            }
        }

        public float getIm(int n) {
            n = this.offset + (n - 1) * this.incr;
            return this.im[n / this.wh][n % this.wh];
        }

        public void setRe(int n, float f) {
            n = this.offset + (n - 1) * this.incr;
            this.re[n / this.wh][n % this.wh] = f;
        }

        public void setIm(int n, float f) {
            n = this.offset + (n - 1) * this.incr;
            this.im[n / this.wh][n % this.wh] = f;
        }

        public void swap(int n, int n2) {
            float f = this.getRe(n);
            this.setRe(n, this.getRe(n2));
            this.setRe(n2, f);
            f = this.getIm(n);
            this.setIm(n, this.getIm(n2));
            this.setIm(n2, f);
        }

        public void show() {
            ImageStack imageStack = new ImageStack(this.w, this.h);
            ImageStack imageStack2 = new ImageStack(this.w, this.h);
            for (int i = 0; i < this.d; ++i) {
                imageStack.addSlice("", (ImageProcessor)new FloatProcessor(this.w, this.h, this.re[i], null));
                imageStack2.addSlice("", (ImageProcessor)new FloatProcessor(this.w, this.h, this.im[i], null));
            }
            new ImagePlus("re", imageStack).show();
            new ImagePlus("im", imageStack2).show();
        }
    }
}

