/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.util.Stack;

public class Find_Minima
implements PlugInFilter {
    private ImagePlus image;
    private int w;
    private int h;
    private int d;
    private byte[][] data;
    private byte[][] minima;
    private static final int NO_MIN = 0;
    private static final int NON_STRICT_MIN = 1;
    private static final int STRICT_MIN = 2;
    private static final byte LABEL = -1;
    private static final byte CLEAR = 0;

    public Find_Minima() {
    }

    public Find_Minima(ImagePlus imagePlus) {
        this.init(imagePlus);
    }

    public void init(ImagePlus imagePlus) {
        this.image = imagePlus;
        this.w = imagePlus.getWidth();
        this.h = imagePlus.getHeight();
        this.d = imagePlus.getStackSize();
        this.data = new byte[this.d][];
        for (int i = 0; i < this.d; ++i) {
            this.data[i] = (byte[])imagePlus.getStack().getPixels(i + 1);
        }
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 1;
    }

    public void run(ImageProcessor imageProcessor) {
        this.classify().show();
    }

    public ImagePlus classify() {
        this.minima = new byte[this.d][this.w * this.h];
        ImageStack imageStack = new ImageStack(this.w, this.h);
        for (int i = 0; i < this.d; ++i) {
            for (int j = 0; j < this.h; ++j) {
                for (int k = 0; k < this.w; ++k) {
                    this.classifyPixel(k, j, i);
                }
            }
            imageStack.addSlice("", (Object)this.minima[i]);
            IJ.showProgress((int)i, (int)this.d);
        }
        ImagePlus imagePlus = new ImagePlus("Minima", imageStack);
        imagePlus.setCalibration(this.image.getCalibration());
        return imagePlus;
    }

    private void classifyPixel(int n, int n2, int n3) {
        int n4 = this.getD(n, n2, n3);
        int n5 = this.isMinimum(n, n2, n3, n4);
        if (n5 == 0) {
            for (int i = 0; i < 13; ++i) {
                int n6 = i % 3 - 1 + n;
                int n7 = i / 3 % 3 - 1 + n2;
                int n8 = i / 9 - 1 + n3;
                int n9 = this.getD(n6, n7, n8);
                byte by = this.getC(n6, n7, n8);
                if (by != -1 || n9 <= n4) continue;
                this.unlabel(n6, n7, n8);
            }
        } else if (n5 == 2) {
            for (int i = 0; i < 13; ++i) {
                int n10 = i % 3 - 1 + n;
                int n11 = i / 3 % 3 - 1 + n2;
                int n12 = i / 9 - 1 + n3;
                int n13 = this.getD(n10, n11, n12);
                byte by = this.getC(n10, n11, n12);
                if (by != -1) continue;
                this.unlabel(n10, n11, n12);
            }
            this.label(n, n2, n3);
        } else if (n5 == 1) {
            for (int i = 0; i < 13; ++i) {
                int n14 = i % 3 - 1 + n;
                int n15 = i / 3 % 3 - 1 + n2;
                int n16 = i / 9 - 1 + n3;
                int n17 = this.getD(n14, n15, n16);
                byte by = this.getC(n14, n15, n16);
                if (by != -1 || n17 <= n4) continue;
                this.unlabel(n14, n15, n16);
            }
            this.label(n, n2, n3);
        }
    }

    private final int isMinimum(int n, int n2, int n3, int n4) {
        int n5;
        for (n5 = 0; n5 < 13; ++n5) {
            if (this.getD(n5 % 3 - 1 + n, n5 / 3 % 3 - 1 + n2, n5 / 9 - 1 + n3) >= n4) continue;
            return 0;
        }
        for (n5 = 0; n5 < 13; ++n5) {
            if (this.getD(n5 % 3 - 1 + n, n5 / 3 % 3 - 1 + n2, n5 / 9 - 1 + n3) != n4) continue;
            return 1;
        }
        return 2;
    }

    private final int getD(int n, int n2, int n3) {
        if (n >= 0 && n < this.w && n2 >= 0 && n2 < this.h && n3 >= 0 && n3 < this.d) {
            return this.data[n3][n2 * this.w + n] & 0xFF;
        }
        return 0;
    }

    private final byte getC(int n, int n2, int n3) {
        if (n >= 0 && n < this.w && n2 >= 0 && n2 < this.h && n3 >= 0 && n3 < this.d) {
            return this.minima[n3][n2 * this.w + n];
        }
        return -1;
    }

    private final void label(int n, int n2, int n3) {
        this.minima[n3][n2 * this.w + n] = -1;
    }

    private final void unlabel(int n, int n2, int n3) {
        Stack<Point> stack = new Stack<Point>();
        stack.push(new Point(n, n2, n3));
        while (!stack.isEmpty()) {
            Point point = (Point)stack.pop();
            if (point.x < 0 || point.x >= this.w || point.y < 0 || point.y >= this.h || point.z < 0 || point.z >= this.d || this.minima[point.z][point.y * this.w + point.x] != -1) continue;
            this.minima[((Point)point).z][((Point)point).y * this.w + ((Point)point).x] = 0;
            stack.push(new Point(point.x - 1, point.y - 1, point.z - 1));
            stack.push(new Point(point.x, point.y - 1, point.z - 1));
            stack.push(new Point(point.x + 1, point.y - 1, point.z - 1));
            stack.push(new Point(point.x - 1, point.y, point.z - 1));
            stack.push(new Point(point.x, point.y, point.z - 1));
            stack.push(new Point(point.x + 1, point.y, point.z - 1));
            stack.push(new Point(point.x - 1, point.y + 1, point.z - 1));
            stack.push(new Point(point.x, point.y + 1, point.z - 1));
            stack.push(new Point(point.x + 1, point.y + 1, point.z - 1));
            stack.push(new Point(point.x - 1, point.y - 1, point.z));
            stack.push(new Point(point.x, point.y - 1, point.z));
            stack.push(new Point(point.x + 1, point.y - 1, point.z));
            stack.push(new Point(point.x - 1, point.y, point.z));
            stack.push(new Point(point.x + 1, point.y, point.z));
            stack.push(new Point(point.x - 1, point.y + 1, point.z));
            stack.push(new Point(point.x, point.y + 1, point.z));
            stack.push(new Point(point.x + 1, point.y + 1, point.z));
            stack.push(new Point(point.x - 1, point.y - 1, point.z + 1));
            stack.push(new Point(point.x, point.y - 1, point.z + 1));
            stack.push(new Point(point.x + 1, point.y - 1, point.z + 1));
            stack.push(new Point(point.x - 1, point.y, point.z + 1));
            stack.push(new Point(point.x, point.y, point.z + 1));
            stack.push(new Point(point.x + 1, point.y, point.z + 1));
            stack.push(new Point(point.x - 1, point.y + 1, point.z + 1));
            stack.push(new Point(point.x, point.y + 1, point.z + 1));
            stack.push(new Point(point.x + 1, point.y + 1, point.z + 1));
        }
    }

    private static final class Point {
        private int x;
        private int y;
        private int z;

        Point(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.z = n3;
        }
    }
}

