/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Toolbar;
import ij.plugin.MacroInstaller;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class Flood_Fill
implements PlugIn {
    private static boolean debug = false;
    private static int tol = 0;
    public static final String MACRO_CMD = "var leftClick=16, alt=9;\nmacro 'Flood Fill Tool - C111O11ffC100T6c0aF' {\n while (true) {\n  getCursorLoc(x, y, z, flags);\n  if (flags&leftClick==0) exit();\n  call('process3d.Flood_Fill.fill', x,y,z);\n  exit(); }\n}\n\n";

    public void run(String string) {
        MacroInstaller macroInstaller = new MacroInstaller();
        macroInstaller.install(MACRO_CMD);
    }

    public static synchronized void fill(String string, String string2, String string3) {
        Flood_Fill.fill(Integer.parseInt(string), Integer.parseInt(string2), Integer.parseInt(string3));
    }

    public static synchronized void fill(int n, int n2, int n3) {
        Flood_Fill.fill(IJ.getImage(), n, n2, n3, Toolbar.getForegroundColor().getRGB());
    }

    public static synchronized void fill(ImagePlus imagePlus, int n, int n2, int n3, int n4) {
        IJ.showStatus((String)"Flood fill");
        long l = System.currentTimeMillis();
        int n5 = imagePlus.getWidth();
        int n6 = imagePlus.getHeight();
        int n7 = imagePlus.getStackSize();
        int n8 = n5 * n6;
        ImageProcessor[] imageProcessorArray = new ImageProcessor[n7];
        for (int i = 0; i < n7; ++i) {
            imageProcessorArray[i] = imagePlus.getStack().getProcessor(i + 1);
        }
        Difference difference = null;
        if (imageProcessorArray[0] instanceof ByteProcessor) {
            difference = new DifferenceInt();
        } else if (imageProcessorArray[0] instanceof ShortProcessor) {
            difference = new DifferenceInt();
        } else if (imageProcessorArray[0] instanceof FloatProcessor) {
            difference = new DifferenceFloat();
        } else if (imageProcessorArray[0] instanceof ColorProcessor) {
            difference = new DifferenceRGB();
        }
        int n9 = imageProcessorArray[n3].get(n, n2);
        Stack stack = new Stack();
        stack.push(n3 * n8 + n2 * n5 + n);
        while (!stack.isEmpty()) {
            int n10;
            int n11;
            int n12;
            int n13 = stack.pop();
            int n14 = n13 / n8;
            int n15 = imageProcessorArray[n14].get(n12 = (n11 = n13 % n8) % n5, n10 = n11 / n5);
            if (difference.getDifference(n15, n9) > (float)tol) continue;
            imageProcessorArray[n14].set(n12, n10, n4);
            int n16 = n14 * n8;
            if (n12 > 0 && imageProcessorArray[n14].get(n12 - 1, n10) != n4) {
                stack.push(n16 + n11 - 1);
            }
            if (n12 < n5 - 1 && imageProcessorArray[n14].get(n12 + 1, n10) != n4) {
                stack.push(n16 + n11 + 1);
            }
            if (n10 > 0 && imageProcessorArray[n14].get(n12, n10 - 1) != n4) {
                stack.push(n16 + n11 - n5);
            }
            if (n10 < n6 - 1 && imageProcessorArray[n14].get(n12, n10 + 1) != n4) {
                stack.push(n16 + n11 + n5);
            }
            if (n14 > 0 && imageProcessorArray[n14 - 1].get(n12, n10) != n4) {
                stack.push((n14 - 1) * n8 + n11);
            }
            if (n14 >= n7 - 1 || imageProcessorArray[n14 + 1].get(n12, n10) == n4) continue;
            stack.push((n14 + 1) * n8 + n11);
        }
        imagePlus.updateAndDraw();
        long l2 = System.currentTimeMillis();
        System.out.println("Needed " + (l2 - l) / 1000L + " seconds");
        IJ.showStatus((String)"");
    }

    static final class Stack {
        private int[] array = new int[1000000];
        private int size = 0;

        Stack() {
        }

        public void push(int n) {
            if (this.size == this.array.length) {
                int[] nArray = new int[this.array.length + 1000000];
                System.arraycopy(this.array, 0, nArray, 0, this.array.length);
                this.array = nArray;
            }
            this.array[this.size] = n;
            ++this.size;
        }

        public int pop() {
            --this.size;
            return this.array[this.size];
        }

        public int size() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }
    }

    static final class DifferenceFloat
    implements Difference {
        DifferenceFloat() {
        }

        public float getDifference(int n, int n2) {
            return Math.abs(Float.intBitsToFloat(n2) - Float.intBitsToFloat(n));
        }
    }

    static final class DifferenceRGB
    implements Difference {
        DifferenceRGB() {
        }

        public final float getDifference(int n, int n2) {
            return (float)Math.abs((n & 0xFF0000) >> 16 - (n2 & 0xFF0000) >> 16) + (float)Math.abs((n & 0xFF00) >> 8 - (n2 & 0xFF00) >> 8) + (float)Math.abs((n & 0xFF) - (n2 & 0xFF));
        }
    }

    static final class DifferenceInt
    implements Difference {
        DifferenceInt() {
        }

        public float getDifference(int n, int n2) {
            return Math.abs(n2 - n);
        }
    }

    static interface Difference {
        public float getDifference(int var1, int var2);
    }
}

