/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import process3d.Convolve_3d;
import process3d.Rebin_;

public class Gradient_
implements PlugInFilter {
    private ImagePlus image;

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 5;
    }

    public void run(ImageProcessor imageProcessor) {
        GenericDialog genericDialog = new GenericDialog("Gradient_");
        genericDialog.addCheckbox("Use calibration", true);
        if (genericDialog.wasCanceled()) {
            return;
        }
        boolean bl = genericDialog.getNextBoolean();
        ImagePlus imagePlus = Gradient_.calculateGrad(this.image, bl);
        Rebin_.rebin(imagePlus, 256).show();
    }

    public static ImagePlus calculateGrad(ImagePlus imagePlus, boolean bl) {
        IJ.showStatus((String)"Calculating gradient");
        Calibration calibration = imagePlus.getCalibration();
        float f = bl ? 2.0f * (float)calibration.pixelWidth : 2.0f;
        float f2 = bl ? 2.0f * (float)calibration.pixelHeight : 2.0f;
        float f3 = bl ? 2.0f * (float)calibration.pixelDepth : 2.0f;
        float[] fArray = new float[]{-1.0f / f, 0.0f, 1.0f / f};
        ImagePlus imagePlus2 = Convolve_3d.convolveX(imagePlus, fArray);
        float[] fArray2 = new float[]{-1.0f / f2, 0.0f, 1.0f / f2};
        ImagePlus imagePlus3 = Convolve_3d.convolveY(imagePlus, fArray2);
        float[] fArray3 = new float[]{-1.0f / f3, 0.0f, 1.0f / f3};
        ImagePlus imagePlus4 = Convolve_3d.convolveZ(imagePlus, fArray3);
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = imagePlus.getStackSize();
        ImageStack imageStack = new ImageStack(n, n2);
        for (int i = 0; i < n3; ++i) {
            FloatProcessor floatProcessor = new FloatProcessor(n, n2);
            imageStack.addSlice("", (ImageProcessor)floatProcessor);
            float[] fArray4 = (float[])floatProcessor.getPixels();
            float[] fArray5 = (float[])imagePlus2.getStack().getProcessor(i + 1).getPixels();
            float[] fArray6 = (float[])imagePlus3.getStack().getProcessor(i + 1).getPixels();
            float[] fArray7 = (float[])imagePlus4.getStack().getProcessor(i + 1).getPixels();
            for (int j = 0; j < n * n2; ++j) {
                fArray4[j] = (float)Math.sqrt(fArray5[j] * fArray5[j] + fArray6[j] * fArray6[j] + fArray7[j] * fArray7[j]);
            }
        }
        ImagePlus imagePlus5 = new ImagePlus("Gradient", imageStack);
        imagePlus5.setCalibration(calibration);
        return imagePlus5;
    }
}

