/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.image.ColorModel;
import java.util.Arrays;

public class MinMaxMedian {
    public static final int MINIMUM = 0;
    public static final int MAXIMUM = 1;
    public static final int MEDIAN = 2;
    private static int method = 2;
    private static int w;
    private static int h;
    private static int d;
    private static int diameter;
    private static Slide[] slices_in;
    private static Slide[] slices_out;
    private static boolean isByte;
    private static boolean isShort;
    private static boolean isFloat;

    public static ImagePlus convolve(ImagePlus imagePlus, int n) {
        int n2;
        int n3;
        if (n < 0 || n >= 3) {
            IJ.error((String)"Neither MINIMUM nor MAXIMUM nor MEDIAN chosen");
            return null;
        }
        w = imagePlus.getWidth();
        h = imagePlus.getHeight();
        d = imagePlus.getStackSize();
        int n4 = diameter / 2;
        int n5 = w - diameter / 2;
        int n6 = h - diameter / 2;
        int n7 = d - diameter / 2;
        isByte = imagePlus.getProcessor().getPixels() instanceof byte[];
        isShort = imagePlus.getProcessor().getPixels() instanceof short[];
        isFloat = imagePlus.getProcessor().getPixels() instanceof float[];
        ColorModel colorModel = imagePlus.getProcessor().getColorModel();
        if (!(isFloat || isByte || isShort)) {
            IJ.error((String)"Float, byte or short image expected");
            return null;
        }
        slices_in = new Slide[d];
        slices_out = new Slide[d];
        for (n3 = 0; n3 < d; ++n3) {
            MinMaxMedian.slices_in[n3] = isByte ? new ByteSlide((byte[])imagePlus.getStack().getProcessor(n3 + 1).getPixels(), colorModel) : (isShort ? new ShortSlide((short[])imagePlus.getStack().getProcessor(n3 + 1).getPixels(), colorModel) : new FloatSlide((float[])imagePlus.getStack().getProcessor(n3 + 1).getPixels(), colorModel));
            MinMaxMedian.slices_out[n3] = slices_in[n3].getEmptySlide();
        }
        for (n3 = n4; n3 < n7; ++n3) {
            IJ.showProgress((int)n3, (int)n7);
            for (n2 = n4; n2 < n6; ++n2) {
                for (int i = n4; i < n5; ++i) {
                    slices_out[n3].setValue(i, n2, slices_out[n3].convolvePoint(n3, n2, i, n));
                }
            }
        }
        ImageStack imageStack = new ImageStack(w, h);
        for (n2 = 0; n2 < d; ++n2) {
            imageStack.addSlice("", slices_out[n2].getProcessor());
        }
        ImagePlus imagePlus2 = new ImagePlus("", imageStack);
        imagePlus2.setCalibration(imagePlus.getCalibration());
        return imagePlus2;
    }

    static {
        diameter = 3;
    }

    private static class ByteSlide
    extends Slide {
        byte[] slide;
        static int size = MinMaxMedian.access$200() * MinMaxMedian.access$200() * MinMaxMedian.access$200();
        static int[] values = new int[size];

        ByteSlide(byte[] byArray, ColorModel colorModel) {
            super(colorModel);
            this.slide = byArray;
        }

        void setValue(int n, int n2, Object object) {
            Byte by = (Byte)object;
            this.slide[n2 * w + n] = by;
        }

        Byte getValue(int n, int n2) {
            return this.slide[n2 * w + n];
        }

        ImageProcessor getEmptyProcessor() {
            return new ByteProcessor(w, h, new byte[w * h], this.cm);
        }

        ImageProcessor getProcessor() {
            return new ByteProcessor(w, h, this.slide, this.cm);
        }

        Slide getEmptySlide() {
            return new ByteSlide(new byte[w * h], this.cm);
        }

        Byte convolvePoint(int n, int n2, int n3, int n4) {
            int n5 = 0;
            int n6 = diameter / 2;
            for (int i = -n6; i <= n6; ++i) {
                for (int j = -n6; j <= n6; ++j) {
                    for (int k = -n6; k <= n6; ++k) {
                        ByteSlide.values[n5++] = (Byte)slices_in[n + i].getValue(n3 + k, n2 + j) & 0xFF;
                    }
                }
            }
            Arrays.sort(values);
            if (n4 == 1) {
                return (byte)values[size - 1];
            }
            if (n4 == 0) {
                return (byte)values[0];
            }
            return (byte)values[size / 2];
        }
    }

    private static class ShortSlide
    extends Slide {
        short[] slide;
        static int size = MinMaxMedian.access$200() * MinMaxMedian.access$200() * MinMaxMedian.access$200();
        static short[] values = new short[size];

        ShortSlide(short[] sArray, ColorModel colorModel) {
            super(colorModel);
            this.slide = sArray;
        }

        void setValue(int n, int n2, Object object) {
            Short s = (Short)object;
            this.slide[n2 * w + n] = s;
        }

        Short getValue(int n, int n2) {
            return this.slide[n2 * w + n];
        }

        ImageProcessor getEmptyProcessor() {
            return new ShortProcessor(w, h, new short[w * h], this.cm);
        }

        ImageProcessor getProcessor() {
            return new ShortProcessor(w, h, this.slide, this.cm);
        }

        Slide getEmptySlide() {
            return new ShortSlide(new short[w * h], this.cm);
        }

        Short convolvePoint(int n, int n2, int n3, int n4) {
            int n5 = 0;
            int n6 = diameter / 2;
            for (int i = -n6; i <= n6; ++i) {
                for (int j = -n6; j <= n6; ++j) {
                    for (int k = -n6; k <= n6; ++k) {
                        ShortSlide.values[n5++] = (Short)slices_in[n + i].getValue(n3 + k, n2 + j);
                    }
                }
            }
            Arrays.sort(values);
            if (n4 == 1) {
                return values[size - 1];
            }
            if (n4 == 0) {
                return values[0];
            }
            return values[size / 2];
        }
    }

    private static class FloatSlide
    extends Slide {
        float[] slide;
        static int size = MinMaxMedian.access$200() * MinMaxMedian.access$200() * MinMaxMedian.access$200();
        static float[] values = new float[size];

        FloatSlide(float[] fArray, ColorModel colorModel) {
            super(colorModel);
            this.slide = fArray;
        }

        void setValue(int n, int n2, Object object) {
            Float f = (Float)object;
            this.slide[n2 * w + n] = f.floatValue();
        }

        Float getValue(int n, int n2) {
            return Float.valueOf(this.slide[n2 * w + n]);
        }

        ImageProcessor getEmptyProcessor() {
            return new FloatProcessor(w, h, new float[w * h], this.cm);
        }

        ImageProcessor getProcessor() {
            return new FloatProcessor(w, h, this.slide, this.cm);
        }

        Slide getEmptySlide() {
            return new FloatSlide(new float[w * h], this.cm);
        }

        Float convolvePoint(int n, int n2, int n3, int n4) {
            int n5 = 0;
            int n6 = diameter / 2;
            for (int i = -n6; i <= n6; ++i) {
                for (int j = -n6; j <= n6; ++j) {
                    for (int k = -n6; k <= n6; ++k) {
                        FloatSlide.values[n5++] = ((Float)slices_in[n + i].getValue(n3 + k, n2 + j)).floatValue();
                    }
                }
            }
            Arrays.sort(values);
            if (n4 == 1) {
                return Float.valueOf(values[size - 1]);
            }
            if (n4 == 0) {
                return Float.valueOf(values[0]);
            }
            return Float.valueOf(values[size / 2]);
        }
    }

    private static abstract class Slide {
        protected ColorModel cm;

        Slide(ColorModel colorModel) {
            this.cm = colorModel;
        }

        abstract Object getValue(int var1, int var2);

        abstract void setValue(int var1, int var2, Object var3);

        abstract ImageProcessor getEmptyProcessor();

        abstract ImageProcessor getProcessor();

        abstract Slide getEmptySlide();

        abstract Object convolvePoint(int var1, int var2, int var3, int var4);
    }
}

