/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;

public class Rebin_
implements PlugInFilter {
    private ImagePlus image;

    public void run(ImageProcessor imageProcessor) {
        GenericDialog genericDialog = new GenericDialog("Rebin_");
        genericDialog.addNumericField("min", 0.0, 3);
        genericDialog.addNumericField("max", 255.0, 3);
        genericDialog.addNumericField("nbins", 256.0, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        Rebin_.rebin(this.image, (float)genericDialog.getNextNumber(), (float)genericDialog.getNextNumber(), (int)genericDialog.getNextNumber()).show();
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 8;
    }

    public static ImagePlus rebin(ImagePlus imagePlus, int n) {
        float[] fArray = new float[2];
        Rebin_.getMinAndMax(imagePlus, fArray);
        return Rebin_.rebin(imagePlus, fArray[0], fArray[1], n);
    }

    public static ImagePlus rebin(ImagePlus imagePlus, float f, float f2, int n) {
        float f3 = (f2 - f) / (float)n;
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        int n4 = imagePlus.getStackSize();
        ImageStack imageStack = new ImageStack(n2, n3);
        for (int i = 0; i < n4; ++i) {
            float[] fArray = (float[])imagePlus.getStack().getProcessor(i + 1).getPixels();
            byte[] byArray = new byte[n2 * n3];
            for (int j = 0; j < n2 * n3; ++j) {
                byArray[j] = (byte)((fArray[j] - f) / f3);
            }
            imageStack.addSlice("", (ImageProcessor)new ByteProcessor(n2, n3, byArray, null));
        }
        ImagePlus imagePlus2 = new ImagePlus("Rebinned", imageStack);
        imagePlus2.setCalibration(imagePlus.getCalibration());
        return imagePlus2;
    }

    public static void getMinAndMax(ImagePlus imagePlus, float[] fArray) {
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = imagePlus.getStackSize();
        float f = Float.MAX_VALUE;
        float f2 = Float.MIN_VALUE;
        for (int i = 0; i < n3; ++i) {
            float[] fArray2 = (float[])imagePlus.getStack().getProcessor(i + 1).getPixels();
            for (int j = 0; j < n * n2; ++j) {
                f = fArray2[j] < f ? fArray2[j] : f;
                f2 = fArray2[j] > f2 ? fArray2[j] : f2;
            }
        }
        fArray[0] = f;
        fArray[1] = f2;
    }
}

