/*
 * Decompiled with CFR 0.152.
 */
package stacks;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import stacks.ThreePaneCrop;

class CropDialog
extends Dialog
implements ActionListener,
WindowListener {
    Button setFromFields;
    Button setFromThreshold;
    TextField threshold;
    Button cropButton;
    Button cancelButton;
    ThreePaneCrop owner;
    TextField x_min_field;
    TextField y_min_field;
    TextField z_min_field;
    TextField x_max_field;
    TextField y_max_field;
    TextField z_max_field;
    ArrayList<ImagePlus> otherImages = new ArrayList();
    ArrayList<Checkbox> otherImagesCheckboxes = new ArrayList();

    public void windowClosing(WindowEvent windowEvent) {
        this.owner.cancel();
        this.dispose();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public CropDialog(String string, ThreePaneCrop threePaneCrop) {
        super((Frame)IJ.getInstance(), string, false);
        this.x_min_field = new TextField("", 4);
        this.y_min_field = new TextField("", 4);
        this.z_min_field = new TextField("", 4);
        this.x_max_field = new TextField("", 4);
        this.y_max_field = new TextField("", 4);
        this.z_max_field = new TextField("", 4);
        this.addWindowListener(this);
        this.owner = threePaneCrop;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridwidth = 5;
        panel.add((Component)new Label("Current Crop Boundaries (Maxima)"), gridBagConstraints2);
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridx = 0;
        panel.add((Component)new Label("x from "), gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        panel.add((Component)this.x_min_field, gridBagConstraints2);
        gridBagConstraints2.gridx = 2;
        panel.add((Component)new Label(" (" + threePaneCrop.overall_min_x + ")  to "), gridBagConstraints2);
        gridBagConstraints2.gridx = 3;
        panel.add((Component)this.x_max_field, gridBagConstraints2);
        gridBagConstraints2.gridx = 4;
        panel.add((Component)new Label(" (" + threePaneCrop.overall_max_x + ")"), gridBagConstraints2);
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridx = 0;
        panel.add((Component)new Label("y from "), gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        panel.add((Component)this.y_min_field, gridBagConstraints2);
        gridBagConstraints2.gridx = 2;
        panel.add((Component)new Label(" (" + threePaneCrop.overall_min_y + ")  to "), gridBagConstraints2);
        gridBagConstraints2.gridx = 3;
        panel.add((Component)this.y_max_field, gridBagConstraints2);
        gridBagConstraints2.gridx = 4;
        panel.add((Component)new Label(" (" + threePaneCrop.overall_max_y + ")"), gridBagConstraints2);
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.gridx = 0;
        panel.add((Component)new Label("z from "), gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        panel.add((Component)this.z_min_field, gridBagConstraints2);
        gridBagConstraints2.gridx = 2;
        panel.add((Component)new Label(" (" + (threePaneCrop.overall_min_z + 1) + ")  to "), gridBagConstraints2);
        gridBagConstraints2.gridx = 3;
        panel.add((Component)this.z_max_field, gridBagConstraints2);
        gridBagConstraints2.gridx = 4;
        panel.add((Component)new Label(" (" + (threePaneCrop.overall_max_z + 1) + ")"), gridBagConstraints2);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        this.setFromFields = new Button("Set from fields above");
        this.setFromFields.addActionListener(this);
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        panel2.add((Component)this.setFromFields, gridBagConstraints3);
        this.setFromThreshold = new Button("Set crop above value: ");
        this.setFromThreshold.addActionListener(this);
        this.threshold = new TextField("50");
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints.anchor = 21;
        panel2.add((Component)this.setFromThreshold, gridBagConstraints3);
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 1;
        panel2.add((Component)this.threshold, gridBagConstraints3);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        int[] nArray = WindowManager.getIDList();
        if (nArray != null) {
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.anchor = 21;
            panel3.add(new Label("Also crop these images:"));
            ++gridBagConstraints4.gridy;
            for (int i = 0; i < nArray.length; ++i) {
                ImagePlus imagePlus = WindowManager.getImage((int)nArray[i]);
                if (imagePlus.getWidth() != threePaneCrop.overall_max_x + 1 || imagePlus.getHeight() != threePaneCrop.overall_max_y + 1 || imagePlus.getStackSize() != threePaneCrop.overall_max_z + 1 || imagePlus == threePaneCrop.xy) continue;
                this.otherImages.add(imagePlus);
                Checkbox checkbox = new Checkbox(imagePlus.getTitle());
                panel3.add((Component)checkbox, gridBagConstraints4);
                ++gridBagConstraints4.gridy;
                this.otherImagesCheckboxes.add(checkbox);
            }
        }
        Panel panel4 = new Panel();
        panel4.setLayout(new FlowLayout());
        this.cropButton = new Button("Crop");
        this.cropButton.addActionListener(this);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        panel4.add(this.cropButton);
        panel4.add(this.cancelButton);
        gridBagConstraints.gridx = 0;
        this.add((Component)panel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        this.add((Component)panel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)panel3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 10;
        this.add((Component)panel4, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.add((Component)new Label("(Move mouse with shift to update panes.)"), gridBagConstraints);
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.cropButton) {
            ArrayList<ImagePlus> arrayList = new ArrayList<ImagePlus>();
            arrayList.add(this.owner.xy);
            for (int i = 0; i < this.otherImagesCheckboxes.size(); ++i) {
                Checkbox checkbox = this.otherImagesCheckboxes.get(i);
                if (!checkbox.getState()) continue;
                arrayList.add(this.otherImages.get(i));
            }
            this.owner.performMultipleCrops(arrayList);
        } else if (object == this.cancelButton) {
            this.owner.cancel();
            this.dispose();
        } else if (object == this.setFromFields) {
            this.setFromFields();
        } else if (object == this.setFromThreshold) {
            this.setFromThreshold();
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public void updateCropBounds(int n, int n2, int n3, int n4, int n5, int n6) {
        this.x_min_field.setText(Integer.toString(n));
        this.x_max_field.setText(Integer.toString(n2));
        this.y_min_field.setText(Integer.toString(n3));
        this.y_max_field.setText(Integer.toString(n4));
        this.z_min_field.setText(Integer.toString(n5 + 1));
        this.z_max_field.setText(Integer.toString(n6 + 1));
    }

    public void setFromThreshold() {
        double d;
        try {
            String string = this.threshold.getText();
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            IJ.error((String)"The threshold must be a number.");
            return;
        }
        this.owner.setCropAbove(d);
    }

    public void setFromFields() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        try {
            String string = this.x_min_field.getText();
            n6 = Integer.parseInt(string);
            String string2 = this.x_max_field.getText();
            n5 = Integer.parseInt(string2);
            String string3 = this.y_min_field.getText();
            n4 = Integer.parseInt(string3);
            String string4 = this.y_max_field.getText();
            n3 = Integer.parseInt(string4);
            String string5 = this.z_min_field.getText();
            n2 = Integer.parseInt(string5);
            String string6 = this.z_max_field.getText();
            n = Integer.parseInt(string6);
        }
        catch (NumberFormatException numberFormatException) {
            IJ.error((String)"The fields must all be integers.");
            return;
        }
        --n2;
        --n;
        if (n5 < n6) {
            IJ.error((String)"The maximum x must be >= the minimum x.");
            return;
        }
        if (n3 < n4) {
            IJ.error((String)"The maximum y must be >= the minimum y.");
            return;
        }
        if (n < n2) {
            IJ.error((String)"The maximum z must be >= the minimum z.");
            return;
        }
        if (n6 < this.owner.overall_min_x || n6 > this.owner.overall_max_x) {
            IJ.error((String)("The minimum x must be between " + this.owner.overall_min_x + " and " + this.owner.overall_max_x + " inclusive."));
            return;
        }
        if (n5 < this.owner.overall_min_x || n5 > this.owner.overall_max_x) {
            IJ.error((String)("The maximum x must be between " + this.owner.overall_min_x + " and " + this.owner.overall_max_x + " inclusive."));
            return;
        }
        if (n4 < this.owner.overall_min_y || n4 > this.owner.overall_max_y) {
            IJ.error((String)("The minimum y must be between " + this.owner.overall_min_y + " and " + this.owner.overall_max_y + " inclusive."));
            return;
        }
        if (n3 < this.owner.overall_min_y || n3 > this.owner.overall_max_y) {
            IJ.error((String)("The maximum y must be between " + this.owner.overall_min_y + " and " + this.owner.overall_max_y + " inclusive."));
            return;
        }
        if (n2 < this.owner.overall_min_z || n2 > this.owner.overall_max_z) {
            IJ.error((String)("The minimum z must be between " + this.owner.overall_min_z + " and " + this.owner.overall_max_z + " inclusive."));
            return;
        }
        if (n < this.owner.overall_min_z || n > this.owner.overall_max_z) {
            IJ.error((String)("The maximum z must be between " + this.owner.overall_min_z + " and " + this.owner.overall_max_z + " inclusive."));
            return;
        }
        this.owner.setCropCuboid(n6, n5, n4, n3, n2, n);
        this.owner.repaintAllPanes();
    }
}

