/*
 * Decompiled with CFR 0.152.
 */
package stacks;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.ImageLayout;
import ij.gui.StackWindow;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import stacks.PaneOwner;
import stacks.ThreePanesCanvas;

public class ThreePaneContainer
extends StackWindow
implements PaneOwner,
ActionListener {
    protected ThreePanesCanvas original_xy_canvas;
    protected ImagePlus xy;
    protected ImagePlus xz;
    protected ImagePlus zy;
    protected ThreePanesCanvas xy_canvas;
    protected ThreePanesCanvas xz_canvas;
    protected ThreePanesCanvas zy_canvas;

    public ThreePanesCanvas createCanvas(ImagePlus imagePlus, int n) {
        return new ThreePanesCanvas(imagePlus, this, n);
    }

    public ThreePaneContainer(ImagePlus imagePlus) {
        super(imagePlus, (ImageCanvas)new ThreePanesCanvas(imagePlus, 0));
        Object object;
        int n;
        Object object2;
        int n2;
        int n3;
        this.original_xy_canvas = (ThreePanesCanvas)imagePlus.getWindow().getCanvas();
        this.original_xy_canvas.setPaneOwner(this);
        System.out.println("Creating ThreePaneContainer");
        this.xy = imagePlus;
        int n4 = this.xy.getType();
        if (n4 != 0) {
            IJ.error((String)"This doesn't currently work on 8 bit stacks.");
            return;
        }
        this.remove((Component)this.getCanvas());
        this.remove(this.sliceSelector);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n5 = this.xy.getWidth();
        int n6 = this.xy.getHeight();
        int n7 = n3 = this.xy.getStackSize();
        int n8 = n6;
        ImageStack imageStack = new ImageStack(n7, n8);
        int n9 = n5;
        int n10 = n3;
        ImageStack imageStack2 = new ImageStack(n9, n10);
        byte[][] byArrayArray = new byte[n3][];
        ImageStack imageStack3 = this.xy.getStack();
        for (n2 = 0; n2 < n3; ++n2) {
            byArrayArray[n2] = (byte[])imageStack3.getPixels(n2 + 1);
        }
        IJ.showStatus((String)"Generating XZ planes...");
        IJ.showProgress((double)0.0);
        for (n2 = 0; n2 < n5; ++n2) {
            object2 = new byte[n7 * n8];
            for (int i = 0; i < n3; ++i) {
                for (n = 0; n < n6; ++n) {
                    int n11 = i;
                    int n12 = n;
                    object2[n12 * n7 + n11] = byArrayArray[i][n * n5 + n2];
                }
            }
            object = new ByteProcessor(n7, n8);
            object.setPixels(object2);
            imageStack.addSlice(null, (ImageProcessor)object);
            IJ.showProgress((double)((double)n2 / (double)n5));
        }
        IJ.showProgress((double)1.0);
        IJ.showStatus((String)"Generating ZY planes...");
        IJ.showProgress((double)0.0);
        this.zy = new ImagePlus("ZY planes of " + this.xy.getShortTitle(), imageStack);
        for (n2 = 0; n2 < n6; ++n2) {
            object2 = new byte[n9 * n10];
            for (int i = 0; i < n3; ++i) {
                n = i;
                System.arraycopy(byArrayArray[i], n2 * n5, object2, n * n9, n5);
            }
            object = new ByteProcessor(n9, n10);
            object.setPixels(object2);
            imageStack2.addSlice(null, (ImageProcessor)object);
            IJ.showProgress((double)((double)n2 / (double)n5));
        }
        this.xz = new ImagePlus("XZ planes of " + this.xy.getShortTitle(), imageStack2);
        IJ.showProgress((double)1.0);
        System.gc();
        this.xy_canvas = this.original_xy_canvas;
        this.xz_canvas = this.createCanvas(this.xz, 1);
        this.zy_canvas = this.createCanvas(this.zy, 2);
        Container container = new Container();
        object2 = new Container();
        object = new Container();
        container.setLayout((LayoutManager)new ImageLayout((ImageCanvas)this.xy_canvas));
        ((Container)object2).setLayout((LayoutManager)new ImageLayout((ImageCanvas)this.xz_canvas));
        ((Container)object).setLayout((LayoutManager)new ImageLayout((ImageCanvas)this.zy_canvas));
        container.add((Component)((Object)this.xy_canvas));
        ((Container)object2).add((Component)((Object)this.xz_canvas));
        ((Container)object).add((Component)((Object)this.zy_canvas));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)object2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)object, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.add(container, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add(this.sliceSelector, gridBagConstraints);
        this.pack();
        this.show();
        this.repaintAllPanes();
    }

    public void findPointInStack(int n, int n2, int n3, int[] nArray) {
        switch (n3) {
            case 0: {
                nArray[0] = n;
                nArray[1] = n2;
                nArray[2] = this.xy.getCurrentSlice() - 1;
                break;
            }
            case 1: {
                nArray[0] = n;
                nArray[1] = this.xz.getCurrentSlice() - 1;
                nArray[2] = n2;
                break;
            }
            case 2: {
                nArray[0] = this.zy.getCurrentSlice() - 1;
                nArray[1] = n2;
                nArray[2] = n;
            }
        }
    }

    public void mouseMovedTo(int n, int n2, int n3, boolean bl) {
        int[] nArray = new int[3];
        this.findPointInStack(n, n2, n3, nArray);
        this.xy_canvas.setCrosshairs(nArray[0], nArray[1], nArray[2], true);
        this.xz_canvas.setCrosshairs(nArray[0], nArray[1], nArray[2], true);
        this.zy_canvas.setCrosshairs(nArray[0], nArray[1], nArray[2], true);
        if (bl) {
            this.setSlicesAllPanes(nArray[0], nArray[1], nArray[2]);
        }
    }

    public void setSlicesAllPanes(int n, int n2, int n3) {
        this.xy.setSlice(n3 + 1);
        this.xy.updateImage();
        this.xz.setSlice(n2 + 1);
        this.xz.updateImage();
        this.zy.setSlice(n + 1);
        this.zy.updateImage();
        this.repaintAllPanes();
    }

    public void repaintAllPanes() {
        this.xy_canvas.repaint();
        this.xz_canvas.repaint();
        this.zy_canvas.repaint();
    }

    public void closeAndReset() {
        this.zy.close();
        this.xz.close();
        new StackWindow(this.xy, (ImageCanvas)this.original_xy_canvas);
    }
}

