/*
 * Decompiled with CFR 0.152.
 */
package surfaceplot;

import ij.ImagePlus;
import ij.gui.StackWindow;
import ij3d.Content;
import ij3d.ContentNode;
import ij3d.Volume;
import java.awt.Component;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.media.j3d.Node;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import surfaceplot.SurfacePlot;
import vib.Resample_;

public class SurfacePlotGroup
extends ContentNode
implements AdjustmentListener {
    private SurfacePlot surfacep;
    private Content c;
    private Point3d min = new Point3d();
    private Point3d max = new Point3d();
    private Point3d center = new Point3d();

    public SurfacePlotGroup(Content content) {
        this.c = content;
        int n = content.getResamplingFactor();
        ImagePlus imagePlus = n == 1 ? content.getImage() : Resample_.resample(content.getImage(), n, n, 1);
        Volume volume = new Volume(imagePlus);
        volume.setAverage(true);
        volume.setChannels(content.getChannels());
        this.surfacep = new SurfacePlot(volume, content.getColor(), content.getTransparency(), content.getImage().getSlice());
        this.surfacep.calculateMinMaxCenterPoint(this.min, this.max, this.center);
        this.addChild((Node)this.surfacep);
        if (content.getImage().getStackSize() == 1) {
            return;
        }
        StackWindow stackWindow = (StackWindow)content.getImage().getWindow();
        if (stackWindow == null) {
            return;
        }
        Component[] componentArray = stackWindow.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Scrollbar)) continue;
            ((Scrollbar)componentArray[i]).addAdjustmentListener(this);
        }
    }

    public void setSlice(int n) {
        this.surfacep.setSlice(n);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.surfacep.setSlice(((Scrollbar)adjustmentEvent.getSource()).getValue());
    }

    public void getMax(Tuple3d tuple3d) {
        tuple3d.set((Tuple3d)this.max);
    }

    public void getMin(Tuple3d tuple3d) {
        tuple3d.set((Tuple3d)this.min);
    }

    public void getCenter(Tuple3d tuple3d) {
        tuple3d.set((Tuple3d)this.center);
    }

    public void eyePtChanged(View view) {
    }

    public void thresholdUpdated() {
    }

    public void channelsUpdated() {
        this.surfacep.setChannels(this.c.getChannels());
    }

    public float getVolume() {
        if (this.surfacep == null) {
            return -1.0f;
        }
        return 0.0f;
    }

    public void colorUpdated() {
        this.surfacep.setColor(this.c.getColor());
    }

    public void transparencyUpdated() {
        this.surfacep.setTransparency(this.c.getTransparency());
    }

    public void shadeUpdated() {
        this.surfacep.setShaded(this.c.isShaded());
    }
}

