/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.PlugIn;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import landmarks.Bookstein_From_Landmarks;
import tracing.Connectivity;
import tracing.GraphNode;
import tracing.Path;
import tracing.PathAndFillManager;
import tracing.PathWithLength;
import tracing.PointInPath;
import util.BatchOpener;
import util.FileAndChannel;
import vib.oldregistration.RegistrationAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzeTracings_
implements PlugIn {
    public static Connectivity buildGraph(String string, ArrayList<Path> arrayList) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        double[] dArray;
        int n6;
        Connectivity connectivity = new Connectivity();
        FileAndChannel fileAndChannel = new FileAndChannel(string, 0);
        String string2 = "/media/WD USB 2/standard-brain/data/vib-drosophila/CantonM43c.grey";
        String string3 = "/media/WD USB 2/standard-brain/data/vib-drosophila/CantonM43c.labels";
        FileAndChannel fileAndChannel2 = new FileAndChannel(string2, 0);
        Bookstein_From_Landmarks bookstein_From_Landmarks = new Bookstein_From_Landmarks();
        bookstein_From_Landmarks.loadImages(fileAndChannel2, fileAndChannel);
        bookstein_From_Landmarks.generateTransformation();
        ImageStack imageStack = BatchOpener.open(string3);
        ImagePlus imagePlus = imageStack[0];
        System.out.println("   labels were: " + imagePlus);
        imageStack = imagePlus.getStack();
        int n7 = imageStack.getWidth();
        int n8 = imageStack.getHeight();
        int n9 = imageStack.getSize();
        byte[][] byArrayArray = new byte[n9][];
        for (int i = 0; i < n9; ++i) {
            byArrayArray[i] = (byte[])imageStack.getPixels(i + 1);
        }
        AmiraParameters amiraParameters = new AmiraParameters(imagePlus);
        int n10 = amiraParameters.getMaterialCount();
        connectivity.materialNames = new String[256];
        connectivity.materialNameToIndex = new Hashtable();
        for (n6 = 0; n6 < n10; ++n6) {
            connectivity.materialNames[n6] = amiraParameters.getMaterialName(n6);
            connectivity.materialNameToIndex.put(connectivity.materialNames[n6], new Integer(n6));
            System.out.println("Material: " + n6 + " is " + connectivity.materialNames[n6]);
        }
        connectivity.redValues = new int[n10];
        connectivity.greenValues = new int[n10];
        connectivity.blueValues = new int[n10];
        for (n6 = 0; n6 < n10; ++n6) {
            dArray = amiraParameters.getMaterialColor(n6);
            connectivity.redValues[n6] = (int)(255.0 * dArray[0]);
            connectivity.greenValues[n6] = (int)(255.0 * dArray[1]);
            connectivity.blueValues[n6] = (int)(255.0 * dArray[2]);
        }
        ArrayList<PointInPath> arrayList2 = new ArrayList<PointInPath>();
        dArray = new double[3];
        ArrayList<GraphNode> arrayList3 = new ArrayList<GraphNode>();
        ArrayList<GraphNode> arrayList4 = new ArrayList<GraphNode>();
        RegistrationAlgorithm.ImagePoint imagePoint = new RegistrationAlgorithm.ImagePoint();
        int n11 = arrayList.size();
        for (n5 = 0; n5 < n11; ++n5) {
            Path path = arrayList.get(n5);
            for (n4 = 0; n4 < path.size(); ++n4) {
                int n12 = path.getXUnscaled(n4);
                n3 = path.getYUnscaled(n4);
                int n13 = path.getZUnscaled(n4);
                bookstein_From_Landmarks.transformDomainToTemplate(n12, n3, n13, imagePoint);
                int n14 = imagePoint.x;
                int n15 = imagePoint.y;
                int n16 = imagePoint.z;
                n2 = byArrayArray[n16][n15 * n7 + n14] & 0xFF;
                if (n2 >= n10) {
                    IJ.error((String)("A label value of " + n2 + " was found, which is not a valid material (max " + (n10 - 1) + ")"));
                    return null;
                }
                PointInPath pointInPath = new PointInPath();
                pointInPath.setPosition(n14, n15, n16);
                pointInPath.setNeuropilRegion(connectivity.materialNames[n2]);
                pointInPath.setPathID(n5);
                if (n4 == 0) {
                    pointInPath.setStart(true);
                }
                if (n4 == path.size() - 1) {
                    pointInPath.setEnd(true);
                }
                arrayList2.add(pointInPath);
            }
        }
        n5 = 5;
        int n17 = 0;
        System.out.println("Finding which endpoints are really the same.");
        for (n4 = 0; n4 < arrayList2.size(); ++n4) {
            PointInPath pointInPath = (PointInPath)arrayList2.get(n4);
            if (!pointInPath.start() && !pointInPath.end()) continue;
            n3 = 0;
            for (int i = 0; i < arrayList3.size(); ++i) {
                GraphNode graphNode = (GraphNode)arrayList3.get(i);
                if (!pointInPath.nearTo(n5, graphNode.x, graphNode.y, graphNode.z) || !pointInPath.getNeuropilRegion().equals(graphNode.material_name)) continue;
                pointInPath.node = graphNode;
                n3 = 1;
                break;
            }
            if (n3 != 0) continue;
            GraphNode graphNode = new GraphNode();
            graphNode.x = (int)pointInPath.getX();
            graphNode.y = (int)pointInPath.getY();
            graphNode.z = (int)pointInPath.getZ();
            graphNode.id = n17++;
            graphNode.material_name = pointInPath.getNeuropilRegion();
            pointInPath.node = graphNode;
            arrayList3.add(graphNode);
            arrayList4.add(graphNode);
        }
        System.out.println("Done finding which endpoints are really the same.");
        ArrayList<PointInPath> arrayList5 = null;
        for (n = 0; n < arrayList2.size(); ++n) {
            PointInPath pointInPath = (PointInPath)arrayList2.get(n);
            if (pointInPath.start()) {
                arrayList5 = new ArrayList<PointInPath>();
                arrayList5.add(pointInPath);
                continue;
            }
            if (pointInPath.end()) {
                GraphNode graphNode;
                arrayList5.add(pointInPath);
                int n18 = ((PointInPath)arrayList5.get((int)0)).node.id;
                int n19 = ((PointInPath)arrayList5.get((int)(arrayList5.size() - 1))).node.id;
                System.out.println("Path from ID " + n18 + " to " + n19);
                double[] dArray2 = new double[arrayList3.size()];
                for (int i = 0; i < dArray2.length; ++i) {
                    dArray2[i] = -1.0;
                }
                PointInPath[] pointInPathArray = new PointInPath[arrayList3.size()];
                block9: for (n2 = 0; n2 < arrayList5.size(); ++n2) {
                    PointInPath pointInPath2 = (PointInPath)arrayList5.get(n2);
                    for (int i = 0; i < arrayList3.size(); ++i) {
                        graphNode = (GraphNode)arrayList3.get(i);
                        if (!pointInPath2.nearTo(n5, graphNode.x, graphNode.y, graphNode.z) || !pointInPath2.getNeuropilRegion().equals(graphNode.material_name) || graphNode.id == n18 || graphNode.id == n19) continue;
                        double d = (double)graphNode.x - pointInPath2.getX();
                        double d2 = (double)graphNode.y - pointInPath2.getY();
                        double d3 = (double)graphNode.z - pointInPath2.getZ();
                        double d4 = d * d + d2 * d2 + d3 * d3;
                        System.out.println("  on path between " + n18 + " and " + n19 + "  lies the node " + graphNode.id + " (distancesq " + d4);
                        if (!(dArray2[i] < 0.0) && !(d4 < dArray2[i])) continue block9;
                        dArray2[i] = d4;
                        pointInPathArray[i] = pointInPath2;
                        continue block9;
                    }
                }
                for (n2 = 0; n2 < dArray2.length; ++n2) {
                    double d = dArray2[n2];
                    if (!(d >= 0.0)) continue;
                    graphNode = (GraphNode)arrayList3.get(n2);
                    PointInPath pointInPath3 = pointInPathArray[n2];
                    pointInPath3.node = graphNode;
                    System.out.println("--- nearest point to node " + n2 + " (distancesq: " + d + ") was point " + pointInPath3);
                }
                arrayList5 = null;
                continue;
            }
            arrayList5.add(pointInPath);
        }
        System.out.println("Number of end points is: " + arrayList3.size());
        n = 4096;
        double[][] dArray3 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray3[i][j] = -1.0;
            }
        }
        double d = 0.0;
        double d5 = -1.0;
        double d6 = -1.0;
        double d7 = -1.0;
        String string4 = null;
        boolean bl = false;
        GraphNode graphNode = null;
        for (int i = 0; i < arrayList2.size(); ++i) {
            PointInPath pointInPath = (PointInPath)arrayList2.get(i);
            double d8 = pointInPath.getX();
            double d9 = pointInPath.getY();
            double d10 = pointInPath.getZ();
            String string5 = pointInPath.getNeuropilRegion();
            if (pointInPath.start()) {
                System.out.println("=====================");
                System.out.println("Path starting at id " + pointInPath.node.id);
                d = 0.0;
                graphNode = pointInPath.node;
                d5 = -1.0;
                d6 = -1.0;
                d7 = -1.0;
                string4 = string5;
            } else if (string5.equals("Exterior")) {
                double d11 = d8 - d5;
                double d12 = d9 - d6;
                double d13 = d10 - d7;
                d += Math.sqrt(d11 * d11 + d12 * d12 + d13 * d13);
            }
            System.out.println("point " + pointInPath);
            boolean bl2 = false;
            if (pointInPath.node == null) {
                for (int j = 0; j < arrayList3.size(); ++j) {
                    GraphNode graphNode2 = (GraphNode)arrayList3.get(j);
                    if (!graphNode2.nearTo(n5, (int)d8, (int)d9, (int)d10) || !graphNode2.material_name.equals(pointInPath.getNeuropilRegion()) || graphNode2.id == graphNode.id) continue;
                    bl2 = true;
                    bl = false;
                    System.out.println("A: distance " + d + " from " + graphNode.id + " to " + graphNode2.id);
                    dArray3[graphNode.id][graphNode2.id] = d;
                    dArray3[graphNode2.id][graphNode.id] = d;
                    graphNode = graphNode2;
                    d = 0.0;
                    break;
                }
            } else {
                GraphNode graphNode3 = pointInPath.node;
                if (pointInPath.node.id != graphNode.id) {
                    bl2 = true;
                    bl = false;
                    System.out.println("B: distance " + d + " from " + graphNode.id + " to " + graphNode3.id);
                    dArray3[graphNode.id][graphNode3.id] = d;
                    dArray3[graphNode3.id][graphNode.id] = d;
                    graphNode = graphNode3;
                    d = 0.0;
                }
            }
            if (!bl2 && !string4.equals(string5)) {
                System.out.println("changing from material " + string4 + " to " + string5);
                if (string5.equals("Exterior") && bl) {
                    GraphNode graphNode4 = new GraphNode();
                    graphNode4.x = (int)d5;
                    graphNode4.y = (int)d6;
                    graphNode4.z = (int)d7;
                    graphNode4.material_name = string4;
                    graphNode4.id = n17++;
                    arrayList4.add(graphNode4);
                    System.out.println("C: distance " + d + " from " + graphNode.id + " to " + graphNode4.id);
                    dArray3[graphNode.id][graphNode4.id] = d;
                    dArray3[graphNode4.id][graphNode.id] = d;
                    graphNode = graphNode4;
                    d = 0.0;
                    graphNode = graphNode4;
                    bl = false;
                } else {
                    bl = true;
                }
            }
            d5 = d8;
            d6 = d9;
            d7 = d10;
            string4 = string5;
        }
        connectivity.distances = dArray3;
        connectivity.allNodes = arrayList4;
        return connectivity;
    }

    public static Connectivity buildGraph(String string) {
        String string2 = string + ".traces";
        PathAndFillManager pathAndFillManager = new PathAndFillManager();
        pathAndFillManager.load(string2);
        return AnalyzeTracings_.buildGraph(string, pathAndFillManager.getAllPaths());
    }

    public void run(String string) {
        Enumeration enumeration;
        Object object;
        Object object2;
        FileAndChannel[] fileAndChannelArray = new FileAndChannel[]{new FileAndChannel("/media/WD USB 2/corpus/central-complex/c061AG.lsm", 0), new FileAndChannel("/media/WD USB 2/corpus/central-complex/c061AH.lsm", 0), new FileAndChannel("/media/WD USB 2/corpus/central-complex/c061AI().lsm", 0), new FileAndChannel("/media/WD USB 2/corpus/central-complex/c061AJ.lsm", 0), new FileAndChannel("/media/WD USB 2/corpus/central-complex/c061AK.lsm", 0)};
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Hashtable<String, double[]> hashtable2 = new Hashtable<String, double[]>();
        int n = fileAndChannelArray.length;
        Connectivity connectivity = null;
        HashSet<Object> hashSet = new HashSet<Object>();
        String[] stringArray = new String[20];
        int n2 = 0;
        for (int i = 0; i < fileAndChannelArray.length; ++i) {
            GraphNode graphNode;
            int n3;
            Object object3;
            BufferedWriter bufferedWriter;
            String string3;
            FileAndChannel fileAndChannel = fileAndChannelArray[i];
            String string4 = fileAndChannel.getPath();
            int n4 = string4.lastIndexOf(46);
            System.out.println("lastDotIndex " + n4);
            int n5 = string4.lastIndexOf(File.separatorChar);
            System.out.println("lastSeparatorIndex " + n5);
            String string5 = string4.substring(n5 + 1, n4);
            object2 = AnalyzeTracings_.buildGraph(string4);
            ArrayList<GraphNode> arrayList = ((Connectivity)object2).allNodes;
            double[][] dArray = ((Connectivity)object2).distances;
            connectivity = object2;
            try {
                string3 = "test-" + string5;
                stringArray[n2++] = string3;
                bufferedWriter = new BufferedWriter(new FileWriter(string3 + ".dot", false));
                bufferedWriter.write("graph G {\n");
                bufferedWriter.write("        graph [overlap=scale,splines=true];\n");
                bufferedWriter.write("        node [fontname=\"DejaVuSans\",style=filled];\n");
                for (int j = 0; j < arrayList.size(); ++j) {
                    GraphNode graphNode2 = arrayList.get(j);
                    object3 = graphNode2.material_name;
                    bufferedWriter.write("        \"" + graphNode2.toDotName() + "\" [fillcolor=\"" + ((Connectivity)object2).colorString((String)object3) + "\"];\n");
                }
                HashSet hashSet2 = new HashSet();
                for (int j = 0; j < arrayList.size(); ++j) {
                    object3 = arrayList.get(j);
                    for (n3 = 0; n3 < arrayList.size(); ++n3) {
                        if (!(dArray[j][n3] >= 0.0)) continue;
                        graphNode = arrayList.get(n3);
                        bufferedWriter.write("        \"" + ((GraphNode)object3).toDotName() + "\" -- \"" + graphNode.toDotName() + "\";\n");
                    }
                }
                for (String string6 : hashSet2) {
                    bufferedWriter.write("        \"" + string6 + "\" -- \"" + string6 + "\";\n");
                }
                bufferedWriter.write("}");
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                IJ.error((String)"Exception while writing the file");
            }
            try {
                string3 = "test-collapsed-" + string5;
                stringArray[n2++] = string3;
                bufferedWriter = new BufferedWriter(new FileWriter(string3 + ".dot", false));
                bufferedWriter.write("graph G {\n");
                bufferedWriter.write("        graph [overlap=scale,splines=true];\n");
                bufferedWriter.write("        node [fontname=\"DejaVuSans\",style=filled];\n");
                for (int j = 0; j < arrayList.size(); ++j) {
                    GraphNode graphNode3 = arrayList.get(j);
                    object3 = graphNode3.material_name;
                    bufferedWriter.write("        \"" + graphNode3.toCollapsedDotName() + "\" [fillcolor=\"" + ((Connectivity)object2).colorString((String)object3) + "\"];\n");
                }
                HashSet<String> hashSet3 = new HashSet<String>();
                for (int j = 0; j < arrayList.size(); ++j) {
                    object3 = arrayList.get(j);
                    for (n3 = 0; n3 < arrayList.size(); ++n3) {
                        if (!(dArray[j][n3] >= 0.0)) continue;
                        graphNode = arrayList.get(n3);
                        if (((GraphNode)object3).toCollapsedDotName().equals(graphNode.toCollapsedDotName())) {
                            hashSet3.add(((GraphNode)object3).toCollapsedDotName());
                            continue;
                        }
                        bufferedWriter.write("        \"" + ((GraphNode)object3).toCollapsedDotName() + "\" -- \"" + graphNode.toCollapsedDotName() + "\";\n");
                    }
                }
                for (String string7 : hashSet3) {
                    bufferedWriter.write("        \"" + string7 + "\" -- \"" + string7 + "\";\n");
                }
                bufferedWriter.write("}");
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                IJ.error((String)"Exception while writing the file");
            }
            try {
                int n6;
                string3 = "test-verycollapsed-" + string5;
                stringArray[n2++] = string3;
                bufferedWriter = new BufferedWriter(new FileWriter(string3 + ".dot", false));
                bufferedWriter.write("graph G {\n");
                bufferedWriter.write("        graph [overlap=scale,splines=true];\n");
                bufferedWriter.write("        node [fontname=\"DejaVuSans\",style=filled];\n");
                for (n6 = 0; n6 < arrayList.size(); ++n6) {
                    GraphNode graphNode4 = arrayList.get(n6);
                    object3 = graphNode4.material_name;
                    bufferedWriter.write("        \"" + graphNode4.material_name + "\" [fillcolor=\"" + ((Connectivity)object2).colorString((String)object3) + "\"];\n");
                }
                for (n6 = 1; n6 < ((Connectivity)object2).materialNames.length; ++n6) {
                    for (int j = n6 + 1; j < ((Connectivity)object2).materialNames.length; ++j) {
                        int n7;
                        object3 = ((Connectivity)object2).materialNames[n6];
                        String string8 = ((Connectivity)object2).materialNames[j];
                        if (object3 == null || string8 == null) continue;
                        boolean bl = false;
                        double d = Double.MAX_VALUE;
                        System.out.println("from: " + (String)object3 + " -> " + string8);
                        String string9 = "\"" + (String)object3 + "\" -- \"" + string8 + "\"";
                        for (int k = 0; k < arrayList.size(); ++k) {
                            for (n7 = 0; n7 < arrayList.size(); ++n7) {
                                GraphNode graphNode5 = arrayList.get(k);
                                GraphNode graphNode6 = arrayList.get(n7);
                                if (!graphNode5.material_name.equals(object3) || !graphNode6.material_name.equals(string8)) continue;
                                System.out.println("== Trying to find path between " + graphNode5.toDotName() + " and " + graphNode6.toDotName());
                                PathWithLength pathWithLength = ((Connectivity)object2).pathBetween(graphNode5, graphNode6);
                                if (pathWithLength == null) continue;
                                bl = true;
                                for (int i2 = 0; i2 < pathWithLength.path.size(); ++i2) {
                                    GraphNode graphNode7 = pathWithLength.path.get(i2);
                                    System.out.print(graphNode7.toDotName() + "-");
                                }
                                System.out.println("");
                                if (!(pathWithLength.length < d)) continue;
                                d = pathWithLength.length;
                            }
                        }
                        if (!bl) continue;
                        if (!((String)object3).equals("Exterior")) {
                            hashSet.add(object3);
                        }
                        if (!string8.equals("Exterior")) {
                            hashSet.add(string8);
                        }
                        bufferedWriter.write("        \"" + (String)object3 + "\" -- \"" + string8 + "\";\n");
                        System.out.println("C: " + (String)object3 + "-" + string8);
                        if (!hashtable2.containsKey(string9)) {
                            hashtable2.put(string9, new double[n]);
                        }
                        if (!hashtable.containsKey(string9)) {
                            hashtable.put(string9, new Integer(0));
                        }
                        double[] dArray2 = (double[])hashtable2.get(string9);
                        n7 = (Integer)hashtable.get(string9);
                        dArray2[n7] = d * 1.16;
                        hashtable.put(string9, new Integer(n7 + 1));
                    }
                }
                bufferedWriter.write("}");
                bufferedWriter.close();
                continue;
            }
            catch (IOException iOException) {
                IJ.error((String)"Exception while writing the file");
            }
        }
        try {
            String string10 = "overall-";
            stringArray[n2++] = string10;
            object = new BufferedWriter(new FileWriter(string10 + ".dot", false));
            ((Writer)object).write("graph G {\n");
            ((Writer)object).write("        graph [overlap=scale,splines=true];\n");
            ((Writer)object).write("        node [fontname=\"DejaVuSans\",style=filled];\n");
            for (String string22 : hashSet) {
                ((Writer)object).write("        \"" + string22 + "\" [fillcolor=\"" + connectivity.colorString(string22) + "\"];\n");
            }
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                int n8 = (Integer)hashtable.get(string2);
                double d = 0.0;
                double d2 = 0.0;
                object2 = (double[])hashtable2.get(string2);
                for (int i = 0; i < n8; ++i) {
                    d += object2[i];
                    d2 += object2[i] * object2[i];
                }
                double d3 = d / (double)n8;
                double d4 = Math.sqrt(d2 / (double)n8 - d3 * d3);
                System.out.println(string2 + n8 / n + " mean distance " + d3 + " [sd " + d4 + "]");
                String string11 = "p: " + (double)n8 / (double)n + "\\nmean d: " + d3 + (d4 > 0.0 ? "\\nsd d: " + d4 : "");
                ((Writer)object).write("        " + string2 + " [style=\"setlinewidth(" + n8 + ")\",label=\"" + string11 + "\",fontsize=11]\n");
            }
            ((Writer)object).write("}");
            ((BufferedWriter)object).close();
        }
        catch (IOException iOException) {
            IJ.error((String)"Exception while writing the file");
        }
        for (int i = 0; i < n2; ++i) {
            object = stringArray[i];
            enumeration = (String)object + ".dot";
            String string3 = (String)object + ".svg";
            System.out.println("Generating " + string3 + " from " + enumeration);
            try {
                Process process = Runtime.getRuntime().exec("neato -Tsvg -o" + string3 + " < " + enumeration);
                process.waitFor();
                continue;
            }
            catch (IOException iOException) {
                System.out.println("Got IOException: " + iOException);
                continue;
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Got InterruptedException: " + interruptedException);
            }
        }
        System.exit(0);
    }
}

