/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.PriorityQueue;
import tracing.GraphNode;
import tracing.PathWithLength;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connectivity {
    ArrayList<GraphNode> allNodes;
    public double[][] distances;
    public int[] redValues;
    public int[] greenValues;
    public int[] blueValues;
    public String[] materialNames;
    public Hashtable<String, Integer> materialNameToIndex;

    public String colorString(String string) {
        String string2;
        String string3;
        String string4;
        if (string.equals("Exterior")) {
            return "#DDDDDD";
        }
        Integer n = this.materialNameToIndex.get(string);
        int n2 = n;
        double d = 1.4;
        int n3 = (int)((double)this.redValues[n2] * d);
        int n4 = (int)((double)this.greenValues[n2] * d);
        int n5 = (int)((double)this.blueValues[n2] * d);
        if (n3 > 255) {
            n3 = 255;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        if (n5 > 255) {
            n5 = 255;
        }
        if ((string4 = Integer.toHexString(n3)).length() <= 1) {
            string4 = "0" + string4;
        }
        if ((string3 = Integer.toHexString(n4)).length() <= 1) {
            string3 = "0" + string3;
        }
        if ((string2 = Integer.toHexString(n5)).length() <= 1) {
            string2 = "0" + string2;
        }
        return "#" + string4 + string3 + string2;
    }

    ArrayList<GraphNode> trimPath(ArrayList<GraphNode> arrayList, String string, String string2) {
        int n;
        int n2 = -1;
        for (n = 0; n < arrayList.size(); ++n) {
            GraphNode graphNode = arrayList.get(n);
            if (!string.equals(graphNode.material_name)) continue;
            n2 = n;
        }
        n = -1;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            GraphNode graphNode = arrayList.get(i);
            if (!string2.equals(graphNode.material_name)) continue;
            n = i;
        }
        if (n < n2) {
            return null;
        }
        ArrayList<GraphNode> arrayList2 = new ArrayList<GraphNode>();
        for (int i = n2; i <= n; ++i) {
            arrayList2.add(arrayList.get(i));
        }
        return arrayList2;
    }

    ArrayList<GraphNode> makePath(GraphNode graphNode) {
        ArrayList<GraphNode> arrayList = new ArrayList<GraphNode>();
        GraphNode graphNode2 = graphNode;
        do {
            arrayList.add(graphNode2);
        } while (null != (graphNode2 = graphNode2.previous));
        ArrayList<GraphNode> arrayList2 = new ArrayList<GraphNode>();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            arrayList2.add((GraphNode)arrayList.get(i));
        }
        return arrayList2;
    }

    PathWithLength pathBetween(GraphNode graphNode, GraphNode graphNode2) {
        Object object;
        for (int i = 0; i < this.allNodes.size(); ++i) {
            object = this.allNodes.get(i);
            ((GraphNode)object).g = 0.0;
            ((GraphNode)object).h = 0.0;
            ((GraphNode)object).previous = null;
        }
        PriorityQueue<GraphNode> priorityQueue = new PriorityQueue<GraphNode>();
        object = new PriorityQueue();
        Hashtable<GraphNode, GraphNode> hashtable = new Hashtable<GraphNode, GraphNode>();
        Hashtable<GraphNode, GraphNode> hashtable2 = new Hashtable<GraphNode, GraphNode>();
        graphNode.g = 0.0;
        graphNode.h = 0.0;
        graphNode.previous = null;
        ((PriorityQueue)object).add(graphNode);
        hashtable.put(graphNode, graphNode);
        while (((PriorityQueue)object).size() > 0) {
            GraphNode graphNode3 = (GraphNode)((PriorityQueue)object).poll();
            hashtable.remove(graphNode3);
            if (graphNode3.id == graphNode2.id) {
                ArrayList<GraphNode> arrayList = this.trimPath(this.makePath(graphNode3), graphNode.material_name, graphNode2.material_name);
                if (arrayList == null) {
                    return null;
                }
                PathWithLength pathWithLength = new PathWithLength();
                pathWithLength.path = arrayList;
                pathWithLength.length = graphNode3.g;
                return pathWithLength;
            }
            priorityQueue.add(graphNode3);
            hashtable2.put(graphNode3, graphNode3);
            for (int i = 0; i < this.distances.length; ++i) {
                double d = this.distances[graphNode3.id][i];
                if (!(d >= 0.0)) continue;
                GraphNode graphNode4 = this.allNodes.get(i);
                if (!graphNode4.material_name.equals("Exterior") && !graphNode4.material_name.equals(graphNode.material_name) && !graphNode4.material_name.equals(graphNode2.material_name)) continue;
                GraphNode graphNode5 = new GraphNode();
                graphNode5.setFrom(graphNode4);
                graphNode5.g = graphNode3.g + d;
                graphNode5.h = 0.0;
                graphNode5.previous = graphNode3;
                GraphNode graphNode6 = (GraphNode)hashtable2.get(graphNode4);
                GraphNode graphNode7 = (GraphNode)hashtable.get(graphNode4);
                if (graphNode6 != null && graphNode6.f() <= graphNode5.f() || graphNode7 != null && graphNode7.f() <= graphNode5.f()) continue;
                if (graphNode6 != null) {
                    priorityQueue.remove(graphNode6);
                    hashtable2.remove(graphNode6);
                    graphNode6.setFrom(graphNode5);
                    ((PriorityQueue)object).add(graphNode6);
                    hashtable.put(graphNode6, graphNode6);
                    continue;
                }
                if (graphNode7 != null) {
                    ((PriorityQueue)object).remove(graphNode7);
                    hashtable.remove(graphNode7);
                    graphNode7.setFrom(graphNode5);
                    ((PriorityQueue)object).add(graphNode7);
                    hashtable.put(graphNode7, graphNode7);
                    continue;
                }
                ((PriorityQueue)object).add(graphNode5);
                hashtable.put(graphNode5, graphNode5);
            }
        }
        return null;
    }
}

