/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import landmarks.Bookstein_From_Landmarks;
import tracing.Path;
import tracing.PathAndFillManager;
import util.BatchOpener;
import util.FileAndChannel;
import vib.oldregistration.RegistrationAlgorithm;

public class CreateTracingVolume_
implements PlugIn {
    static final boolean verbose = false;
    static final int NONE = 0;
    static final int EB = 9;
    static final int NOD = 10;
    static final int FB = 11;
    static final int PB = 12;

    public void run(String string) {
        int n;
        String string2 = "/media/WD USB 2/standard-brain/data/vib-drosophila/CantonM43c.grey";
        String string3 = "/media/WD USB 2/standard-brain/data/vib-drosophila/CantonM43c.labels";
        FileAndChannel fileAndChannel = new FileAndChannel(string2, 0);
        String string4 = "/media/WD USB 2/corpus/central-complex/c061AK.lsm";
        FileAndChannel fileAndChannel2 = new FileAndChannel(string4, 0);
        String string5 = string4 + ".traces";
        PathAndFillManager pathAndFillManager = new PathAndFillManager();
        pathAndFillManager.load(string5);
        ArrayList<Path> arrayList = pathAndFillManager.getAllPaths();
        Bookstein_From_Landmarks bookstein_From_Landmarks = new Bookstein_From_Landmarks();
        bookstein_From_Landmarks.loadImages(fileAndChannel, fileAndChannel2);
        bookstein_From_Landmarks.generateTransformation();
        ImageStack imageStack = bookstein_From_Landmarks.getDomain().getStack();
        ImagePlus imagePlus = bookstein_From_Landmarks.getTemplate();
        double d = 1.0;
        int n2 = (int)((double)imagePlus.getWidth() * d);
        int n3 = (int)((double)imagePlus.getHeight() * d);
        int n4 = (int)((double)imagePlus.getStackSize() * d);
        Object object = BatchOpener.open(string3);
        ImagePlus imagePlus2 = object[0];
        object = new AmiraParameters(imagePlus2);
        int n5 = ((AmiraParameters)object).getMaterialCount();
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        int[] nArray3 = new int[n5];
        for (int i = 0; i < n5; ++i) {
            double[] dArray = ((AmiraParameters)object).getMaterialColor(i);
            nArray[i] = (int)(255.0 * dArray[0]);
            nArray2[i] = (int)(255.0 * dArray[1]);
            nArray3[i] = (int)(255.0 * dArray[2]);
        }
        ImageStack imageStack2 = imagePlus2.getStack();
        int n6 = imageStack2.getWidth();
        int n7 = imageStack2.getHeight();
        int n8 = imageStack2.getSize();
        ImageStack imageStack3 = new ImageStack(n2, n3);
        byte[][] byArrayArray = new byte[n8][];
        for (n = 0; n < n8; ++n) {
            byArrayArray[n] = (byte[])imageStack2.getPixels(n + 1);
        }
        byte[][] byArrayArray2 = new byte[n4][];
        byte[][] byArrayArray3 = new byte[n4][];
        byte[][] byArrayArray4 = new byte[n4][];
        for (n = 0; n < n4; ++n) {
            byArrayArray2[n] = new byte[n2 * n3];
            byArrayArray3[n] = new byte[n2 * n3];
            byArrayArray4[n] = new byte[n2 * n3];
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    int n9 = byArrayArray[(int)((double)n / d)][(int)((double)i / d) * n6 + (int)((double)j / d)] & 0xFF;
                    if (n9 >= n5) {
                        IJ.error((String)("A label value of " + n9 + " was found, which is not a valid material (max " + (n5 - 1) + ")"));
                        return;
                    }
                    byArrayArray2[n][i * n2 + j] = (byte)(nArray[n9] / 1);
                    byArrayArray3[n][i * n2 + j] = (byte)(nArray2[n9] / 1);
                    byArrayArray4[n][i * n2 + j] = (byte)(nArray3[n9] / 1);
                }
            }
        }
        RegistrationAlgorithm.ImagePoint imagePoint = new RegistrationAlgorithm.ImagePoint();
        if (arrayList != null) {
            int n10 = arrayList.size();
            for (int i = 0; i < n10; ++i) {
                Path path = arrayList.get(i);
                int n11 = -1;
                int n12 = -1;
                int n13 = -1;
                for (int j = 0; j < path.size(); ++j) {
                    int n14 = path.getXUnscaled(j);
                    int n15 = path.getYUnscaled(j);
                    int n16 = path.getZUnscaled(j);
                    bookstein_From_Landmarks.transformDomainToTemplate(n14, n15, n16, imagePoint);
                    int n17 = imagePoint.x;
                    int n18 = imagePoint.y;
                    int n19 = imagePoint.z;
                    if (n11 >= 0 && n12 >= 0 && n13 >= 0) {
                        int n20;
                        long l;
                        long l2;
                        double d2;
                        double d3;
                        double d4;
                        long l3;
                        int n21;
                        int n22 = Math.abs(n17 - n11);
                        int n23 = Math.abs(n18 - n12);
                        int n24 = Math.abs(n19 - n13);
                        if (n22 > 5 || n23 > 5 || n24 > 5) {
                            // empty if block
                        }
                        int n25 = n17 - n11;
                        int n26 = n18 - n12;
                        int n27 = n19 - n13;
                        if (n24 >= n23 && n24 >= n22) {
                            if (n24 == 0) {
                                n21 = n18 * n2 + n17;
                                byArrayArray2[n19][n21] = -1;
                                byArrayArray3[n19][n21] = -1;
                                byArrayArray4[n19][n21] = -1;
                            } else {
                                n21 = n13 <= n19 ? 1 : -1;
                                l3 = n13;
                                do {
                                    d4 = (double)Math.abs(l3 - (long)n13) / (double)n24;
                                    d3 = d4 * (double)n26;
                                    d2 = d4 * (double)n25;
                                    l2 = Math.round(d3 + (double)n12);
                                    l = Math.round(d2 + (double)n11);
                                    n20 = (int)(l2 * (long)n2 + l);
                                    byArrayArray2[(int)l3][n20] = -1;
                                    byArrayArray3[(int)l3][n20] = -1;
                                    byArrayArray4[(int)l3][n20] = -1;
                                } while ((l3 += (long)n21) != (long)n19);
                            }
                        } else if (n23 >= n24 && n23 >= n22) {
                            if (n23 == 0) {
                                n21 = n18 * n2 + n17;
                                byArrayArray2[n19][n21] = -1;
                                byArrayArray3[n19][n21] = -1;
                                byArrayArray4[n19][n21] = -1;
                            } else {
                                n21 = n12 <= n18 ? 1 : -1;
                                l2 = n12;
                                do {
                                    d4 = (double)Math.abs(l2 - (long)n12) / (double)n23;
                                    d3 = d4 * (double)n27;
                                    d2 = d4 * (double)n25;
                                    l3 = Math.round(d3 + (double)n13);
                                    l = Math.round(d2 + (double)n11);
                                    n20 = (int)(l2 * (long)n2 + l);
                                    byArrayArray2[(int)l3][n20] = -1;
                                    byArrayArray3[(int)l3][n20] = -1;
                                    byArrayArray4[(int)l3][n20] = -1;
                                } while ((l2 += (long)n21) != (long)n18);
                            }
                        } else if (n22 >= n23 && n22 >= n24) {
                            if (n22 == 0) {
                                n21 = n18 * n2 + n17;
                                byArrayArray2[n19][n21] = -1;
                                byArrayArray3[n19][n21] = -1;
                                byArrayArray4[n19][n21] = -1;
                            } else {
                                n21 = n11 <= n17 ? 1 : -1;
                                l = n11;
                                do {
                                    d4 = (double)Math.abs(l - (long)n11) / (double)n22;
                                    d3 = d4 * (double)n27;
                                    d2 = d4 * (double)n26;
                                    l3 = Math.round(d3 + (double)n13);
                                    l2 = Math.round(d2 + (double)n12);
                                    n20 = (int)(l2 * (long)n2 + l);
                                    byArrayArray2[(int)l3][n20] = -1;
                                    byArrayArray3[(int)l3][n20] = -1;
                                    byArrayArray4[(int)l3][n20] = -1;
                                } while ((l += (long)n21) != (long)n17);
                            }
                        }
                    }
                    n11 = n17;
                    n12 = n18;
                    n13 = n19;
                }
            }
        }
        for (n = 0; n < n4; ++n) {
            ColorProcessor colorProcessor = new ColorProcessor(n2, n3);
            colorProcessor.setRGB(byArrayArray2[n], byArrayArray3[n], byArrayArray4[n]);
            imageStack3.addSlice(null, (ImageProcessor)colorProcessor);
        }
        ImagePlus imagePlus3 = new ImagePlus("tracings stack", imageStack3);
        imagePlus3.show();
    }
}

