/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import ij.IJ;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import tracing.FillerProgressCallback;
import tracing.Path;
import tracing.PathAndFillListener;
import tracing.PathAndFillManager;
import tracing.SearchThread;
import tracing.Simple_Neurite_Tracer;

public class FillWindow
extends JFrame
implements PathAndFillListener,
ActionListener,
ItemListener,
FillerProgressCallback {
    Simple_Neurite_Tracer plugin;
    PathAndFillManager pathAndFillManager;
    JScrollPane scrollPane;
    JList fillList;
    DefaultListModel listModel;
    JButton deleteFills;
    JButton reloadFill;
    JPanel fillControlPanel;
    JLabel fillStatus;
    float maxThresholdValue = 0.0f;
    JTextField thresholdField;
    JLabel maxThreshold;
    JButton setThreshold;
    JButton setMaxThreshold;
    JButton view3D;
    JCheckBox maskNotReal;
    JCheckBox transparent;
    boolean currentlyFilling = true;
    JButton pauseOrRestartFilling;
    JButton saveFill;
    JButton discardFill;

    public FillWindow(PathAndFillManager pathAndFillManager, Simple_Neurite_Tracer simple_Neurite_Tracer) {
        this(pathAndFillManager, simple_Neurite_Tracer, 200, 60);
    }

    public void setControlsEnabled(boolean bl) {
    }

    public void setEnabledWhileFilling() {
        this.fillList.setEnabled(false);
        this.deleteFills.setEnabled(false);
        this.reloadFill.setEnabled(false);
        this.fillStatus.setEnabled(true);
        this.thresholdField.setEnabled(true);
        this.maxThreshold.setEnabled(true);
        this.setThreshold.setEnabled(true);
        this.setMaxThreshold.setEnabled(true);
        this.view3D.setEnabled(true);
        this.maskNotReal.setEnabled(true);
        this.transparent.setEnabled(true);
        this.pauseOrRestartFilling.setEnabled(true);
        this.saveFill.setEnabled(false);
        this.discardFill.setEnabled(true);
    }

    public void setEnabledWhileNotFilling() {
        this.fillList.setEnabled(true);
        this.deleteFills.setEnabled(true);
        this.reloadFill.setEnabled(true);
        this.fillStatus.setEnabled(true);
        this.thresholdField.setEnabled(false);
        this.maxThreshold.setEnabled(false);
        this.setThreshold.setEnabled(false);
        this.setMaxThreshold.setEnabled(false);
        this.view3D.setEnabled(false);
        this.maskNotReal.setEnabled(false);
        this.transparent.setEnabled(false);
        this.pauseOrRestartFilling.setEnabled(false);
        this.saveFill.setEnabled(false);
        this.discardFill.setEnabled(false);
    }

    public void setEnabledNone() {
        this.fillList.setEnabled(false);
        this.deleteFills.setEnabled(false);
        this.reloadFill.setEnabled(false);
        this.fillStatus.setEnabled(false);
        this.thresholdField.setEnabled(false);
        this.maxThreshold.setEnabled(false);
        this.setThreshold.setEnabled(false);
        this.setMaxThreshold.setEnabled(false);
        this.view3D.setEnabled(false);
        this.maskNotReal.setEnabled(false);
        this.transparent.setEnabled(false);
        this.pauseOrRestartFilling.setEnabled(false);
        this.saveFill.setEnabled(false);
        this.discardFill.setEnabled(false);
    }

    public FillWindow(PathAndFillManager pathAndFillManager, Simple_Neurite_Tracer simple_Neurite_Tracer, int n, int n2) {
        super("All Fills");
        this.plugin = simple_Neurite_Tracer;
        this.pathAndFillManager = pathAndFillManager;
        this.setBounds(n, n2, 400, 400);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.listModel = new DefaultListModel();
        this.fillList = new JList(this.listModel);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().add(this.fillList);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(8, 8, 1, 8);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.scrollPane, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.deleteFills = new JButton("Delete Fill(s)");
        this.deleteFills.addActionListener(this);
        jPanel.add((Component)this.deleteFills, "West");
        this.reloadFill = new JButton("Reload Fill");
        this.reloadFill.addActionListener(this);
        jPanel.add((Component)this.reloadFill, "Center");
        gridBagConstraints.insets = new Insets(1, 8, 8, 8);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 4;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 21;
        gridBagConstraints2.fill = 2;
        this.fillStatus = new JLabel("(Not filling at the moment.)");
        jPanel.add((Component)this.fillStatus, gridBagConstraints2);
        this.thresholdField = new JTextField("", 20);
        this.thresholdField.addActionListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.fill = 0;
        jPanel.add((Component)this.thresholdField, gridBagConstraints2);
        this.maxThreshold = new JLabel("(0)                  ", 2);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 21;
        jPanel.add((Component)this.maxThreshold, gridBagConstraints2);
        this.setThreshold = new JButton("Set");
        this.setThreshold.addActionListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        jPanel.add((Component)this.setThreshold, gridBagConstraints2);
        this.setMaxThreshold = new JButton("Set Max");
        this.setMaxThreshold.addActionListener(this);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        jPanel.add((Component)this.setMaxThreshold, gridBagConstraints2);
        this.view3D = new JButton("Create Image Stack from Fill");
        this.view3D.addActionListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.anchor = 21;
        jPanel.add((Component)this.view3D, gridBagConstraints2);
        this.maskNotReal = new JCheckBox("Create as Mask");
        this.maskNotReal.addItemListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.gridwidth = 3;
        gridBagConstraints2.anchor = 21;
        jPanel.add((Component)this.maskNotReal, gridBagConstraints2);
        this.transparent = new JCheckBox("Transparent fill display (slow!)");
        this.transparent.addItemListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.gridwidth = 3;
        gridBagConstraints2.anchor = 21;
        jPanel.add((Component)this.transparent, gridBagConstraints2);
        this.fillControlPanel = new JPanel();
        this.fillControlPanel.setLayout(new BorderLayout());
        this.pauseOrRestartFilling = new JButton("Pause");
        this.currentlyFilling = true;
        this.pauseOrRestartFilling.addActionListener(this);
        this.fillControlPanel.add((Component)this.pauseOrRestartFilling, "West");
        this.saveFill = new JButton("Save Fill");
        this.saveFill.addActionListener(this);
        this.fillControlPanel.add((Component)this.saveFill, "Center");
        this.discardFill = new JButton("Cancel Fill");
        this.discardFill.addActionListener(this);
        this.fillControlPanel.add((Component)this.discardFill, "East");
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 6;
        gridBagConstraints2.gridwidth = 3;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 21;
        jPanel.add((Component)this.fillControlPanel, gridBagConstraints2);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.add((Component)jPanel, gridBagConstraints);
        this.deleteFills.addActionListener(this);
        this.reloadFill.addActionListener(this);
    }

    public void setPathList(String[] stringArray, Path path, boolean bl) {
    }

    public void setFillList(String[] stringArray) {
        this.listModel.removeAllElements();
        for (int i = 0; i < stringArray.length; ++i) {
            this.listModel.addElement(stringArray[i]);
        }
    }

    public void setSelectedPaths(HashSet hashSet, Object object) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.deleteFills) {
            int[] nArray = this.fillList.getSelectedIndices();
            if (nArray.length < 1) {
                IJ.error((String)"No fill was selected for deletion");
                return;
            }
            this.pathAndFillManager.deleteFills(nArray);
            this.plugin.repaintAllPanes();
        } else if (object == this.reloadFill) {
            int[] nArray = this.fillList.getSelectedIndices();
            if (nArray.length != 1) {
                IJ.error((String)"You must have a single fill selected in order to reload.");
                return;
            }
            this.pathAndFillManager.reloadFill(nArray[0]);
        } else if (object == this.setMaxThreshold) {
            this.plugin.setFillThreshold(this.maxThresholdValue);
        } else if (object == this.setThreshold) {
            try {
                double d = Double.parseDouble(this.thresholdField.getText());
                if (d < 0.0) {
                    IJ.error((String)"The fill threshold cannot be negative.");
                    return;
                }
                this.plugin.setFillThreshold(d);
            }
            catch (NumberFormatException numberFormatException) {
                IJ.error((String)("The threshold '" + this.thresholdField.getText() + "' wasn't a valid number."));
                return;
            }
        } else if (object == this.discardFill) {
            this.plugin.discardFill();
        } else if (object == this.saveFill) {
            this.plugin.saveFill();
        } else if (object == this.pauseOrRestartFilling) {
            this.plugin.pauseOrRestartFilling();
        } else if (object == this.view3D) {
            this.plugin.viewFillIn3D(!this.maskNotReal.isSelected());
        } else {
            IJ.error((String)"BUG: FillWindow received an event from an unknown source");
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.transparent) {
            this.plugin.setFillTransparent(this.transparent.isSelected());
        }
    }

    public void thresholdChanged(double d) {
        this.thresholdField.setText("" + d);
    }

    public void maximumDistanceCompletelyExplored(SearchThread searchThread, float f) {
        this.maxThreshold.setText("(" + f + ")");
        this.maxThresholdValue = f;
    }

    public void pointsInSearch(SearchThread searchThread, int n, int n2) {
    }

    public void finished(SearchThread searchThread, boolean bl) {
    }

    public void threadStatus(SearchThread searchThread, int n) {
        switch (n) {
            case 2: {
                this.pauseOrRestartFilling.setLabel("Stopped");
                this.pauseOrRestartFilling.setEnabled(false);
                this.saveFill.setEnabled(false);
                break;
            }
            case 1: {
                this.pauseOrRestartFilling.setLabel("Continue");
                this.saveFill.setEnabled(true);
                break;
            }
            case 0: {
                this.pauseOrRestartFilling.setLabel("Pause");
                this.saveFill.setEnabled(false);
            }
        }
        this.fillControlPanel.doLayout();
    }
}

