/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import tracing.Fill;
import tracing.FillerProgressCallback;
import tracing.Path;
import tracing.SearchNode;
import tracing.SearchProgressCallback;
import tracing.SearchThread;
import tracing.TracerCanvas;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FillerThread
extends SearchThread {
    static final boolean verbose = false;
    boolean reciprocal;
    double reciprocal_fudge = 0.5;
    Set<Path> sourcePaths;
    float threshold;

    public float getDistanceAtPoint(int n, int n2, int n3) {
        SearchNode[] searchNodeArray = this.nodes_as_image[n3];
        if (searchNodeArray == null) {
            return -1.0f;
        }
        SearchNode searchNode = searchNodeArray[n2 * this.width + n];
        if (searchNode == null) {
            return -1.0f;
        }
        return searchNode.g;
    }

    Fill getFill() {
        Hashtable<SearchNode, Integer> hashtable = new Hashtable<SearchNode, Integer>();
        ArrayList<SearchNode> arrayList = new ArrayList<SearchNode>();
        int n = 0;
        for (SearchNode searchNode : this.closed_from_start) {
            hashtable.put(searchNode, new Integer(n));
            arrayList.add(searchNode);
            ++n;
        }
        int n2 = n;
        for (SearchNode searchNode : this.open_from_start) {
            hashtable.put(searchNode, new Integer(n));
            arrayList.add(searchNode);
            ++n;
        }
        Fill fill = new Fill();
        fill.setThreshold(this.threshold);
        if (this.reciprocal) {
            fill.setMetric("reciprocal-intensity-scaled");
        } else {
            fill.setMetric("256-minus-intensity-scaled");
        }
        fill.setSpacing(this.x_spacing, this.y_spacing, this.z_spacing, this.spacing_units);
        for (n = 0; n < arrayList.size(); ++n) {
            Integer n3;
            SearchNode searchNode;
            searchNode = (SearchNode)arrayList.get(n);
            int n4 = -1;
            SearchNode searchNode2 = searchNode.getPredecessor();
            if (searchNode2 != null && (n3 = (Integer)hashtable.get(searchNode2)) != null) {
                n4 = n3;
            }
            fill.add(searchNode.x, searchNode.y, searchNode.z, searchNode.g, n4, n >= n2);
        }
        if (this.sourcePaths != null) {
            fill.setSourcePaths(this.sourcePaths);
        }
        return fill;
    }

    public static FillerThread fromFill(ImagePlus imagePlus, float f, float f2, boolean bl, Fill fill) {
        SearchNode searchNode;
        boolean bl2;
        String string = fill.getMetric();
        if (string.equals("reciprocal-intensity-scaled")) {
            bl2 = true;
        } else if (string.equals("256-minus-intensity-scaled")) {
            bl2 = false;
        } else {
            IJ.error((String)("Trying to load a fill with an unknown metric ('" + string + "')"));
            return null;
        }
        FillerThread fillerThread = new FillerThread(imagePlus, f, f2, bl, bl2, fill.getThreshold(), 5000L);
        ArrayList<SearchNode> arrayList = new ArrayList<SearchNode>();
        for (Fill.Node node : fill.nodeList) {
            searchNode = new SearchNode(node.x, node.y, node.z, (float)node.distance, 0.0f, null, 5);
            arrayList.add(searchNode);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Fill.Node node;
            node = fill.nodeList.get(i);
            searchNode = (SearchNode)arrayList.get(i);
            if (node.previous >= 0) {
                searchNode.setPredecessor((SearchNode)arrayList.get(node.previous));
            }
            if (node.open) {
                searchNode.searchStatus = 1;
                fillerThread.addNode(searchNode);
                continue;
            }
            searchNode.searchStatus = (byte)2;
            fillerThread.addNode(searchNode);
        }
        fillerThread.setSourcePaths(fill.sourcePaths);
        return fillerThread;
    }

    public void setThreshold(double d) {
        this.threshold = (float)d;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public FillerThread(ImagePlus imagePlus, float f, float f2, boolean bl, boolean bl2, double d, long l) {
        super(imagePlus, f, f2, false, false, bl, 0, l);
        this.reciprocal = bl2;
        this.setThreshold(d);
        long l2 = 0L;
        this.setPriority(1);
    }

    public void setSourcePaths(Set<Path> set) {
        this.sourcePaths = new HashSet<Path>();
        this.sourcePaths.addAll(set);
        for (Path path : set) {
            for (int i = 0; i < path.size(); ++i) {
                SearchNode searchNode = new SearchNode(path.getXUnscaled(i), path.getYUnscaled(i), path.getZUnscaled(i), 0.0f, 0.0f, null, 1);
                this.addNode(searchNode);
            }
        }
    }

    public ImagePlus fillAsImagePlus(boolean bl) {
        byte[][] byArrayArray = new byte[this.depth][];
        short[][] sArrayArray = new short[this.depth][];
        float[][] fArrayArray = new float[this.depth][];
        block15: for (int i = 0; i < this.depth; ++i) {
            switch (this.imageType) {
                case 0: 
                case 3: {
                    byArrayArray[i] = new byte[this.width * this.height];
                    continue block15;
                }
                case 1: {
                    sArrayArray[i] = new short[this.width * this.height];
                    continue block15;
                }
                case 2: {
                    fArrayArray[i] = new float[this.width * this.height];
                }
            }
        }
        ImageStack imageStack = new ImageStack(this.width, this.height);
        block16: for (int i = 0; i < this.depth; ++i) {
            Object object;
            SearchNode[] searchNodeArray = this.nodes_as_image[i];
            if (searchNodeArray != null) {
                for (int j = 0; j < this.height; ++j) {
                    block18: for (int k = 0; k < this.width; ++k) {
                        object = this.nodes_as_image[i][j * this.width + k];
                        if (object == null || !(object.g <= this.threshold)) continue;
                        switch (this.imageType) {
                            case 0: 
                            case 3: {
                                byArrayArray[i][j * this.width + k] = bl ? this.slices_data_b[i][j * this.width + k] : -1;
                                continue block18;
                            }
                            case 1: {
                                sArrayArray[i][j * this.width + k] = bl ? this.slices_data_s[i][j * this.width + k] : 255;
                                continue block18;
                            }
                            case 2: {
                                fArrayArray[i][j * this.width + k] = bl ? this.slices_data_f[i][j * this.width + k] : 255.0f;
                                continue block18;
                            }
                        }
                    }
                }
            }
            switch (this.imageType) {
                case 0: 
                case 3: {
                    ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height);
                    byteProcessor.setPixels((Object)byArrayArray[i]);
                    imageStack.addSlice(null, (ImageProcessor)byteProcessor);
                    continue block16;
                }
                case 1: {
                    ShortProcessor shortProcessor = new ShortProcessor(this.width, this.height);
                    shortProcessor.setPixels((Object)sArrayArray[i]);
                    imageStack.addSlice(null, (ImageProcessor)shortProcessor);
                    continue block16;
                }
                case 2: {
                    object = new FloatProcessor(this.width, this.height);
                    object.setPixels((Object)fArrayArray[i]);
                    imageStack.addSlice(null, (ImageProcessor)object);
                    continue block16;
                }
            }
        }
        ImagePlus imagePlus = new ImagePlus("filled neuron", imageStack);
        imagePlus.setCalibration(this.imagePlus.getCalibration());
        return imagePlus;
    }

    @Override
    protected void reportPointsInSearch() {
        super.reportPointsInSearch();
        SearchNode searchNode = (SearchNode)this.open_from_start.peek();
        if (searchNode == null) {
            return;
        }
        float f = searchNode.g;
        for (SearchProgressCallback searchProgressCallback : this.progressListeners) {
            if (!(searchProgressCallback instanceof FillerProgressCallback)) continue;
            FillerProgressCallback fillerProgressCallback = (FillerProgressCallback)searchProgressCallback;
            fillerProgressCallback.maximumDistanceCompletelyExplored(this, f);
        }
    }

    @Override
    void drawProgressOnSlice(int n, int n2, TracerCanvas tracerCanvas, Graphics graphics) {
        super.drawProgressOnSlice(n, n2, tracerCanvas, graphics);
    }
}

