/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import tracing.SinglePathsGraph;
import tracing.TraceLoaderListener;

public class Load_Auto_Traces
implements PlugIn,
TraceLoaderListener {
    int width = -1;
    int height = -1;
    int depth = -1;
    float spacing_x = Float.MIN_VALUE;
    float spacing_y = Float.MIN_VALUE;
    float spacing_z = Float.MIN_VALUE;
    byte[][] values = null;

    public void gotVertex(int n, float f, float f2, float f3, int n2, int n3, int n4) {
        if (this.values == null) {
            if (this.width < 0 || this.height < 0 || this.depth < 0 || this.spacing_x == Float.MIN_VALUE || this.spacing_y == Float.MIN_VALUE || this.spacing_z == Float.MIN_VALUE) {
                throw new RuntimeException("Some metadata was missing from the comments before the first vertex.");
            }
            this.values = new byte[this.depth][];
            for (int i = 0; i < this.depth; ++i) {
                this.values[i] = new byte[this.width * this.height];
            }
        }
        if (n4 >= this.depth) {
            System.out.println("z_image: " + n4 + " was too large for depth: " + this.depth);
            System.out.println("z_scaled was: " + f3);
        }
        this.values[n4][n3 * this.width + n2] = -1;
    }

    public void gotLine(int n, int n2) {
    }

    public void gotWidth(int n) {
        this.width = n;
    }

    public void gotHeight(int n) {
        this.height = n;
    }

    public void gotDepth(int n) {
        this.depth = n;
    }

    public void gotSpacingX(float f) {
        this.spacing_x = f;
    }

    public void gotSpacingY(float f) {
        this.spacing_y = f;
    }

    public void gotSpacingZ(float f) {
        this.spacing_z = f;
    }

    public void run(String string) {
        OpenDialog openDialog = new OpenDialog("Select traces.obj file...", null, null);
        String string2 = openDialog.getFileName();
        String string3 = openDialog.getDirectory();
        if (string2 == null) {
            return;
        }
        System.out.println("Got " + string2);
        boolean bl = SinglePathsGraph.loadWithListener(string3 + string2, this);
        if (!bl) {
            IJ.error((String)("Loading " + string3 + string2));
            return;
        }
        ImageStack imageStack = new ImageStack(this.width, this.height);
        for (int i = 0; i < this.depth; ++i) {
            ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height);
            byteProcessor.setPixels((Object)this.values[i]);
            imageStack.addSlice("", (ImageProcessor)byteProcessor);
        }
        ImagePlus imagePlus = new ImagePlus(string2, imageStack);
        imagePlus.show();
    }
}

