/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import tracing.Path;

public class NearPoint
implements Comparable {
    private Path path;
    private int indexInPath;
    double pathPointX;
    double pathPointY;
    double pathPointZ;
    double nearX;
    double nearY;
    double nearZ;
    private double distanceSquared;
    private Double cachedDistanceToPathNearPoint;

    public NearPoint(double d, double d2, double d3, Path path, int n) {
        this.path = path;
        this.indexInPath = n;
        this.pathPointX = path.precise_x_positions[n];
        this.pathPointY = path.precise_y_positions[n];
        this.pathPointZ = path.precise_z_positions[n];
        this.nearX = d;
        this.nearY = d2;
        this.nearZ = d3;
        double d4 = d - this.pathPointX;
        double d5 = d2 - this.pathPointY;
        double d6 = d3 - this.pathPointZ;
        this.distanceSquared = d4 * d4 + d5 * d5 + d6 * d6;
    }

    public int compareTo(Object object) {
        double d = this.distanceSquared;
        double d2 = ((NearPoint)object).distanceSquared;
        return d < d2 ? -1 : (d > d2 ? 1 : 0);
    }

    public String toString() {
        return "  near: (" + this.nearX + "," + this.nearY + "," + this.nearZ + ")\n" + "  pathPoint: (" + this.pathPointX + "," + this.pathPointY + "," + this.pathPointZ + ")\n" + "  indexInPath: " + this.indexInPath + "\n" + "  path: " + this.path + "\n" + "  distanceSquared: " + this.distanceSquared + "\n" + "  cachedDistanceToPathNearPoint: " + this.cachedDistanceToPathNearPoint;
    }

    public double distanceToPathNearPoint() {
        boolean bl;
        if (this.cachedDistanceToPathNearPoint != null) {
            return this.cachedDistanceToPathNearPoint;
        }
        int n = this.path.size();
        if (n <= 1) {
            this.cachedDistanceToPathNearPoint = new Double(-1.0);
            return -1.0;
        }
        if (this.indexInPath == 0 || this.indexInPath == n - 1) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            if (this.indexInPath == 0) {
                d6 = this.pathPointX;
                d5 = this.pathPointY;
                d4 = this.pathPointZ;
                d3 = this.path.precise_x_positions[0];
                d2 = this.path.precise_y_positions[0];
                d = this.path.precise_z_positions[0];
            } else {
                d6 = this.path.precise_x_positions[n - 2];
                d5 = this.path.precise_y_positions[n - 2];
                d4 = this.path.precise_z_positions[n - 2];
                d3 = this.pathPointX;
                d2 = this.pathPointY;
                d = this.pathPointZ;
            }
            double d7 = NearPoint.distanceToLineSegment(this.nearX, this.nearY, this.nearZ, d6, d5, d4, d3, d2, d);
            this.cachedDistanceToPathNearPoint = new Double(d7);
            return d7;
        }
        double d = this.path.precise_x_positions[this.indexInPath - 1];
        double d8 = this.path.precise_y_positions[this.indexInPath - 1];
        double d9 = this.path.precise_z_positions[this.indexInPath - 1];
        double d10 = this.path.precise_x_positions[this.indexInPath + 1];
        double d11 = this.path.precise_y_positions[this.indexInPath + 1];
        double d12 = this.path.precise_z_positions[this.indexInPath + 1];
        double d13 = NearPoint.distanceToLineSegment(this.nearX, this.nearY, this.nearZ, d, d8, d9, this.pathPointX, this.pathPointY, this.pathPointZ);
        double d14 = NearPoint.distanceToLineSegment(this.nearX, this.nearY, this.nearZ, this.pathPointX, this.pathPointY, this.pathPointZ, d10, d11, d12);
        double d15 = d13 < 0.0 ? d14 : (d14 < 0.0 ? d13 : Math.min(d13, d14));
        if (d15 >= 0.0) {
            this.cachedDistanceToPathNearPoint = new Double(d15);
            return d15;
        }
        boolean bl2 = 0 < NearPoint.normalSideOfPlane(this.pathPointX, this.pathPointY, this.pathPointZ, this.pathPointX - d, this.pathPointY - d8, this.pathPointZ - d9, this.nearX, this.nearY, this.nearZ);
        boolean bl3 = bl = 0 < NearPoint.normalSideOfPlane(this.pathPointX, this.pathPointY, this.pathPointZ, this.pathPointX - d10, this.pathPointY - d11, this.pathPointZ - d12, this.nearX, this.nearY, this.nearZ);
        if (bl2 && bl) {
            double d16 = this.distanceToPathPoint();
            this.cachedDistanceToPathNearPoint = new Double(d16);
            return d16;
        }
        this.cachedDistanceToPathNearPoint = new Double(-1.0);
        return -1.0;
    }

    public static double distanceToLineSegment(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        boolean bl;
        boolean bl2 = 0 >= NearPoint.normalSideOfPlane(d4, d5, d6, d4 - d7, d5 - d8, d6 - d9, d, d2, d3);
        boolean bl3 = bl = 0 >= NearPoint.normalSideOfPlane(d7, d8, d9, d7 - d4, d8 - d5, d9 - d6, d, d2, d3);
        if (bl2 && bl) {
            return NearPoint.distanceFromPointToLine(d4, d5, d6, d7 - d4, d8 - d5, d9 - d6, d, d2, d3);
        }
        return -1.0;
    }

    public double distanceToPathPoint() {
        return Math.sqrt(this.distanceSquared);
    }

    public double distanceToPathPointSquared() {
        return this.distanceSquared;
    }

    public static int normalSideOfPlane(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d7 - d;
        double d11 = d8 - d2;
        double d12 = d9 - d3;
        double d13 = d4 * d10 + d5 * d11 + d6 * d12;
        if (d13 > 0.0) {
            return 1;
        }
        if (d13 < 0.0) {
            return -1;
        }
        return 0;
    }

    public static double distanceFromPointToLine(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = ((d - d4) * d7 + (d2 - d5) * d8 + (d3 - d6) * d9) / (d7 * d7 + d8 * d8 + d9 * d9);
        double d11 = d4 + d10 * d7;
        double d12 = d5 + d10 * d8;
        double d13 = d6 + d10 * d9;
        double d14 = d11 - d;
        double d15 = d12 - d2;
        double d16 = d13 - d3;
        return Math.sqrt(d14 * d14 + d15 * d15 + d16 * d16);
    }
}

