/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileSaver;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.PriorityQueue;
import landmarks.Bookstein_From_Landmarks;
import tracing.ImagesFromLine;
import tracing.Path;
import tracing.PathAndFillManager;
import tracing.SinglePathsGraph;
import tracing.TraceLoaderListener;
import util.BatchOpener;
import util.FileAndChannel;
import vib.oldregistration.RegistrationAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewAnalyzeTracings_
implements PlugIn,
TraceLoaderListener {
    int[] labelIndices = new int[]{7, 8, 9, 11, 10, 12, 15, 16};
    int width = -1;
    int height = -1;
    int depth = -1;
    float spacing_x = Float.MIN_VALUE;
    float spacing_y = Float.MIN_VALUE;
    float spacing_z = Float.MIN_VALUE;
    String spacing_units = "";
    ArrayList<NewGraphNode> verticesInObjOrder;
    Hashtable<Integer, NewGraphNode> positionToNode;
    int numberOfVertices = -1;
    ArrayList<ArrayList<NewGraphNode>> links;
    byte[][] label_data;
    byte[][] registered_label_data;
    String[] materialNames;
    int[] redValues;
    int[] greenValues;
    int[] blueValues;
    int materials;
    AmiraParameters parameters;
    String standardBrainFileName = "/home/mark/arnim-brain/CantonF41c.grey";
    String standardBrainLabelsFileName = "/home/mark/arnim-brain/CantonF41c.labels";
    public Hashtable<String, Integer> materialNameToIndex;

    ArrayList<NewGraphNode> makePath(NewGraphNode newGraphNode) {
        ArrayList<NewGraphNode> arrayList = new ArrayList<NewGraphNode>();
        NewGraphNode newGraphNode2 = newGraphNode;
        do {
            arrayList.add(newGraphNode2);
        } while (null != (newGraphNode2 = newGraphNode2.previous));
        ArrayList<NewGraphNode> arrayList2 = new ArrayList<NewGraphNode>();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            arrayList2.add((NewGraphNode)arrayList.get(i));
        }
        return arrayList2;
    }

    PathWithLength findPath(NewGraphNode newGraphNode, int n) {
        byte by = this.label_data[newGraphNode.z][newGraphNode.y * this.width + newGraphNode.x];
        Collection<NewGraphNode> collection = this.positionToNode.values();
        for (NewGraphNode object2 : collection) {
            object2.g = 0.0f;
            object2.h = 0.0f;
            object2.previous = null;
        }
        collection = new PriorityQueue<NewGraphNode>();
        PriorityQueue priorityQueue = new PriorityQueue();
        Hashtable<NewGraphNode, NewGraphNode> hashtable = new Hashtable<NewGraphNode, NewGraphNode>();
        Hashtable<NewGraphNode, NewGraphNode> hashtable2 = new Hashtable<NewGraphNode, NewGraphNode>();
        newGraphNode.g = 0.0f;
        newGraphNode.h = 0.0f;
        newGraphNode.previous = null;
        priorityQueue.add(newGraphNode);
        hashtable.put(newGraphNode, newGraphNode);
        while (priorityQueue.size() > 0) {
            Object object;
            NewGraphNode newGraphNode2 = (NewGraphNode)priorityQueue.poll();
            hashtable.remove(newGraphNode2);
            byte by2 = this.label_data[newGraphNode2.z][newGraphNode2.y * this.width + newGraphNode2.x];
            if (by2 == n) {
                ArrayList<NewGraphNode> arrayList = this.makePath(newGraphNode2);
                if (arrayList == null) {
                    return null;
                }
                object = new PathWithLength();
                ((PathWithLength)object).path = arrayList;
                ((PathWithLength)object).length = newGraphNode2.g;
                return object;
            }
            ((PriorityQueue)collection).add(newGraphNode2);
            hashtable2.put(newGraphNode2, newGraphNode2);
            for (int arrayList = 0; arrayList < newGraphNode2.linkedTo.length; ++arrayList) {
                byte by3;
                object = newGraphNode2.linkedTo[arrayList];
                float f = newGraphNode2.distanceTo((NewGraphNode)object);
                if (((NewGraphNode)object).z == 118 || ((NewGraphNode)object).y * this.width + ((NewGraphNode)object).x == 118) {
                    System.out.println("neighbour is: (" + ((NewGraphNode)object).x + "," + ((NewGraphNode)object).y + "," + ((NewGraphNode)object).z + " and width " + this.width + " height " + this.height + " depth " + this.depth);
                }
                if ((by3 = this.label_data[((NewGraphNode)object).z][((NewGraphNode)object).y * this.width + ((NewGraphNode)object).x]) != 0 && by3 != n) continue;
                NewGraphNode newGraphNode3 = new NewGraphNode();
                newGraphNode3.setFrom((NewGraphNode)object);
                newGraphNode3.g = newGraphNode2.g + f;
                newGraphNode3.h = 0.0f;
                newGraphNode3.previous = newGraphNode2;
                NewGraphNode newGraphNode4 = (NewGraphNode)hashtable2.get(object);
                NewGraphNode newGraphNode5 = (NewGraphNode)hashtable.get(object);
                if (newGraphNode4 != null && newGraphNode4.f() <= newGraphNode3.f() || newGraphNode5 != null && newGraphNode5.f() <= newGraphNode3.f()) continue;
                if (newGraphNode4 != null) {
                    ((PriorityQueue)collection).remove(newGraphNode4);
                    hashtable2.remove(newGraphNode4);
                    newGraphNode4.setFrom(newGraphNode3);
                    priorityQueue.add(newGraphNode4);
                    hashtable.put(newGraphNode4, newGraphNode4);
                    continue;
                }
                if (newGraphNode5 != null) {
                    priorityQueue.remove(newGraphNode5);
                    hashtable.remove(newGraphNode5);
                    newGraphNode5.setFrom(newGraphNode3);
                    priorityQueue.add(newGraphNode5);
                    hashtable.put(newGraphNode5, newGraphNode5);
                    continue;
                }
                priorityQueue.add(newGraphNode3);
                hashtable.put(newGraphNode3, newGraphNode3);
            }
        }
        return null;
    }

    public int positionToKey(int n, int n2, int n3) {
        return n + n2 * this.width + n3 * this.width * this.height;
    }

    @Override
    public void gotVertex(int n, float f, float f2, float f3, int n2, int n3, int n4) {
        if (this.width < 0 || this.height < 0 || this.depth < 0 || this.spacing_x == Float.MIN_VALUE || this.spacing_y == Float.MIN_VALUE || this.spacing_z == Float.MIN_VALUE) {
            throw new RuntimeException("Some metadata was missing from the comments before the first vertex.");
        }
        if (n4 >= this.depth) {
            System.out.println("z is too deep:");
            System.out.println("x_scaled: " + f);
            System.out.println("y_scaled: " + f2);
            System.out.println("z_scaled: " + f3);
            System.out.println("x_image: " + n2);
            System.out.println("y_image: " + n3);
            System.out.println("z_image: " + n4);
            System.out.println("spacing_x: " + this.spacing_x);
            System.out.println("spacing_y: " + this.spacing_y);
            System.out.println("spacing_z: " + this.spacing_z);
        }
        this.verticesInObjOrder.add(new NewGraphNode(n2, n3, n4));
    }

    @Override
    public void gotLine(int n, int n2) {
        if (this.links == null) {
            this.numberOfVertices = this.verticesInObjOrder.size() - 1;
            this.links = new ArrayList(this.numberOfVertices);
            for (int i = 0; i <= this.numberOfVertices; ++i) {
                this.links.add(new ArrayList());
            }
        }
        ArrayList<NewGraphNode> arrayList = this.links.get(n);
        ArrayList<NewGraphNode> arrayList2 = this.links.get(n2);
        NewGraphNode newGraphNode = this.verticesInObjOrder.get(n2);
        NewGraphNode newGraphNode2 = this.verticesInObjOrder.get(n);
        if (!arrayList.contains(newGraphNode)) {
            arrayList.add(newGraphNode);
        }
        if (!arrayList2.contains(newGraphNode2)) {
            arrayList2.add(newGraphNode2);
        }
    }

    @Override
    public void gotWidth(int n) {
        this.width = n;
    }

    @Override
    public void gotHeight(int n) {
        this.height = n;
    }

    @Override
    public void gotDepth(int n) {
        this.depth = n;
    }

    @Override
    public void gotSpacingX(float f) {
        this.spacing_x = f;
    }

    @Override
    public void gotSpacingY(float f) {
        this.spacing_y = f;
    }

    @Override
    public void gotSpacingZ(float f) {
        this.spacing_z = f;
    }

    public void gotSpacingUnits(String string) {
        this.spacing_units = string;
    }

    public byte[][] loadRegisteredLabels(String string) {
        Object object;
        int n;
        String string2 = string + ".lsm";
        ImagePlus imagePlus = BatchOpener.openFirstChannel(this.standardBrainLabelsFileName);
        ImageStack imageStack = imagePlus.getStack();
        int n2 = imageStack.getWidth();
        int n3 = imageStack.getHeight();
        int n4 = imageStack.getSize();
        byte[][] byArrayArray = new byte[n4][];
        for (n = 0; n < n4; ++n) {
            byArrayArray[n] = (byte[])imageStack.getPixels(n + 1);
        }
        this.parameters = new AmiraParameters(imagePlus);
        this.materials = this.parameters.getMaterialCount();
        this.materialNames = new String[256];
        this.materialNameToIndex = new Hashtable();
        for (n = 0; n < this.materials; ++n) {
            this.materialNames[n] = this.parameters.getMaterialName(n);
            this.materialNameToIndex.put(this.materialNames[n], new Integer(n));
            System.out.println("Material: " + n + " is " + this.materialNames[n]);
        }
        this.redValues = new int[this.materials];
        this.greenValues = new int[this.materials];
        this.blueValues = new int[this.materials];
        for (n = 0; n < this.materials; ++n) {
            object = this.parameters.getMaterialColor(n);
            this.redValues[n] = (int)(255.0 * object[0]);
            this.greenValues[n] = (int)(255.0 * object[1]);
            this.blueValues[n] = (int)(255.0 * object[2]);
        }
        Object object2 = null;
        object = string + ".registered.labels";
        File file = new File((String)object);
        if (file.exists()) {
            ImagePlus imagePlus2 = BatchOpener.openFirstChannel((String)object);
            ImageStack imageStack2 = imagePlus2.getStack();
            object2 = new byte[imagePlus2.getStackSize()][];
            for (int i = 0; i < imagePlus2.getStackSize(); ++i) {
                object2[i] = (byte[])imageStack2.getPixels(i + 1);
            }
            imagePlus.close();
        } else {
            int n5;
            FileAndChannel fileAndChannel = new FileAndChannel(string2, 0);
            FileAndChannel fileAndChannel2 = new FileAndChannel(this.standardBrainFileName, 0);
            Bookstein_From_Landmarks bookstein_From_Landmarks = new Bookstein_From_Landmarks();
            bookstein_From_Landmarks.loadImages(fileAndChannel2, fileAndChannel);
            bookstein_From_Landmarks.generateTransformation();
            object2 = new byte[this.depth][this.width * this.height];
            RegistrationAlgorithm.ImagePoint imagePoint = new RegistrationAlgorithm.ImagePoint();
            for (int i = 0; i < this.depth; ++i) {
                System.out.println("doing slice: " + i);
                for (n5 = 0; n5 < this.height; ++n5) {
                    for (int j = 0; j < this.width; ++j) {
                        bookstein_From_Landmarks.transformDomainToTemplate(j, n5, i, imagePoint);
                        int n6 = imagePoint.x;
                        int n7 = imagePoint.y;
                        int n8 = imagePoint.z;
                        int n9 = 0;
                        if (n8 >= 0 && n8 < n4 && n7 >= 0 && n7 < n3 && n6 >= 0 && n6 < n2) {
                            n9 = byArrayArray[n8][n7 * n2 + n6] & 0xFF;
                        }
                        object2[i][n5 * this.width + j] = (byte)n9;
                        if (n9 < this.materials) continue;
                        throw new RuntimeException("A label value of " + n9 + " was found, which is not a valid material (max " + (this.materials - 1) + ")");
                    }
                }
            }
            ImageStack imageStack3 = new ImageStack(this.width, this.height);
            for (n5 = 0; n5 < this.depth; ++n5) {
                ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height);
                byteProcessor.setPixels((Object)object2[n5]);
                imageStack3.addSlice("", (ImageProcessor)byteProcessor);
            }
            ImagePlus imagePlus3 = new ImagePlus("transformed labels", imageStack3);
            imagePlus3.getProcessor().setColorModel(imagePlus.getProcessor().getColorModel());
            boolean bl = new FileSaver(imagePlus3).saveAsTiffStack((String)object);
            if (!bl) {
                throw new RuntimeException("Failed to save registered labels to: " + (String)object);
            }
        }
        imagePlus.close();
        return object2;
    }

    public ArrayList<PathWithLength> buildGraph(File file, File file2, File file3, File file4) {
        Comparable comparable;
        int n;
        int n2;
        Object object2;
        int n4;
        boolean bl = true;
        String string = file.getAbsolutePath();
        String string2 = file2.getAbsolutePath();
        this.verticesInObjOrder = new ArrayList();
        this.verticesInObjOrder.add(new NewGraphNode());
        System.out.println("Loading traces file: " + string);
        boolean bl2 = SinglePathsGraph.loadWithListener(string, this);
        if (!bl2) {
            throw new RuntimeException("Failed to load traces");
        }
        System.out.println("Finished loading: " + (this.verticesInObjOrder.size() - 1) + " vertices found");
        System.out.println("  traces width:" + this.width);
        System.out.println("  traces height:" + this.height);
        System.out.println("  traces depth:" + this.depth);
        long l = 0L;
        for (n4 = 1; n4 < this.verticesInObjOrder.size(); ++n4) {
            object2 = this.verticesInObjOrder.get(n4);
            ArrayList<NewGraphNode> object3 = this.links.get(n4);
            n2 = object3.size();
            l += (long)n2;
            NewGraphNode[] pathAndFillManager = new NewGraphNode[n2];
            ((NewGraphNode)object2).linkedTo = object3.toArray(pathAndFillManager);
        }
        this.links = null;
        System.out.println("And set the links in the NewGraphNodes: " + l);
        this.positionToNode = new Hashtable();
        n4 = 1;
        for (NewGraphNode newGraphNode : this.verticesInObjOrder) {
            if (n4 != 0) {
                n4 = 0;
                continue;
            }
            n2 = this.positionToKey(newGraphNode.x, newGraphNode.y, newGraphNode.z);
            this.positionToNode.put(n2, newGraphNode);
        }
        this.verticesInObjOrder = null;
        System.out.println("Added vertices to the hash, now has: " + this.positionToNode.size() + " entries");
        object2 = BatchOpener.openFirstChannel(string2);
        if (object2 == null) {
            throw new RuntimeException("Couldn't open labels file " + string2);
        }
        ImageStack imageStack = object2.getStack();
        System.out.println("label file width:" + object2.getWidth());
        System.out.println("label file height:" + object2.getHeight());
        System.out.println("label file depth:" + object2.getStackSize());
        this.label_data = new byte[this.depth][];
        for (n2 = 0; n2 < this.depth; ++n2) {
            this.label_data[n2] = (byte[])imageStack.getPixels(n2 + 1);
        }
        if (bl) {
            String string3 = string2.substring(0, string2.lastIndexOf("."));
            this.registered_label_data = this.loadRegisteredLabels(string3);
            for (int i = 0; i < this.depth; ++i) {
                for (int n5 = 0; n5 < this.height; ++n5) {
                    for (int i2 = 0; i2 < this.width; ++i2) {
                        byte hashSet;
                        if (this.label_data[i][n5 * this.width + i2] != 0 || (hashSet = this.registered_label_data[i][n5 * this.width + i2]) != 7 && hashSet != 8 && hashSet != 15 && hashSet != 16) continue;
                        this.label_data[i][n5 * this.width + i2] = this.registered_label_data[i][n5 * this.width + i2];
                    }
                }
            }
        } else {
            this.parameters = new AmiraParameters((ImagePlus)object2);
            this.materials = this.parameters.getMaterialCount();
            this.materialNames = new String[256];
            this.materialNameToIndex = new Hashtable();
            for (n2 = 0; n2 < this.materials; ++n2) {
                this.materialNames[n2] = this.parameters.getMaterialName(n2);
                this.materialNameToIndex.put(this.materialNames[n2], new Integer(n2));
                System.out.println("Material: " + n2 + " is " + this.materialNames[n2]);
            }
            this.redValues = new int[this.materials];
            this.greenValues = new int[this.materials];
            this.blueValues = new int[this.materials];
        }
        ArrayList arrayList = new ArrayList();
        for (n = 0; n < this.materials; ++n) {
            arrayList.add(new ArrayList());
            double[] dArray = this.parameters.getMaterialColor(n);
            this.redValues[n] = (int)(255.0 * dArray[0]);
            this.greenValues[n] = (int)(255.0 * dArray[1]);
            this.blueValues[n] = (int)(255.0 * dArray[2]);
        }
        for (n = 0; n < this.labelIndices.length; ++n) {
            int n3 = this.labelIndices[n];
            String bufferedWriter = this.materialNames[n3];
            System.out.println("   Dealing with label index " + n3 + ", name: " + bufferedWriter);
            ArrayList arrayList2 = (ArrayList)arrayList.get(n3);
            for (int object6 = 0; object6 < this.depth; ++object6) {
                for (int pathWithLength = 0; pathWithLength < this.height; ++pathWithLength) {
                    block15: for (pathWithLength = 0; pathWithLength < this.width; ++pathWithLength) {
                        int n5;
                        Object object;
                        if (this.label_data[object6][pathWithLength * this.width + pathWithLength] != n3 || (object = this.positionToNode.get(n5 = this.positionToKey(pathWithLength, pathWithLength, object6))) == null) continue;
                        Object object3 = ((NewGraphNode)object).linkedTo;
                        for (int i = 0; i < ((NewGraphNode[])object3).length; ++i) {
                            comparable = object3[i];
                            if (this.label_data[((NewGraphNode)comparable).z][((NewGraphNode)comparable).y * this.width + ((NewGraphNode)comparable).x] != 0) continue;
                            arrayList2.add(comparable);
                            continue block15;
                        }
                    }
                }
            }
            System.out.println("   Found " + arrayList2.size() + " points on the edge of the " + bufferedWriter);
        }
        PathAndFillManager pathAndFillManager = new PathAndFillManager(this.width, this.height, this.depth, this.spacing_x, this.spacing_y, this.spacing_z, null);
        ArrayList<PathWithLength> arrayList3 = new ArrayList<PathWithLength>();
        for (int iOException = 0; iOException < this.labelIndices.length; ++iOException) {
            int n6 = this.labelIndices[iOException];
            String string4 = this.materialNames[n6];
            System.out.println("Starting searches from " + n6 + ", name: " + string4);
            ArrayList arrayList4 = (ArrayList)arrayList.get(n6);
            for (int pathWithLength = n6 + 1; pathWithLength < this.materials; ++pathWithLength) {
                ArrayList arrayList5 = (ArrayList)arrayList.get(pathWithLength);
                if (arrayList5.size() == 0) continue;
                for (Object object3 : arrayList4) {
                    System.out.println("  Starting from point " + object3 + " (" + string4 + " looking for material: " + this.materialNames[pathWithLength]);
                    PathWithLength pathWithLength2 = this.findPath((NewGraphNode)object3, pathWithLength);
                    if (pathWithLength2 == null) continue;
                    pathWithLength2.startNeuropilRegion = n6;
                    pathWithLength2.endNeuropilRegion = pathWithLength;
                    arrayList3.add(pathWithLength2);
                    comparable = pathWithLength2.toPath();
                    ((Path)comparable).setName(this.materialNames[n6] + " to " + this.materialNames[pathWithLength]);
                    pathAndFillManager.addPath((Path)comparable);
                    System.out.println("  Found a route!");
                }
            }
        }
        if (file3 != null) {
            try {
                pathAndFillManager.writeXML(file3.getAbsolutePath(), true);
            }
            catch (IOException iOException) {
                System.out.println("Writing to: " + file3 + " failed");
            }
        }
        if (file4 != null) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file4.getAbsolutePath(), false));
                bufferedWriter.write("graph G {\n");
                bufferedWriter.write("        graph [overlap=scale,splines=true];\n");
                bufferedWriter.write("        node [fontname=\"DejaVuSans\",style=filled];\n");
                HashSet<Integer> hashSet = new HashSet<Integer>();
                for (PathWithLength pathWithLength : arrayList3) {
                    hashSet.add(pathWithLength.startNeuropilRegion);
                    hashSet.add(pathWithLength.endNeuropilRegion);
                }
                Object object = hashSet.iterator();
                while (object.hasNext()) {
                    int n7 = (Integer)((Object)object.next());
                    String string5 = this.materialNames[n7];
                    bufferedWriter.write("        \"" + string5 + "\" [fillcolor=\"" + this.colorString(string5) + "\"];\n");
                }
                object = new HashSet();
                for (PathWithLength pathWithLength : arrayList3) {
                    String string6 = "        \"" + this.materialNames[pathWithLength.startNeuropilRegion] + "\" -- \"" + this.materialNames[pathWithLength.endNeuropilRegion] + "\";\n";
                    if (((HashSet)object).contains(string6)) continue;
                    bufferedWriter.write(string6);
                    ((HashSet)object).add(string6);
                }
                bufferedWriter.write("}");
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                IJ.error((String)"Exception while writing the file");
            }
        }
        return arrayList3;
    }

    public void run(String string) {
        String string2 = "/media/WD Passport/corpus/central-complex/";
        ArrayList<ImagesFromLine> arrayList = new ArrayList<ImagesFromLine>();
        ImagesFromLine imagesFromLine = new ImagesFromLine();
        imagesFromLine.lineName = "c005";
        imagesFromLine.baseNames.add("c005BA");
        imagesFromLine.baseNames.add("c005BB");
        imagesFromLine.baseNames.add("c005BC");
        imagesFromLine.baseNames.add("c005BE");
        imagesFromLine.baseNames.add("c005BF");
        imagesFromLine.baseNames.add("c5xUAS-CD8GFP-40x-central-complex-BF");
        imagesFromLine.baseNames.add("c5xUAS-lacZ-40x-cc-BB");
        imagesFromLine.baseNames.add("c5xUAS-lacZ-40x-cc-BC");
        arrayList.add(imagesFromLine);
        ImagesFromLine imagesFromLine2 = new ImagesFromLine();
        imagesFromLine2.lineName = "210y";
        imagesFromLine2.baseNames.add("210y-40x-central-complex-CA");
        imagesFromLine2.baseNames.add("210y-40x-central-complex-CB");
        imagesFromLine2.baseNames.add("210y-40x-central-complex-CD");
        imagesFromLine2.baseNames.add("210y-40x-central-complex-CE");
        imagesFromLine2.baseNames.add("210yAC");
        imagesFromLine2.baseNames.add("210yAD");
        imagesFromLine2.baseNames.add("210yAE");
        imagesFromLine2.baseNames.add("210yAO");
        imagesFromLine2.baseNames.add("210yAP");
        arrayList.add(imagesFromLine2);
        ImagesFromLine imagesFromLine3 = new ImagesFromLine();
        imagesFromLine3.lineName = "71y";
        imagesFromLine3.baseNames.add("71yAAeastmost");
        imagesFromLine3.baseNames.add("71yABwestmost");
        imagesFromLine3.baseNames.add("71yAF");
        imagesFromLine3.baseNames.add("71yAM");
        imagesFromLine3.baseNames.add("71yAN");
        imagesFromLine3.baseNames.add("71yAQ");
        imagesFromLine3.baseNames.add("71yAR");
        arrayList.add(imagesFromLine3);
        ImagesFromLine imagesFromLine4 = new ImagesFromLine();
        imagesFromLine4.lineName = "c61";
        imagesFromLine4.baseNames.add("c061AG");
        imagesFromLine4.baseNames.add("c061AH");
        imagesFromLine4.baseNames.add("c061AI()");
        imagesFromLine4.baseNames.add("c061AK");
        imagesFromLine4.baseNames.add("c061AL");
        imagesFromLine4.baseNames.add("c061AU");
        arrayList.add(imagesFromLine4);
        for (ImagesFromLine imagesFromLine5 : arrayList) {
            System.out.println("Looking at line: " + imagesFromLine5.lineName);
            for (String string3 : imagesFromLine5.baseNames) {
                System.out.println("  Image basename: " + string3);
                File file = new File(string2, string3 + ".lsm");
                File file2 = new File(string2, string3 + ".traces.obj");
                if (!file.exists()) continue;
                File file3 = new File(string2, string3 + ".labels");
                if (!file.exists()) continue;
                System.out.println("!!!");
                ArrayList<PathWithLength> arrayList2 = this.buildGraph(file2, file3, new File(string2, string3 + ".neuropil-connections.traces"), new File(string2, string3 + ".dot"));
            }
        }
    }

    public String colorString(String string) {
        String string2;
        String string3;
        String string4;
        if (string.equals("Exterior")) {
            return "#DDDDDD";
        }
        Integer n = this.materialNameToIndex.get(string);
        int n2 = n;
        double d = 1.4;
        int n3 = (int)((double)this.redValues[n2] * d);
        int n4 = (int)((double)this.greenValues[n2] * d);
        int n5 = (int)((double)this.blueValues[n2] * d);
        if (n3 > 255) {
            n3 = 255;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        if (n5 > 255) {
            n5 = 255;
        }
        if ((string4 = Integer.toHexString(n3)).length() <= 1) {
            string4 = "0" + string4;
        }
        if ((string3 = Integer.toHexString(n4)).length() <= 1) {
            string3 = "0" + string3;
        }
        if ((string2 = Integer.toHexString(n5)).length() <= 1) {
            string2 = "0" + string2;
        }
        return "#" + string4 + string3 + string2;
    }

    class PathWithLength {
        int startNeuropilRegion;
        int endNeuropilRegion;
        public double length;
        public ArrayList<NewGraphNode> path;

        PathWithLength() {
        }

        public Path toPath() {
            Path path = new Path(NewAnalyzeTracings_.this.spacing_x, NewAnalyzeTracings_.this.spacing_y, NewAnalyzeTracings_.this.spacing_z, "", this.path.size());
            for (int i = 0; i < this.path.size(); ++i) {
                NewGraphNode newGraphNode = this.path.get(i);
                path.addPointDouble((float)newGraphNode.x * NewAnalyzeTracings_.this.spacing_x, (float)newGraphNode.y * NewAnalyzeTracings_.this.spacing_y, (float)newGraphNode.z * NewAnalyzeTracings_.this.spacing_z);
            }
            return path;
        }
    }

    class NewGraphNode
    implements Comparable {
        int x = -1;
        int y = -1;
        int z = -1;
        NewGraphNode[] linkedTo = null;
        float g = Float.MIN_VALUE;
        float h = Float.MIN_VALUE;
        NewGraphNode previous = null;

        public NewGraphNode() {
        }

        public NewGraphNode(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.z = n3;
        }

        public boolean equals(Object object) {
            NewGraphNode newGraphNode = (NewGraphNode)object;
            return this.x == newGraphNode.x && this.y == newGraphNode.y && this.z == newGraphNode.z;
        }

        public int hashCode() {
            return this.x + this.y * 2048 + this.z * 0x400000;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + "," + this.z + ")";
        }

        public float distanceTo(NewGraphNode newGraphNode) {
            float f = (float)(this.x - newGraphNode.x) * NewAnalyzeTracings_.this.spacing_x;
            float f2 = (float)(this.y - newGraphNode.y) * NewAnalyzeTracings_.this.spacing_y;
            float f3 = (float)(this.z - newGraphNode.z) * NewAnalyzeTracings_.this.spacing_y;
            float f4 = f * f + f2 * f2 + f3 * f3;
            return (float)Math.sqrt(f4);
        }

        public void setFrom(NewGraphNode newGraphNode) {
            this.x = newGraphNode.x;
            this.y = newGraphNode.y;
            this.z = newGraphNode.z;
            this.linkedTo = newGraphNode.linkedTo;
        }

        double f() {
            return this.g + this.h;
        }

        public int compareTo(Object object) {
            NewGraphNode newGraphNode = (NewGraphNode)object;
            return Double.compare(this.f(), newGraphNode.f());
        }
    }
}

