/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.StackWindow;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij3d.Content;
import ij3d.Image3DUniverse;
import ij3d.Pipe;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.Color3f;
import pal.math.ConjugateDirectionSearch;
import pal.math.MultivariateFunction;
import tracing.NormalPlaneCanvas;
import tracing.PathTransformer;
import tracing.PointInImage;
import tracing.Simple_Neurite_Tracer;
import tracing.TracerCanvas;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path
implements Comparable {
    private int id = -1;
    static final boolean verbose = false;
    boolean selected;
    Path startJoins;
    PointInImage startJoinsPoint = null;
    Path endJoins;
    PointInImage endJoinsPoint = null;
    public static final int PATH_START = 0;
    public static final int PATH_END = 1;
    String name;
    ArrayList<Path> somehowJoins;
    ArrayList<Path> children;
    boolean primary = false;
    double x_spacing;
    double y_spacing;
    double z_spacing;
    String spacing_units;
    public int points;
    public int maxPoints;
    Path fitted;
    boolean useFitted = false;
    Path fittedVersionOf;
    double[] radiuses;
    double[] tangents_x;
    double[] tangents_y;
    double[] tangents_z;
    double[] precise_x_positions;
    double[] precise_y_positions;
    double[] precise_z_positions;
    static final int SWC_UNDEFINED = 0;
    static final int SWC_SOMA = 1;
    static final int SWC_AXON = 2;
    static final int SWC_DENDRITE = 3;
    static final int SWC_APICAL_DENDRITE = 4;
    static final int SWC_FORK_POINT = 5;
    static final int SWC_END_POINT = 6;
    static final int SWC_CUSTOM = 7;
    static final String[] swcTypeNames = new String[]{"undefined", "soma", "axon", "dendrite", "apical dendrite", "fork point", "end point", "custom"};
    int swcType = 0;
    Content content3D;
    String nameWhenAddedToViewer;
    public static final int noMoreThanOneEvery = 2;

    public int compareTo(Object object) {
        Path path = (Path)object;
        if (this.id == path.id) {
            return 0;
        }
        if (this.id < path.id) {
            return -1;
        }
        return 1;
    }

    public int getID() {
        return this.id;
    }

    void setID(int n) {
        this.id = n;
    }

    public Path getStartJoins() {
        return this.startJoins;
    }

    public PointInImage getStartJoinsPoint() {
        return this.startJoinsPoint;
    }

    public Path getEndJoins() {
        return this.endJoins;
    }

    public PointInImage getEndJoinsPoint() {
        return this.endJoinsPoint;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDefaultName() {
        this.name = "Path " + this.id;
    }

    public String getName() {
        if (this.name == null) {
            throw new RuntimeException("In Path.getName() for id " + this.id + ", name was null");
        }
        return this.name;
    }

    private String pathsToIDListString(ArrayList<Path> arrayList) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(arrayList.get(i).getID());
            if (i >= n - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public String somehowJoinsAsString() {
        return this.pathsToIDListString(this.somehowJoins);
    }

    public String childrenAsString() {
        return this.pathsToIDListString(this.children);
    }

    public void setChildren(Set<Path> set) {
        this.children.clear();
        for (Path path : this.somehowJoins) {
            if (!set.contains(path)) continue;
            this.children.add(path);
            set.remove(path);
        }
        for (Path path : this.children) {
            path.setChildren(set);
        }
    }

    public double getRealLength() {
        double d = 0.0;
        for (int i = 1; i < this.points; ++i) {
            double d2 = this.precise_x_positions[i] - this.precise_x_positions[i - 1];
            double d3 = this.precise_y_positions[i] - this.precise_y_positions[i - 1];
            double d4 = this.precise_z_positions[i] - this.precise_z_positions[i - 1];
            d += Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
        }
        return d;
    }

    public String getRealLengthString() {
        return String.format("%.4f", this.getRealLength());
    }

    public void createCircles() {
        if (this.tangents_x != null || this.tangents_y != null || this.tangents_z != null || this.radiuses != null) {
            throw new RuntimeException("BUG: Trying to create circles data arrays when at least one is already there");
        }
        this.tangents_x = new double[this.maxPoints];
        this.tangents_y = new double[this.maxPoints];
        this.tangents_z = new double[this.maxPoints];
        this.radiuses = new double[this.maxPoints];
    }

    void setPrimary(boolean bl) {
        this.primary = bl;
    }

    boolean getPrimary() {
        return this.primary;
    }

    void disconnectFromAll() {
        for (Path path : this.somehowJoins) {
            int n;
            if (path.startJoins != null && path.startJoins == this) {
                path.startJoins = null;
                path.startJoinsPoint = null;
            }
            if (path.endJoins != null && path.endJoins == this) {
                path.endJoins = null;
                path.endJoinsPoint = null;
            }
            if ((n = path.somehowJoins.indexOf(this)) < 0) continue;
            path.somehowJoins.remove(n);
        }
        this.somehowJoins.clear();
        this.startJoins = null;
        this.startJoinsPoint = null;
        this.endJoins = null;
        this.endJoinsPoint = null;
    }

    public void setStartJoin(Path path, PointInImage pointInImage) {
        this.setJoin(0, path, pointInImage);
    }

    public void setEndJoin(Path path, PointInImage pointInImage) {
        this.setJoin(1, path, pointInImage);
    }

    void setJoin(int n, Path path, PointInImage pointInImage) {
        if (path == null) {
            throw new RuntimeException("BUG: setJoin now should never take a null other path");
        }
        if (n == 0) {
            if (this.startJoins != null) {
                throw new RuntimeException("BUG: setJoin for START should not replace another join");
            }
            this.startJoins = path;
            this.startJoinsPoint = pointInImage;
        } else if (n == 1) {
            if (this.endJoins != null) {
                throw new RuntimeException("BUG: setJoin for END should not replace another join");
            }
            this.endJoins = path;
            this.endJoinsPoint = pointInImage;
        } else {
            IJ.error((String)"BUG: unknown first parameter to setJoin");
        }
        if (this.somehowJoins.indexOf(path) < 0) {
            this.somehowJoins.add(path);
        }
        if (path.somehowJoins.indexOf(this) < 0) {
            path.somehowJoins.add(this);
        }
    }

    public void unsetStartJoin() {
        this.unsetJoin(0);
    }

    public void unsetEndJoin() {
        this.unsetJoin(1);
    }

    void unsetJoin(int n) {
        Path path;
        Path path2;
        if (n == 0) {
            path2 = this.startJoins;
            path = this.endJoins;
        } else {
            path2 = this.endJoins;
            path = this.startJoins;
        }
        if (path2 == null) {
            throw new RuntimeException("Don't call unsetJoin if the other Path is already null");
        }
        if (path2.startJoins != this && path2.endJoins != this && path != path2) {
            this.somehowJoins.remove(path2);
            path2.somehowJoins.remove(this);
        }
        if (n == 0) {
            this.startJoins = null;
            this.startJoinsPoint = null;
        } else {
            this.endJoins = null;
            this.endJoinsPoint = null;
        }
    }

    Path(double d, double d2, double d3, String string) {
        this.x_spacing = d;
        this.y_spacing = d2;
        this.z_spacing = d3;
        this.spacing_units = string;
        this.points = 0;
        this.maxPoints = 128;
        this.precise_x_positions = new double[this.maxPoints];
        this.precise_y_positions = new double[this.maxPoints];
        this.precise_z_positions = new double[this.maxPoints];
        this.somehowJoins = new ArrayList();
        this.children = new ArrayList();
    }

    Path(double d, double d2, double d3, String string, int n) {
        this.x_spacing = d;
        this.y_spacing = d2;
        this.z_spacing = d3;
        this.spacing_units = string;
        this.points = 0;
        this.maxPoints = n;
        this.precise_x_positions = new double[this.maxPoints];
        this.precise_y_positions = new double[this.maxPoints];
        this.precise_z_positions = new double[this.maxPoints];
        this.somehowJoins = new ArrayList();
        this.children = new ArrayList();
    }

    public int size() {
        return this.points;
    }

    public void getPointDouble(int n, double[] dArray) {
        if (n < 0 || n >= this.size()) {
            throw new RuntimeException("BUG: getPointDouble was asked for an out-of-range point: " + n);
        }
        dArray[0] = this.precise_x_positions[n];
        dArray[1] = this.precise_y_positions[n];
        dArray[2] = this.precise_z_positions[n];
    }

    public PointInImage getPointInImage(int n) {
        if (n < 0 || n >= this.size()) {
            throw new RuntimeException("BUG: getPointInImage was asked for an out-of-range point: " + n);
        }
        PointInImage pointInImage = new PointInImage(this.precise_x_positions[n], this.precise_y_positions[n], this.precise_z_positions[n]);
        pointInImage.onPath = this;
        return pointInImage;
    }

    public int getXUnscaled(int n) {
        if (n < 0 || n >= this.size()) {
            throw new RuntimeException("BUG: getXUnscaled was asked for an out-of-range point: " + n);
        }
        return (int)Math.round(this.precise_x_positions[n] / this.x_spacing);
    }

    public int getYUnscaled(int n) {
        if (n < 0 || n >= this.size()) {
            throw new RuntimeException("BUG: getYUnscaled was asked for an out-of-range point: " + n);
        }
        return (int)Math.round(this.precise_y_positions[n] / this.y_spacing);
    }

    public int getZUnscaled(int n) {
        if (n < 0 || n >= this.size()) {
            throw new RuntimeException("BUG: getZUnscaled was asked for an out-of-range point: " + n);
        }
        return (int)Math.round(this.precise_z_positions[n] / this.z_spacing);
    }

    public double getXUnscaledDouble(int n) {
        if (n < 0 || n >= this.size()) {
            throw new RuntimeException("BUG: getXUnscaled was asked for an out-of-range point: " + n);
        }
        return this.precise_x_positions[n] / this.x_spacing;
    }

    public double getYUnscaledDouble(int n) {
        if (n < 0 || n >= this.size()) {
            throw new RuntimeException("BUG: getYUnscaled was asked for an out-of-range point: " + n);
        }
        return this.precise_y_positions[n] / this.y_spacing;
    }

    public double getZUnscaledDouble(int n) {
        if (n < 0 || n >= this.size()) {
            throw new RuntimeException("BUG: getZUnscaled was asked for an out-of-range point: " + n);
        }
        return this.precise_z_positions[n] / this.z_spacing;
    }

    public double[][] getXYZUnscaled() {
        double[][] dArray = new double[3][this.size()];
        for (int i = dArray[0].length - 1; i > -1; --i) {
            dArray[0][i] = this.precise_x_positions[i] / this.x_spacing;
            dArray[1][i] = this.precise_y_positions[i] / this.y_spacing;
            dArray[2][i] = this.precise_z_positions[i] / this.z_spacing;
        }
        return dArray;
    }

    PointInImage lastPoint() {
        if (this.points < 1) {
            return null;
        }
        return new PointInImage(this.precise_x_positions[this.points - 1], this.precise_y_positions[this.points - 1], this.precise_z_positions[this.points - 1]);
    }

    void expandTo(int n) {
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        System.arraycopy(this.precise_x_positions, 0, dArray, 0, this.points);
        System.arraycopy(this.precise_y_positions, 0, dArray2, 0, this.points);
        System.arraycopy(this.precise_z_positions, 0, dArray3, 0, this.points);
        this.precise_x_positions = dArray;
        this.precise_y_positions = dArray2;
        this.precise_z_positions = dArray3;
        if (this.hasCircles()) {
            double[] dArray4 = new double[n];
            double[] dArray5 = new double[n];
            double[] dArray6 = new double[n];
            double[] dArray7 = new double[n];
            System.arraycopy(this.tangents_x, 0, dArray4, 0, this.points);
            System.arraycopy(this.tangents_y, 0, dArray5, 0, this.points);
            System.arraycopy(this.tangents_z, 0, dArray6, 0, this.points);
            System.arraycopy(this.radiuses, 0, dArray7, 0, this.points);
            this.tangents_x = dArray4;
            this.tangents_y = dArray5;
            this.tangents_z = dArray6;
            this.radiuses = dArray7;
        }
        this.maxPoints = n;
    }

    void add(Path path) {
        if (path == null) {
            IJ.log((String)"BUG: Trying to add null Path");
            return;
        }
        if (this.maxPoints < this.points + path.points) {
            this.expandTo(this.points + path.points);
        }
        int n = 0;
        if (this.points > 0) {
            double d = this.precise_x_positions[this.points - 1];
            double d2 = this.precise_y_positions[this.points - 1];
            double d3 = this.precise_z_positions[this.points - 1];
            while (path.precise_x_positions[n] == d && path.precise_y_positions[n] == d2 && path.precise_z_positions[n] == d3) {
                ++n;
            }
        }
        System.arraycopy(path.precise_x_positions, n, this.precise_x_positions, this.points, path.points - n);
        System.arraycopy(path.precise_y_positions, n, this.precise_y_positions, this.points, path.points - n);
        System.arraycopy(path.precise_z_positions, n, this.precise_z_positions, this.points, path.points - n);
        if (this.endJoins != null) {
            throw new RuntimeException("BUG: we should never be adding to a path that already endJoins");
        }
        if (path.endJoins != null) {
            this.setEndJoin(path.endJoins, path.endJoinsPoint);
            path.disconnectFromAll();
        }
        this.points += path.points - n;
    }

    void unsetPrimaryForConnected(HashSet<Path> hashSet) {
        for (Path path : this.somehowJoins) {
            if (hashSet.contains(path)) continue;
            path.setPrimary(false);
            hashSet.add(path);
            path.unsetPrimaryForConnected(hashSet);
        }
    }

    Path reversed() {
        Path path = new Path(this.x_spacing, this.y_spacing, this.z_spacing, this.spacing_units, this.points);
        path.points = this.points;
        for (int i = 0; i < this.points; ++i) {
            path.precise_x_positions[i] = this.precise_x_positions[this.points - 1 - i];
            path.precise_y_positions[i] = this.precise_y_positions[this.points - 1 - i];
            path.precise_z_positions[i] = this.precise_z_positions[this.points - 1 - i];
        }
        return path;
    }

    void addPointDouble(double d, double d2, double d3) {
        if (this.points >= this.maxPoints) {
            int n = (int)((double)this.maxPoints * 1.2 + 1.0);
            this.expandTo(n);
        }
        this.precise_x_positions[this.points] = d;
        this.precise_y_positions[this.points] = d2;
        this.precise_z_positions[this.points++] = d3;
    }

    public void drawPathAsPoints(TracerCanvas tracerCanvas, Graphics graphics, Color color, int n) {
        this.drawPathAsPoints(tracerCanvas, graphics, color, n, 0, -1);
    }

    public void drawPathAsPoints(TracerCanvas tracerCanvas, Graphics graphics, Color color, int n, int n2, int n3) {
        graphics.setColor(color);
        int n4 = (int)tracerCanvas.getMagnification();
        if (n4 < 1) {
            n4 = 1;
        }
        int n5 = n4;
        int n6 = n4 * 3;
        boolean bl = false;
        Path path = this.fittedVersionOf == null ? this.startJoins : this.fittedVersionOf.startJoins;
        Path path2 = this.fittedVersionOf == null ? this.endJoins : this.fittedVersionOf.endJoins;
        switch (n) {
            case 0: {
                for (int i = 0; i < this.points; ++i) {
                    if (n3 >= 0 && Math.abs(this.getZUnscaled(i) - n2) > n3) continue;
                    int n7 = tracerCanvas.myScreenXD(this.getXUnscaledDouble(i));
                    int n8 = tracerCanvas.myScreenYD(this.getYUnscaledDouble(i));
                    if (bl) {
                        double d = 0.0;
                        double d2 = 0.0;
                        double d3 = 1.0;
                        double d4 = this.tangents_x[i];
                        double d5 = this.tangents_y[i];
                        double d6 = this.tangents_z[i];
                        double d7 = d2 * d6 - d3 * d5;
                        double d8 = d3 * d4 - d * d6;
                        double d9 = d * d5 - d2 * d4;
                        double d10 = Math.sqrt(d7 * d7 + d8 * d8);
                        double d11 = d7 / d10;
                        double d12 = d8 / d10;
                        double d13 = this.precise_x_positions[i] + d11 * this.radiuses[i];
                        double d14 = this.precise_y_positions[i] + d12 * this.radiuses[i];
                        double d15 = this.precise_x_positions[i] - d11 * this.radiuses[i];
                        double d16 = this.precise_y_positions[i] - d12 * this.radiuses[i];
                        int n9 = tracerCanvas.myScreenXD(d13 / this.x_spacing);
                        int n10 = tracerCanvas.myScreenYD(d14 / this.y_spacing);
                        int n11 = tracerCanvas.myScreenXD(d15 / this.x_spacing);
                        int n12 = tracerCanvas.myScreenYD(d16 / this.y_spacing);
                        int n13 = tracerCanvas.myScreenXD(this.precise_x_positions[i] / this.x_spacing);
                        int n14 = tracerCanvas.myScreenYD(this.precise_y_positions[i] / this.y_spacing);
                        graphics.drawLine(n13, n14, n9, n10);
                        graphics.drawLine(n13, n14, n11, n12);
                        graphics.setColor(color);
                    }
                    if (i == 0 && path == null || i == this.points - 1 && path2 == null) {
                        graphics.fillRect(n7 - n6 / 2, n8 - n6 / 2, n6, n6);
                        continue;
                    }
                    if (i == 0 && path != null || i == this.points - 1 && path2 != null) {
                        graphics.fillOval(n7 - n6 / 2, n8 - n6 / 2, n6, n6);
                        continue;
                    }
                    graphics.fillRect(n7 - n5 / 2, n8 - n5 / 2, n5, n5);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.points; ++i) {
                    if (n3 >= 0 && Math.abs(this.getYUnscaled(i) - n2) > n3) continue;
                    int n15 = tracerCanvas.myScreenXD(this.getXUnscaled(i));
                    int n16 = tracerCanvas.myScreenYD(this.getZUnscaled(i));
                    if (i == 0 && path == null || i == this.points - 1 && path2 == null) {
                        graphics.fillRect(n15 - n5, n16 - n5, n6, n6);
                        continue;
                    }
                    if (i == 0 && path != null || i == this.points - 1 && path2 != null) {
                        graphics.fillOval(n15 - n5, n16 - n5, n6, n6);
                        continue;
                    }
                    graphics.fillRect(n15, n16, n5, n5);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.points; ++i) {
                    if (n3 >= 0 && Math.abs(this.getXUnscaled(i) - n2) > n3) continue;
                    int n17 = tracerCanvas.myScreenXD(this.getZUnscaled(i));
                    int n18 = tracerCanvas.myScreenYD(this.getYUnscaled(i));
                    if (i == 0 && path == null || i == this.points - 1 && path2 == null) {
                        graphics.fillRect(n17 - n5, n18 - n5, n6, n6);
                        continue;
                    }
                    if (i == 0 && path != null || i == this.points - 1 && path2 != null) {
                        graphics.fillOval(n17 - n5, n18 - n5, n6, n6);
                        continue;
                    }
                    graphics.fillRect(n17, n18, n5, n5);
                }
                break;
            }
        }
    }

    public int indexNearestTo(double d, double d2, double d3) {
        if (this.size() < 1) {
            throw new RuntimeException("indexNearestTo called on a Path of size() = 0");
        }
        PointInImage pointInImage = new PointInImage(Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE);
        double d4 = Double.MAX_VALUE;
        int n = -1;
        for (int i = 0; i < this.size(); ++i) {
            double d5 = d - this.precise_x_positions[i];
            double d6 = d2 - this.precise_y_positions[i];
            double d7 = d3 - this.precise_z_positions[i];
            double d8 = d5 * d5 + d6 * d6 + d7 * d7;
            if (!(d8 < d4)) continue;
            n = i;
            d4 = d8;
        }
        return n;
    }

    public void setFitted(Path path) {
        if (this.fitted != null) {
            throw new RuntimeException("BUG: Trying to set a fitted path when there already is one...");
        }
        this.fitted = path;
        path.fittedVersionOf = this;
    }

    public void setUseFitted(boolean bl) {
        this.setUseFitted(bl, null);
    }

    public void setUseFitted(boolean bl, Simple_Neurite_Tracer simple_Neurite_Tracer) {
        if (bl && this.fitted == null) {
            throw new RuntimeException("BUG: setUseFitted(true) was called, but the 'fitted' member was null");
        }
        if (simple_Neurite_Tracer != null && simple_Neurite_Tracer.use3DViewer) {
            if (bl) {
                this.removeFrom3DViewer(simple_Neurite_Tracer.univ);
                this.fitted.addTo3DViewer(simple_Neurite_Tracer.univ);
            } else {
                this.fitted.removeFrom3DViewer(simple_Neurite_Tracer.univ);
                this.addTo3DViewer(simple_Neurite_Tracer.univ);
            }
        }
        this.useFitted = bl;
    }

    public boolean getUseFitted() {
        return this.useFitted;
    }

    public void setGuessedTangents(int n) {
        if (this.tangents_x == null || this.tangents_y == null || this.tangents_z == null) {
            throw new RuntimeException("BUG: setGuessedTangents called with one of the tangent arrays null");
        }
        double[] dArray = new double[3];
        for (int i = 0; i < this.points; ++i) {
            this.getTangent(i, n, dArray);
            this.tangents_x[i] = dArray[0];
            this.tangents_y[i] = dArray[1];
            this.tangents_z[i] = dArray[2];
        }
    }

    public void getTangent(int n, int n2, double[] dArray) {
        int n3;
        int n4 = n - n2;
        if (n4 < 0) {
            n4 = 0;
        }
        if ((n3 = n + n2) >= this.points) {
            n3 = this.points - 1;
        }
        dArray[0] = this.precise_x_positions[n3] - this.precise_x_positions[n4];
        dArray[1] = this.precise_y_positions[n3] - this.precise_y_positions[n4];
        dArray[2] = this.precise_z_positions[n3] - this.precise_z_positions[n4];
    }

    public Path fitCircles(int n, Simple_Neurite_Tracer simple_Neurite_Tracer, boolean bl) {
        int n2;
        int n3;
        int n4;
        Path path = new Path(this.x_spacing, this.y_spacing, this.z_spacing, this.spacing_units);
        int n5 = this.size();
        double d = simple_Neurite_Tracer.x_spacing;
        double d2 = simple_Neurite_Tracer.y_spacing;
        double d3 = simple_Neurite_Tracer.z_spacing;
        int n6 = 4;
        int n7 = simple_Neurite_Tracer.width;
        int n8 = simple_Neurite_Tracer.height;
        int n9 = simple_Neurite_Tracer.depth;
        ImageStack imageStack = new ImageStack(n, n);
        double[] dArray = new double[n5];
        double[] dArray2 = new double[n5];
        double[] dArray3 = new double[n5];
        double[] dArray4 = new double[n5];
        double[] dArray5 = new double[n5];
        double[] dArray6 = new double[n5];
        double[] dArray7 = new double[n5];
        double[] dArray8 = new double[n5];
        double[] dArray9 = new double[n5];
        double[] dArray10 = new double[n5];
        double[] dArray11 = new double[n5];
        double[] dArray12 = new double[n5];
        boolean[] blArray = new boolean[n5];
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        int[] nArray3 = new int[n5];
        double d4 = simple_Neurite_Tracer.getMinimumSeparation();
        double[] dArray13 = new double[3];
        for (n4 = 0; n4 < n5; ++n4) {
            this.getTangent(n4, n6, dArray13);
            IJ.showProgress((double)((float)n4 / (float)n5));
            double d5 = this.precise_x_positions[n4];
            double d6 = this.precise_y_positions[n4];
            double d7 = this.precise_z_positions[n4];
            double[] dArray14 = new double[3];
            double[] dArray15 = new double[3];
            byte[] byArray = simple_Neurite_Tracer.squareNormalToVector(n, d4, d5, d6, d7, dArray13[0], dArray13[1], dArray13[2], dArray14, dArray15);
            dArray5[n4] = dArray13[0];
            dArray6[n4] = dArray13[1];
            dArray7[n4] = dArray13[2];
            ConjugateDirectionSearch conjugateDirectionSearch = new ConjugateDirectionSearch();
            conjugateDirectionSearch.step = (double)n / 4.0;
            double[] dArray16 = new double[]{(double)n / 2.0, (double)n / 2.0, 3.0};
            int n10 = Integer.MAX_VALUE;
            int n11 = Integer.MIN_VALUE;
            for (int i = 0; i < n * n; ++i) {
                int n12 = byArray[i] & 0xFF;
                if (n12 > n11) {
                    n11 = n12;
                }
                if (n12 >= n10) continue;
                n10 = n12;
            }
            CircleAttempt circleAttempt = new CircleAttempt(dArray16, byArray, n10, n11, n);
            conjugateDirectionSearch.optimize(circleAttempt, dArray16, 2.0, 2.0);
            dArray[n4] = dArray16[0];
            dArray2[n4] = dArray16[1];
            dArray4[n4] = dArray16[2];
            dArray3[n4] = d4 * dArray4[n4];
            dArray11[n4] = circleAttempt.min;
            double d8 = dArray16[0] - (double)n / 2.0;
            double d9 = dArray16[1] - (double)n / 2.0;
            dArray12[n4] = d4 * Math.sqrt(d8 * d8 + d9 * d9);
            double d10 = d5;
            double d11 = d6;
            double d12 = d7;
            dArray8[n4] = d10 -= dArray14[0] * d8 + dArray15[0] * d9;
            dArray9[n4] = d11 -= dArray14[1] * d8 + dArray15[1] * d9;
            dArray10[n4] = d12 -= dArray14[2] * d8 + dArray15[2] * d9;
            int n13 = (int)Math.round(d10 / d);
            int n14 = (int)Math.round(d11 / d2);
            int n15 = (int)Math.round(d12 / d3);
            if (n13 < 0) {
                n13 = 0;
            }
            if (n13 >= n7) {
                n13 = n7 - 1;
            }
            if (n14 < 0) {
                n14 = 0;
            }
            if (n14 >= n8) {
                n14 = n8 - 1;
            }
            if (n15 < 0) {
                n15 = 0;
            }
            if (n15 >= n9) {
                n15 = n9 - 1;
            }
            nArray[n4] = n13;
            nArray2[n4] = n14;
            nArray3[n4] = n15;
            ByteProcessor byteProcessor = new ByteProcessor(n, n);
            byteProcessor.setPixels((Object)byArray);
            imageStack.addSlice(null, (ImageProcessor)byteProcessor);
        }
        IJ.showProgress((double)1.0);
        n4 = 4;
        double[] dArray17 = new double[n5];
        double[] dArray18 = new double[n5];
        double[] dArray19 = new double[n4 * 2 + 1];
        for (int i = 0; i < n5; ++i) {
            int n16 = i - n4;
            n3 = i + n4;
            int n17 = 0;
            for (int j = n16; j <= n3; ++j) {
                dArray19[n17] = j < 0 ? Double.MIN_VALUE : (j >= n5 ? Double.MAX_VALUE : (dArray4[j] < 1.0 ? 1.0 : dArray4[j]));
                ++n17;
            }
            Arrays.sort(dArray19);
            dArray17[i] = dArray19[n4];
            dArray18[i] = d4 * dArray17[i];
            blArray[i] = dArray12[i] < dArray17[i];
        }
        double[] dArray20 = new double[n5];
        dArray20[n5 - 1] = Math.PI;
        dArray20[0] = Math.PI;
        for (int i = 1; i < n5 - 1; ++i) {
            int n18;
            n3 = 0;
            for (n18 = 0; n18 < i; ++n18) {
                if (!blArray[n18]) continue;
                n3 = n18;
            }
            n18 = n5 - 1;
            for (int j = n5 - 1; j > i; --j) {
                if (!blArray[j]) continue;
                n18 = j;
            }
            double d13 = dArray8[n3] - dArray8[i];
            double d14 = dArray9[n3] - dArray9[i];
            double d15 = dArray10[n3] - dArray10[i];
            double d16 = dArray8[n18] - dArray8[i];
            double d17 = dArray9[n18] - dArray9[i];
            double d18 = dArray10[n18] - dArray10[i];
            double d19 = d13 * d16 + d14 * d17 + d15 * d18;
            double d20 = Math.sqrt(d13 * d13 + d14 * d14 + d15 * d15);
            double d21 = Math.sqrt(d16 * d16 + d17 * d17 + d18 * d18);
            dArray20[i] = Math.acos(d19 / (d20 * d21));
            if (!(dArray20[i] < 1.5707963267948966)) continue;
            blArray[i] = false;
        }
        int[] nArray4 = new int[n5];
        n3 = 1;
        block7: while (n3 != 0) {
            int n19;
            int n20;
            n3 = 0;
            int n21 = -1;
            for (n20 = 0; n20 < n5; ++n20) {
                nArray4[n20] = 0;
                if (!blArray[n20]) continue;
                for (n19 = 0; n19 < n5; ++n19) {
                    if (!blArray[n19] || n20 == n19 || !this.circlesOverlap(dArray5[n20], dArray6[n20], dArray7[n20], dArray8[n20], dArray9[n20], dArray10[n20], dArray3[n20], dArray5[n19], dArray6[n19], dArray7[n19], dArray8[n19], dArray9[n19], dArray10[n19], dArray3[n19])) continue;
                    int n22 = n20;
                    nArray4[n22] = nArray4[n22] + 1;
                    n3 = 1;
                }
                if (nArray4[n20] <= n21) continue;
                n21 = nArray4[n20];
            }
            if (n21 <= 0) break;
            for (n20 = 0; n20 < n5; ++n20) {
                if (!blArray[n20]) continue;
                n19 = n5;
                for (int i = n5 - 1; i > n20; --i) {
                    if (!blArray[i]) continue;
                    n19 = i;
                }
                if (nArray4[n20] != n21) continue;
                if (n19 < n5 && nArray4[n19] == n21 && dArray3[n19] > dArray3[n20]) {
                    blArray[n19] = false;
                    continue block7;
                }
                blArray[n20] = false;
                continue block7;
            }
        }
        int n23 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            boolean bl2;
            boolean bl3 = bl2 = n2 == 0 || n2 == this.points - 1;
            if (!blArray[n2]) {
                boolean bl4 = n2 - n23 >= 2;
                boolean bl5 = false;
                if (n2 < this.points - 1 && blArray[n2 + 1]) {
                    bl5 = true;
                }
                if (bl4 && !bl5 || bl2) {
                    blArray[n2] = true;
                    nArray[n2] = this.getXUnscaled(n2);
                    nArray2[n2] = this.getYUnscaled(n2);
                    nArray3[n2] = this.getZUnscaled(n2);
                    dArray8[n2] = this.precise_x_positions[n2];
                    dArray9[n2] = this.precise_y_positions[n2];
                    dArray10[n2] = this.precise_z_positions[n2];
                    dArray4[n2] = 1.0;
                    dArray3[n2] = d4;
                    dArray17[n2] = 1.0;
                    dArray18[n2] = d4;
                    dArray[n2] = (double)n / 2.0;
                    dArray2[n2] = (double)n / 2.0;
                }
            }
            if (!blArray[n2]) continue;
            if (dArray3[n2] < d4) {
                dArray4[n2] = 1.0;
                dArray3[n2] = d4;
            }
            path.addPointDouble(dArray8[n2], dArray9[n2], dArray10[n2]);
            n23 = n2;
        }
        n2 = path.size();
        double[] dArray21 = new double[n2];
        double[] dArray22 = new double[n2];
        double[] dArray23 = new double[n2];
        double[] dArray24 = new double[n2];
        double[] dArray25 = new double[n2];
        double[] dArray26 = new double[n2];
        double[] dArray27 = new double[n2];
        int n24 = 0;
        for (int i = 0; i < this.points; ++i) {
            if (!blArray[i]) continue;
            dArray21[n24] = dArray5[i];
            dArray22[n24] = dArray6[i];
            dArray23[n24] = dArray7[i];
            dArray24[n24] = dArray3[i];
            dArray25[n24] = dArray8[i];
            dArray26[n24] = dArray9[i];
            dArray27[n24] = dArray10[i];
            ++n24;
        }
        if (n24 != n2) {
            throw new RuntimeException("Mismatch of lengths, added=" + n24 + " and fittedLength=" + n2);
        }
        path.setFittedCircles(dArray21, dArray22, dArray23, dArray24, dArray25, dArray26, dArray27);
        if (bl) {
            ImagePlus imagePlus = new ImagePlus("normal stack", imageStack);
            NormalPlaneCanvas normalPlaneCanvas = new NormalPlaneCanvas(imagePlus, simple_Neurite_Tracer, dArray, dArray2, dArray4, dArray11, dArray17, dArray20, blArray, path);
            new StackWindow(imagePlus, (ImageCanvas)normalPlaneCanvas);
            imagePlus.show();
        }
        path.setName("Fitted Path [" + this.getID() + "]");
        return path;
    }

    public boolean circlesOverlap(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14) {
        double d15 = 1.0E-6;
        double d16 = d2 * d10 - d3 * d9;
        double d17 = d3 * d8 - d * d10;
        double d18 = d * d9 - d2 * d8;
        if (Math.abs(d16) < d15 && Math.abs(d17) < d15 && Math.abs(d18) < d15) {
            double d19 = d11 - d4;
            double d20 = d12 - d5;
            double d21 = d13 - d6;
            double d22 = d19 * d + d20 * d2 + d21 * d3;
            return Math.abs(d22) < d15;
        }
        double d23 = d * d + d2 * d2 + d3 * d3;
        double d24 = d8 * d8 + d9 * d9 + d10 * d10;
        double d25 = d * d8 + d2 * d9 + d3 * d10;
        double d26 = d23 * d24 - d25 * d25;
        if (Math.abs(d26) < d15) {
            System.out.println("WARNING: det was nearly zero: " + d26);
            return true;
        }
        double d27 = d * d4 + d2 * d5 + d3 * d6;
        double d28 = d8 * d11 + d9 * d12 + d10 * d13;
        double d29 = (d27 * d24 - d28 * d25) / d26;
        double d30 = (d28 * d23 - d27 * d25) / d26;
        double d31 = d16 * d16 + d17 * d17 + d18 * d18;
        double d32 = 2.0 * (d16 * (d29 * d + d30 * d8 - d4) + d17 * (d29 * d2 + d30 * d9 - d5) + d18 * (d29 * d3 + d30 * d10 - d6));
        double d33 = (d29 * d + d30 * d8 - d4) * (d29 * d + d30 * d8 - d4) + (d29 * d2 + d30 * d9 - d5) * (d29 * d2 + d30 * d9 - d5) + (d29 * d3 + d30 * d10 - d6) * (d29 * d3 + d30 * d10 - d6) - d7 * d7;
        double d34 = d16 * d16 + d17 * d17 + d18 * d18;
        double d35 = 2.0 * (d16 * (d29 * d + d30 * d8 - d11) + d17 * (d29 * d2 + d30 * d9 - d12) + d18 * (d29 * d3 + d30 * d10 - d13));
        double d36 = (d29 * d + d30 * d8 - d11) * (d29 * d + d30 * d8 - d11) + (d29 * d2 + d30 * d9 - d12) * (d29 * d2 + d30 * d9 - d12) + (d29 * d3 + d30 * d10 - d13) * (d29 * d3 + d30 * d10 - d13) - d14 * d14;
        double d37 = d32 * d32 - 4.0 * d31 * d33;
        double d38 = d35 * d35 - 4.0 * d34 * d36;
        if (d37 < 0.0 || d38 < 0.0) {
            return false;
        }
        if (Math.abs(d31) < d15) {
            System.out.println("WARNING: a1 was nearly zero: " + d31);
            return true;
        }
        double d39 = Math.sqrt(d37) / (2.0 * d31) - d32 / (2.0 * d31);
        double d40 = -Math.sqrt(d37) / (2.0 * d31) - d32 / (2.0 * d31);
        double d41 = Math.sqrt(d38) / (2.0 * d34) - d35 / (2.0 * d34);
        double d42 = -Math.sqrt(d38) / (2.0 * d34) - d35 / (2.0 * d34);
        double d43 = Math.min(d39, d40);
        double d44 = Math.max(d39, d40);
        double d45 = Math.min(d41, d42);
        double d46 = Math.max(d41, d42);
        if (d44 < d45) {
            return false;
        }
        if (d46 < d43) {
            return false;
        }
        if (d43 <= d45 && d46 <= d44) {
            return true;
        }
        if (d45 <= d43 && d44 <= d46) {
            return true;
        }
        if (d43 <= d45 && d45 <= d44 && d44 <= d46) {
            return true;
        }
        if (d45 <= d43 && d43 <= d46 && d46 <= d44) {
            return true;
        }
        System.out.println("det is: " + d26);
        System.out.println("discriminant1 is: " + d37);
        System.out.println("discriminant2 is: " + d38);
        System.out.println("n1: (" + d + "," + d2 + "," + d3 + ")");
        System.out.println("n2: (" + d8 + "," + d9 + "," + d10 + ")");
        System.out.println("c1: (" + d4 + "," + d5 + "," + d6 + ")");
        System.out.println("c2: (" + d11 + "," + d12 + "," + d13 + ")");
        System.out.println("radius1: " + d7);
        System.out.println("radius2: " + d14);
        throw new RuntimeException("BUG: some overlapping case missed: u1_smaller=" + d43 + "u1_larger=" + d44 + "u2_smaller=" + d45 + "u2_larger=" + d46);
    }

    public boolean hasCircles() {
        return this.radiuses != null;
    }

    public void setFittedCircles(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7) {
        this.tangents_x = (double[])dArray.clone();
        this.tangents_y = (double[])dArray2.clone();
        this.tangents_z = (double[])dArray3.clone();
        this.radiuses = (double[])dArray4.clone();
        this.precise_x_positions = (double[])dArray5.clone();
        this.precise_y_positions = (double[])dArray6.clone();
        this.precise_z_positions = (double[])dArray7.clone();
    }

    public String toString() {
        if (this.useFitted) {
            return this.fitted.toString();
        }
        String string = this.getName();
        if (string == null) {
            string = "Path " + this.id;
        }
        string = string + " [" + this.getRealLengthString() + " " + this.spacing_units + "]";
        if (this.startJoins != null) {
            string = string + ", starts on " + this.startJoins.getName();
        }
        if (this.endJoins != null) {
            string = string + ", ends on " + this.endJoins.getName();
        }
        return string;
    }

    public void removeFrom3DViewer(Image3DUniverse image3DUniverse) {
        if (this.content3D != null) {
            image3DUniverse.removeContent(this.nameWhenAddedToViewer);
            this.content3D = null;
        }
    }

    public Content addTo3DViewer(Image3DUniverse image3DUniverse) {
        return this.addTo3DViewer(image3DUniverse, null);
    }

    public Content addTo3DViewer(Image3DUniverse image3DUniverse, Color color) {
        double[] dArray;
        int n;
        if (this.points <= 1) {
            this.content3D = null;
            return null;
        }
        int n2 = -1;
        double[] dArray2 = new double[this.points];
        double[] dArray3 = new double[this.points];
        double[] dArray4 = new double[this.points];
        double[] dArray5 = new double[this.points];
        if (this.hasCircles()) {
            n = 0;
            int n3 = -2;
            for (int i = 0; i < this.points; ++i) {
                if (this.points > 2 && i - n3 < 2) continue;
                dArray2[n] = this.precise_x_positions[i];
                dArray3[n] = this.precise_y_positions[i];
                dArray4[n] = this.precise_z_positions[i];
                dArray5[n] = this.radiuses[i];
                n3 = i;
                ++n;
            }
            n2 = n;
        } else {
            for (n = 0; n < this.points; ++n) {
                dArray2[n] = this.precise_x_positions[n];
                dArray3[n] = this.precise_y_positions[n];
                dArray4[n] = this.precise_z_positions[n];
                dArray5[n] = this.x_spacing * 1.5;
            }
            n2 = this.points;
        }
        if (n2 == 2) {
            double[] dArray6 = new double[3];
            double[] dArray7 = new double[3];
            double[] dArray8 = new double[3];
            dArray = new double[3];
            dArray6[0] = dArray2[0];
            dArray7[0] = dArray3[0];
            dArray8[0] = dArray4[0];
            dArray[0] = dArray5[0];
            dArray6[1] = (dArray2[0] + dArray2[1]) / 2.0;
            dArray7[1] = (dArray3[0] + dArray3[1]) / 2.0;
            dArray8[1] = (dArray4[0] + dArray4[1]) / 2.0;
            dArray[1] = (dArray5[0] + dArray5[1]) / 2.0;
            dArray6[2] = dArray2[1];
            dArray7[2] = dArray3[1];
            dArray8[2] = dArray4[1];
            dArray[2] = dArray5[1];
            dArray2 = dArray6;
            dArray3 = dArray7;
            dArray4 = dArray8;
            dArray5 = dArray;
            n2 = 3;
        }
        double[] dArray9 = new double[n2];
        double[] dArray10 = new double[n2];
        double[] dArray11 = new double[n2];
        dArray = new double[n2];
        System.arraycopy(dArray2, 0, dArray9, 0, n2);
        System.arraycopy(dArray3, 0, dArray10, 0, n2);
        System.arraycopy(dArray4, 0, dArray11, 0, n2);
        System.arraycopy(dArray5, 0, dArray, 0, n2);
        double[][][] dArray12 = Pipe.makeTube(dArray9, dArray10, dArray11, dArray, 2, 12);
        if (dArray12 == null) {
            this.content3D = null;
            return null;
        }
        List list = Pipe.generateTriangles(dArray12, 1.0);
        this.nameWhenAddedToViewer = image3DUniverse.getSafeContentName(this.getName());
        image3DUniverse.resetView();
        this.content3D = image3DUniverse.addTriangleMesh(list, color == null ? new Color3f(Color.magenta) : new Color3f(color), this.nameWhenAddedToViewer);
        this.content3D.setLocked(true);
        image3DUniverse.resetView();
        return this.content3D;
    }

    public void setSelected(boolean bl) {
        if (bl != this.selected) {
            this.selected = bl;
        }
    }

    public boolean getSelected() {
        return this.selected;
    }

    public Path transform(PathTransformer pathTransformer, ImagePlus imagePlus, ImagePlus imagePlus2) {
        int n = imagePlus2.getWidth();
        int n2 = imagePlus2.getHeight();
        int n3 = imagePlus2.getStackSize();
        int n4 = imagePlus.getWidth();
        int n5 = imagePlus.getHeight();
        int n6 = imagePlus.getStackSize();
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        String string = "pixels";
        Calibration calibration = imagePlus.getCalibration();
        if (calibration != null) {
            d = calibration.pixelWidth;
            d2 = calibration.pixelHeight;
            d3 = calibration.pixelDepth;
            string = calibration.getUnits();
        }
        double d4 = 1.0;
        double d5 = 1.0;
        double d6 = 1.0;
        Calibration calibration2 = imagePlus2.getCalibration();
        if (calibration2 != null) {
            d4 = calibration2.pixelWidth;
            d5 = calibration2.pixelHeight;
            d6 = calibration2.pixelDepth;
        }
        Path path = new Path(d, d2, d3, string, this.size());
        double[] dArray = new double[3];
        for (int i = 0; i < this.points; ++i) {
            double d7 = this.precise_x_positions[i];
            double d8 = this.precise_y_positions[i];
            double d9 = this.precise_z_positions[i];
            pathTransformer.transformPoint(d7, d8, d9, dArray);
            double d10 = dArray[0];
            double d11 = dArray[1];
            double d12 = dArray[2];
            if (Double.isNaN(d10) || Double.isNaN(d11) || Double.isNaN(d12)) continue;
            path.addPointDouble(d10, d11, d12);
        }
        path.primary = this.primary;
        path.id = this.id;
        path.selected = this.selected;
        path.name = this.name;
        path.x_spacing = this.x_spacing;
        path.y_spacing = this.y_spacing;
        path.z_spacing = this.z_spacing;
        path.spacing_units = this.spacing_units;
        path.swcType = this.swcType;
        return path;
    }

    class CircleAttempt
    implements MultivariateFunction,
    Comparable {
        double min;
        double[] best;
        double[] initial;
        byte[] data;
        int minValueInData;
        int maxValueInData;
        int side;

        public CircleAttempt(double[] dArray, byte[] byArray, int n, int n2, int n3) {
            this.data = byArray;
            this.minValueInData = n;
            this.maxValueInData = n2;
            this.side = n3;
            this.min = Double.MAX_VALUE;
            this.initial = dArray;
        }

        public int compareTo(Object object) {
            CircleAttempt circleAttempt = (CircleAttempt)object;
            if (this.min < circleAttempt.min) {
                return -1;
            }
            if (this.min > circleAttempt.min) {
                return 1;
            }
            return 0;
        }

        public int getNumArguments() {
            return 3;
        }

        public double getLowerBound(int n) {
            return 0.0;
        }

        public double getUpperBound(int n) {
            return this.side;
        }

        public double evaluate(double[] dArray) {
            double d = this.evaluateCircle(dArray[0], dArray[1], dArray[2]);
            if (d < this.min) {
                this.best = (double[])dArray.clone();
                this.min = d;
            }
            return d;
        }

        public double evaluateCircle(double d, double d2, double d3) {
            double d4 = (this.maxValueInData - this.minValueInData) * (this.maxValueInData - this.minValueInData);
            double d5 = 0.0;
            for (int i = 0; i < this.side; ++i) {
                for (int j = 0; j < this.side; ++j) {
                    int n = this.data[j * this.side + i] & 0xFF;
                    if (d3 * d3 > ((double)i - d) * ((double)i - d) + ((double)j - d2) * ((double)j - d2)) {
                        d5 += (double)((this.maxValueInData - n) * (this.maxValueInData - n));
                        continue;
                    }
                    d5 += (double)((n - this.minValueInData) * (n - this.minValueInData));
                }
            }
            for (double d6 = d - d3; d6 <= d + d3; d6 += 1.0) {
                for (double d7 = d2 - d3; d7 <= d2 + d3; d7 += 1.0) {
                    if (!(d6 < 0.0 || d6 > (double)this.side || d7 < 0.0) && !(d7 > (double)this.side)) continue;
                    d5 += d4;
                }
            }
            return d5 /= (double)(this.side * this.side);
        }
    }
}

