/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import ij.IJ;
import ij.ImagePlus;
import ij.measure.Calibration;
import ij3d.Content;
import ij3d.UniverseListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.media.j3d.View;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import tracing.Fill;
import tracing.FillerThread;
import tracing.NearPoint;
import tracing.Path;
import tracing.PathAndFillListener;
import tracing.PathTransformer;
import tracing.PointInImage;
import tracing.Simple_Neurite_Tracer;
import tracing.TracesFileFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathAndFillManager
extends DefaultHandler
implements UniverseListener {
    static final boolean verbose = false;
    Simple_Neurite_Tracer plugin;
    ImagePlus imagePlus;
    int maxUsedID = -1;
    int width;
    int height;
    int depth;
    double x_spacing;
    double y_spacing;
    double z_spacing;
    String spacing_units;
    ArrayList<Path> allPaths = new ArrayList();
    ArrayList<Fill> allFills = new ArrayList();
    ArrayList<PathAndFillListener> listeners = new ArrayList();
    HashSet<Path> selectedPathsSet = new HashSet();
    double parsed_x_spacing;
    double parsed_y_spacing;
    double parsed_z_spacing;
    String parsed_units;
    int parsed_width;
    int parsed_height;
    int parsed_depth;
    Fill current_fill;
    Path current_path;
    HashMap<Integer, Integer> startJoins;
    HashMap<Integer, Integer> startJoinsIndices;
    HashMap<Integer, PointInImage> startJoinsPoints;
    HashMap<Integer, Integer> endJoins;
    HashMap<Integer, Integer> endJoinsIndices;
    HashMap<Integer, PointInImage> endJoinsPoints;
    HashMap<Integer, Boolean> useFittedFields;
    HashMap<Integer, Integer> fittedFields;
    HashMap<Integer, Integer> fittedVersionOfFields;
    ArrayList<int[]> sourcePathIDForFills;
    int last_fill_node_id;
    int last_fill_id;
    HashSet<Integer> foundIDs;

    public PathAndFillManager() {
    }

    public PathAndFillManager(ImagePlus imagePlus) {
        this();
        this.imagePlus = imagePlus;
        Calibration calibration = imagePlus.getCalibration();
        this.x_spacing = calibration.pixelWidth;
        this.y_spacing = calibration.pixelHeight;
        this.z_spacing = calibration.pixelDepth;
        this.spacing_units = calibration.getUnit();
        if (this.spacing_units == null || this.spacing_units.length() == 0) {
            this.spacing_units = "" + calibration.getUnit();
        }
        this.width = imagePlus.getWidth();
        this.height = imagePlus.getHeight();
        this.depth = imagePlus.getStackSize();
    }

    public PathAndFillManager(Simple_Neurite_Tracer simple_Neurite_Tracer) {
        this();
        this.plugin = simple_Neurite_Tracer;
        this.x_spacing = simple_Neurite_Tracer.x_spacing;
        this.y_spacing = simple_Neurite_Tracer.y_spacing;
        this.z_spacing = simple_Neurite_Tracer.z_spacing;
        this.spacing_units = simple_Neurite_Tracer.spacing_units;
        this.width = simple_Neurite_Tracer.width;
        this.height = simple_Neurite_Tracer.height;
        this.depth = simple_Neurite_Tracer.depth;
    }

    public PathAndFillManager(int n, int n2, int n3, float f, float f2, float f3, String string) {
        this();
        this.x_spacing = f;
        this.y_spacing = f2;
        this.z_spacing = f3;
        this.width = n;
        this.height = n2;
        this.depth = n3;
        if (string == null) {
            this.spacing_units = "unknown";
        }
    }

    public int size() {
        return this.allPaths.size();
    }

    public synchronized void addPathAndFillListener(PathAndFillListener pathAndFillListener) {
        this.listeners.add(pathAndFillListener);
    }

    public synchronized Path getPath(int n) {
        return this.allPaths.get(n);
    }

    public synchronized Path getPathFromName(String string) {
        return this.getPathFromName(string, true);
    }

    public synchronized Path getPathFromName(String string, boolean bl) {
        for (Path path : this.allPaths) {
            if (!(bl ? string.equals(path.getName()) : string.equalsIgnoreCase(path.getName()))) continue;
            return path;
        }
        return null;
    }

    public synchronized Path getPathFromID(int n) {
        for (Path path : this.allPaths) {
            if (n != path.getID()) continue;
            return path;
        }
        return null;
    }

    public synchronized void setSelected(Path[] pathArray, Object object) {
        this.selectedPathsSet.clear();
        for (int i = 0; i < pathArray.length; ++i) {
            this.selectedPathsSet.add(pathArray[i]);
        }
        for (PathAndFillListener pathAndFillListener : this.listeners) {
            if (pathAndFillListener == object) continue;
            pathAndFillListener.setSelectedPaths(this.selectedPathsSet, this);
        }
        if (this.plugin != null) {
            this.plugin.repaintAllPanes();
            this.plugin.update3DViewerContents();
        }
    }

    public synchronized boolean isSelected(Path path) {
        return this.selectedPathsSet.contains(path);
    }

    public boolean anySelected() {
        return this.selectedPathsSet.size() > 0;
    }

    public synchronized Path[] getPathsStructured() {
        Path path;
        int n;
        int n2;
        ArrayList<Path> arrayList = new ArrayList<Path>();
        TreeSet<Path> treeSet = new TreeSet<Path>();
        for (n2 = 0; n2 < this.allPaths.size(); ++n2) {
            treeSet.add(this.allPaths.get(n2));
        }
        n2 = 0;
        Iterator<Object> iterator = treeSet.iterator();
        Path path2 = null;
        while (iterator.hasNext()) {
            Path path3 = (Path)iterator.next();
            if (!path3.getPrimary()) continue;
            iterator.remove();
            arrayList.add(path3);
            ++n2;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            path2 = (Path)arrayList.get(n);
            path2.setChildren(treeSet);
        }
        n = 1;
        block3: while (n != 0) {
            n = 0;
            iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                path = (Path)iterator.next();
                if (path.startJoins != null) continue;
                n = 1;
                iterator.remove();
                arrayList.add(path);
                path.setChildren(treeSet);
                continue block3;
            }
        }
        while (treeSet.size() > 0) {
            iterator = treeSet.iterator();
            path = (Path)iterator.next();
            iterator.remove();
            arrayList.add(path);
            path.setChildren(treeSet);
        }
        return arrayList.toArray(new Path[0]);
    }

    public synchronized void resetListeners(Path path) {
        this.resetListeners(path, false);
    }

    public synchronized void resetListeners(Path path, boolean bl) {
        Object object;
        Hashtable<Path, Integer> hashtable = new Hashtable<Path, Integer>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Path object2 : this.allPaths) {
            int pathAndFillListener = object2.getID();
            hashtable.put(object2, new Integer(pathAndFillListener));
            if (object2 == null) {
                throw new RuntimeException("BUG: A path in allPaths was null!");
            }
            object = object2.getName();
            if (object == null) {
                object = "Path [" + pathAndFillListener + "]";
            }
            if (object2.startJoins != null) {
                object = (String)object + ", starts on " + object2.startJoins.getName();
            }
            if (object2.endJoins != null) {
                object = (String)object + ", ends on " + object2.endJoins.getName();
            }
            object = (String)object + " [" + object2.getRealLengthString() + " " + this.spacing_units + "]";
            arrayList.add(object);
        }
        for (PathAndFillListener stringArray : this.listeners) {
            stringArray.setPathList(arrayList.toArray(new String[0]), path, bl);
        }
        int n = this.allFills.size();
        String[] stringArray = new String[n];
        for (int iterator = 0; iterator < n; ++iterator) {
            object = this.allFills.get(iterator);
            if (object == null) continue;
            String string = "Fill (" + iterator + ")";
            if (((Fill)object).sourcePaths != null && ((Fill)object).sourcePaths.size() > 0) {
                string = string + " from paths: ";
                Object[] objectArray = ((Fill)object).sourcePaths.toArray(new Path[0]);
                Arrays.sort(objectArray);
                for (int i = 0; i < objectArray.length; ++i) {
                    Integer n2;
                    Object object2 = objectArray[i];
                    if (i != 0) {
                        string = string + ", ";
                    }
                    string = (n2 = (Integer)hashtable.get(object2)) == null ? string + "(unknown)" : string + "(" + n2 + ")";
                }
            }
            stringArray[iterator] = string;
        }
        Iterator<PathAndFillListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().setFillList(stringArray);
        }
    }

    private int pathToIndex(Path path) {
        for (int i = 0; i < this.allPaths.size(); ++i) {
            Path path2 = this.allPaths.get(i);
            if (path != path2) continue;
            return i;
        }
        return -1;
    }

    public void addPath(Path path) {
        this.addPath(path, false);
    }

    public synchronized void addPath(Path path, boolean bl) {
        String string;
        if (this.getPathFromID(path.getID()) != null) {
            throw new RuntimeException("Attempted to add a path with an ID that was already added");
        }
        if (path.getID() < 0) {
            path.setID(++this.maxUsedID);
        }
        if (path.name == null || bl) {
            string = this.getDefaultName(path);
            path.setName(string);
        }
        String string2 = string = path.getName();
        int n = 2;
        while (this.getPathFromName(string2) != null) {
            string2 = string + " (" + n + ")";
            ++n;
        }
        path.setName(string2);
        if (this.plugin != null && this.plugin.use3DViewer) {
            path.removeFrom3DViewer(this.plugin.univ);
            path.addTo3DViewer(this.plugin.univ);
        }
        this.allPaths.add(path);
        this.resetListeners(path);
    }

    protected String getDefaultName(Path path) {
        if (path.getID() < 0) {
            throw new RuntimeException("A path's ID should never be negative");
        }
        return "Path (" + path.getID() + ")";
    }

    public synchronized void deletePath(int n) {
        this.deletePath(n, true);
    }

    public synchronized void deletePath(Path path) {
        int n = this.getPathIndex(path);
        if (n < 0) {
            throw new RuntimeException("Trying to delete a non-existent path: " + path);
        }
        this.deletePath(n);
    }

    public synchronized int getPathIndex(Path path) {
        int n = 0;
        for (n = 0; n < this.allPaths.size(); ++n) {
            if (path != this.allPaths.get(n)) continue;
            return n;
        }
        return -1;
    }

    private synchronized void deletePath(int n, boolean bl) {
        Path path = this.allPaths.get(n);
        Path path2 = null;
        Path path3 = null;
        if (path.fittedVersionOf == null) {
            path2 = path;
            path3 = path.fitted;
        } else {
            path2 = path.fittedVersionOf;
            path3 = path;
        }
        this.allPaths.remove(path2);
        if (path3 != null) {
            this.allPaths.remove(path3);
        }
        for (Path path4 : this.allPaths) {
            if (path4.startJoins == path2) {
                path4.startJoins = null;
                path4.startJoinsPoint = null;
            }
            if (path4.endJoins != path2) continue;
            path4.endJoins = null;
            path4.endJoinsPoint = null;
        }
        this.selectedPathsSet.remove(path3);
        this.selectedPathsSet.remove(path2);
        if (this.plugin != null && this.plugin.use3DViewer) {
            if (path3 != null && path3.content3D != null) {
                path3.removeFrom3DViewer(this.plugin.univ);
            }
            if (path2.content3D != null) {
                path2.removeFrom3DViewer(this.plugin.univ);
            }
        }
        if (bl) {
            this.resetListeners(null);
        }
    }

    public void deletePaths(int[] nArray) {
        Arrays.sort(nArray);
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.deletePath(nArray[i], false);
        }
        this.resetListeners(null);
    }

    public void addFill(Fill fill) {
        this.allFills.add(fill);
        this.resetListeners(null);
    }

    public void deleteFills(int[] nArray) {
        Arrays.sort(nArray);
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.deleteFill(nArray[i], false);
        }
        this.resetListeners(null);
    }

    public void deleteFill(int n) {
        this.deleteFill(n, true);
    }

    private synchronized void deleteFill(int n, boolean bl) {
        this.allFills.remove(n);
        if (bl) {
            this.resetListeners(null);
        }
    }

    public void reloadFill(int n) {
        Fill fill = this.allFills.get(n);
        this.plugin.startFillerThread(FillerThread.fromFill(this.plugin.getImagePlus(), this.plugin.stackMin, this.plugin.stackMax, true, fill));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeXML(String string, boolean bl) throws IOException {
        PrintWriter printWriter = null;
        try {
            printWriter = bl ? new PrintWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(string)), "UTF-8")) : new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.println("<!DOCTYPE tracings [");
            printWriter.println("  <!ELEMENT tracings       (samplespacing,imagesize,path*,fill*)>");
            printWriter.println("  <!ELEMENT imagesize      EMPTY>");
            printWriter.println("  <!ELEMENT samplespacing  EMPTY>");
            printWriter.println("  <!ELEMENT path           (point+)>");
            printWriter.println("  <!ELEMENT point          EMPTY>");
            printWriter.println("  <!ELEMENT fill           (node*)>");
            printWriter.println("  <!ELEMENT node           EMPTY>");
            printWriter.println("  <!ATTLIST samplespacing  x                 CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST samplespacing  y                 CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST samplespacing  z                 CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST samplespacing  units             CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST imagesize      width             CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST imagesize      height            CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST imagesize      depth             CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST path           id                CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST path           primary           CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST path           name              CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST path           startson          CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST path           startsindex       CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST path           startsx           CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST path           startsy           CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST path           startsz           CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST path           endson            CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST path           endsindex         CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST path           endsx             CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST path           endsy             CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST path           endsz             CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST path           reallength        CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST path           usefitted         (true|false)    #IMPLIED>");
            printWriter.println("  <!ATTLIST path           fitted            CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST path           fittedversionof   CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST point          x                 CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST point          y                 CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST point          z                 CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST point          xd                CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST point          yd                CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST point          zd                CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST point          tx                CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST point          ty                CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST point          tz                CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST point          r                 CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST fill           id                CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST fill           frompaths         CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST fill           metric            CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST fill           threshold         CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST node           id                CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST node           x                 CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST node           y                 CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST node           z                 CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST node           previousid        CDATA           #IMPLIED>");
            printWriter.println("  <!ATTLIST node           distance          CDATA           #REQUIRED>");
            printWriter.println("  <!ATTLIST node           status            (open|closed)   #REQUIRED>");
            printWriter.println("]>");
            printWriter.println("");
            printWriter.println("<tracings>");
            printWriter.println("  <samplespacing x=\"" + this.x_spacing + "\" " + "y=\"" + this.y_spacing + "\" " + "z=\"" + this.z_spacing + "\" " + "units=\"" + this.spacing_units + "\"/>");
            printWriter.println("  <imagesize width=\"" + this.width + "\" height=\"" + this.height + "\" depth=\"" + this.depth + "\"/>");
            Hashtable<Path, Integer> hashtable = new Hashtable<Path, Integer>();
            for (Path object : this.allPaths) {
                int n = object.getID();
                if (n < 0) {
                    throw new RuntimeException("In writeXML() there was a path with a negative ID (BUG)");
                }
                hashtable.put(object, n);
            }
            for (Path path : this.allPaths) {
                int n;
                int n2;
                printWriter.print("  <path id=\"" + path.getID() + "\"");
                String string2 = "";
                String string3 = "";
                if (path.startJoins != null) {
                    n2 = hashtable.get(path.startJoins);
                    n = path.startJoins.indexNearestTo(path.startJoinsPoint.x, path.startJoinsPoint.y, path.startJoinsPoint.z);
                    string2 = " startson=\"" + n2 + "\"" + " startsindex=\"" + n + "\"" + " startx=\"" + path.startJoinsPoint.x + "\"" + " starty=\"" + path.startJoinsPoint.y + "\"" + " startz=\"" + path.startJoinsPoint.z + "\"";
                }
                if (path.endJoins != null) {
                    n2 = hashtable.get(path.endJoins);
                    n = path.endJoins.indexNearestTo(path.endJoinsPoint.x, path.endJoinsPoint.y, path.endJoinsPoint.z);
                    string3 = " endson=\"" + n2 + "\"" + " endsindex=\"" + n + "\"" + " endsx=\"" + path.endJoinsPoint.x + "\"" + " endsy=\"" + path.endJoinsPoint.y + "\"" + " endsz=\"" + path.endJoinsPoint.z + "\"";
                }
                if (path.getPrimary()) {
                    printWriter.print(" primary=\"true\"");
                }
                printWriter.print(" usefitted=\"" + path.getUseFitted() + "\"");
                if (path.fitted != null) {
                    printWriter.print(" fitted=\"" + path.fitted.getID() + "\"");
                }
                if (path.fittedVersionOf != null) {
                    printWriter.print(" fittedversionof=\"" + path.fittedVersionOf.getID() + "\"");
                }
                printWriter.print(string2);
                printWriter.print(string3);
                if (path.name != null) {
                    printWriter.print(" name=\"" + PathAndFillManager.escapeForXMLAttributeValue(path.name) + "\"");
                }
                printWriter.print(" reallength=\"" + path.getRealLength() + "\"");
                printWriter.println(">");
                for (n2 = 0; n2 < path.size(); ++n2) {
                    n = path.getXUnscaled(n2);
                    int n3 = path.getYUnscaled(n2);
                    int n4 = path.getZUnscaled(n2);
                    double d = path.precise_x_positions[n2];
                    double d2 = path.precise_y_positions[n2];
                    double d3 = path.precise_z_positions[n2];
                    String string4 = "x=\"" + n + "\" " + "y=\"" + n3 + "\" z=\"" + n4 + "\" " + "xd=\"" + d + "\" yd=\"" + d2 + "\" zd=\"" + d3 + "\"";
                    if (path.hasCircles()) {
                        string4 = string4 + " tx=\"" + path.tangents_x[n2] + "\"";
                        string4 = string4 + " ty=\"" + path.tangents_y[n2] + "\"";
                        string4 = string4 + " tz=\"" + path.tangents_z[n2] + "\"";
                        string4 = string4 + " r=\"" + path.radiuses[n2] + "\"";
                    }
                    printWriter.println("    <point " + string4 + "/>");
                }
                printWriter.println("  </path>");
            }
            int n = 0;
            for (Fill fill : this.allFills) {
                fill.writeXML(printWriter, n, hashtable);
            }
            printWriter.println("</tracings>");
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws TracesFileFormatException {
        if (string3.equals("tracings")) {
            this.startJoins = new HashMap();
            this.startJoinsIndices = new HashMap();
            this.startJoinsPoints = new HashMap();
            this.endJoins = new HashMap();
            this.endJoinsIndices = new HashMap();
            this.endJoinsPoints = new HashMap();
            this.useFittedFields = new HashMap();
            this.fittedFields = new HashMap();
            this.fittedVersionOfFields = new HashMap();
            this.sourcePathIDForFills = new ArrayList();
            this.foundIDs = new HashSet();
            this.last_fill_id = -1;
            this.clearPathsAndFills();
            return;
        }
        if (string3.equals("imagesize")) {
            try {
                String string4 = attributes.getValue("width");
                String string5 = attributes.getValue("height");
                String string6 = attributes.getValue("depth");
                this.parsed_width = Integer.parseInt(string4);
                this.parsed_height = Integer.parseInt(string5);
                this.parsed_depth = Integer.parseInt(string6);
                if (this.parsed_width == this.width && this.parsed_height == this.height && this.parsed_depth == this.depth) return;
                throw new TracesFileFormatException("The image size in the traces file didn't match - it's probably for another image");
            }
            catch (NumberFormatException numberFormatException) {
                throw new TracesFileFormatException("There was an invalid attribute to <imagesize/>: " + numberFormatException);
            }
        }
        if (string3.equals("samplespacing")) {
            try {
                String string7 = attributes.getValue("x");
                String string8 = attributes.getValue("y");
                String string9 = attributes.getValue("z");
                this.parsed_units = attributes.getValue("units");
                this.parsed_x_spacing = Double.parseDouble(string7);
                this.parsed_y_spacing = Double.parseDouble(string8);
                this.parsed_z_spacing = Double.parseDouble(string9);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw new TracesFileFormatException("There was an invalid attribute to <samplespacing/>: " + numberFormatException);
            }
        }
        if (string3.equals("path")) {
            boolean bl;
            String string10 = attributes.getValue("id");
            String string11 = attributes.getValue("d");
            String string12 = attributes.getValue("usefitted");
            String string13 = attributes.getValue("fitted");
            String string14 = attributes.getValue("fittedversionof");
            String string15 = attributes.getValue("startson");
            String string16 = attributes.getValue("startsindex");
            String string17 = attributes.getValue("startsx");
            String string18 = attributes.getValue("startsy");
            String string19 = attributes.getValue("startsz");
            String string20 = attributes.getValue("endson");
            String string21 = attributes.getValue("endsindex");
            String string22 = attributes.getValue("endsx");
            String string23 = attributes.getValue("endsy");
            String string24 = attributes.getValue("endsz");
            String string25 = attributes.getValue("name");
            String string26 = attributes.getValue("primary");
            if (!(string17 == null && string18 == null && string19 == null || string17 != null && string18 != null && string19 != null)) {
                throw new TracesFileFormatException("If one of starts[xyz] is specified, all of them must be.");
            }
            if (!(string22 == null && string23 == null && string24 == null || string22 != null && string23 != null && string24 != null)) {
                throw new TracesFileFormatException("If one of ends[xyz] is specified, all of them must be.");
            }
            boolean bl2 = string17 != null;
            boolean bl3 = bl = string22 != null;
            if (string15 != null && string16 == null && !bl2) {
                throw new TracesFileFormatException("If startson is specified for a path, then startsindex or starts[xyz] must also be specified.");
            }
            if (string20 != null && string21 == null && !bl2) {
                throw new TracesFileFormatException("If endson is specified for a path, then endsindex or ends[xyz] must also be specified.");
            }
            this.current_path = new Path(this.x_spacing, this.y_spacing, this.z_spacing, this.spacing_units);
            Integer n = null;
            Integer n2 = null;
            PointInImage pointInImage = null;
            Integer n3 = null;
            Integer n4 = null;
            PointInImage pointInImage2 = null;
            Integer n5 = null;
            Integer n6 = null;
            if (string26 != null && string26.equals("true")) {
                this.current_path.setPrimary(true);
            }
            int n7 = -1;
            try {
                n7 = Integer.parseInt(string10);
                if (this.foundIDs.contains(n7)) {
                    throw new TracesFileFormatException("There is more than one path with ID " + n7);
                }
                this.current_path.setID(n7);
                if (n7 > this.maxUsedID) {
                    this.maxUsedID = n7;
                }
                if (string15 == null) {
                    int n8 = -1;
                    int n9 = -1;
                } else {
                    int n10 = Integer.parseInt(string15);
                    n = new Integer(n10);
                    if (string17 != null) {
                        pointInImage = new PointInImage(Double.parseDouble(string17), Double.parseDouble(string18), Double.parseDouble(string19));
                    } else {
                        int n11 = Integer.parseInt(string16);
                        n2 = new Integer(string16);
                    }
                }
                if (string20 == null) {
                    int n12 = -1;
                    int n13 = -1;
                } else {
                    int n14 = Integer.parseInt(string20);
                    n3 = new Integer(n14);
                    if (string22 != null) {
                        pointInImage2 = new PointInImage(Double.parseDouble(string22), Double.parseDouble(string23), Double.parseDouble(string24));
                    } else {
                        int n15 = Integer.parseInt(string21);
                        n4 = new Integer(n15);
                    }
                }
                if (string14 != null) {
                    n6 = new Integer(Integer.parseInt(string14));
                }
                if (string13 != null) {
                    n5 = new Integer(Integer.parseInt(string13));
                }
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                throw new TracesFileFormatException("There was an invalid attribute in <path/>: " + numberFormatException);
            }
            if (string25 == null) {
                this.current_path.setDefaultName();
            } else {
                this.current_path.setName(string25);
            }
            if (n != null) {
                this.startJoins.put(n7, n);
            }
            if (n3 != null) {
                this.endJoins.put(n7, n3);
            }
            if (pointInImage != null) {
                this.startJoinsPoints.put(n7, pointInImage);
            }
            if (pointInImage2 != null) {
                this.endJoinsPoints.put(n7, pointInImage2);
            }
            if (n2 != null) {
                this.startJoinsIndices.put(n7, n2);
            }
            if (n4 != null) {
                this.endJoinsIndices.put(n7, n4);
            }
            if (string12 == null) {
                this.useFittedFields.put(n7, false);
            } else if (string12.equals("true")) {
                this.useFittedFields.put(n7, true);
            } else {
                if (!string12.equals("false")) throw new TracesFileFormatException("Unknown value for 'fitted' attribute: '" + string12 + "'");
                this.useFittedFields.put(n7, false);
            }
            if (n5 != null) {
                this.fittedFields.put(n7, n5);
            }
            if (n6 == null) return;
            this.fittedVersionOfFields.put(n7, n6);
            return;
        }
        if (string3.equals("point")) {
            try {
                double d;
                double d2;
                double d3;
                String string27 = attributes.getValue("xd");
                String string28 = attributes.getValue("yd");
                String string29 = attributes.getValue("zd");
                String string30 = attributes.getValue("x");
                String string31 = attributes.getValue("y");
                String string32 = attributes.getValue("z");
                if (string27 != null && string28 != null && string29 != null) {
                    d3 = Double.parseDouble(string27);
                    d2 = Double.parseDouble(string28);
                    d = Double.parseDouble(string29);
                } else {
                    if (string27 != null || string28 != null || string29 != null) {
                        throw new TracesFileFormatException("If one of the attributes xd, yd or zd to the point element is specified, they all must be.");
                    }
                    if (string30 != null && string31 != null && string32 != null) {
                        d3 = this.parsed_x_spacing * (double)Integer.parseInt(string30);
                        d2 = this.parsed_y_spacing * (double)Integer.parseInt(string31);
                        d = this.parsed_z_spacing * (double)Integer.parseInt(string32);
                    } else {
                        if (string30 == null && string31 == null && string32 == null) throw new TracesFileFormatException("Each point element must have at least the attributes (x, y and z) or (xd, yd, zd)");
                        throw new TracesFileFormatException("If one of the attributes x, y or z to the point element is specified, they all must be.");
                    }
                }
                this.current_path.addPointDouble(d3, d2, d);
                int n = this.current_path.size() - 1;
                String string33 = attributes.getValue("r");
                String string34 = attributes.getValue("tx");
                String string35 = attributes.getValue("ty");
                String string36 = attributes.getValue("tz");
                if (string33 != null && string34 != null && string35 != null && string36 != null) {
                    if (n == 0) {
                        this.current_path.createCircles();
                    } else if (!this.current_path.hasCircles()) {
                        throw new TracesFileFormatException("The point at index " + n + " had a fitted circle, but none previously did");
                    }
                    this.current_path.tangents_x[n] = Double.parseDouble(string34);
                    this.current_path.tangents_y[n] = Double.parseDouble(string35);
                    this.current_path.tangents_z[n] = Double.parseDouble(string36);
                    this.current_path.radiuses[n] = Double.parseDouble(string33);
                    return;
                }
                if (string33 != null || string34 != null || string35 != null || string36 != null) {
                    throw new TracesFileFormatException("If one of the r, tx, ty or tz attributes to the point element is specified, they all must be");
                }
                if (!this.current_path.hasCircles()) return;
                throw new TracesFileFormatException("The point at index " + n + " had no fitted circle, but all previously did");
            }
            catch (NumberFormatException numberFormatException) {
                throw new TracesFileFormatException("There was an invalid attribute to <imagesize/>");
            }
        }
        if (string3.equals("fill")) {
            try {
                String[] stringArray = new String[]{};
                String string37 = attributes.getValue("frompaths");
                if (string37 != null) {
                    stringArray = string37.split(", *");
                }
                this.current_fill = new Fill();
                String string38 = attributes.getValue("metric");
                this.current_fill.setMetric(string38);
                this.last_fill_node_id = -1;
                String string39 = attributes.getValue("id");
                int n = Integer.parseInt(string39);
                if (n < 0) {
                    throw new TracesFileFormatException("Can't have a negative id in <fill>");
                }
                if (n != this.last_fill_id + 1) {
                    throw new TracesFileFormatException("Out of order id in <fill> (" + n + " when we were expecting " + (this.last_fill_id + 1) + ")");
                }
                int[] nArray = new int[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    nArray[i] = Integer.parseInt(stringArray[i]);
                }
                this.sourcePathIDForFills.add(nArray);
                this.last_fill_id = n;
                String string40 = attributes.getValue("threshold");
                double d = Double.parseDouble(string40);
                this.current_fill.setThreshold(d);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw new TracesFileFormatException("There was an invalid attribute to <fill>");
            }
        }
        if (!string3.equals("node")) throw new TracesFileFormatException("Unknown element: '" + string3 + "'");
        try {
            String string41 = attributes.getValue("x");
            String string42 = attributes.getValue("y");
            String string43 = attributes.getValue("z");
            String string44 = attributes.getValue("id");
            String string45 = attributes.getValue("distance");
            String string46 = attributes.getValue("previousid");
            int n = Integer.parseInt(string41);
            int n16 = Integer.parseInt(string42);
            int n17 = Integer.parseInt(string43);
            int n18 = Integer.parseInt(string44);
            double d = Double.parseDouble(string45);
            int n19 = string46 == null ? -1 : Integer.parseInt(string46);
            if (n18 != this.last_fill_node_id + 1) {
                throw new TracesFileFormatException("Fill node IDs weren't consecutive integers");
            }
            String string47 = attributes.getValue("status");
            this.current_fill.add(n, n16, n17, d, n19, string47.equals("open"));
            this.last_fill_node_id = n18;
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new TracesFileFormatException("There was an invalid attribute to <node/>: " + numberFormatException);
        }
    }

    public void addTo3DViewer(Path path) {
        if (this.plugin != null && this.plugin.use3DViewer && path.fittedVersionOf == null && path.size() > 1) {
            Path path2 = path.getUseFitted() ? path.fitted : path;
            path2.addTo3DViewer(this.plugin.univ, this.plugin.deselectedColor);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (string3.equals("path")) {
            this.allPaths.add(this.current_path);
        } else if (string3.equals("fill")) {
            this.allFills.add(this.current_fill);
        } else if (string3.equals("tracings")) {
            Path[] pathArray;
            Object object;
            Object object2;
            int n;
            for (n = 0; n < this.allPaths.size(); ++n) {
                Path path;
                object2 = this.allPaths.get(n);
                object = this.startJoins.get(((Path)object2).getID());
                pathArray = this.startJoinsIndices.get(((Path)object2).getID());
                PointInImage pointInImage = this.startJoinsPoints.get(((Path)object2).getID());
                Integer n2 = this.endJoins.get(((Path)object2).getID());
                Integer n3 = this.endJoinsIndices.get(((Path)object2).getID());
                PointInImage pointInImage2 = this.endJoinsPoints.get(((Path)object2).getID());
                Integer n4 = this.fittedFields.get(((Path)object2).getID());
                Integer n5 = this.fittedVersionOfFields.get(((Path)object2).getID());
                Boolean bl = this.useFittedFields.get(((Path)object2).getID());
                if (object != null) {
                    path = this.getPathFromID((Integer)object);
                    if (pointInImage == null) {
                        pointInImage = path.getPointInImage(pathArray.intValue());
                    }
                    ((Path)object2).setStartJoin(path, pointInImage);
                }
                if (n2 != null) {
                    path = this.getPathFromID(n2);
                    if (pointInImage2 == null) {
                        pointInImage2 = path.getPointInImage(n3);
                    }
                    ((Path)object2).setEndJoin(path, pointInImage2);
                }
                if (n4 != null) {
                    ((Path)object2).fitted = path = this.getPathFromID(n4);
                    ((Path)object2).setUseFitted(bl);
                }
                if (n5 != null) {
                    ((Path)object2).fittedVersionOf = path = this.getPathFromID(n5);
                }
                this.addTo3DViewer((Path)object2);
            }
            for (n = 0; n < this.allFills.size(); ++n) {
                object2 = this.allFills.get(n);
                object = this.sourcePathIDForFills.get(n);
                pathArray = new Path[((Object)object).length];
                for (int i = 0; i < ((Object)object).length; ++i) {
                    pathArray[i] = this.getPathFromID((int)object[i]);
                }
                ((Fill)object2).setSourcePaths(pathArray);
            }
            this.setSelected(new Path[0], this);
            this.resetListeners(null, true);
            if (this.plugin != null) {
                this.plugin.repaintAllPanes();
            }
        }
    }

    public boolean loadFromString(String string) {
        StringReader stringReader = new StringReader(string);
        boolean bl = this.load(null, stringReader);
        stringReader.close();
        return bl;
    }

    public boolean load(InputStream inputStream, Reader reader) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (inputStream != null) {
                sAXParser.parse(inputStream, (DefaultHandler)this);
            } else if (reader != null) {
                InputSource inputSource = new InputSource(reader);
                sAXParser.parse(inputSource, (DefaultHandler)this);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.clearPathsAndFills();
            IJ.error((String)("There was a ParserConfigurationException: " + parserConfigurationException));
            return false;
        }
        catch (SAXException sAXException) {
            this.clearPathsAndFills();
            IJ.error((String)sAXException.toString());
            return false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.clearPathsAndFills();
            IJ.error((String)("File not found: " + fileNotFoundException));
            return false;
        }
        catch (IOException iOException) {
            this.clearPathsAndFills();
            IJ.error((String)("There was an IO exception while reading the file: " + iOException));
            return false;
        }
        return true;
    }

    void clearPathsAndFills() {
        this.maxUsedID = -1;
        if (this.plugin != null && this.plugin.use3DViewer) {
            for (Path path : this.allPaths) {
                path.removeFrom3DViewer(this.plugin.univ);
            }
        }
        this.allPaths.clear();
        this.allFills.clear();
        this.resetListeners(null);
    }

    public boolean importSWC(BufferedReader bufferedReader) throws IOException {
        Object object;
        SWCPoint sWCPoint;
        SWCPoint sWCPoint2;
        String[] stringArray;
        Object object2;
        Object object3;
        String string;
        this.clearPathsAndFills();
        Pattern pattern = Pattern.compile("^\\s*$");
        Pattern pattern2 = Pattern.compile("^([^#]*)#.*$");
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashMap<Integer, SWCPoint> hashMap = new HashMap<Integer, SWCPoint>();
        ArrayList<SWCPoint> arrayList = new ArrayList<SWCPoint>();
        double d = Math.min(0.0 * this.x_spacing, (double)this.width * this.x_spacing);
        double d2 = Math.min(0.0 * this.y_spacing, (double)this.width * this.y_spacing);
        double d3 = Math.min(0.0 * this.z_spacing, (double)this.width * this.z_spacing);
        double d4 = Math.max(0.0 * this.x_spacing, (double)this.width * this.x_spacing);
        double d5 = Math.max(0.0 * this.y_spacing, (double)this.width * this.y_spacing);
        double d6 = Math.max(0.0 * this.z_spacing, (double)this.width * this.z_spacing);
        while ((string = bufferedReader.readLine()) != null) {
            object3 = pattern2.matcher(string);
            object2 = pattern.matcher(string = ((Matcher)object3).replaceAll("$1"));
            if (((Matcher)object2).matches()) continue;
            stringArray = string.split("\\s+");
            if (stringArray.length != 7) {
                IJ.error((String)("Wrong number of fields (" + stringArray.length + ") in line: " + string));
                return false;
            }
            try {
                SWCPoint sWCPoint3;
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                double d7 = Double.parseDouble(stringArray[2]);
                double d8 = Double.parseDouble(stringArray[3]);
                double d9 = Double.parseDouble(stringArray[4]);
                double d10 = Double.parseDouble(stringArray[5]);
                int n3 = Integer.parseInt(stringArray[6]);
                if (hashSet.contains(n)) {
                    IJ.error((String)("Point with ID " + n + " found more than once"));
                    return false;
                }
                hashSet.add(n);
                if (!(!(d7 < 0.0) || d7 >= d && d7 <= d4)) {
                    d7 = Math.abs(d7);
                }
                if (!(!(d8 < 0.0) || d8 >= d2 && d8 <= d5)) {
                    d8 = Math.abs(d8);
                }
                if (!(!(d9 < 0.0) || d9 >= d3 && d9 <= d6)) {
                    d9 = Math.abs(d9);
                }
                SWCPoint sWCPoint4 = new SWCPoint(n, n2, d7, d8, d9, d10, n3);
                hashMap.put(n, sWCPoint4);
                if (n3 == -1) {
                    arrayList.add(sWCPoint4);
                    continue;
                }
                sWCPoint4.previousPoint = sWCPoint3 = (SWCPoint)hashMap.get(n3);
                sWCPoint3.addNextPoint(sWCPoint4);
            }
            catch (NumberFormatException numberFormatException) {
                IJ.error((String)("There was a malformed number in line: " + string));
                return false;
            }
        }
        object3 = new HashMap();
        object2 = new PriorityQueue();
        for (SWCPoint sWCPoint5 : arrayList) {
            ((PriorityQueue)object2).add(sWCPoint5);
        }
        stringArray = new HashMap();
        HashMap<Path, PointInImage> hashMap2 = new HashMap<Path, PointInImage>();
        while ((sWCPoint2 = (SWCPoint)((PriorityQueue)object2).poll()) != null) {
            SWCPoint sWCPoint6;
            Path path = new Path(this.x_spacing, this.y_spacing, this.z_spacing, this.spacing_units);
            path.createCircles();
            int n = 0;
            if (sWCPoint2.previousPoint != null) {
                sWCPoint6 = sWCPoint2.previousPoint;
                stringArray.put(path, sWCPoint6);
                hashMap2.put(path, sWCPoint6.getPointInImage());
                path.addPointDouble(sWCPoint6.x, sWCPoint6.y, sWCPoint6.z);
                path.radiuses[n] = sWCPoint6.radius;
                ++n;
            }
            sWCPoint6 = sWCPoint2;
            while (sWCPoint6 != null) {
                path.addPointDouble(sWCPoint6.x, sWCPoint6.y, sWCPoint6.z);
                path.radiuses[n] = sWCPoint6.radius;
                ++n;
                ((HashMap)object3).put(sWCPoint6, path);
                hashSet.remove(sWCPoint6.id);
                if (sWCPoint6.nextPoints.size() > 0) {
                    sWCPoint = sWCPoint6.nextPoints.get(0);
                    sWCPoint6.nextPoints.remove(0);
                    for (int i = 0; i < sWCPoint6.nextPoints.size(); ++i) {
                        object = sWCPoint6.nextPoints.get(i);
                        ((PriorityQueue)object2).add(object);
                    }
                    sWCPoint6 = sWCPoint;
                    continue;
                }
                sWCPoint6 = null;
            }
            path.setGuessedTangents(2);
            this.addPath(path);
        }
        if (hashSet.size() > 0) {
            IJ.error((String)"Malformed file: there are some misconnected points");
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                SWCPoint sWCPoint7 = (SWCPoint)hashMap.get(iterator.next());
                System.out.println("  Misconnected: " + sWCPoint7);
            }
            return false;
        }
        for (Path path : this.allPaths) {
            sWCPoint = (SWCPoint)stringArray.get(path);
            if (sWCPoint == null) continue;
            Path path2 = (Path)((HashMap)object3).get(sWCPoint);
            object = (PointInImage)hashMap2.get(path);
            path.setStartJoin(path2, (PointInImage)object);
        }
        for (Path path : this.allPaths) {
            this.addTo3DViewer(path);
        }
        this.resetListeners(null, true);
        return true;
    }

    public boolean importSWC(String string) {
        File file = new File(string);
        if (!file.exists()) {
            IJ.error((String)("The traces file '" + string + "' does not exist."));
            return false;
        }
        BufferedInputStream bufferedInputStream = null;
        boolean bl = false;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, "UTF-8"));
            bl = this.importSWC(bufferedReader);
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (IOException iOException) {
            IJ.error((String)("Couldn't open file '" + string + "' for reading."));
            return false;
        }
        return bl;
    }

    public boolean load(String string) {
        InputStream inputStream;
        File file = new File(string);
        if (!file.exists()) {
            IJ.error((String)("The traces file '" + string + "' does not exist."));
            return false;
        }
        boolean bl = false;
        try {
            byte[] byArray = new byte[2];
            inputStream = new FileInputStream(string);
            inputStream.read(byArray, 0, 2);
            inputStream.close();
            if ((byArray[0] & 0xFF) == 31 && (byArray[1] & 0xFF) == 139) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            IJ.error((String)("Couldn't read from file: " + string));
            return false;
        }
        inputStream = null;
        boolean bl2 = false;
        try {
            inputStream = bl ? new GZIPInputStream(new BufferedInputStream(new FileInputStream(string))) : new BufferedInputStream(new FileInputStream(string));
            bl2 = this.load(inputStream, null);
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            IJ.error((String)("Couldn't open file '" + string + "' for reading."));
            return false;
        }
        return bl2;
    }

    synchronized void setPathPointsInVolume(byte[][] byArray, int n, int n2, int n3) {
        for (Path path : this.allPaths) {
            for (int i = 0; i < path.size(); ++i) {
                byArray[path.getZUnscaled((int)i)][path.getYUnscaled((int)i) * n + path.getXUnscaled((int)i)] = -1;
            }
        }
    }

    synchronized PointInImage nearestJoinPointOnSelectedPaths(double d, double d2, double d3) {
        PointInImage pointInImage = null;
        double d4 = Double.MAX_VALUE;
        int n = this.allPaths.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            PointInImage pointInImage2;
            double d5;
            Path path = this.allPaths.get(i);
            if (!this.selectedPathsSet.contains(path) || 0 == path.size() || !((d5 = (pointInImage2 = path.getPointInImage(n2 = path.indexNearestTo(d * this.x_spacing, d2 * this.y_spacing, d3 * this.z_spacing))).distanceSquaredTo(d * this.x_spacing, d2 * this.y_spacing, d3 * this.z_spacing)) < d4)) continue;
            pointInImage = pointInImage2;
            d4 = d5;
        }
        return pointInImage;
    }

    @Deprecated
    ArrayList<Path> getAllPaths() {
        return this.allPaths;
    }

    @Override
    public void transformationStarted(View view) {
    }

    @Override
    public void transformationUpdated(View view) {
    }

    @Override
    public void transformationFinished(View view) {
    }

    @Override
    public void contentAdded(Content content) {
    }

    @Override
    public void contentRemoved(Content content) {
    }

    @Override
    public void contentChanged(Content content) {
    }

    @Override
    public void contentSelected(Content content) {
    }

    @Override
    public void canvasResized() {
    }

    @Override
    public void universeClosed() {
        this.plugin.use3DViewer = false;
    }

    private static void replaceAll(StringBuffer stringBuffer, String string, String string2) {
        int n;
        int n2 = 0;
        while ((n = stringBuffer.indexOf(string, n2)) >= 0) {
            int n3 = n + string.length();
            stringBuffer.replace(n, n3, string2);
            n2 = n3;
        }
    }

    public static String escapeForXMLAttributeValue(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        PathAndFillManager.replaceAll(stringBuffer, "&", "&amp;");
        PathAndFillManager.replaceAll(stringBuffer, "<", "&lt;");
        PathAndFillManager.replaceAll(stringBuffer, ">", "&gt;");
        PathAndFillManager.replaceAll(stringBuffer, "'", "&apos;");
        PathAndFillManager.replaceAll(stringBuffer, "\"", "&quot;");
        return stringBuffer.toString();
    }

    public NearPoint nearestPointOnAnyPath(double d, double d2, double d3, double d4) {
        double d5;
        PriorityQueue<NearPoint> priorityQueue = new PriorityQueue<NearPoint>();
        Object object = this.allPaths.iterator();
        while (object.hasNext()) {
            Path path = object.next();
            if (path.useFitted || path.fittedVersionOf != null && !path.fittedVersionOf.useFitted) continue;
            for (int i = 0; i < path.size(); ++i) {
                priorityQueue.add(new NearPoint(d, d2, d3, path, i));
            }
        }
        do {
            if ((object = (NearPoint)priorityQueue.poll()) == null) {
                return null;
            }
            if (!(((NearPoint)object).distanceToPathPointSquared() > d4 * d4)) continue;
            return null;
        } while (!((d5 = ((NearPoint)object).distanceToPathNearPoint()) >= 0.0));
        return object;
    }

    public AllPointsIterator allPointsIterator() {
        return new AllPointsIterator();
    }

    public int pointsInAllPaths() {
        AllPointsIterator allPointsIterator = this.allPointsIterator();
        int n = 0;
        while (allPointsIterator.hasNext()) {
            allPointsIterator.next();
            ++n;
        }
        return n;
    }

    public ArrayList<NearPoint> getCorrespondences(PathAndFillManager pathAndFillManager, double d) {
        ArrayList<NearPoint> arrayList = new ArrayList<NearPoint>();
        AllPointsIterator allPointsIterator = this.allPointsIterator();
        boolean bl = false;
        while (allPointsIterator.hasNext()) {
            PointInImage pointInImage = allPointsIterator.next();
            NearPoint nearPoint = pathAndFillManager.nearestPointOnAnyPath(pointInImage.x, pointInImage.y, pointInImage.z, d);
            arrayList.add(nearPoint);
        }
        return arrayList;
    }

    public static String stringForCSV(String string) {
        boolean bl = false;
        String string2 = string;
        if (string.indexOf(44) >= 0) {
            bl = true;
        }
        if (string.indexOf(34) >= 0) {
            System.out.println("ooh, got a quote..");
            bl = true;
            string2 = string.replaceAll("\"", "\"\"");
            System.out.println("result is now: " + string2);
        }
        if (bl) {
            return "\"" + string2 + "\"";
        }
        return string2;
    }

    public void exportToCSV(File file) throws IOException {
        String[] stringArray = new String[]{"PathID", "PathName", "PrimaryPath", "PathLength", "PathLengthUnits", "StartsOnPath", "EndsOnPath", "ConnectedPathIDs", "ChildPathIDs"};
        Path[] pathArray = this.getPathsStructured();
        HashSet<Path> hashSet = new HashSet<Path>();
        for (int i = 0; i < pathArray.length; ++i) {
            hashSet.add(pathArray[i]);
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsolutePath()), "UTF-8"));
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            printWriter.print(PathAndFillManager.stringForCSV(stringArray[i]));
            if (i >= n - 1) continue;
            printWriter.print(",");
        }
        printWriter.print("\r\n");
        Iterator<Path> iterator = this.allPaths.iterator();
        while (iterator.hasNext()) {
            Path path;
            Path path2 = path = iterator.next();
            if (path.getUseFitted()) {
                path2 = path.fitted;
            }
            if (path.fittedVersionOf != null) continue;
            printWriter.print(PathAndFillManager.stringForCSV("" + path.getID()));
            printWriter.print(",");
            printWriter.print(PathAndFillManager.stringForCSV("" + path2.getName()));
            printWriter.print(",");
            boolean bl = hashSet.contains(path);
            printWriter.print(PathAndFillManager.stringForCSV("" + bl));
            printWriter.print(",");
            printWriter.print(PathAndFillManager.stringForCSV("" + path2.getRealLength()));
            printWriter.print(",");
            printWriter.print(PathAndFillManager.stringForCSV("" + path.spacing_units));
            printWriter.print(",");
            if (path.startJoins != null) {
                printWriter.print("" + path.startJoins.getID());
            }
            printWriter.print(",");
            if (path.endJoins != null) {
                printWriter.print("" + path.endJoins.getID());
            }
            printWriter.print(",");
            printWriter.print(PathAndFillManager.stringForCSV(path.somehowJoinsAsString()));
            printWriter.print(",");
            printWriter.print(PathAndFillManager.stringForCSV(path.childrenAsString()));
            printWriter.print("\r\n");
            printWriter.flush();
        }
        printWriter.close();
    }

    public void update3DViewerContents() {
        if (this.plugin != null && !this.plugin.use3DViewer) {
            return;
        }
        boolean bl = this.plugin.getShowOnlySelectedPaths();
        for (Path path : this.allPaths) {
            if (path.fittedVersionOf != null) continue;
            Content content = null;
            Content content2 = null;
            if (path.getUseFitted()) {
                content = path.fitted.content3D;
                content2 = path.content3D;
            } else {
                content = path.content3D;
                if (path.fitted != null) {
                    content2 = path.fitted.content3D;
                }
            }
            boolean bl2 = path.getSelected();
            if (content == null) {
                throw new RuntimeException("content3D should never be null for any path if use3DViewer is true");
            }
            String string = content.getName();
            Color3f color3f = content.getColor();
            String string2 = null;
            if (content2 != null) {
                string2 = content2.getName();
            }
            if (bl2 && !color3f.equals((Tuple3f)this.plugin.selectedColor3f)) {
                content.setColor(this.plugin.selectedColor3f);
            }
            if (!bl2 && !color3f.equals((Tuple3f)this.plugin.deselectedColor3f)) {
                content.setColor(this.plugin.deselectedColor3f);
            }
            boolean bl3 = this.plugin.univ.contains(string);
            if (bl2 || !bl) {
                if (!bl3) {
                    this.plugin.univ.resetView();
                    this.plugin.univ.addContent(content);
                    content.setLocked(true);
                    this.plugin.univ.resetView();
                }
            } else if (bl3) {
                this.plugin.univ.removeContent(string);
            }
            if (string2 == null || !this.plugin.univ.contains(string2)) continue;
            this.plugin.univ.removeContent(string2);
        }
    }

    public PathAndFillManager transformPaths(PathTransformer pathTransformer, ImagePlus imagePlus) {
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        String string = "pixels";
        Calibration calibration = imagePlus.getCalibration();
        if (calibration != null) {
            d = calibration.pixelWidth;
            d2 = calibration.pixelHeight;
            d3 = calibration.pixelDepth;
            string = calibration.getUnits();
        }
        PathAndFillManager pathAndFillManager = new PathAndFillManager(imagePlus.getWidth(), imagePlus.getHeight(), imagePlus.getStackSize(), (float)d, (float)d2, (float)d3, string);
        int[] nArray = new int[this.size()];
        int[] nArray2 = new int[this.size()];
        PointInImage[] pointInImageArray = new PointInImage[this.size()];
        PointInImage[] pointInImageArray2 = new PointInImage[this.size()];
        Path[] pathArray = new Path[this.size()];
        int n = 0;
        for (Path path : this.allPaths) {
            Path path2;
            Path path3 = path.getStartJoins();
            if (path3 == null) {
                nArray[n] = -1;
                pointInImageArray2[n] = null;
            } else {
                nArray[n] = this.allPaths.indexOf(path3);
                pointInImageArray[n] = path.getStartJoinsPoint().transform(pathTransformer);
            }
            Path path4 = path.getEndJoins();
            if (path4 == null) {
                nArray2[n] = -1;
                pointInImageArray2[n] = null;
            } else {
                nArray2[n] = this.allPaths.indexOf(path4);
                pointInImageArray2[n] = path.getEndJoinsPoint().transform(pathTransformer);
            }
            pathArray[n] = path2 = path.transform(pathTransformer, imagePlus, this.imagePlus);
            pathAndFillManager.addPath(path2);
            ++n;
        }
        for (n = 0; n < this.size(); ++n) {
            if (nArray[n] >= 0) {
                pathArray[n].setStartJoin(pathArray[nArray[n]], pointInImageArray[n]);
            }
            if (nArray2[n] < 0) continue;
            pathArray[n].setEndJoin(pathArray[nArray2[n]], pointInImageArray2[n]);
        }
        return pathAndFillManager;
    }

    public class AllPointsIterator
    implements Iterator {
        int numberOfPaths;
        Path currentPath;
        int currentPathIndex;
        int currentPointIndex;

        public AllPointsIterator() {
            this.numberOfPaths = PathAndFillManager.this.allPaths.size();
            this.currentPath = null;
            this.currentPathIndex = -1;
            this.currentPointIndex = -1;
        }

        public boolean hasNext() {
            if (this.currentPath == null || this.currentPointIndex == this.currentPath.points - 1) {
                int n = this.currentPathIndex + 1;
                while (n < this.numberOfPaths) {
                    Path path = PathAndFillManager.this.allPaths.get(n);
                    if (path.size() <= 0) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        public PointInImage next() {
            if (this.currentPath == null || this.currentPointIndex == this.currentPath.points - 1) {
                this.currentPointIndex = 0;
                do {
                    ++this.currentPathIndex;
                    if (this.currentPathIndex == this.numberOfPaths) {
                        throw new NoSuchElementException();
                    }
                    this.currentPath = PathAndFillManager.this.allPaths.get(this.currentPathIndex);
                } while (this.currentPath.size() <= 0);
            } else {
                ++this.currentPointIndex;
            }
            return this.currentPath.getPointInImage(this.currentPointIndex);
        }

        public void remove() {
            throw new UnsupportedOperationException("AllPointsIterator does not allow the removal of points");
        }
    }

    private static class SWCPoint
    implements Comparable {
        ArrayList<SWCPoint> nextPoints = new ArrayList();
        SWCPoint previousPoint;
        int id;
        int type;
        int previous;
        double x;
        double y;
        double z;
        double radius;

        public SWCPoint(int n, int n2, double d, double d2, double d3, double d4, int n3) {
            this.id = n;
            this.type = n2;
            this.x = d;
            this.y = d2;
            this.z = d3;
            this.radius = d4;
            this.previous = n3;
        }

        public PointInImage getPointInImage() {
            return new PointInImage(this.x, this.y, this.z);
        }

        public void addNextPoint(SWCPoint sWCPoint) {
            if (!this.nextPoints.contains(sWCPoint)) {
                this.nextPoints.add(sWCPoint);
            }
        }

        public void setPreviousPoint(SWCPoint sWCPoint) {
            this.previousPoint = sWCPoint;
        }

        public String toString() {
            return "SWCPoint [" + this.id + "] " + Path.swcTypeNames[this.type] + " " + "(" + this.x + "," + this.y + "," + this.z + ") " + "radius: " + this.radius + ", " + "[previous: " + this.previous + "]";
        }

        public int compareTo(Object object) {
            int n = ((SWCPoint)object).id;
            return this.id < n ? -1 : (this.id > n ? 1 : 0);
        }
    }
}

