/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import tracing.Path;

public class SearchNode
implements Comparable {
    public int x;
    public int y;
    public int z;
    public float g;
    public float h;
    public float f;
    private SearchNode predecessor;
    public byte searchStatus;

    public SearchNode getPredecessor() {
        return this.predecessor;
    }

    public void setPredecessor(SearchNode searchNode) {
        this.predecessor = searchNode;
    }

    public SearchNode(int n, int n2, int n3, float f, float f2, SearchNode searchNode, byte by) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.g = f;
        this.h = f2;
        this.f = f + f2;
        this.predecessor = searchNode;
        this.searchStatus = by;
    }

    public boolean equals(Object object) {
        SearchNode searchNode = (SearchNode)object;
        return this.x == searchNode.x && this.y == searchNode.y && this.z == searchNode.z;
    }

    public int hashCode() {
        int n = 3;
        n = 67 * n + this.x;
        n = 67 * n + this.y;
        n = 67 * n + this.z;
        return n;
    }

    public void setFrom(SearchNode searchNode) {
        this.x = searchNode.x;
        this.y = searchNode.y;
        this.z = searchNode.z;
        this.g = searchNode.g;
        this.h = searchNode.h;
        this.f = searchNode.f;
        this.predecessor = searchNode.predecessor;
        this.searchStatus = searchNode.searchStatus;
    }

    public int compareTo(Object object) {
        SearchNode searchNode = (SearchNode)object;
        int n = 0;
        if (this.f > searchNode.f) {
            n = 1;
        } else if (this.f < searchNode.f) {
            n = -1;
        }
        if (n != 0) {
            return n;
        }
        int n2 = 0;
        if (this.x > searchNode.x) {
            n2 = 1;
        }
        if (this.x < searchNode.x) {
            n2 = -1;
        }
        if (n2 != 0) {
            return n2;
        }
        int n3 = 0;
        if (this.y > searchNode.y) {
            n3 = 1;
        }
        if (this.y < searchNode.y) {
            n3 = -1;
        }
        if (n3 != 0) {
            return n3;
        }
        int n4 = 0;
        if (this.z > searchNode.z) {
            n4 = 1;
        }
        if (this.z < searchNode.z) {
            n4 = -1;
        }
        return n4;
    }

    public String toString() {
        String string = "BUG: unknown!";
        if (this.searchStatus == 1) {
            string = "open from start";
        } else if (this.searchStatus == 2) {
            string = "closed from start";
        } else if (this.searchStatus == 3) {
            string = "open from goal";
        } else if (this.searchStatus == 4) {
            string = "closed from goal";
        } else if (this.searchStatus == 5) {
            string = "free";
        }
        return "(" + this.x + "," + this.y + "," + this.z + ") h: " + this.h + " g: " + this.g + " f: " + this.f + " [" + string + "]";
    }

    public Path asPath(double d, double d2, double d3, String string) {
        Path path = new Path(d, d2, d3, string);
        SearchNode searchNode = this;
        do {
            path.addPointDouble((double)searchNode.x * d, (double)searchNode.y * d2, (double)searchNode.z * d3);
        } while ((searchNode = searchNode.predecessor) != null);
        return path.reversed();
    }

    public Path asPathReversed(double d, double d2, double d3, String string) {
        Path path = new Path(d, d2, d3, string);
        SearchNode searchNode = this;
        do {
            path.addPointDouble((double)searchNode.x * d, (double)searchNode.y * d2, (double)searchNode.z * d3);
        } while ((searchNode = searchNode.predecessor) != null);
        return path;
    }
}

