/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.PriorityQueue;
import tracing.Path;
import tracing.SearchNode;
import tracing.SearchProgressCallback;
import tracing.TracerCanvas;

public abstract class SearchThread
extends Thread {
    boolean verbose = false;
    public static final byte OPEN_FROM_START = 1;
    public static final byte CLOSED_FROM_START = 2;
    public static final byte OPEN_FROM_GOAL = 3;
    public static final byte CLOSED_FROM_GOAL = 4;
    public static final byte FREE = 5;
    Color openColor;
    Color closedColor;
    float drawingThreshold;
    protected double minimum_cost_per_unit_distance;
    byte[][] slices_data_b;
    short[][] slices_data_s;
    float[][] slices_data_f;
    ImagePlus imagePlus;
    float x_spacing;
    float y_spacing;
    float z_spacing;
    String spacing_units;
    int width;
    int height;
    int depth;
    boolean bidirectional;
    boolean definedGoal;
    boolean startPaused;
    int timeoutSeconds;
    long reportEveryMilliseconds;
    long lastReportMilliseconds;
    ArrayList<SearchProgressCallback> progressListeners;
    private int threadStatus = 1;
    public static final int RUNNING = 0;
    public static final int PAUSED = 1;
    public static final int STOPPING = 2;
    int imageType = -1;
    float stackMin;
    float stackMax;
    PriorityQueue<SearchNode> closed_from_start;
    PriorityQueue<SearchNode> open_from_start;
    PriorityQueue<SearchNode> closed_from_goal;
    PriorityQueue<SearchNode> open_from_goal;
    SearchNode[][] nodes_as_image;
    public static int SUCCESS = 0;
    public static int CANCELLED = 1;
    public static int TIMED_OUT = 2;
    public static int POINTS_EXHAUSTED = 3;
    public static int OUT_OF_MEMORY = 4;
    public static String[] exitReasonStrings = new String[]{"SUCCESS", "CANCELLED", "TIMED_OUT", "POINTS_EXHAUSTED", "OUT_OF_MEMORY"};
    protected int exitReason;

    protected double costMovingTo(int n, int n2, int n3) {
        double d = -1.0;
        switch (this.imageType) {
            case 0: 
            case 3: {
                d = this.slices_data_b[n3][n2 * this.width + n] & 0xFF;
                break;
            }
            case 1: {
                d = this.slices_data_s[n3][n2 * this.width + n];
                d = 255.0 * (d - (double)this.stackMin) / (double)(this.stackMax - this.stackMin);
                break;
            }
            case 2: {
                d = this.slices_data_f[n3][n2 * this.width + n];
                d = 255.0 * (d - (double)this.stackMin) / (double)(this.stackMax - this.stackMin);
            }
        }
        if (d == 0.0) {
            return 2.0;
        }
        return 1.0 / d;
    }

    protected void reportPointsInSearch() {
        for (SearchProgressCallback searchProgressCallback : this.progressListeners) {
            searchProgressCallback.pointsInSearch(this, this.open_from_start.size() + (this.bidirectional ? this.open_from_goal.size() : 0), this.closed_from_start.size() + (this.bidirectional ? this.closed_from_goal.size() : 0));
        }
    }

    public int pointsConsideredInSearch() {
        return this.open_from_start.size() + (this.bidirectional ? this.open_from_goal.size() : 0) + this.closed_from_start.size() + (this.bidirectional ? this.closed_from_goal.size() : 0);
    }

    protected SearchNode createNewNode(int n, int n2, int n3, float f, float f2, SearchNode searchNode, byte by) {
        return new SearchNode(n, n2, n3, f, f2, searchNode, by);
    }

    protected void foundGoal(Path path) {
    }

    protected boolean atStart(int n, int n2, int n3) {
        return false;
    }

    protected boolean atGoal(int n, int n2, int n3) {
        return false;
    }

    void setDrawingColors(Color color, Color color2) {
        this.openColor = color;
        this.closedColor = color2;
    }

    void setDrawingThreshold(float f) {
        this.drawingThreshold = f;
    }

    protected double minimumCostPerUnitDistance() {
        return 0.0;
    }

    public void addProgressListener(SearchProgressCallback searchProgressCallback) {
        this.progressListeners.add(searchProgressCallback);
    }

    public int getThreadStatus() {
        return this.threadStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestStop() {
        if (this.verbose) {
            System.out.println("requestStop called, about to enter synchronized");
        }
        SearchThread searchThread = this;
        synchronized (searchThread) {
            if (this.verbose) {
                System.out.println("... entered synchronized");
            }
            if (this.threadStatus == 1) {
                if (this.verbose) {
                    System.out.println("was paused so interrupting");
                }
                this.interrupt();
                if (this.verbose) {
                    System.out.println("done interrupting");
                }
            }
            this.threadStatus = 2;
            this.reportThreadStatus();
            if (this.verbose) {
                System.out.println("... leaving synchronized");
            }
        }
        if (this.verbose) {
            System.out.println("requestStop finished (threadStatus now " + this.threadStatus + ")");
        }
    }

    protected void addingNode(SearchNode searchNode) {
    }

    public void reportThreadStatus() {
        for (SearchProgressCallback searchProgressCallback : this.progressListeners) {
            searchProgressCallback.threadStatus(this, this.threadStatus);
        }
    }

    public void reportFinished(boolean bl) {
        for (SearchProgressCallback searchProgressCallback : this.progressListeners) {
            searchProgressCallback.finished(this, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseOrUnpause() {
        if (this.verbose) {
            System.out.println("pauseOrUnpause called, about to enter synchronized");
        }
        SearchThread searchThread = this;
        synchronized (searchThread) {
            if (this.verbose) {
                System.out.println("... entered synchronized");
            }
            switch (this.threadStatus) {
                case 1: {
                    if (this.verbose) {
                        System.out.println("paused, going to switch to running - interrupting first");
                    }
                    this.interrupt();
                    if (this.verbose) {
                        System.out.println("finished interrupting");
                    }
                    this.threadStatus = 0;
                    break;
                }
                case 0: {
                    if (this.verbose) {
                        System.out.println("running, going to switch to paused");
                    }
                    this.threadStatus = 1;
                    break;
                }
            }
            this.reportThreadStatus();
            if (this.verbose) {
                System.out.println("... leaving synchronized");
            }
        }
        if (this.verbose) {
            System.out.println("pauseOrUnpause finished");
        }
    }

    public SearchThread(ImagePlus imagePlus, float f, float f2, boolean bl, boolean bl2, boolean bl3, int n, long l) {
        this.imagePlus = imagePlus;
        this.stackMin = f;
        this.stackMax = f2;
        this.bidirectional = bl;
        this.definedGoal = bl2;
        this.startPaused = bl3;
        this.imageType = imagePlus.getType();
        this.width = imagePlus.getWidth();
        this.height = imagePlus.getHeight();
        this.depth = imagePlus.getStackSize();
        ImageStack imageStack = imagePlus.getStack();
        switch (this.imageType) {
            case 0: 
            case 3: {
                this.slices_data_b = new byte[this.depth][];
                for (int i = 0; i < this.depth; ++i) {
                    this.slices_data_b[i] = (byte[])imageStack.getPixels(i + 1);
                }
                break;
            }
            case 1: {
                this.slices_data_s = new short[this.depth][];
                for (int i = 0; i < this.depth; ++i) {
                    this.slices_data_s[i] = (short[])imageStack.getPixels(i + 1);
                }
                break;
            }
            case 2: {
                this.slices_data_f = new float[this.depth][];
                for (int i = 0; i < this.depth; ++i) {
                    this.slices_data_f[i] = (float[])imageStack.getPixels(i + 1);
                }
                break;
            }
        }
        imageStack = imagePlus.getCalibration();
        this.x_spacing = (float)imageStack.pixelWidth;
        this.y_spacing = (float)imageStack.pixelHeight;
        this.z_spacing = (float)imageStack.pixelDepth;
        this.spacing_units = imageStack.getUnit();
        if ((double)this.x_spacing == 0.0 || (double)this.y_spacing == 0.0 || (double)this.z_spacing == 0.0) {
            IJ.error((String)("SearchThread: One dimension of the calibration information was zero: (" + this.x_spacing + "," + this.y_spacing + "," + this.z_spacing + ")"));
            return;
        }
        this.timeoutSeconds = n;
        this.reportEveryMilliseconds = l;
        this.closed_from_start = new PriorityQueue();
        this.open_from_start = new PriorityQueue();
        if (bl) {
            this.closed_from_goal = new PriorityQueue();
            this.open_from_goal = new PriorityQueue();
        }
        this.nodes_as_image = new SearchNode[this.depth][];
        this.minimum_cost_per_unit_distance = this.minimumCostPerUnitDistance();
        this.progressListeners = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            SearchThread searchThread;
            if (this.verbose) {
                System.out.println("New SearchThread running!");
            }
            if (this.verbose) {
                System.out.println("... with " + this.open_from_start.size() + " open nodes at the start");
            }
            if (this.verbose) {
                System.out.println(" ... and " + this.closed_from_start.size() + " closed nodes at the start");
            }
            if (this.bidirectional) {
                if (this.verbose) {
                    System.out.println("... with " + this.open_from_goal.size() + " open nodes at the goal");
                }
                if (this.verbose) {
                    System.out.println(" ... and " + this.closed_from_goal.size() + " closed nodes at the goal");
                }
            } else if (this.verbose) {
                System.out.println(" ... unidirectional search");
            }
            if (this.startPaused) {
                if (this.verbose) {
                    System.out.println("... was asked to start it in the paused state.");
                }
            } else if (this.verbose) {
                System.out.println("... was asked to start it unpaused.");
            }
            if (this.startPaused) {
                searchThread = this;
                synchronized (searchThread) {
                    this.threadStatus = 1;
                    this.reportThreadStatus();
                }
            }
            searchThread = this;
            synchronized (searchThread) {
                this.threadStatus = 0;
                this.reportThreadStatus();
            }
            long l = this.lastReportMilliseconds = System.currentTimeMillis();
            int n = 0;
            int n2 = 0;
            while (this.open_from_start.size() > 0 || this.bidirectional && this.open_from_goal.size() > 0) {
                int n3;
                if (this.threadStatus == 2) {
                    this.reportThreadStatus();
                    this.setExitReason(CANCELLED);
                    this.reportFinished(false);
                    return;
                }
                if (this.threadStatus == 1) {
                    try {
                        this.reportThreadStatus();
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (0 == n2 % 1000) {
                    long l2 = System.currentTimeMillis();
                    long l3 = l2 - l;
                    if (this.timeoutSeconds > 0 && l3 > (long)(1000 * this.timeoutSeconds)) {
                        if (this.verbose) {
                            System.out.println("Timed out...");
                        }
                        this.setExitReason(TIMED_OUT);
                        this.reportFinished(false);
                        return;
                    }
                    long l4 = l2 - this.lastReportMilliseconds;
                    if (this.reportEveryMilliseconds > 0L && l4 > this.reportEveryMilliseconds) {
                        n3 = n2 - n;
                        if (this.verbose) {
                            System.out.println("milliseconds per loop: " + (double)l4 / (double)n3);
                        }
                        this.reportPointsInSearch();
                        n = n2;
                    }
                }
                boolean bl = false;
                SearchNode searchNode = null;
                SearchNode searchNode2 = null;
                if (this.open_from_start.size() > 0) {
                    searchNode = this.open_from_start.poll();
                    this.nodes_as_image[searchNode.z][searchNode.y * this.width + searchNode.x] = null;
                }
                if (this.bidirectional && this.open_from_goal.size() > 0) {
                    searchNode2 = this.open_from_goal.poll();
                    this.nodes_as_image[searchNode2.z][searchNode2.y * this.width + searchNode2.x] = null;
                }
                if (this.definedGoal && searchNode != null && this.atGoal(searchNode.x, searchNode.y, searchNode.z)) {
                    if (bl) {
                        System.out.println("Found the goal! (from start to end)");
                    }
                    this.foundGoal(searchNode.asPath(this.x_spacing, this.y_spacing, this.z_spacing, this.spacing_units));
                    this.setExitReason(SUCCESS);
                    this.reportFinished(true);
                    return;
                }
                if (this.bidirectional && this.definedGoal && searchNode2 != null && this.atStart(searchNode2.x, searchNode2.y, searchNode2.z)) {
                    if (bl) {
                        System.out.println("Found the goal! (from end to start)");
                    }
                    this.foundGoal(searchNode2.asPathReversed(this.x_spacing, this.y_spacing, this.z_spacing, this.spacing_units));
                    this.setExitReason(SUCCESS);
                    this.reportFinished(true);
                    return;
                }
                if (bl) {
                    if (bl) {
                        System.out.println("at loop: " + n2 + " open_from_start: " + this.open_from_start.size() + " closed_from_start:" + this.closed_from_start.size());
                    }
                    if (bl) {
                        System.out.println("         " + n2 + " open_from_goal: " + this.open_from_goal.size() + " closed_from_goal: " + this.closed_from_goal.size());
                    }
                }
                for (int i = 0; i < 2; ++i) {
                    SearchNode searchNode3;
                    SearchNode searchNode4 = searchNode3 = i == 0 ? searchNode : searchNode2;
                    if (searchNode3 == null) continue;
                    if (i == 1 && !this.bidirectional) break;
                    if (i == 0) {
                        searchNode3.searchStatus = (byte)2;
                        this.closed_from_start.add(searchNode3);
                        this.nodes_as_image[searchNode3.z][searchNode3.y * this.width + searchNode3.x] = searchNode3;
                    } else {
                        searchNode3.searchStatus = (byte)4;
                        this.closed_from_goal.add(searchNode3);
                        this.nodes_as_image[searchNode3.z][searchNode3.y * this.width + searchNode3.x] = searchNode3;
                    }
                    for (int j = -1; j <= 1; ++j) {
                        n3 = searchNode3.z + j;
                        if (n3 < 0 || n3 >= this.depth) continue;
                        if (this.nodes_as_image[n3] == null) {
                            this.nodes_as_image[n3] = new SearchNode[this.width * this.height];
                        }
                        for (int k = -1; k <= 1; ++k) {
                            for (int i2 = -1; i2 <= 1; ++i2) {
                                if (k == 0 && i2 == 0 && j == 0) continue;
                                int n4 = searchNode3.x + k;
                                int n5 = searchNode3.y + i2;
                                if (n4 < 0 || n4 >= this.width || n5 < 0 || n5 >= this.height) continue;
                                double d = (float)k * this.x_spacing * ((float)k * this.x_spacing);
                                double d2 = (float)i2 * this.y_spacing * ((float)i2 * this.y_spacing);
                                double d3 = (float)j * this.z_spacing * ((float)j * this.z_spacing);
                                float f = this.estimateCostToGoal(n4, n5, n3, i);
                                double d4 = this.costMovingTo(n4, n5, n3);
                                if (d4 < this.minimum_cost_per_unit_distance) {
                                    d4 = this.minimum_cost_per_unit_distance;
                                }
                                float f2 = (float)((double)searchNode3.g + Math.sqrt(d + d2 + d3) * d4);
                                float f3 = f + f2;
                                SearchNode searchNode5 = this.createNewNode(n4, n5, n3, f2, f, searchNode3, (byte)5);
                                SearchNode searchNode6 = this.nodes_as_image[n3][n5 * this.width + n4];
                                if (searchNode6 == null) {
                                    if (i == 0) {
                                        searchNode5.searchStatus = 1;
                                        this.open_from_start.add(searchNode5);
                                    } else {
                                        searchNode5.searchStatus = (byte)3;
                                        this.open_from_goal.add(searchNode5);
                                    }
                                    this.addingNode(searchNode5);
                                    this.nodes_as_image[n3][n5 * this.width + n4] = searchNode5;
                                    continue;
                                }
                                if (this.bidirectional) {
                                    Path path = null;
                                    boolean bl2 = false;
                                    if (i == 0 && (searchNode6.searchStatus == 3 || searchNode6.searchStatus == 4)) {
                                        if (bl) {
                                            System.out.println("Trying to add a new node from start, found a node in the goal search already there.");
                                        }
                                        path = searchNode3.asPath(this.x_spacing, this.y_spacing, this.z_spacing, this.spacing_units);
                                        if (bl) {
                                            System.out.println("e.asPath() is: " + searchNode3.asPath(this.x_spacing, this.y_spacing, this.z_spacing, this.spacing_units));
                                        }
                                        Path path2 = searchNode6.asPathReversed(this.x_spacing, this.y_spacing, this.z_spacing, this.spacing_units);
                                        if (bl) {
                                            System.out.println("fromGoalReversed is: " + path2);
                                        }
                                        path.add(path2);
                                        if (bl) {
                                            System.out.println("added, that is: " + path);
                                        }
                                        bl2 = true;
                                    } else if (i == 1 && (searchNode6.searchStatus == 1 || searchNode6.searchStatus == 2)) {
                                        if (bl) {
                                            System.out.println("Trying to add a new node from goal, found a node in the start search already there.");
                                        }
                                        path = searchNode6.asPath(this.x_spacing, this.y_spacing, this.z_spacing, this.spacing_units);
                                        if (bl) {
                                            System.out.println("alreadyThere.asPath() is " + searchNode6.asPath(this.x_spacing, this.y_spacing, this.z_spacing, this.spacing_units));
                                        }
                                        if (bl) {
                                            System.out.println("now the path from goal reversed is: " + searchNode3.asPathReversed(this.x_spacing, this.y_spacing, this.z_spacing, this.spacing_units));
                                        }
                                        path.add(searchNode3.asPathReversed(this.x_spacing, this.y_spacing, this.z_spacing, this.spacing_units));
                                        if (bl) {
                                            System.out.println("added, that is: " + path);
                                        }
                                        bl2 = true;
                                    }
                                    if (bl2) {
                                        if (bl) {
                                            System.out.println("Searches met!");
                                        }
                                        this.foundGoal(path);
                                        this.setExitReason(SUCCESS);
                                        this.reportFinished(true);
                                        return;
                                    }
                                }
                                if (!(searchNode6.f > f3)) continue;
                                if (i == 0) {
                                    if (searchNode6.searchStatus == 1) {
                                        this.open_from_start.remove(searchNode6);
                                        searchNode6.setFrom(searchNode5);
                                        searchNode6.searchStatus = 1;
                                        this.open_from_start.add(searchNode6);
                                        continue;
                                    }
                                    if (searchNode6.searchStatus != 2) continue;
                                    this.closed_from_start.remove(searchNode6);
                                    searchNode6.setFrom(searchNode5);
                                    searchNode6.searchStatus = 1;
                                    this.open_from_start.add(searchNode6);
                                    continue;
                                }
                                if (i != 1) continue;
                                if (searchNode6.searchStatus == 3) {
                                    this.open_from_goal.remove(searchNode6);
                                    searchNode6.setFrom(searchNode5);
                                    searchNode6.searchStatus = (byte)3;
                                    this.open_from_goal.add(searchNode6);
                                    continue;
                                }
                                if (searchNode6.searchStatus != 4) continue;
                                this.closed_from_goal.remove(searchNode6);
                                searchNode6.setFrom(searchNode5);
                                searchNode6.searchStatus = (byte)3;
                                this.open_from_goal.add(searchNode6);
                            }
                        }
                    }
                }
                ++n2;
            }
            if (this.verbose) {
                System.out.println("FAILED to find a route.  Shouldn't happen...");
            }
            this.setExitReason(POINTS_EXHAUSTED);
            this.reportFinished(false);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println("Got an OOME: " + outOfMemoryError);
            outOfMemoryError.printStackTrace();
            IJ.error((String)"Out of memory while searching for a path");
            this.setExitReason(OUT_OF_MEMORY);
            this.reportFinished(false);
        }
    }

    float estimateCostToGoal(int n, int n2, int n3, int n4) {
        return 0.0f;
    }

    void setExitReason(int n) {
        this.exitReason = n;
    }

    int getExitReason() {
        return this.exitReason;
    }

    void drawProgressOnSlice(int n, int n2, TracerCanvas tracerCanvas, Graphics graphics) {
        for (int i = 0; i < 2; ++i) {
            byte by;
            SearchNode searchNode;
            SearchNode[] searchNodeArray;
            int n3;
            int n4;
            int n5;
            Color color;
            byte by2 = i == 0 ? (byte)1 : 2;
            byte by3 = i == 0 ? (byte)3 : 4;
            Color color2 = color = i == 0 ? this.openColor : this.closedColor;
            if (color == null) continue;
            graphics.setColor(color);
            int n6 = (int)tracerCanvas.getMagnification();
            if (n6 < 1) {
                n6 = 1;
            }
            if (n == 0) {
                n5 = n2;
                for (n4 = 0; n4 < this.height; ++n4) {
                    for (n3 = 0; n3 < this.width; ++n3) {
                        searchNodeArray = this.nodes_as_image[n5];
                        if (searchNodeArray == null || (searchNode = searchNodeArray[n4 * this.width + n3]) == null) continue;
                        by = searchNode.searchStatus;
                        if (this.drawingThreshold >= 0.0f && searchNode.g > this.drawingThreshold || by != by2 && by != by3) continue;
                        graphics.fillRect(tracerCanvas.myScreenX(n3) - n6 / 2, tracerCanvas.myScreenY(n4) - n6 / 2, n6, n6);
                    }
                }
                continue;
            }
            if (n == 1) {
                n5 = n2;
                for (n4 = 0; n4 < this.depth; ++n4) {
                    for (n3 = 0; n3 < this.width; ++n3) {
                        searchNodeArray = this.nodes_as_image[n4];
                        if (searchNodeArray == null || (searchNode = searchNodeArray[n5 * this.width + n3]) == null) continue;
                        by = searchNode.searchStatus;
                        if (this.drawingThreshold >= 0.0f && searchNode.g > this.drawingThreshold || by != by2 && by != by3) continue;
                        graphics.fillRect(tracerCanvas.myScreenX(n3) - n6 / 2, tracerCanvas.myScreenY(n4) - n6 / 2, n6, n6);
                    }
                }
                continue;
            }
            if (n != 2) continue;
            n5 = n2;
            for (n4 = 0; n4 < this.height; ++n4) {
                for (n3 = 0; n3 < this.depth; ++n3) {
                    searchNodeArray = this.nodes_as_image[n3];
                    if (searchNodeArray == null || (searchNode = searchNodeArray[n4 * this.width + n5]) == null) continue;
                    by = searchNode.searchStatus;
                    if (this.drawingThreshold >= 0.0f && searchNode.g > this.drawingThreshold || by != by2 && by != by3) continue;
                    graphics.fillRect(tracerCanvas.myScreenX(n3) - n6 / 2, tracerCanvas.myScreenY(n4) - n6 / 2, n6, n6);
                }
            }
        }
    }

    public void addNode(SearchNode searchNode) {
        if (this.nodes_as_image[searchNode.z] == null) {
            this.nodes_as_image[searchNode.z] = new SearchNode[this.width * this.height];
        }
        if (this.nodes_as_image[searchNode.z][searchNode.y * this.width + searchNode.x] != null) {
            return;
        }
        if (searchNode.searchStatus == 1) {
            this.open_from_start.add(searchNode);
            this.nodes_as_image[searchNode.z][searchNode.y * this.width + searchNode.x] = searchNode;
        } else if (searchNode.searchStatus == 3) {
            assert (!this.bidirectional || !this.definedGoal);
            this.open_from_goal.add(searchNode);
            this.nodes_as_image[searchNode.z][searchNode.y * this.width + searchNode.x] = searchNode;
        } else if (searchNode.searchStatus == 2) {
            this.closed_from_start.add(searchNode);
            this.nodes_as_image[searchNode.z][searchNode.y * this.width + searchNode.x] = searchNode;
        } else if (searchNode.searchStatus == 4) {
            assert (!this.bidirectional || !this.definedGoal);
            this.closed_from_goal.add(searchNode);
            this.nodes_as_image[searchNode.z][searchNode.y * this.width + searchNode.x] = searchNode;
        }
    }
}

