/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import amira.AmiraMeshDecoder;
import amira.AmiraParameters;
import client.ArchiveClient;
import features.ComputeCurvatures;
import features.GaussianGenerationCallback;
import features.Sigma_Palette;
import features.TubenessProcessor;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.YesNoCancelDialog;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import ij3d.Content;
import ij3d.Image3DUniverse;
import ij3d.Pipe;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.KeyListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.vecmath.Color3f;
import stacks.ThreePanes;
import tracing.FillerProgressCallback;
import tracing.FillerThread;
import tracing.InteractiveTracerCanvas;
import tracing.NearPoint;
import tracing.NeuriteTracerResultsDialog;
import tracing.Path;
import tracing.PathAndFillManager;
import tracing.PointInImage;
import tracing.SearchProgressCallback;
import tracing.SearchThread;
import tracing.TracerThread;
import util.BatchOpener;
import util.RGB_to_Luminance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Simple_Neurite_Tracer
extends ThreePanes
implements PlugIn,
SearchProgressCallback,
FillerProgressCallback,
GaussianGenerationCallback {
    public static final String PLUGIN_VERSION = "1.5.0";
    static final boolean verbose = false;
    PathAndFillManager pathAndFillManager;
    boolean use3DViewer;
    Image3DUniverse univ;
    Content imageContent;
    boolean unsavedPaths = false;
    InteractiveTracerCanvas xy_tracer_canvas;
    InteractiveTracerCanvas xz_tracer_canvas;
    InteractiveTracerCanvas zy_tracer_canvas;
    String nonsense = "unused";
    boolean setupLog = false;
    boolean setupEv = false;
    boolean setupTrace = false;
    boolean setupPreprocess = false;
    boolean setupTimeout = false;
    float setupTimeoutValue = 0.0f;
    public FileInfo file_info;
    protected int width;
    protected int height;
    protected int depth;
    protected String[] materialList;
    byte[][] labelData;
    boolean loading = false;
    boolean lastStartPointSet = false;
    int last_start_point_x;
    int last_start_point_y;
    int last_start_point_z;
    Path endJoin;
    PointInImage endJoinPoint;
    Path temporaryPath = null;
    Path currentPath = null;
    boolean pathUnfinished = false;
    int[] selectedPaths = null;
    TracerThread currentSearchThread;
    double x_spacing = 1.0;
    double y_spacing = 1.0;
    double z_spacing = 1.0;
    String spacing_units = "";
    int imageType = -1;
    byte[][] slices_data_b;
    short[][] slices_data_s;
    float[][] slices_data_f;
    NeuriteTracerResultsDialog resultsDialog;
    boolean cancelled = false;
    TextWindow helpTextWindow;
    boolean singleSlice;
    ArchiveClient archiveClient;
    float stackMax = Float.MIN_VALUE;
    float stackMin = Float.MAX_VALUE;
    FillerThread filler = null;
    boolean hessianEnabled = false;
    ComputeCurvatures hessian = null;
    double hessianSigma = -1.0;
    float[][] tubeness;
    private boolean showOnlySelectedPaths;
    public Color3f selectedColor3f = new Color3f(Color.green);
    public Color3f deselectedColor3f = new Color3f(Color.magenta);
    public Color selectedColor = Color.GREEN;
    public Color deselectedColor = Color.MAGENTA;

    public boolean pathsUnsaved() {
        return this.unsavedPaths;
    }

    public PathAndFillManager getPathAndFillManager() {
        return this.pathAndFillManager;
    }

    public ImagePlus getImagePlus() {
        return this.xy;
    }

    @Override
    public InteractiveTracerCanvas createCanvas(ImagePlus imagePlus, int n) {
        return new InteractiveTracerCanvas(imagePlus, this, n, this.pathAndFillManager);
    }

    public void cancelSearch(boolean bl) {
        if (this.currentSearchThread != null) {
            this.currentSearchThread.requestStop();
        }
        this.endJoin = null;
        this.endJoinPoint = null;
        if (bl && this.filler != null) {
            this.filler.requestStop();
        }
    }

    @Override
    public void threadStatus(SearchThread searchThread, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveFill() {
        if (this.filler != null) {
            FillerThread fillerThread = this.filler;
            synchronized (fillerThread) {
                if (1 == this.filler.getThreadStatus()) {
                    this.pathAndFillManager.addFill(this.filler.getFill());
                    this.filler.requestStop();
                    this.resultsDialog.changeState(0);
                    this.filler = null;
                } else {
                    IJ.error((String)"The filler must be paused before saving the fill.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void discardFill() {
        if (this.filler != null) {
            FillerThread fillerThread = this.filler;
            synchronized (fillerThread) {
                this.filler.requestStop();
                this.resultsDialog.changeState(0);
                this.filler = null;
            }
        }
    }

    public synchronized void pauseOrRestartFilling() {
        if (this.filler != null) {
            this.filler.pauseOrUnpause();
        }
    }

    @Override
    public void finished(SearchThread searchThread, boolean bl) {
        if (searchThread == this.currentSearchThread) {
            if (bl) {
                Path path = this.currentSearchThread.getResult();
                if (path == null) {
                    IJ.error((String)"Bug! Succeeded, but null result.");
                    return;
                }
                if (this.endJoin != null) {
                    path.setEndJoin(this.endJoin, this.endJoinPoint);
                }
                this.setTemporaryPath(path);
                this.resultsDialog.changeState(3);
            } else {
                this.resultsDialog.changeState(1);
            }
            this.currentSearchThread = null;
        }
        this.removeThreadToDraw(searchThread);
        this.repaintAllPanes();
    }

    @Override
    public void pointsInSearch(SearchThread searchThread, int n, int n2) {
        this.repaintAllPanes();
    }

    public void justDisplayNearSlices(boolean bl, int n) {
        this.xy_tracer_canvas.just_near_slices = bl;
        if (!this.single_pane) {
            this.xz_tracer_canvas.just_near_slices = bl;
            this.zy_tracer_canvas.just_near_slices = bl;
        }
        this.xy_tracer_canvas.eitherSide = n;
        if (!this.single_pane) {
            this.xz_tracer_canvas.eitherSide = n;
            this.zy_tracer_canvas.eitherSide = n;
        }
        this.repaintAllPanes();
    }

    public void setCrosshair(double d, double d2, double d3) {
        this.xy_tracer_canvas.setCrosshairs(d, d2, d3, true);
        if (!this.single_pane) {
            this.xz_tracer_canvas.setCrosshairs(d, d2, d3, true);
            this.zy_tracer_canvas.setCrosshairs(d, d2, d3, true);
        }
    }

    public synchronized void loadLabelsFile(String string) {
        AmiraMeshDecoder amiraMeshDecoder = new AmiraMeshDecoder();
        if (!amiraMeshDecoder.open(string)) {
            IJ.error((String)("Could not open the labels file '" + string + "'"));
            return;
        }
        ImageStack imageStack = amiraMeshDecoder.getStack();
        ImagePlus imagePlus = new ImagePlus("Label file for Tracer", imageStack);
        if (imagePlus.getWidth() != this.width || imagePlus.getHeight() != this.height || imagePlus.getStackSize() != this.depth) {
            IJ.error((String)"The size of that labels file doesn't match the size of the image you're tracing.");
            return;
        }
        AmiraParameters amiraParameters = amiraMeshDecoder.parameters;
        int n = amiraParameters.getMaterialCount();
        this.materialList = amiraParameters.getMaterialList();
        this.labelData = new byte[this.depth][];
        for (int i = 0; i < this.depth; ++i) {
            this.labelData[i] = (byte[])imageStack.getPixels(i + 1);
        }
    }

    public synchronized void loadLabels() {
        Object object;
        String string;
        String string2;
        if (this.file_info != null) {
            string2 = this.file_info.fileName;
            string = this.file_info.directory;
            object = new File(string, string2 + ".labels");
            String string3 = ((File)object).getPath();
            if (((File)object).exists()) {
                YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)IJ.getInstance(), "Confirm", "Load the default labels file? (" + string3 + ")");
                if (yesNoCancelDialog.yesPressed()) {
                    this.loadLabelsFile(string3);
                    return;
                }
                if (yesNoCancelDialog.cancelPressed()) {
                    return;
                }
            }
        }
        object = new OpenDialog("Select labels file...", null, null);
        string2 = object.getFileName();
        string = object.getDirectory();
        if (string2 != null) {
            this.loadLabelsFile(string + string2);
            return;
        }
    }

    public synchronized void importSWC() {
        this.loading = true;
        String string = null;
        String string2 = null;
        OpenDialog openDialog = new OpenDialog("Select SWC file...", string2, null);
        string = openDialog.getFileName();
        string2 = openDialog.getDirectory();
        if (string != null) {
            if (this.pathAndFillManager.importSWC(string2 + string)) {
                this.unsavedPaths = false;
            }
            this.loading = false;
            return;
        }
        this.loading = false;
    }

    public synchronized void loadTracings() {
        Object object;
        this.loading = true;
        String string = null;
        String string2 = null;
        if (this.file_info != null) {
            string = this.file_info.fileName;
            string2 = this.file_info.directory;
            object = null;
            int n = string.lastIndexOf(".");
            if (n >= 0) {
                object = new File(string2, string.substring(0, n) + ".traces");
                String string3 = ((File)object).getPath();
                if (((File)object).exists()) {
                    YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)IJ.getInstance(), "Confirm", "Load the default traces file? (" + string3 + ")");
                    if (yesNoCancelDialog.yesPressed()) {
                        if (this.pathAndFillManager.load(string3)) {
                            this.unsavedPaths = false;
                        }
                        this.loading = false;
                        return;
                    }
                    if (yesNoCancelDialog.cancelPressed()) {
                        this.loading = false;
                        return;
                    }
                }
            }
        }
        object = new OpenDialog("Select traces file...", string2, null);
        string = object.getFileName();
        string2 = object.getDirectory();
        if (string != null) {
            if (this.pathAndFillManager.load(string2 + string)) {
                this.unsavedPaths = false;
            }
            this.loading = false;
            return;
        }
        this.loading = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseMovedTo(double d, double d2, int n, boolean bl, boolean bl2) {
        PointInImage pointInImage;
        double[] dArray = new double[3];
        this.findPointInStackPrecise(d, d2, n, dArray);
        double d3 = dArray[0];
        double d4 = dArray[1];
        double d5 = dArray[2];
        if (bl2 && this.pathAndFillManager.anySelected() && (pointInImage = this.pathAndFillManager.nearestJoinPointOnSelectedPaths(d3, d4, d5)) != null) {
            d3 = pointInImage.x / this.x_spacing;
            d4 = pointInImage.y / this.y_spacing;
            d5 = pointInImage.z / this.z_spacing;
        }
        int n2 = (int)Math.round(d3);
        int n3 = (int)Math.round(d4);
        int n4 = (int)Math.round(d5);
        if (bl) {
            this.setSlicesAllPanes(n2, n3, n4);
        }
        if (this.xy_tracer_canvas != null && (this.xz_tracer_canvas != null || this.single_pane) && (this.zy_tracer_canvas != null || this.single_pane)) {
            this.setCrosshair(d3, d4, d5);
            if (this.labelData != null) {
                byte by = this.labelData[n4][n3 * this.width + n2];
                int n5 = by & 0xFF;
                String string = this.materialList[n5];
                IJ.showStatus((String)("Material at crosshairs is: " + string));
            }
            this.repaintAllPanes();
        }
        if (this.filler != null) {
            FillerThread fillerThread = this.filler;
            synchronized (fillerThread) {
                float f = this.filler.getDistanceAtPoint(n2, n3, n4);
                this.resultsDialog.showMouseThreshold(f);
            }
        }
    }

    public synchronized void setTemporaryPath(Path path) {
        Path path2 = this.temporaryPath;
        this.xy_tracer_canvas.setTemporaryPath(path);
        if (!this.single_pane) {
            this.zy_tracer_canvas.setTemporaryPath(path);
            this.xz_tracer_canvas.setTemporaryPath(path);
        }
        this.temporaryPath = path;
        if (this.temporaryPath != null) {
            this.temporaryPath.setName("Temporary Path");
        }
        if (this.use3DViewer) {
            if (path2 != null) {
                path2.removeFrom3DViewer(this.univ);
            }
            if (this.temporaryPath != null) {
                this.temporaryPath.addTo3DViewer(this.univ, Color.BLUE);
            }
        }
    }

    public synchronized void setCurrentPath(Path path) {
        Path path2 = this.currentPath;
        this.xy_tracer_canvas.setCurrentPath(path);
        if (!this.single_pane) {
            this.zy_tracer_canvas.setCurrentPath(path);
            this.xz_tracer_canvas.setCurrentPath(path);
        }
        this.currentPath = path;
        if (this.currentPath != null) {
            this.currentPath.setName("Current Path");
        }
        if (this.use3DViewer) {
            if (path2 != null) {
                path2.removeFrom3DViewer(this.univ);
            }
            if (this.currentPath != null) {
                this.currentPath.addTo3DViewer(this.univ, Color.RED);
            }
        }
    }

    public synchronized Path getCurrentPath() {
        return this.currentPath;
    }

    public void setPathUnfinished(boolean bl) {
        this.pathUnfinished = bl;
        this.xy_tracer_canvas.setPathUnfinished(bl);
        if (!this.single_pane) {
            this.zy_tracer_canvas.setPathUnfinished(bl);
            this.xz_tracer_canvas.setPathUnfinished(bl);
        }
    }

    void addThreadToDraw(SearchThread searchThread) {
        this.xy_tracer_canvas.addSearchThread(searchThread);
        if (!this.single_pane) {
            this.zy_tracer_canvas.addSearchThread(searchThread);
            this.xz_tracer_canvas.addSearchThread(searchThread);
        }
    }

    void removeThreadToDraw(SearchThread searchThread) {
        this.xy_tracer_canvas.removeSearchThread(searchThread);
        if (!this.single_pane) {
            this.zy_tracer_canvas.removeSearchThread(searchThread);
            this.xz_tracer_canvas.removeSearchThread(searchThread);
        }
    }

    public synchronized void makePathVolume() {
        byte[][] byArrayArray = new byte[this.depth][];
        for (int i = 0; i < this.depth; ++i) {
            byArrayArray[i] = new byte[this.width * this.height];
        }
        this.pathAndFillManager.setPathPointsInVolume(byArrayArray, this.width, this.height, this.depth);
        ImageStack imageStack = new ImageStack(this.width, this.height);
        for (int i = 0; i < this.depth; ++i) {
            ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height);
            byteProcessor.setPixels((Object)byArrayArray[i]);
            imageStack.addSlice(null, (ImageProcessor)byteProcessor);
        }
        ImagePlus imagePlus = new ImagePlus("Paths rendered in a Stack", imageStack);
        imagePlus.show();
    }

    synchronized void testPathTo(int n, int n2, int n3, PointInImage pointInImage) {
        int n4;
        int n5;
        int n6;
        if (!this.lastStartPointSet) {
            IJ.showStatus((String)"No initial start point has been set.  Do that with a mouse click. (Or a shift-click if the start of the path should join another neurite.");
            return;
        }
        if (this.temporaryPath != null) {
            IJ.showStatus((String)"There's already a temporary path; use 'N' to cancel it or 'Y' to keep it.");
            return;
        }
        int[] nArray = new int[3];
        this.findPointInStack(n, n2, n3, nArray);
        if (pointInImage == null) {
            n6 = nArray[0];
            n5 = nArray[1];
            n4 = nArray[2];
        } else {
            n6 = (int)Math.round(pointInImage.x / this.x_spacing);
            n5 = (int)Math.round(pointInImage.y / this.y_spacing);
            n4 = (int)Math.round(pointInImage.z / this.z_spacing);
            this.endJoin = pointInImage.onPath;
            this.endJoinPoint = pointInImage;
        }
        this.currentSearchThread = new TracerThread(this.xy, this.stackMin, this.stackMax, 0, 1000L, this.last_start_point_x, this.last_start_point_y, this.last_start_point_z, n6, n5, n4, true, this.singleSlice, this.hessianEnabled ? this.hessian : null, this.resultsDialog.getMultiplier(), this.tubeness, this.hessianEnabled);
        this.addThreadToDraw(this.currentSearchThread);
        this.currentSearchThread.setDrawingColors(Color.CYAN, null);
        this.currentSearchThread.setDrawingThreshold(-1.0f);
        this.currentSearchThread.addProgressListener(this);
        this.currentSearchThread.start();
        this.repaintAllPanes();
    }

    public synchronized void confirmTemporary() {
        if (this.temporaryPath == null) {
            return;
        }
        this.currentPath.add(this.temporaryPath);
        PointInImage pointInImage = this.currentPath.lastPoint();
        this.last_start_point_x = (int)Math.round(pointInImage.x / this.x_spacing);
        this.last_start_point_y = (int)Math.round(pointInImage.y / this.y_spacing);
        this.last_start_point_z = (int)Math.round(pointInImage.z / this.z_spacing);
        if (this.currentPath.endJoins == null) {
            this.setTemporaryPath(null);
            this.resultsDialog.changeState(1);
            this.repaintAllPanes();
        } else {
            this.setTemporaryPath(null);
            this.finishedPath();
        }
        this.setCurrentPath(this.currentPath);
    }

    public synchronized void cancelTemporary() {
        if (!this.lastStartPointSet) {
            IJ.error((String)"No initial start point has been set yet.  Do that with a mouse click. (Or a control-click if the start of the path should join another neurite.");
            return;
        }
        if (this.temporaryPath == null) {
            IJ.error((String)"There's no temporary path to cancel!");
            return;
        }
        this.setTemporaryPath(null);
        this.endJoin = null;
        this.endJoinPoint = null;
        this.resultsDialog.changeState(1);
        this.repaintAllPanes();
    }

    public synchronized void cancelPath() {
        this.setCurrentPath(null);
        this.setTemporaryPath(null);
        this.lastStartPointSet = false;
        this.setPathUnfinished(false);
        this.resultsDialog.changeState(0);
        this.repaintAllPanes();
    }

    public synchronized void finishedPath() {
        if (this.temporaryPath != null) {
            IJ.error((String)"There's an unconfirmed path, need to confirm or cancel it before finishing the path.");
            return;
        }
        if (this.currentPath == null) {
            IJ.error((String)"You can't complete a path with only a start point in it.");
            return;
        }
        this.lastStartPointSet = false;
        this.setPathUnfinished(false);
        Path path = this.currentPath;
        this.setCurrentPath(null);
        this.pathAndFillManager.addPath(path, true);
        this.unsavedPaths = true;
        this.resultsDialog.changeState(0);
        this.repaintAllPanes();
    }

    public synchronized void clickForTrace(int n, int n2, int n3, boolean bl) {
        PointInImage pointInImage = null;
        if (bl) {
            int[] nArray = new int[3];
            this.findPointInStack(n, n2, n3, nArray);
            pointInImage = this.pathAndFillManager.nearestJoinPointOnSelectedPaths(nArray[0], nArray[1], nArray[2]);
        }
        if (this.resultsDialog == null) {
            return;
        }
        if (this.currentSearchThread != null) {
            return;
        }
        if (this.temporaryPath != null) {
            return;
        }
        if (this.filler != null) {
            this.setFillThresholdFrom(n, n2, n3);
            return;
        }
        if (this.pathUnfinished) {
            this.testPathTo(n, n2, n3, pointInImage);
            this.resultsDialog.changeState(2);
        } else {
            this.startPath(n, n2, n3, pointInImage);
            this.resultsDialog.changeState(1);
        }
    }

    public void setFillThresholdFrom(int n, int n2, int n3) {
        int[] nArray = new int[3];
        this.findPointInStack(n, n2, n3, nArray);
        int n4 = nArray[0];
        int n5 = nArray[1];
        int n6 = nArray[2];
        float f = this.filler.getDistanceAtPoint(n4, n5, n6);
        this.setFillThreshold(f);
    }

    public void setFillThreshold(double d) {
        if (d > 0.0) {
            this.resultsDialog.thresholdChanged(d);
            this.filler.setThreshold(d);
        }
    }

    synchronized void startPath(int n, int n2, int n3, PointInImage pointInImage) {
        this.endJoin = null;
        this.endJoinPoint = null;
        if (this.lastStartPointSet) {
            IJ.showStatus((String)"The start point has already been set; to finish a path press 'F'");
            return;
        }
        int[] nArray = new int[3];
        this.findPointInStack(n, n2, n3, nArray);
        this.setPathUnfinished(true);
        this.lastStartPointSet = true;
        Path path = new Path(this.x_spacing, this.y_spacing, this.z_spacing, this.spacing_units);
        path.setName("New Path");
        if (pointInImage == null) {
            this.last_start_point_x = nArray[0];
            this.last_start_point_y = nArray[1];
            this.last_start_point_z = nArray[2];
        } else {
            this.last_start_point_x = (int)Math.round(pointInImage.x / this.x_spacing);
            this.last_start_point_y = (int)Math.round(pointInImage.y / this.y_spacing);
            this.last_start_point_z = (int)Math.round(pointInImage.z / this.z_spacing);
            path.setStartJoin(pointInImage.onPath, pointInImage);
        }
        this.setCurrentPath(path);
    }

    public boolean justFirstPoint() {
        return this.pathUnfinished && this.currentPath.size() == 0;
    }

    public static String getStackTrace() {
        StringWriter stringWriter = new StringWriter();
        new Exception("Dummy Exception for Stack Trace").printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public void viewFillIn3D(boolean bl) {
        ImagePlus imagePlus = this.filler.fillAsImagePlus(bl);
        imagePlus.show();
    }

    public void setPositionAllPanes(int n, int n2, int n3) {
        this.xy.setSlice(n3 + 1);
        this.zy.setSlice(n);
        this.xz.setSlice(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String string) {
        Applet applet;
        String string2 = Macro.getOptions();
        String string3 = null;
        String string4 = null;
        if (string2 != null) {
            string3 = Macro.getValue((String)string2, (String)"imagefilename", null);
            string4 = Macro.getValue((String)string2, (String)"tracesfilename", null);
        }
        if ((applet = IJ.getApplet()) != null) {
            this.archiveClient = new ArchiveClient(applet, string2);
        }
        if (this.archiveClient != null) {
            this.archiveClient.closeChannelsWithTag("nc82");
        }
        try {
            Object object;
            int n;
            int n2;
            Object object2;
            int n3;
            YesNoCancelDialog yesNoCancelDialog;
            ImagePlus imagePlus = null;
            if (string3 == null) {
                imagePlus = IJ.getImage();
            } else {
                imagePlus = BatchOpener.openFirstChannel(string3);
                if (imagePlus == null) {
                    IJ.error((String)("Opening the image file specified in the macro parameters (" + string3 + ") failed."));
                    return;
                }
                imagePlus.show();
            }
            if (imagePlus == null) {
                IJ.error((String)"There's no current image to trace.");
                return;
            }
            if (imagePlus.getNFrames() > 1) {
                IJ.error((String)"This plugin only works with single images, not multiple images in a time series.");
                return;
            }
            if (imagePlus.getNChannels() > 1) {
                IJ.error((String)"This plugin only works with single channel images: use 'Image>Color>Split Channels' and choose a channel");
                return;
            }
            this.imageType = imagePlus.getType();
            if (this.imageType == 4) {
                yesNoCancelDialog = new YesNoCancelDialog((Frame)IJ.getInstance(), "Convert RGB image", "Convert this RGB image to an 8 bit luminance image first?\n(If you want to trace a particular channel instead, cancel and \"Split Channels\" first.)");
                if (!yesNoCancelDialog.yesPressed()) {
                    return;
                }
                imagePlus = RGB_to_Luminance.convertToLuminance(imagePlus);
                imagePlus.show();
                this.imageType = imagePlus.getType();
            }
            if (imagePlus.getStackSize() == 1) {
                this.singleSlice = true;
            }
            this.width = imagePlus.getWidth();
            this.height = imagePlus.getHeight();
            this.depth = imagePlus.getStackSize();
            yesNoCancelDialog = imagePlus.getCalibration();
            if (yesNoCancelDialog != null) {
                this.x_spacing = yesNoCancelDialog.pixelWidth;
                this.y_spacing = yesNoCancelDialog.pixelHeight;
                this.z_spacing = yesNoCancelDialog.pixelDepth;
                this.spacing_units = yesNoCancelDialog.getUnits();
                if (this.spacing_units == null || this.spacing_units.length() == 0) {
                    this.spacing_units = "" + yesNoCancelDialog.getUnit();
                }
            }
            this.pathAndFillManager = new PathAndFillManager(this);
            this.file_info = imagePlus.getOriginalFileInfo();
            Object object3 = imagePlus.getProcessor();
            Object[] objectArray = new byte[256];
            Object object4 = new byte[256];
            Object object5 = new byte[256];
            for (int i = 0; i < 256; ++i) {
                objectArray[i] = (byte)i;
                object4[i] = (byte)i;
                object5[i] = (byte)i;
            }
            IndexColorModel indexColorModel = new IndexColorModel(8, 256, (byte[])objectArray, (byte[])object4, (byte[])object5);
            object3.setColorModel((ColorModel)indexColorModel);
            if (imagePlus.getStackSize() > 1) {
                imagePlus.getStack().setColorModel((ColorModel)indexColorModel);
            }
            imagePlus.updateAndRepaintWindow();
            if (this.file_info != null && (object3 = this.file_info.fileName) != null && (n3 = ((String)object3).lastIndexOf(".")) > 0) {
                object4 = ((String)object3).substring(0, n3);
                object5 = (String)object4 + ".tubes.tif";
                indexColorModel = null;
                object2 = new File(this.file_info.directory, (String)object5);
                if (((File)object2).exists()) {
                    long l = (long)this.width * (long)this.height * (long)this.depth * 4L / 0x100000L;
                    String string5 = l + "MiB";
                    YesNoCancelDialog yesNoCancelDialog2 = new YesNoCancelDialog((Frame)IJ.getInstance(), "Confirm", "A tubeness file (" + ((File)object2).getName() + ") exists.  Load this file?\n" + "(This would use an extra " + string5 + " of memory.)");
                    if (yesNoCancelDialog2.cancelPressed()) {
                        return;
                    }
                    if (yesNoCancelDialog2.yesPressed()) {
                        IJ.showStatus((String)"Loading tubes file.");
                        indexColorModel = BatchOpener.openFirstChannel(((File)object2).getAbsolutePath());
                        if (indexColorModel == null) {
                            IJ.error((String)("Failed to load tubes image from " + ((File)object2).getAbsolutePath() + " although it existed"));
                            return;
                        }
                        if (indexColorModel.getType() != 2) {
                            IJ.error((String)("The tubeness file must be a 32 bit float image - " + ((File)object2).getAbsolutePath() + " was not."));
                            return;
                        }
                        int n4 = indexColorModel.getWidth();
                        n2 = indexColorModel.getHeight();
                        n = indexColorModel.getStackSize();
                        object = indexColorModel.getStack();
                        this.tubeness = new float[n][];
                        for (int i = 0; i < n; ++i) {
                            FloatProcessor floatProcessor = (FloatProcessor)object.getProcessor(i + 1);
                            this.tubeness[i] = (float[])floatProcessor.getPixels();
                        }
                    }
                }
            }
            this.single_pane = true;
            object3 = null;
            objectArray = null;
            if (!this.singleSlice) {
                String string6;
                boolean bl = Simple_Neurite_Tracer.haveJava3D();
                boolean bl2 = false;
                indexColorModel = new GenericDialog("Simple Neurite Tracer (v1.5.0)");
                indexColorModel.addMessage("Tracing the image: " + imagePlus.getTitle());
                object2 = " (will use an extra: ";
                int n5 = imagePlus.getBitDepth();
                int n6 = n5 == 24 ? 4 : n5 / 8;
                long l = (long)this.width * (long)this.height * (long)this.depth * (long)n6 * 2L / 0x100000L;
                object2 = (String)object2 + l + "MiB of memory)";
                indexColorModel.addCheckbox("Use_three_pane view?" + (String)object2, false);
                if (!bl) {
                    string6 = "(Java3D classes don't seem to be available, so no 3D viewer option is available.)";
                    System.out.println(string6);
                    indexColorModel.addMessage(string6);
                } else if (imagePlus.getBitDepth() != 8) {
                    string6 = "(3D viewer option is only currently available for 8 bit images)";
                    System.out.println(string6);
                    indexColorModel.addMessage(string6);
                } else {
                    bl2 = true;
                    objectArray = new String[Image3DUniverse.universes.size() + 2];
                    string6 = "No 3D view";
                    String string7 = "Create New 3D Viewer";
                    objectArray[objectArray.length - 2] = (byte)string7;
                    objectArray[objectArray.length - 1] = (byte)string6;
                    for (n = 0; n < objectArray.length - 2; ++n) {
                        object = Image3DUniverse.universes.get(n).allContentsString();
                        String string8 = ((String)object).length() == 0 ? "[Empty]" : ((String)object).substring(0, Math.min(40, ((String)object).length() - 1));
                        objectArray[n] = (byte)("Use 3D viewer [" + n + "] containing " + string8);
                    }
                    indexColorModel.addChoice("Choice of 3D Viewer:", (String[])objectArray, string7);
                }
                indexColorModel.showDialog();
                if (indexColorModel.wasCanceled()) {
                    return;
                }
                boolean bl3 = this.single_pane = !indexColorModel.getNextBoolean();
                if (bl2) {
                    string6 = indexColorModel.getNextChoice();
                    for (n2 = 0; n2 < objectArray.length && !objectArray[n2].equals(string6); ++n2) {
                    }
                    if (n2 == objectArray.length - 2) {
                        this.use3DViewer = true;
                        object3 = null;
                    } else if (n2 == objectArray.length - 1) {
                        this.use3DViewer = false;
                        object3 = null;
                    } else {
                        this.use3DViewer = true;
                        object3 = Image3DUniverse.universes.get(n2);
                    }
                }
            }
            this.initialize(imagePlus);
            this.xy_tracer_canvas = (InteractiveTracerCanvas)this.xy_canvas;
            this.xz_tracer_canvas = (InteractiveTracerCanvas)this.xz_canvas;
            this.zy_tracer_canvas = (InteractiveTracerCanvas)this.zy_canvas;
            this.setupTrace = true;
            this.resultsDialog = new NeuriteTracerResultsDialog("Tracing for: " + this.xy.getShortTitle(), this, applet != null);
            this.pathAndFillManager.addPathAndFillListener(this.resultsDialog);
            this.pathAndFillManager.addPathAndFillListener(this.resultsDialog.pw);
            this.pathAndFillManager.addPathAndFillListener(this.resultsDialog.fw);
            if (this.x_spacing == 0.0 || this.y_spacing == 0.0 || this.z_spacing == 0.0) {
                IJ.error((String)("One dimension of the calibration information was zero: (" + this.x_spacing + "," + this.y_spacing + "," + this.z_spacing + ")"));
                return;
            }
            object4 = this.xy.getStack();
            switch (this.imageType) {
                case 0: 
                case 3: {
                    this.slices_data_b = new byte[this.depth][];
                    for (int i = 0; i < this.depth; ++i) {
                        this.slices_data_b[i] = (byte[])object4.getPixels(i + 1);
                    }
                    this.stackMin = 0.0f;
                    this.stackMax = 255.0f;
                    break;
                }
                case 1: {
                    int n7;
                    this.slices_data_s = new short[this.depth][];
                    for (n7 = 0; n7 < this.depth; ++n7) {
                        this.slices_data_s[n7] = (short[])object4.getPixels(n7 + 1);
                    }
                    IJ.showStatus((String)"Finding stack minimum / maximum");
                    for (n7 = 0; n7 < this.depth; ++n7) {
                        for (int i = 0; i < this.height; ++i) {
                            for (int j = 0; j < this.width; ++j) {
                                short s = this.slices_data_s[n7][i * this.width + j];
                                if ((float)s < this.stackMin) {
                                    this.stackMin = s;
                                }
                                if (!((float)s > this.stackMax)) continue;
                                this.stackMax = s;
                            }
                        }
                        IJ.showProgress((double)((float)n7 / (float)this.depth));
                    }
                    IJ.showProgress((double)1.0);
                    break;
                }
                case 2: {
                    int n8;
                    this.slices_data_f = new float[this.depth][];
                    for (n8 = 0; n8 < this.depth; ++n8) {
                        this.slices_data_f[n8] = (float[])object4.getPixels(n8 + 1);
                    }
                    IJ.showStatus((String)"Finding stack minimum / maximum");
                    for (n8 = 0; n8 < this.depth; ++n8) {
                        for (int i = 0; i < this.height; ++i) {
                            for (int j = 0; j < this.width; ++j) {
                                float f = this.slices_data_f[n8][i * this.width + j];
                                if (f < this.stackMin) {
                                    this.stackMin = f;
                                }
                                if (!(f > this.stackMax)) continue;
                                this.stackMax = f;
                            }
                        }
                        IJ.showProgress((double)((float)n8 / (float)this.depth));
                    }
                    IJ.showProgress((double)1.0);
                }
            }
            this.xy_tracer_canvas.addKeyListener(this.xy_tracer_canvas);
            this.xy_window.addKeyListener((KeyListener)this.xy_tracer_canvas);
            if (!this.single_pane) {
                this.xz_tracer_canvas.addKeyListener(this.xz_tracer_canvas);
                this.xz_window.addKeyListener((KeyListener)this.xz_tracer_canvas);
                this.zy_tracer_canvas.addKeyListener(this.zy_tracer_canvas);
                this.zy_window.addKeyListener((KeyListener)this.zy_tracer_canvas);
            }
            if (this.use3DViewer) {
                boolean bl;
                if (object3 == null) {
                    bl = false;
                    this.univ = new Image3DUniverse(512, 512);
                } else {
                    bl = true;
                    this.univ = object3;
                }
                this.univ.setUseToFront(false);
                this.univ.addUniverseListener(this.pathAndFillManager);
                if (!bl) {
                    this.univ.show();
                    GUI.center((Window)((Object)this.univ.getWindow()));
                }
                boolean[] blArray = new boolean[]{true, true, true};
                String string9 = "Image for tracing [" + imagePlus.getTitle() + "]";
                object2 = this.univ.getSafeContentName(string9);
                this.univ.resetView();
                Content content = this.univ.addContent(this.xy, new Color3f(Color.white), (String)object2, 10, blArray, 2, 0);
                content.setLocked(true);
                content.setTransparency(0.5f);
                this.univ.resetView();
            }
            File file = null;
            if (string4 != null) {
                file = new File(string4);
                if (file.exists()) {
                    this.pathAndFillManager.load(file.getAbsolutePath());
                } else {
                    IJ.error((String)("The traces file suggested by the macro parameters (" + string4 + ") does not exist"));
                }
            }
            this.resultsDialog.displayOnStarting();
        }
        finally {
            IJ.getInstance().addKeyListener((KeyListener)IJ.getInstance());
        }
    }

    public boolean isReady() {
        if (this.resultsDialog == null) {
            return false;
        }
        return this.resultsDialog.isVisible();
    }

    public void launchPaletteAround(int n, int n2, int n3) {
        int n4 = 40;
        int n5 = n - n4;
        int n6 = n + n4;
        int n7 = n2 - n4;
        int n8 = n2 + n4;
        int n9 = n3 - n4;
        int n10 = n3 + n4;
        int n11 = this.xy.getWidth();
        int n12 = this.xy.getHeight();
        int n13 = this.xy.getStackSize();
        if (n5 < 0) {
            n5 = 0;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n9 < 0) {
            n9 = 0;
        }
        if (n6 >= n11) {
            n6 = n11 - 1;
        }
        if (n8 >= n12) {
            n8 = n12 - 1;
        }
        if (n10 >= n13) {
            n10 = n13 - 1;
        }
        double[] dArray = new double[9];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (double)(i + 1) * this.getMinimumSeparation() / 2.0;
        }
        this.resultsDialog.changeState(9);
        Sigma_Palette sigma_Palette = new Sigma_Palette();
        sigma_Palette.setListener(this.resultsDialog);
        sigma_Palette.makePalette(this.xy, n5, n6, n7, n8, n9, n10, new TubenessProcessor(true), dArray, 256.0 / this.resultsDialog.getMultiplier(), 3, 3, n3);
    }

    public void startFillerThread(FillerThread fillerThread) {
        this.filler = fillerThread;
        fillerThread.addProgressListener(this);
        fillerThread.addProgressListener(this.resultsDialog.fw);
        this.addThreadToDraw(fillerThread);
        fillerThread.start();
        this.resultsDialog.changeState(6);
    }

    public synchronized void startFillingPaths(Set<Path> set) {
        this.resultsDialog.fw.pauseOrRestartFilling.setLabel("Pause");
        this.filler = new FillerThread(this.xy, this.stackMin, this.stackMax, false, true, 0.03f, 5000L);
        this.addThreadToDraw(this.filler);
        this.filler.addProgressListener(this);
        this.filler.addProgressListener(this.resultsDialog.fw);
        this.filler.setSourcePaths(set);
        this.resultsDialog.setFillListVisible(true);
        this.filler.start();
        this.resultsDialog.changeState(6);
    }

    public void setFillTransparent(boolean bl) {
        this.xy_tracer_canvas.setFillTransparent(bl);
        if (!this.single_pane) {
            this.xz_tracer_canvas.setFillTransparent(bl);
            this.zy_tracer_canvas.setFillTransparent(bl);
        }
    }

    @Override
    public void maximumDistanceCompletelyExplored(SearchThread searchThread, float f) {
    }

    public byte[] squareNormalToVector(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double[] dArray, double[] dArray2) {
        double d8;
        double d9;
        double d10;
        byte[] byArray = new byte[n * n];
        double d11 = 1.0E-6;
        if (Math.abs(d5) < d11 && Math.abs(d6) < d11) {
            d10 = d7;
            d9 = 0.0;
            d8 = -d5;
        } else {
            d10 = -d6;
            d9 = d5;
            d8 = 0.0;
        }
        double d12 = d9 * d7 - d8 * d6;
        double d13 = d8 * d5 - d10 * d7;
        double d14 = d10 * d6 - d9 * d5;
        double d15 = Math.sqrt(d10 * d10 + d9 * d9 + d8 * d8);
        d10 /= d15;
        d9 /= d15;
        d8 /= d15;
        double d16 = Math.sqrt(d12 * d12 + d13 * d13 + d14 * d14);
        d12 /= d16;
        d13 /= d16;
        d14 /= d16;
        double d17 = d10 * d;
        double d18 = d9 * d;
        double d19 = d8 * d;
        double d20 = d12 * d;
        double d21 = d13 * d;
        double d22 = d14 * d;
        double d23 = d10 * d12 + d9 * d13 + d8 * d14;
        double d24 = d10 * d5 + d9 * d6 + d8 * d7;
        double d25 = d12 * d5 + d13 * d6 + d14 * d7;
        byte[][] byArray2 = this.slices_data_b;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d26;
                double d27;
                double d28;
                double d29;
                double d30;
                double d31;
                double d32;
                double d33;
                double d34 = (float)(n - 1) / 2.0f;
                double d35 = d34 - (double)i;
                double d36 = d34 - (double)j;
                double d37 = d2 + d35 * d17 + d36 * d20;
                double d38 = d3 + d35 * d18 + d36 * d21;
                double d39 = d4 + d35 * d19 + d36 * d22;
                double d40 = d37 / this.x_spacing;
                double d41 = d38 / this.y_spacing;
                double d42 = d39 / this.z_spacing;
                double d43 = d40 - Math.floor(d40);
                double d44 = d41 - Math.floor(d41);
                double d45 = d42 - Math.floor(d42);
                int n2 = (int)Math.floor(d40);
                int n3 = (int)Math.ceil(d40);
                int n4 = (int)Math.floor(d41);
                int n5 = (int)Math.ceil(d41);
                int n6 = (int)Math.floor(d42);
                int n7 = (int)Math.ceil(d42);
                if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0 || n6 < 0 || n7 < 0 || n2 >= this.width || n3 >= this.width || n4 >= this.height || n5 >= this.height || n6 >= this.depth || n7 >= this.depth) {
                    d33 = 0.0;
                    d32 = 0.0;
                    d31 = 0.0;
                    d30 = 0.0;
                    d29 = 0.0;
                    d28 = 0.0;
                    d27 = 0.0;
                    d26 = 0.0;
                } else {
                    d33 = byArray2[n6][this.width * n4 + n2] & 0xFF;
                    d32 = byArray2[n7][this.width * n4 + n2] & 0xFF;
                    d31 = byArray2[n6][this.width * n5 + n2] & 0xFF;
                    d30 = byArray2[n7][this.width * n5 + n2] & 0xFF;
                    d29 = byArray2[n6][this.width * n4 + n3] & 0xFF;
                    d28 = byArray2[n7][this.width * n4 + n3] & 0xFF;
                    d27 = byArray2[n6][this.width * n5 + n3] & 0xFF;
                    d26 = byArray2[n7][this.width * n5 + n3] & 0xFF;
                }
                double d46 = (1.0 - d45) * d33 + d32 * d45;
                double d47 = (1.0 - d45) * d31 + d30 * d45;
                double d48 = (1.0 - d45) * d29 + d28 * d45;
                double d49 = (1.0 - d45) * d27 + d26 * d45;
                double d50 = d46 * (1.0 - d44) + d47 * d44;
                double d51 = d48 * (1.0 - d44) + d49 * d44;
                double d52 = d50 * (1.0 - d43) + d51 * d43;
                int n8 = (int)d52;
                if (n8 < 0 || n8 > 255) {
                    System.out.println("BUG: Out of range value!");
                }
                byArray[j * n + i] = (byte)n8;
            }
        }
        dArray[0] = d17;
        dArray[1] = d18;
        dArray[2] = d19;
        dArray2[0] = d20;
        dArray2[1] = d21;
        dArray2[2] = d22;
        return byArray;
    }

    public double getMinimumSeparation() {
        return Math.min(Math.abs(this.x_spacing), Math.min(Math.abs(this.y_spacing), Math.abs(this.z_spacing)));
    }

    public void startHessian() {
        if (this.hessian == null) {
            this.resultsDialog.changeState(7);
            this.hessianSigma = this.resultsDialog.getSigma();
            this.hessian = new ComputeCurvatures(this.xy, this.hessianSigma, this, true);
            new Thread(this.hessian).start();
        } else {
            double d = this.resultsDialog.getSigma();
            if (d != this.hessianSigma) {
                this.resultsDialog.changeState(7);
                this.hessianSigma = d;
                this.hessian = new ComputeCurvatures(this.xy, this.hessianSigma, this, true);
                new Thread(this.hessian).start();
            }
        }
    }

    public synchronized void enableHessian(boolean bl) {
        this.hessianEnabled = bl;
        if (bl) {
            this.startHessian();
            this.resultsDialog.editSigma.setEnabled(false);
            this.resultsDialog.sigmaWizard.setEnabled(false);
        } else {
            this.resultsDialog.editSigma.setEnabled(true);
            this.resultsDialog.sigmaWizard.setEnabled(true);
        }
    }

    public synchronized void cancelGaussian() {
        if (this.hessian != null) {
            this.hessian.cancelGaussianGeneration();
        }
    }

    @Override
    public void proportionDone(double d) {
        if (d < 0.0) {
            this.hessianEnabled = false;
            this.hessian = null;
            this.hessianSigma = -1.0;
            this.resultsDialog.gaussianCalculated(false);
            IJ.showProgress((double)1.0);
            return;
        }
        if (d >= 1.0) {
            this.hessianEnabled = true;
            this.resultsDialog.gaussianCalculated(true);
        }
        IJ.showProgress((double)d);
    }

    public static boolean haveJava3D() {
        ClassLoader classLoader = IJ.getClassLoader();
        if (classLoader == null) {
            throw new RuntimeException("IJ.getClassLoader() failed (!)");
        }
        try {
            Class<?> clazz = classLoader.loadClass("ij3d.ImageWindow3D");
            return clazz != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void addLineTo3DViewer(double d, double d2, double d3, double d4, double d5, double d6, double d7, Color color, String string) {
        if (!this.use3DViewer) {
            return;
        }
        int n = 8;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = (double)i * (d4 - d) / (double)n + d;
            dArray2[i] = (double)i * (d5 - d2) / (double)n + d2;
            dArray3[i] = (double)i * (d6 - d3) / (double)n + d3;
            dArray4[i] = d7;
        }
        double[][][] dArray5 = Pipe.makeTube(dArray, dArray2, dArray3, dArray4, 1, 8);
        List list = Pipe.generateTriangles(dArray5, 1.0);
        String string2 = this.univ.getSafeContentName(string);
        this.univ.resetView();
        this.univ.addMesh(list, color == null ? new Color3f(Color.magenta) : new Color3f(color), string2, 1);
        Content content = this.univ.getContent(string2);
        content.setLocked(true);
        this.univ.resetView();
    }

    public void showCorrespondencesTo(File file, Color color, double d) {
        PathAndFillManager pathAndFillManager = new PathAndFillManager(this.width, this.height, this.depth, (float)this.x_spacing, (float)this.y_spacing, (float)this.z_spacing, this.spacing_units);
        if (!pathAndFillManager.load(file.getAbsolutePath())) {
            IJ.error((String)("Failed to load traces from: " + file.getAbsolutePath()));
            return;
        }
        ArrayList<NearPoint> arrayList = this.pathAndFillManager.getCorrespondences(pathAndFillManager, 2.5);
        Iterator<NearPoint> iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            NearPoint nearPoint = iterator.next();
            if (nearPoint != null) {
                this.addLineTo3DViewer(nearPoint.nearX, nearPoint.nearY, nearPoint.nearZ, nearPoint.pathPointX, nearPoint.pathPointY, nearPoint.pathPointZ, Math.abs(this.x_spacing), color, file.getName() + "-" + n);
            }
            ++n;
        }
    }

    public void setShowOnlySelectedPaths(boolean bl) {
        this.showOnlySelectedPaths = bl;
        this.update3DViewerContents();
        this.repaintAllPanes();
    }

    public boolean getShowOnlySelectedPaths() {
        return this.showOnlySelectedPaths;
    }

    public void update3DViewerContents() {
        this.pathAndFillManager.update3DViewerContents();
    }

    public Image3DUniverse get3DUniverse() {
        return this.univ;
    }

    public void setSelectedColor(Color color) {
        this.selectedColor = color;
        this.selectedColor3f = new Color3f(color);
        this.repaintAllPanes();
        this.update3DViewerContents();
    }

    public void setDeselectedColor(Color color) {
        this.deselectedColor = color;
        this.deselectedColor3f = new Color3f(color);
        this.repaintAllPanes();
        this.update3DViewerContents();
    }
}

