/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import features.ComputeCurvatures;
import ij.ImagePlus;
import ij.measure.Calibration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tracing.Path;
import tracing.TracerThread;
import util.BatchOpener;

public class Test3DTracing {
    ImagePlus image;
    double startX = 56.524;
    double startY = 43.258;
    double startZ = 18.0;
    double endX = 0.0;
    double endY = 17.015;
    double endZ = 22.8;

    @Before
    public void setUp() {
        this.image = BatchOpener.openFirstChannel("test-images/c061AG-small-section.tif");
        Assert.assertNotNull((String)"Couldn't open the 3D test image", (Object)this.image);
    }

    @After
    public void tearDown() {
        this.image.close();
    }

    @Test
    public void testTracing() {
        Object object;
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        Calibration calibration = this.image.getCalibration();
        if (calibration != null) {
            d4 = Math.min(Math.abs(calibration.pixelWidth), Math.min(Math.abs(calibration.pixelHeight), Math.abs(calibration.pixelDepth)));
            d = calibration.pixelWidth;
            d2 = calibration.pixelHeight;
            d3 = calibration.pixelDepth;
        }
        boolean bl = false;
        int n = 0;
        if (bl) {
            TracerThread tracerThread = new TracerThread(this.image, 0.0f, 255.0f, -1, 100L, (int)(this.startX / d), (int)(this.startY / d2), 0, (int)(this.endX / d), (int)(this.endY / d2), 0, true, false, null, 1.0, null, false);
            tracerThread.run();
            object = tracerThread.getResult();
            Assert.assertNotNull((String)"Not path found", (Object)object);
            double d5 = ((Path)object).getRealLength();
            Assert.assertTrue((String)"Path length must be greater than 95 micrometres", (d5 > 95.0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Path length must be less than 100 micrometres", (d5 < 100.0 ? 1 : 0) != 0);
            n = tracerThread.pointsConsideredInSearch();
        }
        int n2 = 0;
        object = new ComputeCurvatures(this.image, 0.721, null, calibration != null);
        ((ComputeCurvatures)object).run();
        TracerThread tracerThread = new TracerThread(this.image, 0.0f, 255.0f, -1, 100L, (int)(this.startX / d), (int)(this.startY / d2), (int)(this.startZ / d3), (int)(this.endX / d), (int)(this.endY / d2), (int)(this.endZ / d3), true, false, (ComputeCurvatures)object, 19.69, null, true);
        tracerThread.run();
        Path path = tracerThread.getResult();
        Assert.assertNotNull((String)"Not path found", (Object)path);
        double d6 = path.getRealLength();
        Assert.assertTrue((String)"Path length must be greater than 92 micrometres", (d6 > 92.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Path length must be less than 96 micrometres", (d6 < 96.0 ? 1 : 0) != 0);
        n2 = tracerThread.pointsConsideredInSearch();
        Assert.assertTrue((String)"Hessian-based analysis should explore less than 20000 points", (n2 < 20000 ? 1 : 0) != 0);
        if (bl) {
            Assert.assertTrue((String)("Hessian-based analysis should reduce the points explored by at least a third; in fact went from " + n + " to " + n2), (n2 * 10 < n ? 1 : 0) != 0);
        }
    }
}

