/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import ij.ImagePlus;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import stacks.PaneOwner;
import stacks.ThreePanesCanvas;
import tracing.Path;
import tracing.PathAndFillManager;
import tracing.SearchThread;

public class TracerCanvas
extends ThreePanesCanvas {
    private PathAndFillManager pathAndFillManager;
    ArrayList<SearchThread> searchThreads = new ArrayList();
    boolean just_near_slices = false;
    int eitherSide;
    private int backBufferWidth;
    private int backBufferHeight;
    private Graphics backBufferGraphics;
    private Image backBufferImage;

    public TracerCanvas(ImagePlus imagePlus, PaneOwner paneOwner, int n, PathAndFillManager pathAndFillManager) {
        super(imagePlus, paneOwner, n);
        this.pathAndFillManager = pathAndFillManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSearchThread(SearchThread searchThread) {
        ArrayList<SearchThread> arrayList = this.searchThreads;
        synchronized (arrayList) {
            this.searchThreads.add(searchThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSearchThread(SearchThread searchThread) {
        ArrayList<SearchThread> arrayList = this.searchThreads;
        synchronized (arrayList) {
            int n = -1;
            for (int i = 0; i < this.searchThreads.size(); ++i) {
                SearchThread searchThread2 = this.searchThreads.get(i);
                if (searchThread != searchThread2) continue;
                n = i;
            }
            if (n >= 0) {
                this.searchThreads.remove(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawOverlay(Graphics graphics) {
        Object object;
        int n = this.imp.getCurrentSlice() - 1;
        ArrayList<SearchThread> arrayList = this.searchThreads;
        synchronized (arrayList) {
            object = this.searchThreads.iterator();
            while (object.hasNext()) {
                object.next().drawProgressOnSlice(this.plane, n, this, graphics);
            }
        }
        boolean bl = this.pathAndFillManager.plugin.getShowOnlySelectedPaths();
        object = this.pathAndFillManager.plugin.selectedColor;
        Color color = this.pathAndFillManager.plugin.deselectedColor;
        if (this.pathAndFillManager != null) {
            for (int i = 0; i < this.pathAndFillManager.size(); ++i) {
                Path path = this.pathAndFillManager.getPath(i);
                if (path == null || path.fittedVersionOf != null) continue;
                Path path2 = path;
                if (path.useFitted) {
                    path2 = path.fitted;
                }
                Object object2 = color;
                if (this.pathAndFillManager.isSelected(path)) {
                    object2 = object;
                } else if (bl) continue;
                if (this.just_near_slices) {
                    path2.drawPathAsPoints(this, graphics, (Color)object2, this.plane, n, this.eitherSide);
                    continue;
                }
                path2.drawPathAsPoints(this, graphics, (Color)object2, this.plane);
            }
        }
        super.drawOverlay(graphics);
    }

    private void resetBackBuffer() {
        if (this.backBufferGraphics != null) {
            this.backBufferGraphics.dispose();
            this.backBufferGraphics = null;
        }
        if (this.backBufferImage != null) {
            this.backBufferImage.flush();
            this.backBufferImage = null;
        }
        this.backBufferWidth = this.getSize().width;
        this.backBufferHeight = this.getSize().height;
        this.backBufferImage = this.createImage(this.backBufferWidth, this.backBufferHeight);
        this.backBufferGraphics = this.backBufferImage.getGraphics();
    }

    public void paint(Graphics graphics) {
        if (this.backBufferWidth != this.getSize().width || this.backBufferHeight != this.getSize().height || this.backBufferImage == null || this.backBufferGraphics == null) {
            this.resetBackBuffer();
        }
        super.paint(this.backBufferGraphics);
        this.drawOverlay(this.backBufferGraphics);
        graphics.drawImage(this.backBufferImage, 0, 0, (ImageObserver)((Object)this));
    }
}

