/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import features.ComputeCurvatures;
import ij.ImagePlus;
import tracing.Path;
import tracing.SearchNode;
import tracing.SearchThread;

public class TracerThread
extends SearchThread {
    int start_x;
    int start_y;
    int start_z;
    int goal_x;
    int goal_y;
    int goal_z;
    boolean reciprocal;
    ComputeCurvatures hessian;
    double multiplier;
    Path result;
    float[][] tubeness;
    boolean useHessian;
    boolean singleSlice;
    static final double RECIPROCAL_FUDGE = 0.5;

    protected boolean atStart(int n, int n2, int n3) {
        return n == this.start_x && n2 == this.start_y && n3 == this.start_z;
    }

    protected boolean atGoal(int n, int n2, int n3) {
        return n == this.goal_x && n2 == this.goal_y && n3 == this.goal_z;
    }

    protected double minimumCostPerUnitDistance() {
        double d = this.hessian == null ? (this.reciprocal ? 0.00392156862745098 : 1.0) : 0.016666666666666666;
        return d;
    }

    public TracerThread(ImagePlus imagePlus, float f, float f2, int n, long l, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2, ComputeCurvatures computeCurvatures, double d, float[][] fArray, boolean bl3) {
        super(imagePlus, f, f2, true, true, false, n, l);
        this.reciprocal = bl;
        this.singleSlice = bl2;
        this.hessian = computeCurvatures;
        this.tubeness = fArray;
        this.multiplier = d;
        this.minimum_cost_per_unit_distance = this.minimumCostPerUnitDistance();
        this.tubeness = fArray;
        this.useHessian = bl3;
        this.start_x = n2;
        this.start_y = n3;
        this.start_z = n4;
        this.goal_x = n5;
        this.goal_y = n6;
        this.goal_z = n7;
        SearchNode searchNode = this.createNewNode(n2, n3, n4, 0.0f, this.estimateCostToGoal(n2, n3, n4, 0), null, (byte)1);
        this.addNode(searchNode);
        SearchNode searchNode2 = this.createNewNode(n5, n6, n7, 0.0f, this.estimateCostToGoal(n5, n6, n7, 1), null, (byte)3);
        this.addNode(searchNode2);
        this.result = null;
    }

    protected void foundGoal(Path path) {
        this.result = path;
    }

    public Path getResult() {
        return this.result;
    }

    protected double costMovingTo(int n, int n2, int n3) {
        double d;
        double d2 = -1.0;
        switch (this.imageType) {
            case 0: 
            case 3: {
                d2 = this.slices_data_b[n3][n2 * this.width + n] & 0xFF;
                break;
            }
            case 1: {
                d2 = this.slices_data_s[n3][n2 * this.width + n];
                d2 = 255.0 * (d2 - (double)this.stackMin) / (double)(this.stackMax - this.stackMin);
                break;
            }
            case 2: {
                d2 = this.slices_data_f[n3][n2 * this.width + n];
                d2 = 255.0 * (d2 - (double)this.stackMin) / (double)(this.stackMax - this.stackMin);
            }
        }
        if (this.useHessian) {
            if (this.tubeness == null) {
                if (this.singleSlice) {
                    double[] dArray = new double[2];
                    boolean bl = this.hessian.hessianEigenvaluesAtPoint2D(n, n2, true, dArray, false, true, this.x_spacing, this.y_spacing);
                    if (bl && dArray[1] < 0.0) {
                        double d3 = Math.abs(dArray[1]);
                        if (d3 == 0.0) {
                            d3 = 0.2;
                        }
                        if ((d3 *= this.multiplier) > 256.0) {
                            d3 = 256.0;
                        }
                        d = 1.0 / d3;
                    } else {
                        d = 5.0;
                    }
                } else {
                    double[] dArray = new double[3];
                    boolean bl = this.hessian.hessianEigenvaluesAtPoint3D(n, n2, n3, true, dArray, false, true, this.x_spacing, this.y_spacing, this.z_spacing);
                    double d4 = dArray[0];
                    double d5 = dArray[1];
                    double d6 = dArray[2];
                    if (bl && dArray[1] < 0.0 && dArray[2] < 0.0) {
                        double d7 = Math.sqrt(dArray[1] * dArray[2]);
                        if (d7 == 0.0) {
                            d7 = 0.2;
                        }
                        if ((d7 *= this.multiplier) > 256.0) {
                            d7 = 256.0;
                        }
                        d = 1.0 / d7;
                    } else {
                        d = 5.0;
                    }
                }
            } else {
                float f = this.tubeness[n3][n2 * this.width + n];
                if (f == 0.0f) {
                    f = 0.2f;
                }
                d = 1.0f / f;
            }
        } else if (this.reciprocal) {
            d = 2.0;
            if (d2 != 0.0) {
                d = 1.0 / d2;
            }
        } else {
            d = 256.0 - d2;
        }
        return d;
    }

    float estimateCostToGoal(int n, int n2, int n3, int n4) {
        double d = (float)((n4 == 0 ? this.goal_x : this.start_x) - n) * this.x_spacing;
        double d2 = (float)((n4 == 0 ? this.goal_y : this.start_y) - n2) * this.y_spacing;
        double d3 = (float)((n4 == 0 ? this.goal_z : this.start_z) - n3) * this.z_spacing;
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        return (float)(this.minimum_cost_per_unit_distance * d4);
    }
}

