/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.PlugIn;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import vib.Average_Images;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Average_Torsten_Results
implements PlugIn {
    public static ImagePlus averageFromDirectoryList(ArrayList<File> arrayList) {
        ClassLoader classLoader = IJ.getClassLoader();
        if (classLoader == null) {
            IJ.error((String)"IJ.getClassLoader() failed (!)");
            return null;
        }
        Average_Images average_Images = new Average_Images();
        Iterator<File> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Throwable throwable;
            File file = new File(iterator.next(), "image.bin.gz");
            ImagePlus imagePlus = null;
            try {
                Class<?> clazz = classLoader.loadClass("io.TorstenRaw_GZ_Reader");
                throwable = clazz.newInstance();
                Class[] classArray = new Class[]{String.class};
                Object[] objectArray = new Object[]{file.getAbsolutePath()};
                Method method = clazz.getMethod("run", classArray);
                method.invoke((Object)throwable, objectArray);
                imagePlus = (ImagePlus)throwable;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                IJ.error((String)("There was an illegal argument when trying to invoke a method on the TorstenRaw GZ Reader plugin: " + illegalArgumentException));
                return null;
            }
            catch (InvocationTargetException invocationTargetException) {
                throwable = invocationTargetException.getTargetException();
                IJ.error((String)("There was an exception thrown by the TorstenRaw GZ Reader plugin: " + throwable));
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                IJ.error((String)("The TorstenRaw GZ Reader plugin was not found: " + classNotFoundException));
                return null;
            }
            catch (InstantiationException instantiationException) {
                IJ.error((String)("Failed to instantiate the TorstenRaw GZ Reader plugin: " + instantiationException));
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                IJ.error((String)("IllegalAccessException when trying the TorstenRaw GZ Reader plugin: " + illegalAccessException));
                return null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                IJ.error((String)("Couldn't find a method in the TorstenRaw GZ Reader plugin: " + noSuchMethodException));
                return null;
            }
            catch (SecurityException securityException) {
                IJ.error((String)("There was a SecurityException when trying to invoke a method of the TorstenRaw GZ Reader plugin: " + securityException));
            }
            average_Images.add(imagePlus);
            imagePlus.close();
        }
        return average_Images.getAverageImage(false);
    }

    public void run(String string) {
        File file = new File("/Volumes/LaCie/corpus/central-complex/biorad/reformatted");
        Pattern pattern = Pattern.compile("01_warp");
        Pattern pattern2 = Pattern.compile("\\.study$");
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            Matcher matcher;
            File file2 = fileArray[i];
            Matcher matcher2 = pattern.matcher(file2.getName());
            if (!matcher2.find() || (matcher = pattern2.matcher(file2.getName())).find()) continue;
            System.out.println("Using: " + file2);
            arrayList.add(file2);
        }
        ImagePlus imagePlus = Average_Torsten_Results.averageFromDirectoryList(arrayList);
        if (imagePlus != null) {
            imagePlus.show();
        }
    }
}

