/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import nrrd.NrrdHeader;
import nrrd.NrrdInfo;
import vib.FastMatrix;

public class CMTK_Transformation {
    File originalFile;
    Inverse inverse;
    int dimsx = -1;
    int dimsy = -1;
    int dimsz = -1;
    double domainx = Double.MIN_VALUE;
    double domainy = Double.MIN_VALUE;
    double domainz = Double.MIN_VALUE;
    double originx = Double.MIN_VALUE;
    double originy = Double.MIN_VALUE;
    double originz = Double.MIN_VALUE;
    double[][] coeffs;
    double deltax = -1.0;
    double deltay = -1.0;
    double deltaz = -1.0;

    public void setOriginalFile(File file) {
        this.originalFile = file;
    }

    public CMTK_Transformation() {
    }

    protected CMTK_Transformation(int n, int n2, int n3, double d, double d2, double d3, double d4, double d5, double d6, double[][] dArray) {
        this.dimsx = n;
        this.dimsy = n2;
        this.dimsz = n3;
        this.domainx = d;
        this.domainy = d2;
        this.domainz = d3;
        this.originx = d4;
        this.originy = d5;
        this.originz = d6;
        this.coeffs = dArray;
        this.deltax = d / (double)(n - 3);
        this.deltay = d2 / (double)(n2 - 3);
        this.deltaz = d3 / (double)(n3 - 3);
    }

    public static double degToRad(double d) {
        return d * Math.PI / 180.0;
    }

    public byte trilinearInterpolateByte(double d, double d2, double d3, int n, int n2, int n3, byte[][] byArray) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12 = d - Math.floor(d);
        double d13 = d2 - Math.floor(d2);
        double d14 = d3 - Math.floor(d3);
        int n4 = (int)Math.floor(d);
        int n5 = (int)Math.ceil(d);
        int n6 = (int)Math.floor(d2);
        int n7 = (int)Math.ceil(d2);
        int n8 = (int)Math.floor(d3);
        int n9 = (int)Math.ceil(d3);
        if (n4 < 0 || n5 < 0 || n6 < 0 || n7 < 0 || n8 < 0 || n9 < 0 || n4 >= n || n5 >= n || n6 >= n2 || n7 >= n2 || n8 >= n3 || n9 >= n3) {
            d11 = 0.0;
            d10 = 0.0;
            d9 = 0.0;
            d8 = 0.0;
            d7 = 0.0;
            d6 = 0.0;
            d5 = 0.0;
            d4 = 0.0;
        } else {
            d11 = byArray[n8][n * n6 + n4] & 0xFF;
            d10 = byArray[n9][n * n6 + n4] & 0xFF;
            d9 = byArray[n8][n * n7 + n4] & 0xFF;
            d8 = byArray[n9][n * n7 + n4] & 0xFF;
            d7 = byArray[n8][n * n6 + n5] & 0xFF;
            d6 = byArray[n9][n * n6 + n5] & 0xFF;
            d5 = byArray[n8][n * n7 + n5] & 0xFF;
            d4 = byArray[n9][n * n7 + n5] & 0xFF;
        }
        double d15 = (1.0 - d14) * d11 + d10 * d14;
        double d16 = (1.0 - d14) * d9 + d8 * d14;
        double d17 = (1.0 - d14) * d7 + d6 * d14;
        double d18 = (1.0 - d14) * d5 + d4 * d14;
        double d19 = d15 * (1.0 - d13) + d16 * d13;
        double d20 = d17 * (1.0 - d13) + d18 * d13;
        double d21 = d19 * (1.0 - d12) + d20 * d12;
        int n10 = (int)Math.round(d21);
        if (n10 < 0 || n10 > 255) {
            throw new RuntimeException("BUG: Out of range value!");
        }
        return (byte)n10;
    }

    public ImagePlus transform(ImagePlus imagePlus, ImagePlus imagePlus2) {
        int n;
        int n2;
        int n3 = imagePlus2.getWidth();
        int n4 = imagePlus2.getHeight();
        int n5 = imagePlus2.getStackSize();
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        Calibration calibration = imagePlus2.getCalibration();
        if (calibration != null) {
            d = calibration.pixelWidth;
            d2 = calibration.pixelHeight;
            d3 = calibration.pixelDepth;
        }
        int n6 = imagePlus.getWidth();
        int n7 = imagePlus.getHeight();
        int n8 = imagePlus.getStackSize();
        double d4 = 1.0;
        double d5 = 1.0;
        double d6 = 1.0;
        Calibration calibration2 = imagePlus.getCalibration();
        if (calibration2 != null) {
            d4 = calibration2.pixelWidth;
            d5 = calibration2.pixelHeight;
            d6 = calibration2.pixelDepth;
        }
        IJ.showProgress((double)0.0);
        double[] dArray = new double[3];
        byte[][] byArray = new byte[n8][n6 * n7];
        ImageStack imageStack = imagePlus2.getStack();
        byte[][] byArrayArray = new byte[n5][];
        for (n2 = 0; n2 < n5; ++n2) {
            byArrayArray[n2] = (byte[])imageStack.getPixels(n2 + 1);
        }
        for (n2 = 0; n2 < n8; ++n2) {
            for (n = 0; n < n7; ++n) {
                for (int i = 0; i < n6; ++i) {
                    byte by;
                    double d7 = (double)i * d4;
                    double d8 = (double)n * d5;
                    double d9 = (double)n2 * d6;
                    this.transformPoint(d7, d8, d9, dArray);
                    double d10 = dArray[0];
                    double d11 = dArray[1];
                    double d12 = dArray[2];
                    byArray[n2][n * n6 + i] = by = this.trilinearInterpolateByte(d10 / d, d11 / d2, d12 / d3, n3, n4, n5, byArrayArray);
                }
            }
            IJ.showProgress((double)((double)n2 / (double)(n8 + 1)));
        }
        ImageStack imageStack2 = new ImageStack(n6, n7);
        for (n = 0; n < n8; ++n) {
            ByteProcessor byteProcessor = new ByteProcessor(n6, n7);
            byteProcessor.setPixels((Object)byArray[n]);
            imageStack2.addSlice("", (ImageProcessor)byteProcessor);
        }
        IJ.showProgress((double)1.0);
        ImagePlus imagePlus3 = new ImagePlus("Transformed", imageStack2);
        imagePlus3.setCalibration(calibration2);
        return imagePlus3;
    }

    public double bSpline(int n, double d) {
        switch (n) {
            case 0: {
                double d2 = 1.0 - d;
                return d2 * d2 * d2 / 6.0;
            }
            case 1: {
                return (3.0 * d * d * d - 6.0 * d * d + 4.0) / 6.0;
            }
            case 2: {
                return (-3.0 * d * d * d + 3.0 * d * d + 3.0 * d + 1.0) / 6.0;
            }
            case 3: {
                return d * d * d / 6.0;
            }
        }
        throw new RuntimeException("bSpline()'s first parameter must be one of 0, 1, 2 or 3");
    }

    public void transformPoint(double d, double d2, double d3, double[] dArray) {
        double d4 = d / this.deltax;
        double d5 = d2 / this.deltay;
        double d6 = d3 / this.deltaz;
        int n = (int)d4;
        int n2 = (int)d5;
        int n3 = (int)d6;
        int n4 = Math.min(n, this.dimsx - 4);
        int n5 = Math.min(n2, this.dimsy - 4);
        int n6 = Math.min(n3, this.dimsz - 4);
        double d7 = d4 - (double)n4;
        double d8 = d5 - (double)n5;
        double d9 = d6 - (double)n6;
        dArray[0] = 0.0;
        dArray[1] = 0.0;
        dArray[2] = 0.0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    int n7 = n4 + i + this.dimsx * (n5 + j + this.dimsy * (n6 + k));
                    double d10 = this.bSpline(i, d7) * this.bSpline(j, d8) * this.bSpline(k, d9);
                    dArray[0] = dArray[0] + d10 * this.coeffs[n7][0];
                    dArray[1] = dArray[1] + d10 * this.coeffs[n7][1];
                    dArray[2] = dArray[2] + d10 * this.coeffs[n7][2];
                }
            }
        }
    }

    public static FastMatrix parseTypedStreamAffine(File file) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = "([-\\.0-9]+)";
            String string2 = "[ \\t]+";
            String string3 = "^\t\t";
            string3 = string3 + "(xlate|rotate|scale|shear|center)";
            string3 = string3 + string2 + string + string2 + string + string2 + string;
            Pattern pattern = Pattern.compile(string3);
            String string4 = bufferedReader.readLine();
            while (string4 != null) {
                Matcher matcher = pattern.matcher(string4);
                if (matcher.find()) {
                    double d16 = Double.parseDouble(matcher.group(2));
                    double d17 = Double.parseDouble(matcher.group(3));
                    double d18 = Double.parseDouble(matcher.group(4));
                    String string5 = matcher.group(1);
                    if (string5.equals("xlate")) {
                        d = d16;
                        d2 = d17;
                        d3 = d18;
                    } else if (string5.equals("rotate")) {
                        d4 = d16;
                        d5 = d17;
                        d6 = d18;
                    } else if (string5.equals("scale")) {
                        d7 = d16;
                        d8 = d17;
                        d9 = d18;
                    } else if (string5.equals("shear")) {
                        d10 = d16;
                        d11 = d17;
                        d12 = d18;
                    } else if (string5.equals("center")) {
                        d13 = d16;
                        d14 = d17;
                        d15 = d18;
                    }
                }
                string4 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            IJ.error((String)("IOException in parseTypedStreamAffine: " + iOException));
            return null;
        }
        double d19 = CMTK_Transformation.degToRad(d4);
        double d20 = CMTK_Transformation.degToRad(d5);
        double d21 = CMTK_Transformation.degToRad(d6);
        double d22 = Math.cos(d19);
        double d23 = Math.sin(d19);
        double d24 = Math.cos(d20);
        double d25 = Math.sin(d20);
        double d26 = Math.cos(d21);
        double d27 = Math.sin(d21);
        double d28 = d23 * d25;
        double d29 = d22 * d25;
        double[][] dArray = new double[4][4];
        dArray[0][0] = d24 * d26 * d7;
        dArray[1][0] = -d24 * d27 * d7;
        dArray[2][0] = -d25 * d7;
        dArray[3][0] = 0.0;
        dArray[0][1] = (d28 * d26 + d22 * d27) * d8;
        dArray[1][1] = (-d28 * d27 + d22 * d26) * d8;
        dArray[2][1] = d23 * d24 * d8;
        dArray[3][1] = 0.0;
        dArray[0][2] = (d29 * d26 - d23 * d27) * d9;
        dArray[1][2] = (-d29 * d27 - d23 * d26) * d9;
        dArray[2][2] = d22 * d24 * d9;
        dArray[3][2] = 0.0;
        dArray[3][3] = 1.0;
        double[] dArray2 = new double[]{d10, d11, d12};
        for (int i = 2; i >= 0; --i) {
            for (int j = 0; j < 3; ++j) {
                double[] dArray3 = dArray[j];
                int n = i;
                dArray3[n] = dArray3[n] + dArray2[i] * dArray[j][(i + 1) % 3];
            }
        }
        double[] dArray4 = new double[]{d13 * dArray[0][0] + d14 * dArray[0][1] + d15 * dArray[0][2], d13 * dArray[1][0] + d14 * dArray[1][1] + d15 * dArray[1][2], d13 * dArray[2][0] + d14 * dArray[2][1] + d15 * dArray[2][2]};
        dArray[0][3] = d - dArray4[0] + d13;
        dArray[1][3] = d2 - dArray4[1] + d14;
        dArray[2][3] = d3 - dArray4[2] + d15;
        return new FastMatrix(dArray);
    }

    public static CMTK_Transformation parseTypedStreamWarp(File file) {
        Object object;
        String string = "([\\-.0-9]+)";
        Pattern pattern = Pattern.compile("^[ \\t]+spline_warp \\{");
        Pattern pattern2 = Pattern.compile("^[ \\t]*}");
        Pattern pattern3 = Pattern.compile("^[ \\t]*dims " + string + " " + string + " " + string);
        Pattern pattern4 = Pattern.compile("^[ \\t]*domain " + string + " " + string + " " + string);
        Pattern pattern5 = Pattern.compile("^[ \\t]*origin " + string + " " + string + " " + string);
        Pattern pattern6 = Pattern.compile("^[ \\t]*coefficients " + string + " " + string + " " + string);
        Pattern pattern7 = Pattern.compile("^[ \\t]+" + string + " " + string + " " + string);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        double d = Double.MIN_VALUE;
        double d2 = Double.MIN_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MIN_VALUE;
        double d5 = Double.MIN_VALUE;
        double d6 = Double.MIN_VALUE;
        double[][] dArray = null;
        try {
            String string2;
            Matcher matcher;
            object = new byte[2];
            InputStream inputStream = new FileInputStream(file);
            ((InputStream)inputStream).read((byte[])object, 0, 2);
            ((InputStream)inputStream).close();
            boolean bl = object[0] == 31 && object[1] == -117;
            inputStream = bl ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            do {
                if ((string2 = bufferedReader.readLine()) != null) continue;
                IJ.error((String)("Couldn't find " + pattern));
                return null;
            } while (!(matcher = pattern.matcher(string2)).find());
            do {
                if ((string2 = bufferedReader.readLine()) != null) continue;
                IJ.error((String)("Couldn't find " + pattern2));
                return null;
            } while (!(matcher = pattern2.matcher(string2)).find());
            while ((string2 = bufferedReader.readLine()) != null) {
                matcher = pattern4.matcher(string2);
                if (matcher.find()) {
                    d = Double.parseDouble(matcher.group(1));
                    d2 = Double.parseDouble(matcher.group(2));
                    d3 = Double.parseDouble(matcher.group(3));
                    continue;
                }
                matcher = pattern3.matcher(string2);
                if (matcher.find()) {
                    n = Integer.parseInt(matcher.group(1));
                    n2 = Integer.parseInt(matcher.group(2));
                    n3 = Integer.parseInt(matcher.group(3));
                    continue;
                }
                matcher = pattern5.matcher(string2);
                if (matcher.find()) {
                    d4 = Double.parseDouble(matcher.group(1));
                    d5 = Double.parseDouble(matcher.group(2));
                    d6 = Double.parseDouble(matcher.group(3));
                    continue;
                }
                matcher = pattern6.matcher(string2);
                if (!matcher.find()) continue;
                if (n < 0) {
                    IJ.error((String)"Failed: got 'coefficients' before 'dims'");
                    return null;
                }
                dArray = new double[n * n2 * n3][3];
                dArray[0][0] = Double.parseDouble(matcher.group(1));
                dArray[0][1] = Double.parseDouble(matcher.group(2));
                dArray[0][2] = Double.parseDouble(matcher.group(3));
                int n4 = 1;
                while ((matcher = pattern7.matcher(string2 = bufferedReader.readLine())).find()) {
                    dArray[n4][0] = Double.parseDouble(matcher.group(1));
                    dArray[n4][1] = Double.parseDouble(matcher.group(2));
                    dArray[n4][2] = Double.parseDouble(matcher.group(3));
                    ++n4;
                }
                int n5 = n * n2 * n3;
                if (n5 == n4) break;
                String string3 = "Number of coefficients (" + n4 + ") didn't match expected number (" + n5 + ")";
                IJ.error((String)string3);
                System.out.println("Error is: " + string3);
                return null;
            }
        }
        catch (IOException iOException) {
            IJ.error((String)("IOException in parseTypedStreamWarp: " + iOException));
            return null;
        }
        if (d == Double.MIN_VALUE) {
            IJ.error((String)"Failed to find 'domain' line");
            return null;
        }
        if (d4 == Double.MIN_VALUE) {
            IJ.error((String)"Failed to find 'origin' line");
            return null;
        }
        if (n < 0) {
            IJ.error((String)"Failed to find 'dims' line");
            return null;
        }
        if (dArray == null) {
            IJ.error((String)"Failed to find 'coefficients' line");
            return null;
        }
        object = new CMTK_Transformation(n, n2, n3, d, d2, d3, d4, d5, d6, dArray);
        object.originalFile = file;
        return object;
    }

    public boolean precalculatedInverseExists() {
        if (this.originalFile == null) {
            throw new RuntimeException("Can't use find an inverse without originalFile being set");
        }
        File file = this.originalFile.getParentFile();
        File file2 = new File(file, "inverse.nhdr");
        File file3 = new File(file, "inverse_x.gz");
        File file4 = new File(file, "inverse_y.gz");
        File file5 = new File(file, "inverse_z.gz");
        return file2.exists() && file3.exists() && file4.exists() && file5.exists();
    }

    public Inverse inverse(ImagePlus imagePlus, ImagePlus imagePlus2) {
        Object object;
        int n;
        int n2;
        float[][] fArray;
        short[][] sArray;
        short[][] sArray2;
        short[][] sArray3;
        if (this.inverse != null) {
            return this.inverse;
        }
        if (this.originalFile == null) {
            throw new RuntimeException("Can't use CMTK_Transformation.inverse without originalFile being set.");
        }
        File file = this.originalFile.getParentFile();
        File file2 = new File(file, "inverse.nhdr");
        File file3 = new File(file, "inverse_x.gz");
        File file4 = new File(file, "inverse_y.gz");
        File file5 = new File(file, "inverse_z.gz");
        if (file2.exists() && file3.exists() && file4.exists() && file5.exists()) {
            this.inverse = Inverse.load(file2, file3, file4, file5, imagePlus, imagePlus2);
            return this.inverse;
        }
        int n3 = imagePlus2.getWidth();
        int n4 = imagePlus2.getHeight();
        int n5 = imagePlus2.getStackSize();
        int n6 = imagePlus.getWidth();
        int n7 = imagePlus.getHeight();
        int n8 = imagePlus.getStackSize();
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        Calibration calibration = imagePlus.getCalibration();
        if (calibration != null) {
            d = calibration.pixelWidth;
            d2 = calibration.pixelHeight;
            d3 = calibration.pixelDepth;
        }
        double d4 = 1.0;
        double d5 = 1.0;
        double d6 = 1.0;
        Calibration calibration2 = imagePlus2.getCalibration();
        if (calibration2 != null) {
            d4 = calibration2.pixelWidth;
            d5 = calibration2.pixelHeight;
            d6 = calibration2.pixelDepth;
        }
        imagePlus.close();
        imagePlus2.close();
        int n9 = 3;
        try {
            sArray3 = new short[n5][n3 * n4];
            sArray2 = new short[n5][n3 * n4];
            sArray = new short[n5][n3 * n4];
            fArray = new float[n5][n3 * n4];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println("Got an OOME with: " + imagePlus2 + " - trying to struggle on");
            return null;
        }
        double[] dArray = new double[3];
        for (n2 = 0; n2 < n5; ++n2) {
            for (n = 0; n < n3 * n4; ++n) {
                fArray[n2][n] = Float.MAX_VALUE;
                sArray3[n2][n] = Short.MIN_VALUE;
                sArray2[n2][n] = Short.MIN_VALUE;
                sArray[n2][n] = Short.MIN_VALUE;
            }
        }
        for (n2 = 0; n2 < n8; ++n2) {
            System.out.println("New template z: " + n2);
            for (n = 0; n < n7; ++n) {
                for (int i = 0; i < n6; ++i) {
                    double d7 = (double)i * d;
                    double d8 = (double)n * d2;
                    double d9 = (double)n2 * d3;
                    this.transformPoint(d7, d8, d9, dArray);
                    double d10 = dArray[0];
                    double d11 = dArray[1];
                    double d12 = dArray[2];
                    int n10 = (int)Math.round(d10 / d4);
                    int n11 = (int)Math.round(d11 / d5);
                    int n12 = (int)Math.round(d12 / d6);
                    for (int j = n12 - n9; j <= n12 + n9; ++j) {
                        for (int k = n11 - n9; k <= n11 + n9; ++k) {
                            for (int i2 = n10 - n9; i2 <= n10 + n9; ++i2) {
                                int n13;
                                double d13;
                                double d14;
                                double d15;
                                double d16;
                                double d17;
                                double d18;
                                double d19;
                                float f;
                                if (i2 < 0 || k < 0 || j < 0 || i2 >= n3 || k >= n4 || j >= n5 || !((f = (float)(d19 = (d18 = (d17 = (double)i2 * d4) - d10) * d18 + (d16 = (d15 = (double)k * d5) - d11) * d16 + (d14 = (d13 = (double)j * d6) - d12) * d14)) < fArray[j][n13 = k * n3 + i2])) continue;
                                fArray[j][n13] = f;
                                sArray3[j][n13] = (short)i;
                                sArray2[j][n13] = (short)n;
                                sArray[j][n13] = (short)n2;
                            }
                        }
                    }
                }
            }
        }
        try {
            System.out.println("Writing to " + file2.getAbsolutePath());
            object = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
            ((PrintWriter)object).println("NRRD0005");
            ((PrintWriter)object).println("type: short");
            ((PrintWriter)object).println("endian: big");
            ((PrintWriter)object).println("dimension: 4");
            ((PrintWriter)object).println("sizes: " + n3 + " " + n4 + " " + n5 + " 3");
            ((PrintWriter)object).println("encoding: gz");
            ((PrintWriter)object).println("data file: LIST");
            ((PrintWriter)object).println(file3.getName());
            ((PrintWriter)object).println(file4.getName());
            ((PrintWriter)object).println(file5.getName());
            ((PrintWriter)object).close();
            System.out.println("  Writing to " + file3.getAbsolutePath());
            System.out.println("  Writing to " + file4.getAbsolutePath());
            System.out.println("  Writing to " + file5.getAbsolutePath());
            DataOutputStream dataOutputStream = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(file3)));
            DataOutputStream dataOutputStream2 = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(file4)));
            DataOutputStream dataOutputStream3 = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(file5)));
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n4; ++j) {
                    for (int k = 0; k < n3; ++k) {
                        int n14 = j * n3 + k;
                        if (fArray[i][n14] < Float.MAX_VALUE) {
                            dataOutputStream.writeShort(sArray3[i][n14]);
                            dataOutputStream2.writeShort(sArray2[i][n14]);
                            dataOutputStream3.writeShort(sArray[i][n14]);
                            continue;
                        }
                        dataOutputStream.writeShort(Short.MIN_VALUE);
                        dataOutputStream2.writeShort(Short.MIN_VALUE);
                        dataOutputStream3.writeShort(Short.MIN_VALUE);
                    }
                }
            }
            dataOutputStream.close();
            dataOutputStream2.close();
            dataOutputStream3.close();
        }
        catch (IOException iOException) {
            IJ.error((String)("Writing the inverse to disk failed: " + iOException));
            iOException.printStackTrace();
        }
        sArray3 = null;
        sArray2 = null;
        sArray = null;
        fArray = null;
        System.gc();
        System.out.println("Loading back in now:");
        object = Inverse.load(file2, file3, file4, file5, imagePlus, imagePlus2);
        return object;
    }

    public static class Inverse {
        int modelWidth;
        int modelHeight;
        int modelDepth;
        int templateWidth;
        int templateHeight;
        int templateDepth;
        short[][] templateX;
        short[][] templateY;
        short[][] templateZ;
        Calibration templateCalibration;
        Calibration modelCalibration;
        double modelPixelWidth = 1.0;
        double modelPixelHeight = 1.0;
        double modelPixelDepth = 1.0;
        double templatePixelWidth = 1.0;
        double templatePixelHeight = 1.0;
        double templatePixelDepth = 1.0;

        public Inverse(ImagePlus imagePlus, ImagePlus imagePlus2) {
            this.modelWidth = imagePlus2.getWidth();
            this.modelHeight = imagePlus2.getHeight();
            this.modelDepth = imagePlus2.getStackSize();
            this.modelCalibration = imagePlus2.getCalibration();
            if (this.modelCalibration != null) {
                this.modelPixelWidth = this.modelCalibration.pixelWidth;
                this.modelPixelHeight = this.modelCalibration.pixelHeight;
                this.modelPixelDepth = this.modelCalibration.pixelDepth;
            }
            this.templateWidth = imagePlus.getWidth();
            this.templateHeight = imagePlus.getHeight();
            this.templateDepth = imagePlus.getStackSize();
            this.templateCalibration = imagePlus.getCalibration();
            if (this.templateCalibration != null) {
                this.templatePixelWidth = this.templateCalibration.pixelWidth;
                this.templatePixelHeight = this.templateCalibration.pixelHeight;
                this.templatePixelDepth = this.templateCalibration.pixelDepth;
            }
            this.templateX = new short[this.modelDepth][this.modelWidth * this.modelHeight];
            this.templateY = new short[this.modelDepth][this.modelWidth * this.modelHeight];
            this.templateZ = new short[this.modelDepth][this.modelWidth * this.modelHeight];
        }

        public static Inverse load(File file, File file2, File file3, File file4, ImagePlus imagePlus, ImagePlus imagePlus2) {
            int n = imagePlus2.getWidth();
            int n2 = imagePlus2.getHeight();
            int n3 = imagePlus2.getStackSize();
            System.out.println("On loading, model is: " + imagePlus2);
            System.out.println("Got modelDepth: " + n3);
            Inverse inverse = null;
            long l = -1L;
            try {
                int n4;
                NrrdHeader nrrdHeader = null;
                NrrdInfo nrrdInfo = null;
                nrrdHeader = new NrrdHeader();
                nrrdHeader.readHeader(file.getAbsolutePath());
                nrrdInfo = new NrrdInfo(nrrdHeader);
                nrrdInfo.parseHeader();
                int[] nArray = nrrdInfo.getIntegerFieldChecked("dimension", 1, true);
                if (nArray[0] != 4) {
                    throw new Exception("The inverse file must have 4 dimensions (not " + nArray[0] + ")");
                }
                String string = nrrdInfo.getStandardType(nrrdInfo.getStringFieldChecked("type", 1, true)[0]);
                if (!string.equals("int16")) {
                    throw new Exception("The inverse's data must be of type signed short (int16), not " + string);
                }
                long[] lArray = new long[]{n, n2, n3, 3L};
                long[] lArray2 = nrrdInfo.getLongFieldChecked("sizes", nArray[0], true);
                if (!Arrays.equals(lArray2, lArray)) {
                    IJ.error((String)("Sizes in one of the dimensions didn't match - required [" + lArray[0] + "," + lArray[1] + "," + lArray[2] + "," + lArray[3] + "] but got" + "[" + lArray2[0] + "," + lArray2[1] + "," + lArray2[2] + "," + lArray2[3] + "]"));
                }
                if (nrrdInfo.dataFiles.length != 3) {
                    throw new Exception("There must be exactly three data files, not: " + nrrdInfo.dataFiles.length);
                }
                for (n4 = 0; n4 < nrrdInfo.dataFiles.length; ++n4) {
                    System.out.println("ni.dataFiles[" + n4 + "] is '" + nrrdInfo.dataFiles[n4] + "'");
                }
                inverse = new Inverse(imagePlus, imagePlus2);
                for (n4 = 0; n4 < nrrdInfo.dataFiles.length; ++n4) {
                    File file5 = nrrdInfo.dataFiles[n4];
                    short[][] sArray = null;
                    switch (n4) {
                        case 0: {
                            sArray = inverse.templateX;
                            break;
                        }
                        case 1: {
                            sArray = inverse.templateY;
                            break;
                        }
                        case 2: {
                            sArray = inverse.templateZ;
                            break;
                        }
                        default: {
                            throw new RuntimeException("BUG: i is surprising (" + n4 + ")");
                        }
                    }
                    DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file5))));
                    long l2 = n * n2 * n3;
                    for (l = 0L; l < l2; ++l) {
                        int n5 = (int)(l % (long)n);
                        int n6 = (int)(l / (long)n % (long)n2);
                        int n7 = (int)(l / (long)(n * n2) % (long)n3);
                        sArray[n7][n6 * n + n5] = dataInputStream.readShort();
                    }
                }
            }
            catch (Exception exception) {
                IJ.error((String)("There was an error loading the CMTK inverse: " + exception));
                System.out.println("p was: " + l);
                exception.printStackTrace();
                return null;
            }
            return inverse;
        }

        public void transformPoint(double d, double d2, double d3, double[] dArray) {
            int n = (int)Math.round(d / this.modelPixelWidth);
            int n2 = (int)Math.round(d2 / this.modelPixelHeight);
            int n3 = (int)Math.round(d3 / this.modelPixelDepth);
            if (n < 0 || n2 < 0 || n3 < 0 || n >= this.modelWidth || n2 >= this.modelHeight || n3 >= this.modelDepth) {
                dArray[0] = Double.NaN;
                dArray[1] = Double.NaN;
                dArray[2] = Double.NaN;
            } else {
                short s = this.templateX[n3][n2 * this.modelWidth + n];
                short s2 = this.templateY[n3][n2 * this.modelWidth + n];
                short s3 = this.templateZ[n3][n2 * this.modelWidth + n];
                if (s == Short.MIN_VALUE || s2 == Short.MIN_VALUE || s3 == Short.MIN_VALUE) {
                    dArray[0] = Double.NaN;
                    dArray[1] = Double.NaN;
                    dArray[2] = Double.NaN;
                } else {
                    dArray[0] = (double)s * this.templatePixelWidth;
                    dArray[1] = (double)s2 * this.templatePixelHeight;
                    dArray[2] = (double)s3 * this.templatePixelDepth;
                }
            }
        }

        public void transformPoint(double d, double d2, double d3, int[] nArray) {
            int n = (int)Math.round(d / this.modelPixelWidth);
            int n2 = (int)Math.round(d2 / this.modelPixelHeight);
            int n3 = (int)Math.round(d3 / this.modelPixelDepth);
            if (n < 0 || n2 < 0 || n3 < 0 || n >= this.modelWidth || n2 >= this.modelHeight || n3 >= this.modelDepth) {
                nArray[0] = Integer.MIN_VALUE;
                nArray[1] = Integer.MIN_VALUE;
                nArray[2] = Integer.MIN_VALUE;
            } else {
                int n4 = this.templateX[n3][n2 * this.modelWidth + n];
                int n5 = this.templateY[n3][n2 * this.modelWidth + n];
                int n6 = this.templateZ[n3][n2 * this.modelWidth + n];
                if (n4 == Short.MIN_VALUE || n5 == Short.MIN_VALUE || n6 == Short.MIN_VALUE) {
                    nArray[0] = Integer.MIN_VALUE;
                    nArray[1] = Integer.MIN_VALUE;
                    nArray[2] = Integer.MIN_VALUE;
                } else {
                    nArray[0] = n4;
                    nArray[1] = n5;
                    nArray[2] = n6;
                }
            }
        }

        public void transformPoint(int n, int n2, int n3, int[] nArray) {
            int n4 = n;
            int n5 = n2;
            int n6 = n3;
            if (n4 < 0 || n5 < 0 || n6 < 0 || n4 >= this.modelWidth || n5 >= this.modelHeight || n6 >= this.modelDepth) {
                nArray[0] = Integer.MIN_VALUE;
                nArray[1] = Integer.MIN_VALUE;
                nArray[2] = Integer.MIN_VALUE;
            } else {
                int n7 = this.templateX[n6][n5 * this.modelWidth + n4];
                int n8 = this.templateY[n6][n5 * this.modelWidth + n4];
                int n9 = this.templateZ[n6][n5 * this.modelWidth + n4];
                if (n7 == Short.MIN_VALUE || n8 == Short.MIN_VALUE || n9 == Short.MIN_VALUE) {
                    nArray[0] = Integer.MIN_VALUE;
                    nArray[1] = Integer.MIN_VALUE;
                    nArray[2] = Integer.MIN_VALUE;
                } else {
                    nArray[0] = n7;
                    nArray[1] = n8;
                    nArray[2] = n9;
                }
            }
        }

        public void transformPoint(int n, int n2, int n3, double[] dArray) {
            int n4 = n;
            int n5 = n2;
            int n6 = n3;
            if (n4 < 0 || n5 < 0 || n6 < 0 || n4 >= this.modelWidth || n5 >= this.modelHeight || n6 >= this.modelDepth) {
                dArray[0] = Double.NaN;
                dArray[1] = Double.NaN;
                dArray[2] = Double.NaN;
            } else {
                short s = this.templateX[n6][n5 * this.modelWidth + n4];
                short s2 = this.templateY[n6][n5 * this.modelWidth + n4];
                short s3 = this.templateZ[n6][n5 * this.modelWidth + n4];
                if (s == Short.MIN_VALUE || s2 == Short.MIN_VALUE || s3 == Short.MIN_VALUE) {
                    dArray[0] = Double.NaN;
                    dArray[1] = Double.NaN;
                    dArray[2] = Double.NaN;
                } else {
                    dArray[0] = (double)s * this.templatePixelWidth;
                    dArray[1] = (double)s2 * this.templatePixelHeight;
                    dArray[2] = (double)s3 * this.templatePixelDepth;
                }
            }
        }

        public ImagePlus transformImage(ImagePlus imagePlus, ImagePlus imagePlus2) {
            int n;
            int n2;
            boolean bl = false;
            int n3 = imagePlus2.getWidth();
            int n4 = imagePlus2.getHeight();
            int n5 = imagePlus2.getStackSize();
            int n6 = imagePlus.getWidth();
            int n7 = imagePlus.getHeight();
            int n8 = imagePlus.getStackSize();
            Calibration calibration = imagePlus.getCalibration();
            byte[][] byArray = new byte[n8][n6 * n7];
            int[] nArray = new int[3];
            byte[][] byArrayArray = new byte[n5][];
            ImageStack imageStack = imagePlus2.getStack();
            for (int i = 0; i < n5; ++i) {
                byArrayArray[i] = (byte[])imageStack.getPixels(i + 1);
            }
            byte[][] byArray2 = null;
            if (bl) {
                byArray2 = new byte[n5][n3 * n4];
            }
            for (int i = 0; i < n5; ++i) {
                for (n2 = 0; n2 < n4; ++n2) {
                    for (int j = 0; j < n3; ++j) {
                        this.transformPoint(j, n2, i, nArray);
                        n = nArray[0];
                        int n9 = nArray[1];
                        int n10 = nArray[2];
                        if (n < 0 || n9 < 0 || n10 < 0 || n >= n6 || n9 >= n7 || n10 >= n8) continue;
                        if (bl) {
                            byArray2[i][n2 * n3 + j] = -1;
                        }
                        byArray[n10][n9 * n6 + n] = byArrayArray[i][n2 * n3 + j];
                    }
                }
            }
            ImageStack imageStack2 = new ImageStack(n6, n7);
            for (n2 = 0; n2 < n8; ++n2) {
                ByteProcessor byteProcessor = new ByteProcessor(n6, n7);
                byteProcessor.setPixels((Object)byArray[n2]);
                imageStack2.addSlice("", (ImageProcessor)byteProcessor);
            }
            ImagePlus imagePlus3 = new ImagePlus("Transformed " + imagePlus2.getTitle(), imageStack2);
            imagePlus3.setCalibration(calibration);
            if (bl) {
                ImageStack imageStack3 = new ImageStack(n3, n4);
                for (n = 0; n < n5; ++n) {
                    ByteProcessor byteProcessor = new ByteProcessor(n3, n4);
                    byteProcessor.setPixels((Object)byArray2[n]);
                    imageStack3.addSlice("", (ImageProcessor)byteProcessor);
                }
                ImagePlus imagePlus4 = new ImagePlus("Debug Stack", imageStack3);
                imagePlus4.show();
            }
            return imagePlus3;
        }
    }
}

