/*
 * Decompiled with CFR 0.152.
 */
package util;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.plugin.PlugIn;
import java.io.File;
import util.BatchOpener;
import util.LabelFilenameFilter;

public class Count_Labels
implements PlugIn {
    public void run(String string) {
        String string2 = Macro.getOptions();
        String string3 = null;
        if (string2 == null) {
            IJ.error((String)"Currently this can only be called as macro with options.");
            return;
        }
        string3 = Macro.getValue((String)string2, (String)"source", null);
        if (string3 == null) {
            IJ.error((String)"No source directory specified. (Macro option 'source'.)");
            return;
        }
        File file = new File(string3);
        if (!file.exists() || !file.isDirectory()) {
            IJ.error((String)("The source (" + string3 + ") must both exist and be a directory. "));
            return;
        }
        LabelFilenameFilter labelFilenameFilter = new LabelFilenameFilter(null);
        File[] fileArray = file.listFiles(labelFilenameFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            int n;
            boolean[] blArray = new boolean[256];
            File file2 = fileArray[i];
            String string4 = file2.getAbsolutePath();
            String string5 = file2.getName();
            ImagePlus[] imagePlusArray = BatchOpener.open(string4);
            if (imagePlusArray == null) {
                IJ.error((String)("Opening '" + string4 + "' failed."));
                return;
            }
            if (imagePlusArray.length != 1) {
                IJ.error((String)("The labels file must only have one channel: there are " + imagePlusArray.length + " in '" + string4));
                return;
            }
            ImagePlus imagePlus = imagePlusArray[0];
            int n2 = imagePlus.getType();
            if (n2 != 0 && n2 != 3) {
                IJ.error((String)("Something's wrong: '" + string4 + "' doesn't seem to be an 8 bit file."));
                return;
            }
            if (!AmiraParameters.isAmiraLabelfield(imagePlus)) {
                IJ.error((String)("The file '" + string4 + "' isn't an Amira labelfield!"));
                return;
            }
            int n3 = imagePlus.getWidth();
            int n4 = imagePlus.getHeight();
            int n5 = imagePlus.getStackSize();
            ImageStack imageStack = imagePlus.getStack();
            for (n = 0; n < n5; ++n) {
                byte[] byArray = (byte[])imageStack.getPixels(n + 1);
                for (int j = 0; j < n3 * n4; ++j) {
                    int n6 = byArray[j] & 0xFF;
                    blArray[n6] = true;
                }
            }
            n = 0;
            for (int j = 0; j < 256; ++j) {
                if (!blArray[j]) continue;
                ++n;
            }
            System.out.println("" + n + " - " + string5);
            imagePlus.close();
        }
    }
}

