/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import pal.math.ConjugateDirectionSearch;
import util.FluorescenceOptimizer;
import util.Histogram_2D;
import util.IdealImager;
import util.RGB_to_Luminance;
import vib.TransformedImage;

public class Exposure_Blend_Two_Stacks
implements PlugIn {
    public void run(String string) {
        int n;
        String string2;
        ImagePlus imagePlus;
        int n2 = 10000;
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.error((String)"No images are open.");
            return;
        }
        String[] stringArray = new String[nArray.length + 1];
        for (int i = 0; i < nArray.length; ++i) {
            imagePlus = WindowManager.getImage((int)nArray[i]);
            stringArray[i] = imagePlus != null ? imagePlus.getTitle() : "";
        }
        stringArray[nArray.length] = string2 = "*None*";
        imagePlus = new GenericDialog("Exposure Blend");
        imagePlus.addChoice("Stack with detail in dark regions (appears brighter):", stringArray, stringArray[0]);
        imagePlus.addChoice("Stack with detail in bright regions (appears darker):", stringArray, stringArray[1]);
        imagePlus.addCheckbox("Keep source images", true);
        imagePlus.showDialog();
        if (imagePlus.wasCanceled()) {
            return;
        }
        int n3 = 2;
        int[] nArray2 = new int[n3];
        nArray2[0] = imagePlus.getNextChoiceIndex();
        nArray2[1] = imagePlus.getNextChoiceIndex();
        ImagePlus[] imagePlusArray = new ImagePlus[n3];
        imagePlusArray[0] = WindowManager.getImage((int)nArray[nArray2[0]]);
        imagePlusArray[1] = WindowManager.getImage((int)nArray[nArray2[1]]);
        int n4 = imagePlusArray[0].getWidth();
        int n5 = imagePlusArray[0].getHeight();
        int n6 = imagePlusArray[0].getStackSize();
        for (n = 1; n < n3; ++n) {
            if (n4 == imagePlusArray[n].getWidth() && n5 == imagePlusArray[n].getHeight() && n6 == imagePlusArray[n].getStackSize()) continue;
            IJ.error((String)("The dimensions of image stack " + imagePlusArray[n].getTitle() + " do not match those of " + imagePlusArray[0].getTitle()));
            return;
        }
        int n7 = imagePlusArray[0].getType();
        for (n = 1; n < n3; ++n) {
            if (n7 != imagePlusArray[n].getType()) {
                IJ.error((String)"Can't exposure blend images of different types.");
                return;
            }
            int n8 = imagePlusArray[0].getBitDepth();
            System.out.println("bitDepth: " + n8);
            if (n8 != 8 && n8 != 16 && n8 != 24) {
                IJ.error((String)"Images must be 8-bit, 16-bit or RGB");
                return;
            }
            if (n8 == 24) {
                for (n = 0; n < n3; ++n) {
                    imagePlusArray[n] = RGB_to_Luminance.convertToLuminance(imagePlusArray[n]);
                    imagePlusArray[n].show();
                }
                n7 = imagePlusArray[0].getType();
                n8 = imagePlusArray[0].getBitDepth();
            }
            ImageStack[] imageStackArray = new ImageStack[n3];
            for (n = 0; n < n3; ++n) {
                imageStackArray[n] = imagePlusArray[n].getStack();
            }
            TransformedImage transformedImage = new TransformedImage(imagePlusArray[0], imagePlusArray[1]);
            float[] fArray = transformedImage.getValuesRange();
            Histogram_2D histogram_2D = new Histogram_2D();
            histogram_2D.start2DHistogram(fArray[0], fArray[1], 256);
            float f = fArray[1] - fArray[0];
            histogram_2D.collectStatisticsFor(fArray[0] + f / 128.0f, fArray[1] - f / 128.0f);
            histogram_2D.addImagePlusPair(imagePlusArray[0], imagePlusArray[1]);
            histogram_2D.calculateCorrelation();
            float f2 = histogram_2D.fittedGradient;
            float f3 = histogram_2D.fittedYIntercept;
            ImagePlus[] imagePlusArray2 = histogram_2D.getHistograms();
            histogram_2D.frame2DHistogram("2D Histogram of Values", imagePlusArray2[1], imagePlusArray[0].getTitle(), fArray[0], fArray[1], imagePlusArray[1].getTitle(), fArray[0], fArray[1], 2);
            float f4 = -f3 / (f2 * 255.0f);
            float f5 = (255.0f - f3) / (f2 * 255.0f);
            System.out.println("Got m: " + f4);
            System.out.println("Got n: " + f5);
            IdealImager[] idealImagerArray = new IdealImager[n3];
            idealImagerArray[0] = new IdealImager(0, 255, 255.0f, 0.0f);
            idealImagerArray[1] = new IdealImager(0, 255, 255.0f / (f5 - f4), -f4 * 255.0f / (f5 - f4));
            FluorescenceOptimizer fluorescenceOptimizer = new FluorescenceOptimizer(idealImagerArray);
            fluorescenceOptimizer.setLowerBound(Math.min(0.0f, f4));
            fluorescenceOptimizer.setUpperBound(Math.max(1.0f, f5));
            ConjugateDirectionSearch conjugateDirectionSearch = new ConjugateDirectionSearch();
            conjugateDirectionSearch.illc = true;
            conjugateDirectionSearch.step = 0.1;
            int[] nArray3 = new int[n3];
            double[] dArray = new double[1];
            ImageStack imageStack = new ImageStack(n4, n5);
            for (int i = 0; i < n6; ++i) {
                System.out.println("Making final stack slice: " + i);
                float[] fArray2 = new float[n4 * n5];
                FloatProcessor floatProcessor = new FloatProcessor(n4, n5);
                byte[][] byArrayArray = new byte[n3][];
                short[][] sArrayArray = new short[n3][];
                if (n8 == 8) {
                    for (n = 0; n < n3; ++n) {
                        byArrayArray[n] = (byte[])imageStackArray[n].getPixels(i + 1);
                    }
                } else if (n8 == 16) {
                    for (n = 0; n < n3; ++n) {
                        sArrayArray[n] = (short[])imageStackArray[n].getPixels(i + 1);
                    }
                }
                for (int j = 0; j < fArray2.length; ++j) {
                    if (j < n4 * 73) continue;
                    if (j > n4 * 73) break;
                    System.out.print("Doing one: ");
                    for (n = 0; n < n3; ++n) {
                        if (n8 == 8) {
                            nArray3[n] = byArrayArray[n][j] & 0xFF;
                            continue;
                        }
                        if (n8 != 16) continue;
                        nArray3[n] = sArrayArray[n][j];
                    }
                    System.out.println("Considering values array:");
                    for (n = 0; n < n3; ++n) {
                        System.out.println("   " + nArray3[n]);
                    }
                    fluorescenceOptimizer.setRealResult(nArray3);
                    dArray[0] = 0.5;
                    conjugateDirectionSearch.optimize(fluorescenceOptimizer, dArray, 100.0, 0.001);
                    fArray2[j] = (float)dArray[0];
                    System.out.println("" + fArray2[j]);
                }
                floatProcessor.setPixels((Object)fArray2);
                imageStack.addSlice("", (ImageProcessor)floatProcessor);
            }
            ImagePlus imagePlus2 = new ImagePlus("final blended image", imageStack);
        }
    }
}

