/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.image.ColorModel;
import vib.TransformedImage;

public class Histogram_2D
implements PlugIn {
    int bins;
    long totalValues;
    long[][] counts;
    float minValue;
    float maxValue;
    float rangeWidth;
    boolean keepStatistics;
    boolean correlationCalculated;
    float statsMinValue;
    float statsMaxValue;
    float sumX;
    float sumY;
    float sumXY;
    float sumXX;
    long statsValues;
    float fittedGradient;
    float fittedYIntercept;
    public static final int PROBABILITIES = 0;
    public static final int LOG_PROBABILITIES = 1;
    public static final int SELF_INFORMATION = 2;

    public Histogram_2D() {
        this.counts = new long[this.bins][this.bins];
        this.keepStatistics = false;
        this.correlationCalculated = false;
    }

    public void collectStatisticsFor(float f, float f2) {
        this.statsMinValue = f;
        this.statsMaxValue = f2;
        this.sumX = 0.0f;
        this.sumY = 0.0f;
        this.sumXX = 0.0f;
        this.sumXY = 0.0f;
        this.statsValues = 0L;
        this.keepStatistics = true;
        this.fittedGradient = 0.0f;
        this.fittedYIntercept = 0.0f;
    }

    public void start2DHistogram(float f, float f2, int n) {
        this.bins = n;
        this.totalValues = 0L;
        this.counts = new long[n][n];
        this.minValue = f;
        this.maxValue = f2;
        this.rangeWidth = f2 - f;
        this.keepStatistics = false;
        this.correlationCalculated = false;
    }

    public void addImagePlusPair(ImagePlus imagePlus, ImagePlus imagePlus2) {
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = imagePlus2.getStack();
        int n = imagePlus.getStackSize();
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        int n4 = imagePlus2.getStackSize();
        int n5 = imagePlus2.getWidth();
        int n6 = imagePlus2.getHeight();
        int n7 = imagePlus.getType();
        int n8 = imagePlus2.getType();
        int n9 = imagePlus.getBitDepth();
        int n10 = imagePlus2.getBitDepth();
        if (n != n4 || n2 != n5 || n3 != n6) {
            String string = "" + n2 + "x" + n3 + "x" + n;
            String string2 = "" + n5 + "x" + n6 + "x" + n4;
            String string3 = "Every image pair must have identical dimensions.\n";
            string3 = string3 + "(" + imagePlus.getTitle() + " (" + string + ") and ";
            string3 = string3 + imagePlus2.getTitle() + " (" + string2 + ") do not.)";
            IJ.error((String)string3);
            return;
        }
        if (n9 != n10) {
            IJ.error((String)"Each image pair must be of the same bit depth.");
            return;
        }
        if (n9 != 8 && n9 != 16) {
            IJ.error((String)"Image pairs must be 8 bit or 16 bit images at the moment.");
            return;
        }
        IJ.showProgress((double)0.0);
        for (int i = 0; i < n; ++i) {
            byte[] byArray = null;
            byte[] byArray2 = null;
            short[] sArray = null;
            short[] sArray2 = null;
            if (n9 == 8) {
                byArray = (byte[])imageStack.getPixels(i + 1);
                byArray2 = (byte[])imageStack2.getPixels(i + 1);
            } else if (n9 == 16) {
                sArray = (short[])imageStack.getPixels(i + 1);
                sArray2 = (short[])imageStack2.getPixels(i + 1);
            }
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    float f = -1.0f;
                    float f2 = -1.0f;
                    if (n9 == 8) {
                        f = byArray[j * n2 + k] & 0xFF;
                        f2 = byArray2[j * n2 + k] & 0xFF;
                    } else if (n9 == 16) {
                        f = sArray[j * n2 + k];
                        f2 = sArray2[j * n2 + k];
                    }
                    if (this.keepStatistics && f >= this.statsMinValue && f2 >= this.statsMinValue && f <= this.statsMaxValue && f2 <= this.statsMaxValue) {
                        this.sumX += f;
                        this.sumY += f2;
                        this.sumXX += f * f;
                        this.sumXY += f * f2;
                        ++this.statsValues;
                    }
                    int n11 = (int)Math.floor((f - this.minValue) * (float)this.bins / this.rangeWidth);
                    int n12 = (int)Math.floor((f2 - this.minValue) * (float)this.bins / this.rangeWidth);
                    if (n11 >= this.bins) {
                        n11 = this.bins - 1;
                    }
                    if (n12 >= this.bins) {
                        n12 = this.bins - 1;
                    }
                    long[] lArray = this.counts[n11];
                    int n13 = n12;
                    lArray[n13] = lArray[n13] + 1L;
                    ++this.totalValues;
                }
            }
            IJ.showProgress((double)(i / n));
        }
        IJ.showProgress((double)1.0);
    }

    public void calculateCorrelation() {
        if (!this.keepStatistics) {
            throw new RuntimeException("calculateCorrelation() was called without collectStatisticsFor() having been called.");
        }
        float f = ((float)this.statsValues * this.sumXY - this.sumX * this.sumY) / ((float)this.statsValues * this.sumXX - this.sumX * this.sumX);
        float f2 = (this.sumY - f * this.sumX) / (float)this.statsValues;
        this.fittedGradient = f;
        this.fittedYIntercept = f2;
        this.correlationCalculated = true;
    }

    public ImagePlus[] getHistograms() {
        System.out.println("totalValues is: " + this.totalValues);
        double[][] dArray = new double[this.bins][this.bins];
        double[][] dArray2 = new double[this.bins][this.bins];
        for (int i = 0; i < this.bins; ++i) {
            for (int j = 0; j < this.bins; ++j) {
                dArray[i][j] = (double)this.counts[i][j] / (double)this.totalValues;
                dArray2[i][j] = -Math.log(dArray[i][j]) / Math.log(2.0);
            }
        }
        Object object = new float[this.bins * this.bins];
        for (int i = 0; i < this.bins; ++i) {
            for (int j = 0; j < this.bins; ++j) {
                object[(this.bins - 1 - j) * this.bins + i] = (float)dArray[i][j];
            }
        }
        Object object2 = new FloatProcessor(this.bins, this.bins);
        object2.setPixels(object);
        ImageStack imageStack = new ImageStack(this.bins, this.bins);
        imageStack.addSlice("", (ImageProcessor)object2);
        ImagePlus imagePlus = new ImagePlus("2D Histogram Log Probabilities", imageStack);
        object2 = new float[this.bins * this.bins];
        for (int i = 0; i < this.bins; ++i) {
            for (int j = 0; j < this.bins; ++j) {
                object2[(this.bins - 1 - j) * this.bins + i] = (FloatProcessor)((float)Math.log(dArray[i][j]));
            }
        }
        ImagePlus[] imagePlusArray = new FloatProcessor(this.bins, this.bins);
        imagePlusArray.setPixels(object2);
        ImageStack imageStack2 = new ImageStack(this.bins, this.bins);
        imageStack2.addSlice("", (ImageProcessor)imagePlusArray);
        object = new ImagePlus("2D Histogram Probabilities", imageStack2);
        imagePlusArray = (ImagePlus[])new float[this.bins * this.bins];
        for (int i = 0; i < this.bins; ++i) {
            for (int j = 0; j < this.bins; ++j) {
                imagePlusArray[(this.bins - 1 - j) * this.bins + i] = (FloatProcessor)((float)dArray2[i][j]);
            }
        }
        FloatProcessor floatProcessor = new FloatProcessor(this.bins, this.bins);
        floatProcessor.setPixels((Object)imagePlusArray);
        ImageStack imageStack3 = new ImageStack(this.bins, this.bins);
        imageStack3.addSlice("", (ImageProcessor)floatProcessor);
        object2 = new ImagePlus("2D Histogram Self Information", imageStack3);
        imagePlusArray = new ImagePlus[]{imagePlus, (ImagePlus)object, object2};
        return imagePlusArray;
    }

    public ImagePlus frame2DHistogram(String string, ImagePlus imagePlus, String string2, float f, float f2, String string3, float f3, float f4, int n) {
        float f5;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = 5;
        int n10 = 10;
        boolean bl = false;
        int n11 = 10;
        int n12 = 12;
        int n13 = 100;
        int n14 = 180;
        int n15 = 60;
        int n16 = 100;
        if (imagePlus.getType() != 2) {
            IJ.error((String)"frame2DHistogram only works on GRAY32 (Float) 2D histogram images");
            return null;
        }
        if (imagePlus.getStackSize() != 1) {
            IJ.error((String)"The histogram must not be a stack.");
            return null;
        }
        ColorModel colorModel = imagePlus.getProcessor().getColorModel();
        int n17 = imagePlus.getWidth();
        int n18 = imagePlus.getHeight();
        FloatProcessor floatProcessor = (FloatProcessor)imagePlus.getProcessor();
        float f6 = (float)floatProcessor.getMin();
        float f7 = (float)floatProcessor.getMax();
        float[] fArray = (float[])floatProcessor.getPixels();
        int n19 = n17 + n13 + n14;
        int n20 = n18 + n15 + n16;
        float[] fArray2 = new float[n19 * n20];
        for (n8 = 0; n8 < fArray2.length; ++n8) {
            fArray2[n8] = f7;
        }
        for (n8 = 0; n8 < n18; ++n8) {
            for (int i = 0; i < n17; ++i) {
                fArray2[(n8 + n15) * n19 + (i + n13)] = fArray[n8 * n17 + i];
            }
        }
        FloatProcessor floatProcessor2 = new FloatProcessor(n19, n20);
        floatProcessor2.setPixels((Object)fArray2);
        floatProcessor2.setMinAndMax((double)f6, (double)f7);
        floatProcessor2.setValue((double)f6);
        floatProcessor2.drawLine(n13, n15 + n18, n13, n15 + n18 + n9);
        floatProcessor2.drawLine(n13 + n17 - 1, n15 + n18, n13 + n17 - 1, n15 + n18 + n9);
        floatProcessor2.drawLine(n13 - 1, n15, n13 - 1 - n9, n15);
        floatProcessor2.drawLine(n13 - 1, n15 + n18 - 1, n13 - 1 - n9, n15 + n18 - 1);
        ImagePlus imagePlus2 = new ImagePlus("Framed Histogram", (ImageProcessor)floatProcessor2);
        if (colorModel != null) {
            imagePlus2.getProcessor().setColorModel(colorModel);
        }
        String string4 = bl ? "Serif" : "SanSerif";
        int n21 = 0;
        Font font = new Font(string4, n21, n11);
        imagePlus2.show();
        ImageCanvas imageCanvas = imagePlus2.getCanvas();
        FontMetrics fontMetrics = imageCanvas.getFontMetrics(font);
        floatProcessor2.setFont(font);
        floatProcessor2.setAntialiasedText(true);
        String string5 = "" + f;
        String string6 = "" + f2;
        String string7 = "" + f3;
        String string8 = "" + f4;
        floatProcessor2.drawString(string5, n13 - fontMetrics.stringWidth(string5) / 2, n15 + n18 + n10 + fontMetrics.getHeight());
        floatProcessor2.drawString(string6, n13 + n17 - fontMetrics.stringWidth(string6) / 2, n15 + n18 + n9 + n10 + fontMetrics.getHeight());
        floatProcessor2.drawString(string7, n13 - n10 - fontMetrics.stringWidth(string7) - n9, n15 + n18 + fontMetrics.getHeight() / 2);
        floatProcessor2.drawString(string8, n13 - n10 - fontMetrics.stringWidth(string8) - n9, n15 + fontMetrics.getHeight() / 2);
        floatProcessor2.drawString(string2, n13 + n17 / 2 - fontMetrics.stringWidth(string2) / 2, n15 + n18 + n9 + 2 * n10 + 2 * fontMetrics.getHeight());
        int n22 = fontMetrics.stringWidth(string3);
        int n23 = fontMetrics.getHeight();
        FloatProcessor floatProcessor3 = new FloatProcessor(n22, n23);
        float[] fArray3 = new float[n22 * n23];
        for (n7 = 0; n7 < fArray3.length; ++n7) {
            fArray3[n7] = f7;
        }
        floatProcessor3.setFont(font);
        floatProcessor3.setPixels((Object)fArray3);
        floatProcessor3.setValue((double)f6);
        floatProcessor3.setMinAndMax((double)f6, (double)f7);
        floatProcessor3.drawString(string3, 0, n23);
        n7 = n13 - n9 - n10 - n23 * 2;
        int n24 = n15 + n18 / 2 - n22 / 2;
        for (n6 = 0; n6 < n23; ++n6) {
            for (n5 = 0; n5 < n22; ++n5) {
                n4 = n7 + n6;
                n3 = n24 + n22 - n5;
                fArray2[n3 * n19 + n4] = fArray3[n6 * n22 + n5];
            }
        }
        n6 = 30;
        n5 = n18 * 2 / 3;
        n4 = n13 + n17 + 40;
        n3 = n15 + (n18 - n5) / 2;
        floatProcessor2.drawRect(n4, n3, n6 + 2, n5 + 2);
        for (int i = 0; i < n5; ++i) {
            int n25 = n4 + 1;
            n2 = n4 + n6;
            int n26 = n3 + 1 + (n5 - (i + 1));
            f5 = (float)i * (f7 - f6) / (float)(n5 - 1) + f6;
            floatProcessor2.setValue((double)f5);
            floatProcessor2.drawLine(n25, n26, n2, n26);
        }
        floatProcessor2.setValue((double)f6);
        floatProcessor2.drawLine(n4 + n6 + 2, n3, n4 + n6 + 2 + n9, n3);
        floatProcessor2.drawString("" + f7, n4 + n6 + 2 + n9 + n10, n3 + fontMetrics.getHeight() / 2);
        floatProcessor2.drawLine(n4 + n6 + 2, n3 + n5 + 1, n4 + n6 + 2 + n9, n3 + n5 + 1);
        floatProcessor2.drawString("" + f6, n4 + n6 + 2 + n9 + n10, n3 + n5 + fontMetrics.getHeight() / 2);
        n21 = 1;
        Font font2 = new Font(string4, n21, n12);
        FontMetrics fontMetrics2 = imageCanvas.getFontMetrics(font);
        floatProcessor2.setFont(font2);
        floatProcessor2.drawString(string, n19 / 2 - fontMetrics2.stringWidth(string) / 2, n15 / 2 + fontMetrics2.getHeight() / 2);
        if (this.correlationCalculated) {
            floatProcessor2.drawPixel(10, 10);
            if (this.fittedGradient <= 1.0f) {
                for (n2 = 0; n2 < this.bins; ++n2) {
                    float f8 = this.minValue + ((float)n2 + 0.5f) / (float)this.bins * this.rangeWidth;
                    System.out.println("xBin " + n2 + " mapped to " + f8);
                    f5 = this.fittedGradient * f8 + this.fittedYIntercept;
                    int n27 = (int)Math.floor((f5 - this.minValue) * (float)this.bins / this.rangeWidth);
                    System.out.println("bin: (" + n2 + "," + n27 + ")");
                    if (n27 < 0 || n27 >= this.bins) continue;
                    floatProcessor2.setValue(n2 % 2 == 0 ? (double)this.minValue : (double)this.maxValue);
                    floatProcessor2.drawPixel(n13 + n2, n15 + n18 - n27);
                }
            } else {
                for (n2 = 0; n2 < this.bins; ++n2) {
                    float f9 = this.minValue + ((float)n2 + 0.5f) / (float)this.bins * this.rangeWidth;
                    System.out.println("yBin " + n2 + " mapped to " + f9);
                    f5 = (f9 - this.fittedYIntercept) / this.fittedGradient;
                    int n28 = (int)Math.floor((f5 - this.minValue) * (float)this.bins / this.rangeWidth);
                    System.out.println("bin: (" + n28 + "," + n2 + ")");
                    if (n28 < 0 || n28 >= this.bins) continue;
                    floatProcessor2.setValue(n2 % 2 == 0 ? (double)this.minValue : (double)this.maxValue);
                    floatProcessor2.drawPixel(n13 + n28, n15 + n18 - n2);
                }
            }
        }
        imagePlus2.updateAndRepaintWindow();
        return imagePlus2;
    }

    public void run(String string) {
        String[] stringArray;
        ImagePlus[] imagePlusArray;
        String string2 = "";
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.error((String)"No images are open.");
            return;
        }
        String[] stringArray2 = new String[nArray.length];
        ImagePlus[] imagePlusArray2 = new ImagePlus[nArray.length];
        ImagePlus[] imagePlusArray3 = new ImagePlus[nArray.length];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            imagePlusArray = WindowManager.getImage((int)nArray[i]);
            Object object = stringArray = imagePlusArray == null ? "" : imagePlusArray.getTitle();
            if (stringArray.indexOf(string2) >= 0) {
                stringArray2[n] = stringArray;
                imagePlusArray2[n] = imagePlusArray;
                ++n;
            }
            imagePlusArray3[i] = imagePlusArray;
        }
        if (n < 2) {
            IJ.error((String)("There are only " + n + " matching images; need at least 2."));
            return;
        }
        String[] stringArray3 = new String[n];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n);
        imagePlusArray = new ImagePlus[n];
        System.arraycopy(imagePlusArray2, 0, imagePlusArray, 0, n);
        stringArray = new String[]{"p (Probability)", "ln(p) (Log Probabilities)", "-log\u2082(p) (Self-information)"};
        GenericDialog genericDialog = new GenericDialog("2D Histogram");
        genericDialog.addChoice("A:", stringArray3, stringArray3[0]);
        genericDialog.addChoice("B:", stringArray3, stringArray3[1]);
        genericDialog.addChoice("Values to plot: ", stringArray, stringArray[1]);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int[] nArray2 = new int[]{genericDialog.getNextChoiceIndex(), genericDialog.getNextChoiceIndex()};
        int n2 = genericDialog.getNextChoiceIndex();
        ImagePlus[] imagePlusArray4 = new ImagePlus[]{imagePlusArray[nArray2[0]], imagePlusArray[nArray2[1]]};
        IJ.showStatus((String)"Calculating values range...");
        TransformedImage transformedImage = new TransformedImage(imagePlusArray4[0], imagePlusArray4[1]);
        float[] fArray = transformedImage.getValuesRange();
        imagePlusArray4[0].getProcessor().setMinAndMax((double)fArray[0], (double)fArray[1]);
        imagePlusArray4[1].getProcessor().setMinAndMax((double)fArray[0], (double)fArray[1]);
        int n3 = imagePlusArray4[0].getWidth();
        int n4 = imagePlusArray4[0].getHeight();
        int n5 = imagePlusArray4[0].getStackSize();
        if (n3 != imagePlusArray4[1].getWidth() || n4 != imagePlusArray4[1].getHeight() || n5 != imagePlusArray4[1].getStackSize()) {
            IJ.error((String)("The dimensions of image stack " + imagePlusArray4[1].getTitle() + " do not match those of " + imagePlusArray4[0].getTitle()));
            return;
        }
        this.start2DHistogram(fArray[0], fArray[1], 256);
        IJ.showStatus((String)"Binning values from the images...");
        this.addImagePlusPair(imagePlusArray4[0], imagePlusArray4[1]);
        ImagePlus[] imagePlusArray5 = this.getHistograms();
        IJ.runPlugIn((ImagePlus)imagePlusArray5[n2], (String)"ij.plugin.LutLoader", (String)"fire");
        this.frame2DHistogram(stringArray[n2] + " for Corresponding Values", imagePlusArray5[n2], imagePlusArray4[0].getTitle(), fArray[0], fArray[1], imagePlusArray4[1].getTitle(), fArray[0], fArray[1], n2);
    }
}

